/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Transient;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.ReflectHelper;

public class AccessStrategyHelper {
    public static final int COMPOSITE_TRACKER_MASK = 1;
    public static final int COMPOSITE_OWNER = 2;
    public static final int PERSISTENT_ATTRIBUTE_INTERCEPTABLE_MASK = 4;

    public static @Nullable Field fieldOrNull(Class<?> containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public static AccessType getAccessType(Class<?> containerJavaType, String propertyName) {
        Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
        AccessType explicitAccessType = AccessStrategyHelper.getExplicitAccessType(containerJavaType, propertyName, field);
        if (explicitAccessType != null) {
            return explicitAccessType;
        }
        AccessType classAccessType = AccessStrategyHelper.getAccessTypeOrNull(containerJavaType);
        if (classAccessType != null) {
            return classAccessType;
        }
        return field != null ? AccessType.FIELD : AccessType.PROPERTY;
    }

    public static @Nullable AccessType getExplicitAccessType(Class<?> containerClass, String propertyName, @Nullable Field field) {
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                containerClass.getMethod(propertyName, ReflectHelper.NO_PARAM_SIGNATURE);
                return AccessType.PROPERTY;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (field != null && field.isAnnotationPresent(Access.class) && !field.isAnnotationPresent(Transient.class) && !Modifier.isStatic(field.getModifiers())) {
            return AccessType.FIELD;
        }
        Method getter = ReflectHelper.getterMethodOrNull(containerClass, propertyName);
        if (getter != null && getter.isAnnotationPresent(Access.class)) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    protected static @Nullable AccessType getAccessTypeOrNull(@Nullable AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Access elementAccess = element.getAnnotation(Access.class);
        return elementAccess == null ? null : elementAccess.value();
    }

    public static int determineEnhancementState(Class<?> containerClass, Class<?> attributeType) {
        return (CompositeOwner.class.isAssignableFrom(containerClass) ? 2 : 0) | (CompositeTracker.class.isAssignableFrom(attributeType) ? 1 : 0) | (ManagedTypeHelper.isPersistentAttributeInterceptableType(containerClass) ? 4 : 0);
    }

    public static void handleEnhancedInjection(Object target, @Nullable Object value, int enhancementState, String propertyName) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        if ((enhancementState & 2) != 0 && ((enhancementState & 1) != 0 && value != null || ManagedTypeHelper.isCompositeTracker(value))) {
            ManagedTypeHelper.asCompositeTracker(NullnessUtil.castNonNull(value)).$$_hibernate_setOwner(propertyName, ManagedTypeHelper.asCompositeOwner(target));
        }
        if ((enhancementState & 4) != 0 && (persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(target).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            BytecodeLazyAttributeInterceptor lazyAttributeInterceptor = (BytecodeLazyAttributeInterceptor)persistentAttributeInterceptor;
            lazyAttributeInterceptor.attributeInitialized(propertyName);
        }
    }
}

