/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.mirror.MirrorClient;

public final class RemoteClusterUtils {
    private RemoteClusterUtils() {
    }

    public static int replicationHops(Map<String, Object> properties, String upstreamClusterAlias) throws InterruptedException, TimeoutException {
        try (MirrorClient client = new MirrorClient(properties);){
            int n = client.replicationHops(upstreamClusterAlias);
            return n;
        }
    }

    public static Set<String> heartbeatTopics(Map<String, Object> properties) throws InterruptedException, TimeoutException {
        try (MirrorClient client = new MirrorClient(properties);){
            Set<String> set = client.heartbeatTopics();
            return set;
        }
    }

    public static Set<String> checkpointTopics(Map<String, Object> properties) throws InterruptedException, TimeoutException {
        try (MirrorClient client = new MirrorClient(properties);){
            Set<String> set = client.checkpointTopics();
            return set;
        }
    }

    public static Set<String> upstreamClusters(Map<String, Object> properties) throws InterruptedException, TimeoutException {
        try (MirrorClient client = new MirrorClient(properties);){
            Set<String> set = client.upstreamClusters();
            return set;
        }
    }

    public static Map<TopicPartition, OffsetAndMetadata> translateOffsets(Map<String, Object> properties, String remoteClusterAlias, String consumerGroupId, Duration timeout) throws InterruptedException, TimeoutException {
        try (MirrorClient client = new MirrorClient(properties);){
            Map<TopicPartition, OffsetAndMetadata> map = client.remoteConsumerOffsets(consumerGroupId, remoteClusterAlias, timeout);
            return map;
        }
    }
}

