/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jsampler.CC;
import org.jsampler.view.std.BasicPianoRollPainter;
import org.jsampler.view.std.PianoRollPainter;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.event.MidiDataEvent;
import org.linuxsampler.lscp.event.MidiDataListener;

public class PianoRoll
extends JPanel
implements MidiDataListener {
    private final Vector<Key> keys = new Vector();
    private boolean vertical;
    private boolean mirror;
    private boolean octaveLabelsVisible = true;
    private boolean playingEnabled = true;
    private int firstKey = -1;
    private int lastKey = -1;
    private int whiteKeyCount = 68;
    private Integer[] enabledKeys = null;
    private Integer[] disabledKeys = null;
    private Integer[] keyswitches = null;
    private Integer[] notKeyswitches = null;
    private int currentOctave = 3;
    private int constantVelocity = 80;
    private HashMap<Integer, Integer> keyMap = new HashMap();
    private final Vector<MidiDataListener> listeners = new Vector();
    private boolean shouldRepaint = true;
    private PianoRollPainter painter;
    public final Action actionScrollLeft = new ActionScrollLeft();
    public final Action actionScrollRight = new ActionScrollRight();
    public final Action actionIncreaseKeyNumber = new ActionIncreaseKeyNumber();
    public final Action actionDecreaseKeyNumber = new ActionDecreaseKeyNumber();
    private final Handler handler = new Handler();

    public PianoRoll() {
        this(false);
    }

    public PianoRoll(boolean bl) {
        this(bl, false);
    }

    public PianoRoll(boolean bl, boolean bl2) {
        this.vertical = bl;
        this.mirror = bl2;
        this.setPainter(new BasicPianoRollPainter(this));
        this.setKeyRange(0, 127);
        this.installListeneres();
    }

    private void installListeneres() {
        this.addMouseListener(this.getHandler());
        this.addMouseMotionListener(this.getHandler());
        this.addKeyListener(this.getHandler());
        this.registerKeys(this);
    }

    public KeyListener getKeyListener() {
        return this.getHandler();
    }

    public void registerKeys(JComponent jComponent) {
        int n = CC.getViewConfig().getDefaultModKey();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, n);
        jComponent.getInputMap(0).put(keyStroke, "scrollLeft");
        jComponent.getActionMap().put("scrollLeft", this.actionScrollLeft);
        keyStroke = KeyStroke.getKeyStroke(39, n);
        jComponent.getInputMap(0).put(keyStroke, "scrollRight");
        jComponent.getActionMap().put("scrollRight", this.actionScrollRight);
        keyStroke = KeyStroke.getKeyStroke(38, n);
        jComponent.getInputMap(0).put(keyStroke, "increaseKeyRange");
        jComponent.getActionMap().put("increaseKeyRange", this.actionIncreaseKeyNumber);
        keyStroke = KeyStroke.getKeyStroke(40, n);
        jComponent.getInputMap(0).put(keyStroke, "decreaseKeyRange");
        jComponent.getActionMap().put("decreaseKeyRange", this.actionDecreaseKeyNumber);
        keyStroke = KeyStroke.getKeyStroke(48, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave0");
        jComponent.getActionMap().put("changeCurrentOctave0", new ActionChangeCurrentOctave(0));
        keyStroke = KeyStroke.getKeyStroke(49, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave1");
        jComponent.getActionMap().put("changeCurrentOctave1", new ActionChangeCurrentOctave(1));
        keyStroke = KeyStroke.getKeyStroke(50, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave2");
        jComponent.getActionMap().put("changeCurrentOctave2", new ActionChangeCurrentOctave(2));
        keyStroke = KeyStroke.getKeyStroke(51, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave3");
        jComponent.getActionMap().put("changeCurrentOctave3", new ActionChangeCurrentOctave(3));
        keyStroke = KeyStroke.getKeyStroke(52, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave4");
        jComponent.getActionMap().put("changeCurrentOctave4", new ActionChangeCurrentOctave(4));
        keyStroke = KeyStroke.getKeyStroke(53, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave5");
        jComponent.getActionMap().put("changeCurrentOctave5", new ActionChangeCurrentOctave(5));
        keyStroke = KeyStroke.getKeyStroke(54, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave6");
        jComponent.getActionMap().put("changeCurrentOctave6", new ActionChangeCurrentOctave(6));
        keyStroke = KeyStroke.getKeyStroke(55, 0);
        jComponent.getInputMap(0).put(keyStroke, "changeCurrentOctave7");
        jComponent.getActionMap().put("changeCurrentOctave7", new ActionChangeCurrentOctave(7));
    }

    public PianoRollPainter getPainter() {
        return this.painter;
    }

    public void setPainter(PianoRollPainter pianoRollPainter) {
        if (pianoRollPainter == null) {
            pianoRollPainter = new BasicPianoRollPainter(this);
        }
        this.painter = pianoRollPainter;
    }

    public void addMidiDataListener(MidiDataListener midiDataListener) {
        this.listeners.add(midiDataListener);
    }

    public void removeMidiDataListener(MidiDataListener midiDataListener) {
        this.listeners.remove(midiDataListener);
    }

    private void fireMidiDataEvent(MidiDataEvent midiDataEvent) {
        for (MidiDataListener midiDataListener : this.listeners) {
            midiDataListener.midiDataArrived(midiDataEvent);
        }
    }

    private void fireNoteOn(int n, int n2) {
        MidiDataEvent midiDataEvent = new MidiDataEvent(this, MidiDataEvent.Type.NOTE_ON, n, n2);
        this.fireMidiDataEvent(midiDataEvent);
    }

    private void fireNoteOff(int n, int n2) {
        MidiDataEvent midiDataEvent = new MidiDataEvent(this, MidiDataEvent.Type.NOTE_OFF, n, n2);
        this.fireMidiDataEvent(midiDataEvent);
    }

    public int getCurrentOctave() {
        return this.currentOctave;
    }

    public void setCurrentOctave(int n) {
        this.currentOctave = n;
    }

    public int getConstantVelocity() {
        return this.constantVelocity;
    }

    public void setConstantVelocity(int n) {
        this.constantVelocity = n;
    }

    public boolean isPlayingEnabled() {
        return this.playingEnabled;
    }

    public void setPlayingEnabled(boolean bl) {
        this.playingEnabled = bl;
    }

    public boolean hasKey(int n) {
        return n >= this.firstKey && n <= this.lastKey;
    }

    public Key getKey(int n) {
        return this.keys.get(n - this.firstKey);
    }

    public boolean isKeyDisabled(int n) {
        return this.getKey(n).isDisabled();
    }

    public void setKeyDisabled(int n, boolean bl) {
        Key key = this.getKey(n);
        if (key.isDisabled() == bl) {
            return;
        }
        this.getKey(n).setDisabled(bl);
        if (this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public boolean isKeyPressed(int n) {
        return this.getKey(n).isPressed();
    }

    public void setKeyPressed(int n, boolean bl) {
        Key key = this.getKey(n);
        if (key.isPressed() == bl) {
            return;
        }
        this.getKey(n).setPressed(bl);
        if (this.getShouldRepaint()) {
            this.repaint(this.painter.getKeyRectangle(n));
        }
    }

    public boolean isKeyswitch(int n) {
        return this.getKey(n).isKeyswitch();
    }

    public void setKeyswitch(int n, boolean bl) {
        Key key = this.getKey(n);
        if (key.isKeyswitch() == bl) {
            return;
        }
        this.getKey(n).setKeyswitch(bl);
        if (this.getShouldRepaint()) {
            this.repaint(this.painter.getKeyRectangle(n));
        }
    }

    public void setAllKeysPressed(boolean bl) {
        boolean bl2 = false;
        for (Key key : this.keys) {
            if (key.isPressed() == bl) continue;
            key.setPressed(bl);
            bl2 = true;
        }
        if (bl2 && this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public void setAllKeysDisabled(boolean bl) {
        boolean bl2 = false;
        for (Key key : this.keys) {
            if (key.isDisabled() == bl) continue;
            key.setDisabled(bl);
            bl2 = true;
        }
        if (bl2 && this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public Integer[] getKeyswitches() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).isKeyswitch()) continue;
            vector.add(this.firstKey + i);
        }
        return vector.toArray(new Integer[vector.size()]);
    }

    public void setKeyswitches(Integer[] integerArray, boolean bl) {
        if (bl) {
            this.keyswitches = integerArray;
        } else {
            this.notKeyswitches = integerArray;
        }
        if (integerArray == null) {
            return;
        }
        boolean bl2 = false;
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            if (!this.hasKey(n2) || this.getKey(n2).isKeyswitch() == bl) continue;
            this.getKey(n2).setKeyswitch(bl);
            bl2 = true;
        }
        if (bl2 && this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public Integer[] getEnabledKeys() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (this.keys.get(i).isDisabled()) continue;
            vector.add(this.firstKey + i);
        }
        return vector.toArray(new Integer[vector.size()]);
    }

    public void setDisabled(Integer[] integerArray, boolean bl) {
        if (bl) {
            this.disabledKeys = integerArray;
        } else {
            this.enabledKeys = integerArray;
        }
        if (integerArray == null) {
            return;
        }
        boolean bl2 = false;
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            if (!this.hasKey(n2) || this.getKey(n2).isDisabled() == bl) continue;
            this.getKey(n2).setDisabled(bl);
            bl2 = true;
        }
        if (bl2 && this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public void removeAllKeyswitches() {
        boolean bl = false;
        for (Key key : this.keys) {
            if (!key.isKeyswitch()) continue;
            key.setKeyswitch(false);
            bl = true;
        }
        if (bl && this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public void setKeyRange(int n, int n2) {
        boolean bl;
        if (this.firstKey == n && this.lastKey == n2) {
            return;
        }
        if (n < 0 || n > 127 || n2 < 0 || n2 > 127 || n >= n2) {
            throw new IllegalArgumentException("Invalid range: " + n + "-" + n2);
        }
        if (!PianoRoll.isWhiteKey(n)) {
            --n;
        }
        if (!PianoRoll.isWhiteKey(n2)) {
            ++n2;
        }
        this.firstKey = n;
        this.lastKey = n2;
        this.keys.removeAllElements();
        for (bl = false; bl <= n2 - n; bl += 1) {
            this.keys.add(new Key());
        }
        this.whiteKeyCount = PianoRoll.getWhiteKeyCount(n, n2);
        bl = this.getShouldRepaint();
        this.setShouldRepaint(false);
        this.reset(true, false);
        this.setDisabled(this.enabledKeys, false);
        this.setDisabled(this.disabledKeys, true);
        this.setKeyswitches(this.keyswitches, true);
        this.setKeyswitches(this.notKeyswitches, false);
        this.setShouldRepaint(bl);
        if (this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public int getFirstKey() {
        return this.firstKey;
    }

    public int getLastKey() {
        return this.lastKey;
    }

    public boolean getOctaveLabelsVisible() {
        return this.octaveLabelsVisible;
    }

    public void setOctaveLabelsVisible(boolean bl) {
        this.octaveLabelsVisible = bl;
    }

    public static int getWhiteKeyCount(int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!PianoRoll.isWhiteKey(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int getWhiteKeyByNumber(int n) {
        int n2 = 0;
        for (int i = this.firstKey; i <= this.lastKey; ++i) {
            if (!PianoRoll.isWhiteKey(i)) continue;
            if (n == n2) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    public int getWhiteKeyCount() {
        return this.whiteKeyCount;
    }

    public static boolean isWhiteKey(int n) {
        if (n < 0 || n > 127) {
            return false;
        }
        int n2 = n % 12;
        return n2 != 1 && n2 != 3 && n2 != 6 && n2 != 8 && n2 != 10;
    }

    public static int getKeyOctaveIndex(int n) {
        if (n < 0 || n > 127) {
            return -1;
        }
        int n2 = n % 12;
        if (n2 == 1 || n2 == 3 || n2 == 6 || n2 == 8 || n2 == 10) {
            return -1;
        }
        return PianoRoll.getWhiteKeyCount(0, n2) - 1;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.reset(bl, true);
    }

    private void reset(boolean bl, boolean bl2) {
        if (bl2) {
            this.enabledKeys = null;
            this.disabledKeys = null;
            this.keyswitches = null;
            this.notKeyswitches = null;
        }
        boolean bl3 = this.getShouldRepaint();
        this.setShouldRepaint(false);
        this.setAllKeysPressed(false);
        this.removeAllKeyswitches();
        this.setAllKeysDisabled(bl);
        this.setShouldRepaint(bl3);
        if (this.getShouldRepaint()) {
            this.repaint();
        }
    }

    public boolean getShouldRepaint() {
        return this.shouldRepaint;
    }

    public void setShouldRepaint(boolean bl) {
        this.shouldRepaint = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.painter.paint(this, (Graphics2D)graphics);
    }

    @Override
    public void midiDataArrived(MidiDataEvent midiDataEvent) {
        switch (midiDataEvent.getType()) {
            case NOTE_ON: {
                this.setKeyPressed(midiDataEvent.getNote(), true);
                break;
            }
            case NOTE_OFF: {
                this.setKeyPressed(midiDataEvent.getNote(), false);
            }
        }
    }

    private void keyPressed(int n, int n2) {
        this.fireNoteOn(n2, this.getConstantVelocity());
        this.keyMap.put(n, n2);
    }

    private void keyPressed(int n) {
        if (!this.isPlayingEnabled()) {
            return;
        }
        int n2 = (this.getCurrentOctave() + 2) * 12;
        switch (n) {
            case 65: {
                this.keyPressed(n, n2);
                break;
            }
            case 87: {
                this.keyPressed(n, n2 + 1);
                break;
            }
            case 83: {
                this.keyPressed(n, n2 + 2);
                break;
            }
            case 69: {
                this.keyPressed(n, n2 + 3);
                break;
            }
            case 68: {
                this.keyPressed(n, n2 + 4);
                break;
            }
            case 70: {
                this.keyPressed(n, n2 + 5);
                break;
            }
            case 84: {
                this.keyPressed(n, n2 + 6);
                break;
            }
            case 71: {
                this.keyPressed(n, n2 + 7);
                break;
            }
            case 89: {
                this.keyPressed(n, n2 + 8);
                break;
            }
            case 72: {
                this.keyPressed(n, n2 + 9);
                break;
            }
            case 85: {
                this.keyPressed(n, n2 + 10);
                break;
            }
            case 74: {
                this.keyPressed(n, n2 + 11);
                break;
            }
            case 75: {
                this.keyPressed(n, n2 + 12);
                break;
            }
            case 79: {
                this.keyPressed(n, n2 + 13);
                break;
            }
            case 76: {
                this.keyPressed(n, n2 + 14);
                break;
            }
            case 80: {
                this.keyPressed(n, n2 + 15);
                break;
            }
            case 59: {
                this.keyPressed(n, n2 + 16);
                break;
            }
            case 222: {
                this.keyPressed(n, n2 + 17);
            }
        }
    }

    public void keyReleased(int n) {
        if (!this.isPlayingEnabled()) {
            return;
        }
        switch (n) {
            case 59: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: 
            case 222: {
                if (this.keyMap.get(n) == null) {
                    return;
                }
                this.fireNoteOff(this.keyMap.get(n), this.getConstantVelocity());
                this.keyMap.remove(n);
            }
        }
    }

    private Handler getHandler() {
        return this.handler;
    }

    class Fix4153069
    implements Runnable,
    ActionListener {
        KeyEvent e;
        int count = 0;

        Fix4153069(KeyEvent keyEvent) {
            this.e = keyEvent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        @Override
        public void run() {
            Long l = (Long)PianoRoll.this.getHandler().pressedKeysMap.get(this.e.getKeyCode());
            if (l == null || l < this.e.getWhen()) {
                if (l != null && this.delay()) {
                    return;
                }
                PianoRoll.this.getHandler().pressedKeysMap.remove(this.e.getKeyCode());
                PianoRoll.this.getHandler().keyReleasedNoAutoRepeat(this.e);
            }
        }

        private boolean delay() {
            if (this.count < 1) {
                ++this.count;
                Timer timer = new Timer(4, this);
                timer.setRepeats(false);
                timer.start();
                return true;
            }
            return false;
        }
    }

    private class Handler
    extends MouseAdapter
    implements KeyListener {
        private int pressedKey = -1;
        private HashMap<Integer, Long> pressedKeysMap = new HashMap();

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PianoRoll.this.requestFocusInWindow();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!PianoRoll.this.isPlayingEnabled()) {
                return;
            }
            if (mouseEvent.getButton() != 1) {
                return;
            }
            int n = PianoRoll.this.painter.getKeyByPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.pressedKey = n;
            PianoRoll.this.setKeyPressed(n, true);
            int n2 = PianoRoll.this.painter.getVelocity(mouseEvent.getPoint(), n);
            PianoRoll.this.fireNoteOn(n, n2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!PianoRoll.this.isPlayingEnabled()) {
                return;
            }
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (this.pressedKey == -1) {
                return;
            }
            PianoRoll.this.setKeyPressed(this.pressedKey, false);
            int n = PianoRoll.this.painter.getVelocity(mouseEvent.getPoint(), this.pressedKey);
            MidiDataEvent midiDataEvent = new MidiDataEvent(PianoRoll.this, MidiDataEvent.Type.NOTE_OFF, this.pressedKey, n);
            this.pressedKey = -1;
            PianoRoll.this.fireMidiDataEvent(midiDataEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!PianoRoll.this.isPlayingEnabled()) {
                return;
            }
            if (this.pressedKey == -1) {
                return;
            }
            int n = PianoRoll.this.painter.getKeyByPoint(mouseEvent.getPoint());
            if (n == this.pressedKey) {
                return;
            }
            PianoRoll.this.setKeyPressed(this.pressedKey, false);
            int n2 = PianoRoll.this.painter.getVelocity(mouseEvent.getPoint(), this.pressedKey);
            PianoRoll.this.fireNoteOff(this.pressedKey, n2);
            this.pressedKey = n;
            if (this.pressedKey == -1) {
                return;
            }
            PianoRoll.this.setKeyPressed(n, true);
            n2 = PianoRoll.this.painter.getVelocity(mouseEvent.getPoint(), n);
            PianoRoll.this.fireNoteOn(n, n2);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.pressedKeysMap.get(keyEvent.getKeyCode()) == null) {
                this.keyPressedNoAutoRepeat(keyEvent);
            }
            this.pressedKeysMap.put(keyEvent.getKeyCode(), keyEvent.getWhen());
        }

        public void keyPressedNoAutoRepeat(KeyEvent keyEvent) {
            if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isMetaDown())) {
                PianoRoll.this.keyPressed(keyEvent.getKeyCode());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            SwingUtilities.invokeLater(new Fix4153069(keyEvent));
        }

        public void keyReleasedNoAutoRepeat(KeyEvent keyEvent) {
            PianoRoll.this.keyReleased(keyEvent.getKeyCode());
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class ActionChangeCurrentOctave
    extends AbstractAction {
        private int octave;

        ActionChangeCurrentOctave(int n) {
            super("");
            this.octave = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PianoRoll.this.setCurrentOctave(this.octave);
        }
    }

    private class ActionDecreaseKeyNumber
    extends AbstractAction {
        ActionDecreaseKeyNumber() {
            super(StdI18n.i18n.getLabel("PianoRoll.decreaseKeyNumber"));
            String string = StdI18n.i18n.getLabel("PianoRoll.decreaseKeyNumber");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (PianoRoll.this.getLastKey() - PianoRoll.this.getFirstKey() < 31) {
                return;
            }
            int n2 = PianoRoll.this.getFirstKey() + 1;
            if (!PianoRoll.isWhiteKey(n2)) {
                ++n2;
            }
            if (!PianoRoll.isWhiteKey(n = PianoRoll.this.getLastKey() - 1)) {
                --n;
            }
            PianoRoll.this.setKeyRange(n2, n);
            CC.preferences().setIntProperty("midiKeyboard.firstKey", n2);
            CC.preferences().setIntProperty("midiKeyboard.lastKey", n);
        }
    }

    private class ActionIncreaseKeyNumber
    extends AbstractAction {
        ActionIncreaseKeyNumber() {
            super(StdI18n.i18n.getLabel("PianoRoll.increaseKeyNumber"));
            String string = StdI18n.i18n.getLabel("PianoRoll.increaseKeyNumber");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            if (PianoRoll.this.getFirstKey() == 0 && PianoRoll.this.getLastKey() == 127) {
                return;
            }
            int n3 = n2 = PianoRoll.this.getFirstKey() == 0 ? 0 : PianoRoll.this.getFirstKey() - 1;
            if (!PianoRoll.isWhiteKey(n2)) {
                --n2;
            }
            int n4 = n = PianoRoll.this.getLastKey() == 127 ? 127 : PianoRoll.this.getLastKey() + 1;
            if (!PianoRoll.isWhiteKey(n)) {
                ++n;
            }
            PianoRoll.this.setKeyRange(n2, n);
            CC.preferences().setIntProperty("midiKeyboard.firstKey", n2);
            CC.preferences().setIntProperty("midiKeyboard.lastKey", n);
        }
    }

    private class ActionScrollRight
    extends AbstractAction {
        ActionScrollRight() {
            super(StdI18n.i18n.getLabel("PianoRoll.scrollRight"));
            String string = StdI18n.i18n.getLabel("PianoRoll.scrollRight");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (PianoRoll.this.getLastKey() == 127) {
                return;
            }
            int n2 = PianoRoll.this.getFirstKey() + 1;
            if (!PianoRoll.isWhiteKey(n2)) {
                ++n2;
            }
            if (!PianoRoll.isWhiteKey(n = PianoRoll.this.getLastKey() + 1)) {
                ++n;
            }
            PianoRoll.this.setKeyRange(n2, n);
            CC.preferences().setIntProperty("midiKeyboard.firstKey", n2);
            CC.preferences().setIntProperty("midiKeyboard.lastKey", n);
        }
    }

    private class ActionScrollLeft
    extends AbstractAction {
        ActionScrollLeft() {
            super(StdI18n.i18n.getLabel("PianoRoll.scrollLeft"));
            String string = StdI18n.i18n.getLabel("PianoRoll.scrollLeft");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (PianoRoll.this.getFirstKey() == 0) {
                return;
            }
            int n2 = PianoRoll.this.getFirstKey() - 1;
            if (!PianoRoll.isWhiteKey(n2)) {
                --n2;
            }
            if (!PianoRoll.isWhiteKey(n = PianoRoll.this.getLastKey() - 1)) {
                --n;
            }
            PianoRoll.this.setKeyRange(n2, n);
            CC.preferences().setIntProperty("midiKeyboard.firstKey", n2);
            CC.preferences().setIntProperty("midiKeyboard.lastKey", n);
        }
    }

    public class Key {
        private boolean disabled = false;
        private boolean pressed = false;
        private boolean keyswitch = false;

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean bl) {
            this.disabled = bl;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setPressed(boolean bl) {
            this.pressed = bl;
        }

        public boolean isKeyswitch() {
            return this.keyswitch;
        }

        public void setKeyswitch(boolean bl) {
            this.keyswitch = bl;
        }
    }
}

