/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.functions.Count;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexMatchHandler;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntHashMap;

public class JRegexIterator
implements RegexIterator,
LastPositionFinder {
    private final String theString;
    private final Pattern pattern;
    private final Matcher matcher;
    private String current;
    private String nextSubstring;
    private int prevEnd = 0;
    private IntToIntHashMap nestingTable = null;

    public JRegexIterator(String str, Pattern pattern) {
        this.theString = str;
        this.pattern = pattern;
        this.matcher = pattern.matcher(str);
        this.nextSubstring = null;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        JRegexIterator another = new JRegexIterator(this.theString, this.pattern);
        return Count.steppingCount(another);
    }

    @Override
    public StringValue next() {
        if (this.nextSubstring == null && this.prevEnd >= 0) {
            if (this.matcher.find()) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                if (this.prevEnd == start) {
                    this.nextSubstring = null;
                    this.current = this.theString.substring(start, end);
                    this.prevEnd = end;
                } else {
                    this.current = this.theString.substring(this.prevEnd, start);
                    this.nextSubstring = this.theString.substring(start, end);
                }
            } else {
                if (this.prevEnd >= this.theString.length()) {
                    this.current = null;
                    this.prevEnd = -1;
                    return null;
                }
                this.current = this.theString.substring(this.prevEnd);
                this.nextSubstring = null;
                this.prevEnd = -1;
            }
        } else if (this.prevEnd >= 0) {
            this.current = this.nextSubstring;
            this.nextSubstring = null;
            this.prevEnd = this.matcher.end();
        } else {
            this.current = null;
            return null;
        }
        return StringValue.makeStringValue(this.current);
    }

    @Override
    public boolean isMatching() {
        return this.nextSubstring == null && this.prevEnd >= 0;
    }

    @Override
    public UnicodeString getRegexGroup(int number) {
        if (!this.isMatching()) {
            return null;
        }
        if (number > this.matcher.groupCount() || number < 0) {
            return EmptyUnicodeString.getInstance();
        }
        String s = this.matcher.group(number);
        if (s == null) {
            return EmptyUnicodeString.getInstance();
        }
        return StringView.of(s).tidy();
    }

    @Override
    public int getNumberOfGroups() {
        return this.matcher.groupCount();
    }

    @Override
    public void processMatchingSubstring(RegexMatchHandler action) throws XPathException {
        int c = this.matcher.groupCount();
        if (c == 0) {
            action.characters(StringView.of(this.current));
        } else {
            IntHashMap actions = new IntHashMap(c);
            for (int i = 1; i <= c; ++i) {
                int start = this.matcher.start(i) - this.matcher.start();
                if (start == -1) continue;
                int end = this.matcher.end(i) - this.matcher.start();
                if (start < end) {
                    ArrayList<Integer> s = (ArrayList<Integer>)actions.get(start);
                    if (s == null) {
                        s = new ArrayList<Integer>(4);
                        actions.put(start, s);
                    }
                    s.add(i);
                    ArrayList<Integer> e = (ArrayList<Integer>)actions.get(end);
                    if (e == null) {
                        e = new ArrayList<Integer>(4);
                        actions.put(end, e);
                    }
                    e.add(0, -i);
                    continue;
                }
                if (this.nestingTable == null) {
                    this.computeNestingTable();
                }
                int parentGroup = this.nestingTable.get(i);
                ArrayList<Integer> s = (ArrayList<Integer>)actions.get(start);
                if (s == null) {
                    s = new ArrayList<Integer>(4);
                    actions.put(start, s);
                    s.add(i);
                    s.add(-i);
                    continue;
                }
                int pos = s.size();
                for (int e = 0; e < s.size(); ++e) {
                    if ((Integer)s.get(e) != -parentGroup) continue;
                    pos = e;
                    break;
                }
                s.add(pos, -i);
                s.add(pos, i);
            }
            UnicodeBuilder buff = new UnicodeBuilder();
            for (int i = 0; i < this.current.length() + 1; ++i) {
                List events = (List)actions.get(i);
                if (events != null) {
                    if (buff.length() > 0L) {
                        action.characters(buff.toUnicodeString());
                        buff.clear();
                    }
                    Iterator iterator = events.iterator();
                    while (iterator.hasNext()) {
                        int group = (Integer)iterator.next();
                        if (group > 0) {
                            action.onGroupStart(group);
                            continue;
                        }
                        action.onGroupEnd(-group);
                    }
                }
                if (i >= this.current.length()) continue;
                buff.append(this.current.charAt(i));
            }
            if (buff.length() > 0L) {
                action.characters(buff.toUnicodeString());
            }
        }
    }

    private void computeNestingTable() {
        this.nestingTable = new IntToIntHashMap(16);
        String s = this.pattern.pattern();
        int[] stack = new int[s.length()];
        int tos = 0;
        int group = 1;
        int inBrackets = 0;
        stack[tos++] = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\'') {
                ++i;
                continue;
            }
            if (ch == '[') {
                ++inBrackets;
                continue;
            }
            if (ch == ']') {
                --inBrackets;
                continue;
            }
            if (ch == '(' && s.charAt(i + 1) != '?' && inBrackets == 0) {
                this.nestingTable.put(group, stack[tos - 1]);
                stack[tos++] = group++;
                continue;
            }
            if (ch != ')' || inBrackets != 0) continue;
            --tos;
        }
    }
}

