/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformOutputsInternal;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.internal.GFileUtils;

public class DefaultTransformOutputs
implements TransformOutputsInternal {
    private final TransformExecutionResult.OutputTypeInferringBuilder resultBuilder;
    private final Set<File> outputDirectories = new HashSet<File>();
    private final Set<File> outputFiles = new HashSet<File>();
    private final PathToFileResolver resolver;
    private final File inputArtifact;
    private final File outputDir;

    public DefaultTransformOutputs(File inputArtifact, File outputDir, FileLookup fileLookup) {
        this.resolver = fileLookup.getPathToFileResolver(outputDir);
        this.inputArtifact = inputArtifact;
        this.outputDir = outputDir;
        this.resultBuilder = TransformExecutionResult.builderFor(inputArtifact, outputDir);
    }

    @Override
    public TransformExecutionResult getRegisteredOutputs() {
        TransformExecutionResult result = this.resultBuilder.build();
        result.visitOutputs(new TransformExecutionResult.OutputVisitor(){

            @Override
            public void visitEntireInputArtifact() {
                this.validate(DefaultTransformOutputs.this.inputArtifact);
            }

            @Override
            public void visitPartOfInputArtifact(String relativePath) {
                this.validate(new File(DefaultTransformOutputs.this.inputArtifact, relativePath));
            }

            @Override
            public void visitProducedOutput(String relativePath) {
                this.validate(new File(DefaultTransformOutputs.this.outputDir, relativePath));
            }

            private void validate(File output) {
                DefaultTransformOutputs.validateOutputExists(DefaultTransformOutputs.this.outputDir, output);
                if (DefaultTransformOutputs.this.outputFiles.contains(output) && !output.isFile()) {
                    throw new InvalidUserDataException("Transform output file " + output.getPath() + " must be a file, but is not.");
                }
                if (DefaultTransformOutputs.this.outputDirectories.contains(output) && !output.isDirectory()) {
                    throw new InvalidUserDataException("Transform output directory " + output.getPath() + " must be a directory, but is not.");
                }
            }
        });
        return result;
    }

    public File dir(Object path) {
        File outputDir = this.resolveAndRegister(path, GFileUtils::mkdirs);
        this.outputDirectories.add(outputDir);
        return outputDir;
    }

    public File file(Object path) {
        File outputFile = this.resolveAndRegister(path, location -> GFileUtils.mkdirs((File)location.getParentFile()));
        this.outputFiles.add(outputFile);
        return outputFile;
    }

    private File resolveAndRegister(Object path, Consumer<File> prepareOutputLocation) {
        File output = this.resolver.resolve(path);
        this.resultBuilder.addOutput(output, prepareOutputLocation);
        return output;
    }

    private static void validateOutputExists(File outputDir, File output) {
        if (!output.exists()) {
            String outputDirPrefix;
            String outputAbsolutePath = output.getAbsolutePath();
            String reportedPath = outputAbsolutePath.startsWith(outputDirPrefix = outputDir.getAbsolutePath() + File.separator) ? outputAbsolutePath.substring(outputDirPrefix.length()) : outputAbsolutePath;
            throw new InvalidUserDataException("Transform output " + reportedPath + " must exist.");
        }
    }
}

