/* $Id: control_codes.h 9874 2007-05-19 09:40:18Z rubidium $ */

#ifndef CONTROL_CODES_H
#define CONTROL_CODES_H

/* List of string control codes used for string formatting, displaying, and
 * by strgen to generate the language files. */

enum {
	SCC_CONTROL_START = 0xE000,
	SCC_CONTROL_END   = 0xE1FF,

	SCC_SPRITE_START  = 0xE200,
	SCC_SPRITE_END    = SCC_SPRITE_START + 0xFF,

	/* Display control codes */
	SCC_SETX = SCC_CONTROL_START,
	SCC_SETXY,
	SCC_TINYFONT,
	SCC_BIGFONT,

	/* Formatting control codes */
	SCC_REVISION,
	SCC_STATION_FEATURES,
	SCC_INDUSTRY_NAME,
	SCC_WAYPOINT_NAME,
	SCC_STATION_NAME,
	SCC_TOWN_NAME,
	SCC_GROUP_NAME,

	SCC_CURRENCY_COMPACT,
	SCC_CURRENCY_COMPACT_64,
	SCC_CURRENCY,
	SCC_CURRENCY_64,

	SCC_CARGO,
	SCC_CARGO_SHORT,
	SCC_POWER,
	SCC_VOLUME,
	SCC_VOLUME_SHORT,
	SCC_WEIGHT,
	SCC_WEIGHT_SHORT,
	SCC_FORCE,
	SCC_VELOCITY,

	SCC_DATE_TINY,
	SCC_DATE_SHORT,
	SCC_DATE_LONG,

	SCC_STRING1,
	SCC_STRING2,
	SCC_STRING3,
	SCC_STRING4,
	SCC_STRING5,

	SCC_SKIP,
	SCC_STRING,
	SCC_COMMA,
	SCC_NUM,

	SCC_STRING_ID,
	SCC_PLURAL_LIST,
	SCC_GENDER_LIST,
	SCC_GENDER_INDEX,
	SCC_ARG_INDEX,
	SCC_SETCASE,
	SCC_SWITCH_CASE,

	/* Colour codes */
	SCC_BLUE,
	SCC_SILVER,
	SCC_GOLD,
	SCC_RED,
	SCC_PURPLE,
	SCC_LTBROWN,
	SCC_ORANGE,
	SCC_GREEN,
	SCC_YELLOW,
	SCC_DKGREEN,
	SCC_CREAM,
	SCC_BROWN,
	SCC_WHITE,
	SCC_LTBLUE,
	SCC_GRAY,
	SCC_DKBLUE,
	SCC_BLACK,

	/* Special printable symbols.
	 * These are mapped to the original glyphs */
	SCC_LESSTHAN       = SCC_SPRITE_START + 0x3C,
	SCC_GREATERTHAN    = SCC_SPRITE_START + 0x3E,
	SCC_UPARROW        = SCC_SPRITE_START + 0x80,
	SCC_SMALLUPARROW   = SCC_SPRITE_START + 0x90,
	SCC_SMALLDOWNARROW = SCC_SPRITE_START + 0x91,
	SCC_TRAIN          = SCC_SPRITE_START + 0x94,
	SCC_LORRY          = SCC_SPRITE_START + 0x95,
	SCC_BUS            = SCC_SPRITE_START + 0x96,
	SCC_PLANE          = SCC_SPRITE_START + 0x97,
	SCC_SHIP           = SCC_SPRITE_START + 0x98,
	SCC_DOWNARROW      = SCC_SPRITE_START + 0xAA,
	SCC_CHECKMARK      = SCC_SPRITE_START + 0xAC,
	SCC_CROSS          = SCC_SPRITE_START + 0xAD,
	SCC_RIGHTARROW     = SCC_SPRITE_START + 0xAF,
};

#endif /* CONTROL_CODES_H */
