/* $Id: town_land.h 9366 2007-03-20 02:24:14Z belugas $ */

/** @file town_land.h */


/** Writes the data into the Town Tile Drawing Struct
 * @param s1 The first sprite of the building, mostly the ground sprite
 * @param s2 The second sprite of the building.
 * @param sx The x-position of the sprite within the tile
 * @param xy the y-position of the sprite within the tile
 * @param w the width of the sprite
 * @param h the height of the sprite
 * @param dz the virtual height of the sprite
 * @param p set to 1 if a lift is present
 * @see DrawTownTileStruct
 */
#define M(s1, p1, s2, p2, sx, sy, w, h, dz, p) { { s1, p1 }, { s2, p2 }, sx, sy, w - 1, h - 1, dz, p}

static const DrawBuildingsTileStruct _town_draw_tile_data[] = {
	M( 0xf54, PAL_NONE,  0x58d, PAL_NONE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58f, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x58f, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PAL_NONE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PAL_NONE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PALETTE_TO_STRUCT_WHITE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x58d, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,   8, 0),
	M( 0xf54, PAL_NONE,  0x58e, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x591, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0x590, PAL_NONE,  0x591, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 14, 14,  60, 0),
	M( 0xf54, PAL_NONE,  0x592, PAL_NONE,  0,  0, 14, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PAL_NONE,  0,  0, 14, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x592, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,  0x593, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x594, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0x595, PAL_NONE,  0x594, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  33, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x596, PAL_NONE,  0,  0, 12, 12,   6, 0),
	M( 0xf54, PAL_NONE,  0x597, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0x599, PAL_NONE,  0x598, PAL_NONE,  0,  0, 12, 12,  17, 0),
	M( 0xf54, PAL_NONE,  0x59a, PAL_NONE,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PAL_NONE,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PAL_NONE,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PAL_NONE,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59E,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59E,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59E,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59E,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59F,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59F,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x59a, PALETTE_59F,  0,  0, 14, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x59b, PALETTE_59F,  0,  0, 14, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0x59d, PAL_NONE,  0x59c, PALETTE_59F,  0,  0, 14, 16,  35, 0),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE,  0x5a2, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a0, PAL_NONE,  0,  0, 15, 15,   5, 0),
	M( 0xf54, PAL_NONE,  0x5a1, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0xf54, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 0),
	M( 0x58c, PAL_NONE, 0x11d9, PAL_NONE,  0,  0, 15, 15,  53, 1),
	M( 0xf54, PAL_NONE,  0x5a4, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a5, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5a7, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a4, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a5, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5a7, PAL_NONE,  0x5a6, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5dd, PAL_NONE,  0x5de, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5df, PAL_NONE,  0x5e0, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5dd, PAL_NONE,  0x5de, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5df, PAL_NONE,  0x5e0, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0x5e1, PAL_NONE,  0x5e2, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5a8, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5a9, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5aa, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5ab, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5ac, PAL_NONE,  0,  0, 16, 16,  38, 0),
	M( 0xf54, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0x58c, PAL_NONE,  0x5ad, PAL_NONE,  0,  0, 16, 16,  45, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0x58c, PAL_NONE,  0x5ae, PAL_NONE,  6,  5,  3,  6,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,    0x0, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0x58c, PAL_NONE,  0x5af, PAL_NONE,  3,  3,  9,  9,   8, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf8d, PAL_NONE,  0x5b1, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PAL_NONE,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_RED,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b2, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,   8, 0),
	M( 0xf54, PAL_NONE,  0x5b3, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0x58c, PAL_NONE,  0x5b4, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b5, PAL_NONE,  1,  3, 14, 11,   7, 0),
	M( 0xf54, PAL_NONE,  0x5b6, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0x58c, PAL_NONE,  0x5b7, PAL_NONE,  1,  3, 14, 11,  53, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5b8, PAL_NONE,  3,  1, 11, 14,   6, 0),
	M( 0xf54, PAL_NONE,  0x5b9, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0x58c, PAL_NONE,  0x5ba, PAL_NONE,  3,  1, 11, 14,  28, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PAL_NONE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PAL_NONE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PAL_NONE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PAL_NONE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PAL_NONE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_BLUE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5bb, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,   6, 0),
	M( 0xf54, PAL_NONE,  0x5bc, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  45, 0),
	M( 0xf54, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  46, 0),
	M( 0x58c, PAL_NONE,  0x5bd, PALETTE_TO_STRUCT_WHITE,  2,  0, 13, 16,  46, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_RED,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_RED,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_BLUE,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_BLUE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_ORANGE,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_ORANGE,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5be, PALETTE_TO_GREEN,  2,  0, 13, 16,  13, 0),
	M( 0xf54, PAL_NONE,  0x5bf, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c0, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0x58c, PAL_NONE,  0x5c0, PALETTE_TO_GREEN,  2,  0, 13, 16, 110, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c1, PAL_NONE,  1,  2, 15, 12,   4, 0),
	M( 0xf54, PAL_NONE,  0x5c2, PAL_NONE,  1,  2, 15, 12,  24, 0),
	M( 0xf54, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0x58c, PAL_NONE,  0x5c3, PAL_NONE,  1,  2, 15, 12,  31, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c4, PAL_NONE,  1,  0, 14, 15,  20, 0),
	M( 0xf54, PAL_NONE,  0x5c5, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0xf54, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x58c, PAL_NONE,  0x5c6, PAL_NONE,  1,  0, 14, 15,  42, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c7, PAL_NONE,  0x5cb, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c8, PAL_NONE,  0x5cc, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5c9, PAL_NONE,  0x5cd, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x5ca, PAL_NONE,  0x5ce, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d3, PAL_NONE,  0x5d4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d5, PAL_NONE,  0x5d6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0x5cf, PAL_NONE,  0x5d0, PAL_NONE,  0,  0, 16, 16,  21, 0),
	M( 0xf54, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0x5d1, PAL_NONE,  0x5d2, PAL_NONE,  0,  0, 16, 16,  11, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d7, PAL_NONE,  0x5d8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5d9, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5da, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5db, PAL_NONE,  0x5dc, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5db, PAL_NONE,  0x5dc, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x622, PAL_NONE,  0x623, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x624, PAL_NONE,  0x625, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x626, PAL_NONE,  0x627, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x626, PAL_NONE,  0x627, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e3, PAL_NONE,  0x5e4, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e5, PAL_NONE,  0x5e6, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e7, PAL_NONE,  0x5e8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e7, PAL_NONE,  0x5e8, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5e9, PAL_NONE,  0x5ea, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5eb, PAL_NONE,  0x5ec, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ed, PAL_NONE,  0x5ee, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ed, PAL_NONE,  0x5ee, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ef, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f0, PAL_NONE,  0x5f1, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5ef, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f0, PAL_NONE,  0x5f1, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f2, PAL_NONE,  0x5f3, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f4, PAL_NONE,  0x5f5, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f6, PAL_NONE,  0x5f7, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f4, PAL_NONE,  0x5f5, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f6, PAL_NONE,  0x5f7, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5f8, PAL_NONE,  0x5f9, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x5fa, PAL_NONE,  0x5fb, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fc, PAL_NONE,  0x5fd, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fa, PAL_NONE,  0x5fb, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fc, PAL_NONE,  0x5fd, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x5fe, PAL_NONE,  0x5ff, PAL_NONE,  0,  0, 16, 16,  85, 0),
	M( 0x60a, PAL_NONE,  0x60b, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60c, PAL_NONE,  0x60d, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60a, PAL_NONE,  0x60b, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60c, PAL_NONE,  0x60d, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0x60e, PAL_NONE,  0x60f, PAL_NONE,  0,  0, 16, 16,  95, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PAL_NONE,  0x601, PAL_NONE,  0,  0, 16, 16,  55, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0x600, PALETTE_TO_STRUCT_WHITE,  0x601, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  55, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PAL_NONE,  0x603, PAL_NONE,  0,  0, 16, 16,  42, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x602, PALETTE_TO_STRUCT_CONCRETE,  0x603, PALETTE_TO_STRUCT_CONCRETE,  0,  0, 16, 16,  42, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x604, PAL_NONE,  0x605, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x606, PAL_NONE,  0x607, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0x608, PAL_NONE,  0x609, PAL_NONE,  0,  0, 16, 16,  88, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x610, PAL_NONE,  0x611, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x612, PAL_NONE,  0x616, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x613, PAL_NONE,  0x617, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x614, PAL_NONE,  0x618, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0x615, PAL_NONE,  0x619, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61a, PAL_NONE,  0x61b, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0x61c, PAL_NONE,  0x61d, PAL_NONE,  0,  0, 16, 16, 100, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PAL_NONE,  0x61f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0x61e, PALETTE_TO_STRUCT_WHITE,  0x61f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0x620, PAL_NONE,  0x621, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0x620, PALETTE_TO_CREAM,  0x621, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PAL_NONE, 0x11db, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M(0x11da, PALETTE_TO_STRUCT_WHITE, 0x11db, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PAL_NONE, 0x11dd, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M(0x11dc, PALETTE_TO_CREAM, 0x11dd, PALETTE_TO_CREAM,  0,  0, 16, 16,  25, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  22, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1134, PAL_NONE, 0x1135, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1136, PAL_NONE, 0x1137, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113b, PAL_NONE, 0x113c, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1138, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113d, PAL_NONE, 0x113e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1139, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113f, PAL_NONE, 0x1140, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x113a, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1141, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1144, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1145, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1146, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x1147, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1142, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1148, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1149, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1143, PAL_NONE, 0x114b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M(0x114c, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_PINK,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114e, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x114f, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1150, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M(0x114d, PAL_NONE, 0x1151, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1153, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1155, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x1155, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1153, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1154, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11de, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1152, PAL_NONE, 0x11de, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1159, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x1159, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_CREAM,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1157, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1158, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11df, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M(0x1156, PAL_NONE, 0x11df, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115d, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x115d, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115b, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x115c, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e0, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x115a, PAL_NONE, 0x11e0, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115e, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115e, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1164, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1164, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115f, PAL_NONE, 0x1163, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1160, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1161, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1162, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x115f, PAL_NONE, 0x1163, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1165, PAL_NONE, 0x1169, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1166, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1167, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x1168, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x1165, PAL_NONE, 0x1169, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x116d, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116b, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x116c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116a, PAL_NONE, 0x11e2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x1171, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116f, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1170, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x116e, PAL_NONE, 0x11e3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M(0x1172, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_BROWN,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_CREAM,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1173, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1174, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1175, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M(0x11e4, PAL_NONE, 0x11e5, PALETTE_TO_GREY,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1176, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11e6, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117b, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117c, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1177, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1179, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e7, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M(0x1178, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117a, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11e8, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x117f, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e3, PALETTE_TO_STRUCT_BROWN,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117d, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x117e, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M( 0x58c, PAL_NONE, 0x11e1, PALETTE_TO_STRUCT_WHITE,  0,  0, 16, 16,  50, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1184, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_DARK_GREEN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_ORANGE,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_BROWN,  0,  0, 16, 16,  60, 0),
	M(0x1180, PAL_NONE, 0x1181, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x1182, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1183, PAL_NONE, 0x11e9, PALETTE_TO_GREY,  0,  0, 16, 16,  60, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x118b, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118c, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1187, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x1189, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1185, PAL_NONE, 0x11ea, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x1188, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x118a, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(0x1186, PAL_NONE, 0x11eb, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ec, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ed, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ee, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ef, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f1, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f2, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f3, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11f4, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f5, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f6, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f7, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f8, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11f9, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fa, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x11fb, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fc, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fd, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11fe, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x11ff, PAL_NONE,  0,  0, 16, 16,  40, 0),
	M( 0xf54, PAL_NONE, 0x1200, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1200, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1201, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1202, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_PINK,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_YELLOW,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1203, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1204, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1205, PALETTE_TO_RED,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1206, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1208, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120a, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1207, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x1209, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120b, PAL_NONE,  0,  0, 16, 16,  80, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120c, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120d, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120e, PAL_NONE,  0,  0, 16, 16,  60, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x120f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1210, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M( 0xf54, PAL_NONE, 0x1211, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1213, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1215, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1213, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1215, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1213, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1214, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1215, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1213, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1214, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1215, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1216, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1217, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1218, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1219, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1221, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121f, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1221, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x121f, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1220, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1221, PALETTE_TO_MAUVE, 0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x121f, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1220, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1221, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1222, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1224, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1222, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1224, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1222, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1223, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1224, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1222, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1223, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1224, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1225, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1227, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1225, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1227, PALETTE_TO_PINK,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1225, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1226, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1227, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1225, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1226, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1227, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1228, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1229, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x122f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x122e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1230, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1231, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1232, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1233, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1234, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1235, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1236, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1237, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1238, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1239, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x123c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x123f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1240, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1241, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1242, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_PALE_GREEN,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1256, PALETTE_TO_RED,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x1256, PALETTE_TO_CREAM,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1257, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1258, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1243, PAL_NONE, 0x1259, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE,    0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(0x1244, PAL_NONE, 0x125a, PAL_NONE,  0,  0, 16, 16,  50, 0),
};
#undef M
/* 4 variants * 4 build stages */
assert_compile(lengthof(_town_draw_tile_data) == (NEW_HOUSE_OFFSET) * 4 * 4);

/** Describes the data that defines each house in the game
 * @param mnd introduction year of the house
 * @param mxd last year it can be built
 * @param p   population
 * @param rc  cost multiplier for removing it
 * @param bn  building name
 * @param rr  rating decrease if removed
 * @param mg  mail generation multiplier
 * @param ca1 acceptance for 1st CargoID
 * @param ca2 acceptance for 2nd CargoID
 * @param ca3 acceptance for 3rd CargoID
 * @param bf  building flags (size, stadium etc...)
 * @param ba  building availability (zone, climate...)
 * @param cg1 1st CargoID available
 * @param cg2 2nd CargoID available
 * @param cg3 3rd CargoID available
 * @see HouseSpec
 */
#define M(mnd, mxd, p, rc, bn, rr, mg, ca1, ca2, ca3, bf, ba, cg1, cg2, cg3) \
	{mnd, mxd, p, rc, bn, rr, mg, {ca1, ca2, ca3}, {cg1, cg2, cg3}, bf, ba, true, \
	 0, NULL, 0, 0, {0, 0, 0, 0}, 16, NO_EXTRA_FLAG, HOUSE_NO_CLASS, 0, 2, 0, 0, NULL}
static const HouseSpec _original_house_specs[] = {
	/**
	 *                                                              remove_rating_decrease
	 *                                                               |    mail_generation
	 *     min_date                                                  |    |    1st CargoID acceptance
	 *     |         max_date                                        |    |    |    2nd CargoID acceptance
	 *     |         |    population                                 |    |    |    |    3th CargoID acceptance
	 *     |         |    |    removal_cost                          |    |    |    |    |
	 *     |         |    |    |    building_name                    |    |    |    |    |
	 *     |         |    |    |    |                                |    |    |    |    |
	 *     |         |    |    |    |                                |    |    |    |    |
	 * +-building_flags   |    |    |                                |    |    |    |    |
	 * +-building_availability |    |                                |    |    |    |    |
	 * +-cargoID accepted |    |    |                                |    |    |    |    |
	 * |   |         |    |    |    |                                |    |    |    |    | */
	M( 1963, MAX_YEAR, 187, 150, STR_200F_TALL_OFFICE_BLOCK,      140,  70,   8,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //00
	M( 1957, MAX_YEAR,  85, 140, STR_2010_OFFICE_BLOCK,           130,  55,   8,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //01
	M( 1968, MAX_YEAR,  40, 100, STR_2011_SMALL_BLOCK_OF_FLATS,    90,  20,   8,   3,   1,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //02
	M(    0, MAX_YEAR,   5,  90, STR_2012_CHURCH,                 230,   2,   2,   0,   0,
	   BUILDING_IS_CHURCH | TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //03
	M( 1975, MAX_YEAR, 220, 160, STR_2013_LARGE_OFFICE_BLOCK,     160,  85,  10,   4,   6,
	   BUILDING_IS_ANIMATED | TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //04
	M( 1975, MAX_YEAR, 220, 160, STR_2013_LARGE_OFFICE_BLOCK,     160,  85,  10,   4,   6,
	   BUILDING_IS_ANIMATED | TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE  | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //05
	M(    0, MAX_YEAR,  30,  80, STR_2014_TOWN_HOUSES,             80,  12,   4,   1,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //06
	M( 1959, MAX_YEAR, 140, 180, STR_2015_HOTEL,                  150,  22,   6,   1,   2,
	   TILE_SIZE_1x2,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //07
	M( 1959, MAX_YEAR,   0, 180, STR_2015_HOTEL,                  150,  22,   6,   1,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //08
	M( 1945, MAX_YEAR,   0,  65, STR_2016_STATUE,                  40,   0,   2,   0,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //09
	M( 1945, MAX_YEAR,   0,  65, STR_2017_FOUNTAIN,                40,   0,   2,   0,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0A
	M(    0, MAX_YEAR,   0,  60, STR_2018_PARK,                    75,   0,   2,   0,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0B
	M( 1935, MAX_YEAR,   0,  60, STR_2018_PARK,                    75,   0,   2,   0,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0C
	M( 1951, MAX_YEAR, 150, 130, STR_2019_OFFICE_BLOCK,           110,  65,   8,   2,   4,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0D
	M( 1930, 1960,      95, 110, STR_201A_SHOPS_AND_OFFICES,      100,  48,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0E
	M( 1930, 1960,      95, 105, STR_201A_SHOPS_AND_OFFICES,      100,  48,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //0F
	M( 1930, 1960,      95, 107, STR_201A_SHOPS_AND_OFFICES,      100,  48,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //10
	M( 1977, MAX_YEAR, 130, 200, STR_201B_MODERN_OFFICE_BUILDING, 150,  50,  10,   3,   6,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //11
	M( 1983, MAX_YEAR,   6, 145, STR_201C_WAREHOUSE,              110,  10,   6,   3,   8,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //12
	M( 1985, MAX_YEAR, 110, 155, STR_201D_OFFICE_BLOCK,           110,  55,   6,   2,   6,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //13
	M(    0, MAX_YEAR,  65, 250, STR_201E_STADIUM,                300,   5,   4,   0,   0,
	   BUILDING_IS_STADIUM | TILE_SIZE_2x2,
	   HZ_TEMP | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //14
	M(    0, MAX_YEAR,   0, 250, STR_201E_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //15
	M(    0, MAX_YEAR,   0, 250, STR_201E_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //16
	M(    0, MAX_YEAR,   0, 250, STR_201E_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //17
	M(    0, 1951,      15,  70, STR_201F_OLD_HOUSES,              75,   6,   3,   1,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //18
	M(    0, 1952,      12,  75, STR_2036_COTTAGES,                75,   7,   3,   1,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //19
	M( 1931, MAX_YEAR,  13,  71, STR_2037_HOUSES,                  75,   8,   3,   1,   0,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1A
	M( 1935, MAX_YEAR, 100, 135, STR_2038_FLATS,                  100,  35,   7,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1B
	M( 1963, MAX_YEAR, 170, 145, STR_2039_TALL_OFFICE_BLOCK,      170,  50,   8,   3,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1C
	M(    0, 1955,     100, 132, STR_203A_SHOPS_AND_OFFICES,      135,  40,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1D
	M( 1973, MAX_YEAR, 180, 155, STR_203B_SHOPS_AND_OFFICES,      180,  64,   8,   3,   3,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1E
	M(    0, MAX_YEAR,  35, 220, STR_203C_THEATER,                230,  23,   8,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //1F
	M( 1958, MAX_YEAR,  65, 250, STR_203D_STADIUM,                300,   5,   4,   0,   0,
	   BUILDING_IS_STADIUM | TILE_SIZE_2x2,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //20
	M( 1958, MAX_YEAR,   0, 250, STR_203D_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //21
	M( 1958, MAX_YEAR,   0, 250, STR_203D_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //22
	M( 1958, MAX_YEAR,   0, 250, STR_203D_STADIUM,                300,   5,   4,   0,   0,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //23
	M( 2000, MAX_YEAR, 140, 170, STR_203E_OFFICES,                250,  65,   8,   3,   2,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //24
	M(    0, 1960,      15,  70, STR_203F_HOUSES,                  75,   6,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //25
	M(    0, 1960,      15,  70, STR_203F_HOUSES,                  75,   6,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //26
	M( 1945, MAX_YEAR,  35, 210, STR_2040_CINEMA,                 230,  23,   8,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //27
	M( 1983, MAX_YEAR, 180, 250, STR_2041_SHOPPING_MALL,          300,   5,   8,   2,   3,
	   TILE_SIZE_2x2,
	   HZ_TEMP | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 |HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //28
	M( 1983, MAX_YEAR,   0, 250, STR_2041_SHOPPING_MALL,          300,   5,   8,   2,   3,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //29
	M( 1983, MAX_YEAR,   0, 250, STR_2041_SHOPPING_MALL,          300,   5,   8,   2,   3,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //2A
	M( 1983, MAX_YEAR,   0, 250, STR_2041_SHOPPING_MALL,          300,   5,   8,   2,   3,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //2B
	M(    0, MAX_YEAR,  80, 100, STR_2038_FLATS,                   90,  20,   5,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //2C
	M(    0, MAX_YEAR,  80, 100, STR_2038_FLATS,                   90,  20,   5,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE  | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //2D
	M(    0, MAX_YEAR,  16,  70, STR_203F_HOUSES,                  70,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //2E
	M(    0, MAX_YEAR,  16,  70, STR_203F_HOUSES,                  70,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //2F
	M(    0, 1963,      14,  80, STR_203F_HOUSES,                  70,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //30
	M(    0, 1963,      14,  80, STR_203F_HOUSES,                  70,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //31
	M( 1966, MAX_YEAR, 135, 150, STR_200F_TALL_OFFICE_BLOCK,      120,  60,   8,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //32
	M( 1966, MAX_YEAR, 135, 150, STR_200F_TALL_OFFICE_BLOCK,      120,  60,   8,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //33
	M( 1970, MAX_YEAR, 170, 170, STR_200F_TALL_OFFICE_BLOCK,      130,  70,   9,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //34
	M( 1970, MAX_YEAR, 170, 170, STR_200F_TALL_OFFICE_BLOCK,      130,  70,   9,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //35
	M( 1974, MAX_YEAR, 210, 200, STR_200F_TALL_OFFICE_BLOCK,      140,  80,  10,   3,   5,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //36
	M( 1974, MAX_YEAR, 210, 200, STR_200F_TALL_OFFICE_BLOCK,      140,  80,  10,   3,   5,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //37
	M(    0, MAX_YEAR,  10,  60, STR_203F_HOUSES,                  60,   5,   2,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //38
	M(    0, MAX_YEAR,  10,  60, STR_203F_HOUSES,                  60,   5,   2,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //39
	M(    0, MAX_YEAR,  25, 100, STR_201A_SHOPS_AND_OFFICES,       80,  20,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //3A
	M(    0, MAX_YEAR,  25, 100, STR_201A_SHOPS_AND_OFFICES,       80,  20,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //3B
	M(    0, MAX_YEAR,   6,  85, STR_2012_CHURCH,                 230,   2,   2,   0,   0,
	   BUILDING_IS_CHURCH | TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //3C
	M(    0, MAX_YEAR,   6,  85, STR_2012_CHURCH,                 230,   2,   2,   0,   0,
	   BUILDING_IS_CHURCH | TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //3D
	M(    0, MAX_YEAR,  17,  80, STR_203F_HOUSES,                  80,   7,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //3E
	M(    0, MAX_YEAR,  17,  80, STR_203F_HOUSES,                  80,   7,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //3F
	M(    0, 1960,      90, 140, STR_201A_SHOPS_AND_OFFICES,      110,  45,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //40
	M(    0, 1960,      90, 140, STR_201A_SHOPS_AND_OFFICES,      110,  45,   6,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //41
	M( 1972, MAX_YEAR, 140, 160, STR_2015_HOTEL,                  160,  25,   6,   1,   3,
	   TILE_SIZE_1x2,
	   HZ_SUBARTC_BELOW| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //42
	M( 1972, MAX_YEAR,   0, 160, STR_2015_HOTEL,                  160,  25,   6,   1,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //43
	M( 1972, MAX_YEAR, 140, 160, STR_2015_HOTEL,                  160,  25,   6,   1,   3,
	   TILE_SIZE_1x2,
	   HZ_SUBARTC_ABOVE| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //44
	M( 1972, MAX_YEAR,   0, 160, STR_2015_HOTEL,                  160,  25,   6,   1,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //45
	M( 1963, MAX_YEAR, 105, 130, STR_201A_SHOPS_AND_OFFICES,      105,  50,   7,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //46
	M( 1963, MAX_YEAR, 105, 130, STR_201A_SHOPS_AND_OFFICES,      105,  50,   7,   2,   3,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //47
	M( 1978, MAX_YEAR, 190, 190, STR_200F_TALL_OFFICE_BLOCK,      135,  75,   9,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_BELOW | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //48
	M( 1978, MAX_YEAR, 190, 190, STR_200F_TALL_OFFICE_BLOCK,      135,  75,   9,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //49
	M( 1967, MAX_YEAR, 250, 140, STR_200F_TALL_OFFICE_BLOCK,      200,  60,   7,   2,   2,
	   TILE_SIZE_2x1,
	   HZ_SUBARTC_BELOW| HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //4A
	M( 1967, MAX_YEAR,   0, 140, STR_200F_TALL_OFFICE_BLOCK,      200,  60,   7,   2,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //4B
	M( 1967, MAX_YEAR, 250, 140, STR_200F_TALL_OFFICE_BLOCK,      200,  60,   7,   2,   2,
	   TILE_SIZE_2x1,
	   HZ_SUBARTC_ABOVE | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //4C
	M( 1967, MAX_YEAR,   0, 140, STR_200F_TALL_OFFICE_BLOCK,      200,  60,   7,   2,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //4D
	M(    0, MAX_YEAR,  16,  80, STR_203F_HOUSES,                  80,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //4E
	M(    0, MAX_YEAR,  16,  80, STR_203F_HOUSES,                  80,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //4F
	M(    0, MAX_YEAR,  16,  80, STR_203F_HOUSES,                  80,   5,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //50
	M(    0, MAX_YEAR,   7,  30, STR_203F_HOUSES,                  30,   4,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //51
	M(    0, MAX_YEAR,  45, 130, STR_2038_FLATS,                   95,  15,   6,   2,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //52
	M(    0, MAX_YEAR,   8,  90, STR_2012_CHURCH,                 200,   3,   2,   0,   0,
	   BUILDING_IS_CHURCH | TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //53
	M(    0, MAX_YEAR,  18,  80, STR_203F_HOUSES,                  80,   7,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2,
	   CT_PASSENGERS, CT_MAIL, CT_FOOD), //54
	M( 1973, MAX_YEAR,  90, 110, STR_2038_FLATS,                   95,  24,   6,   2,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //55
	M( 1962, MAX_YEAR, 120, 120, STR_2038_FLATS,                   95,  25,   6,   2,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //56
	M( 1984, MAX_YEAR, 250, 190, STR_200F_TALL_OFFICE_BLOCK,      140,  80,   8,   3,   4,
	   TILE_SIZE_2x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //57
	M( 1984, MAX_YEAR,   0, 190, STR_200F_TALL_OFFICE_BLOCK,      140,  80,   8,   3,   4,
	   TILE_NO_FLAG,
	   HZ_SUBTROPIC,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //58
	M(    0, MAX_YEAR,  80, 110, STR_2038_FLATS,                   95,  23,   6,   2,   1,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //59
	M( 1993, MAX_YEAR, 180, 180, STR_200F_TALL_OFFICE_BLOCK,      150,  90,   8,   3,   4,
	   TILE_SIZE_1x1,
	   HZ_SUBTROPIC | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_GOODS), //5A
	M(    0, MAX_YEAR,   8,  90, STR_2012_CHURCH,                 200,   3,   2,   0,   0,
	   BUILDING_IS_CHURCH | TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //5B
	M(    0, MAX_YEAR,  18,  90, STR_203F_HOUSES,                  90,   5,   6,   2,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //5C
	M(    0, MAX_YEAR,   7,  70, STR_203F_HOUSES,                  50,   3,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //5D
	M(    0, MAX_YEAR,  15,  80, STR_203F_HOUSES,                  75,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //5E
	M(    0, MAX_YEAR,  17,  80, STR_203F_HOUSES,                  75,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //5F
	M(    0, MAX_YEAR,  19,  80, STR_203F_HOUSES,                  75,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //60
	M(    0, MAX_YEAR,  21,  80, STR_203F_HOUSES,                  75,   6,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //61
	M(    0, MAX_YEAR,  75, 160, STR_200F_TALL_OFFICE_BLOCK,      130,  20,   8,   4,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //62
	M(    0, MAX_YEAR,  35,  90, STR_203F_HOUSES,                  80,   9,   4,   1,   2,
	   TILE_SIZE_1x2,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //63
	M(    0, MAX_YEAR,   0,  90, STR_203F_HOUSES,                  80,   0,   4,   1,   2,
	   TILE_NO_FLAG,
	   HZ_NOZNS,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //64
	M(    0, MAX_YEAR,  85, 150, STR_200F_TALL_OFFICE_BLOCK,      130,  18,   8,   4,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //65
	M(    0, MAX_YEAR,  11,  60, STR_2059_IGLOO,                   45,   3,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //66
	M(    0, MAX_YEAR,  10,  60, STR_205A_TEPEES,                  45,   3,   3,   1,   1,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //67
	M(    0, MAX_YEAR,  67, 140, STR_201A_SHOPS_AND_OFFICES,      130,  22,   8,   4,   4,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FIZZY_DRINKS), //68
	M(    0, MAX_YEAR,  86, 145, STR_201A_SHOPS_AND_OFFICES,      130,  23,   8,   4,   4,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_FIZZY_DRINKS), //69
	M(    0, MAX_YEAR,  95, 165, STR_200F_TALL_OFFICE_BLOCK,      130,  28,   8,   4,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //6A
	M(    0, MAX_YEAR,  30,  90, STR_2016_STATUE,                  70,  10,   4,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //6B
	M(    0, MAX_YEAR,  25,  75, STR_205B_TEAPOT_HOUSE,            65,   8,   3,   1,   2,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_CANDY), //6C
	M(    0, MAX_YEAR,  18,  85, STR_205C_PIGGY_BANK,              95,   7,   3,   2,   4,
	   TILE_SIZE_1x1,
	   HZ_TOYLND | HZ_ZON5 | HZ_ZON4 | HZ_ZON3 | HZ_ZON2 | HZ_ZON1,
	   CT_PASSENGERS, CT_MAIL, CT_FIZZY_DRINKS), //6D
};
#undef M
assert_compile(lengthof(_original_house_specs) == NEW_HOUSE_OFFSET);
