/* $Id: ship.h 9068 2007-03-08 16:27:54Z rubidium $ */

#ifndef SHIP_H
#define SHIP_H

#include "vehicle.h"

void CcBuildShip(bool success, TileIndex tile, uint32 p1, uint32 p2);
void CcCloneShip(bool success, TileIndex tile, uint32 p1, uint32 p2);
void RecalcShipStuff(Vehicle *v);
void GetShipSpriteSize(EngineID engine, uint &width, uint &height);

static inline bool IsShipInDepot(const Vehicle* v)
{
	assert(v->type == VEH_SHIP);
	return v->u.ship.state == 0x80;
}

static inline bool IsShipInDepotStopped(const Vehicle* v)
{
	return IsShipInDepot(v) && v->vehstatus & VS_STOPPED;
}

#endif /* SHIP_H */
