/* $Id: namegen.h 7603 2006-12-28 19:49:31Z rubidium $ */

#include "../stdafx.h"
#include "../openttd.h"

static const char *name_original_english_1[] = {
	"Great ",
	"Little ",
	"New ",
	"Fort ",
};

static const char *name_original_english_2[] = {
	"Wr",
	"B",
	"C",
	"Ch",
	"Br",
	"D",
	"Dr",
	"F",
	"Fr",
	"Fl",
	"G",
	"Gr",
	"H",
	"L",
	"M",
	"N",
	"P",
	"Pr",
	"Pl",
	"R",
	"S",
	"S",
	"Sl",
	"T",
	"Tr",
	"W"
};

static const char *name_original_english_3[] = {
	"ar",
	"a",
	"e",
	"in",
	"on",
	"u",
	"un",
	"en"
};

static const char *name_original_english_4[] = {
	"n",
	"ning",
	"ding",
	"d",
	"",
	"t"
	"fing"
};

static const char *name_original_english_5[] = {
	"ville",
	"ham",
	"field",
	"ton",
	"town",
	"bridge",
	"bury",
	"wood",
	"ford",
	"hall",
	"ston",
	"way",
	"stone",
	"borough",
	"ley",
	"head",
	"bourne",
	"pool",
	"worth",
	"hill",
	"well",
	"hattan",
	"burg",
};

static const char *name_original_english_6[] = {
	"-on-sea",
	" Bay",
	" Market",
	" Cross",
	" Bridge",
	" Falls",
	" City",
	" Ridge",
	" Springs"
};

static const char *name_additional_english_prefix[] = {
	"Great ",
	"Little ",
	"New ",
	"Fort ",
	"St. ",
	"Old "
};

static const char *name_additional_english_1a[] = {
	"Pen",
	"Lough",
	"Stam",
	"Aber",
	"Acc",
	"Ex",
	"Ax",
	"Bre",
	"Cum",
	"Dun",
	"Fin",
	"Inver",
	"Kin",
	"Mon",
	"Nan",
	"Nant",
	"Pit",
	"Pol",
	"Pont",
	"Strath",
	"Tre",
	"Tilly",
	"Beck",
	"Canter",
	"Bath",
	"Liver",
	"Mal",
	"Ox",
	"Bletch",
	"Maccles",
	"Grim",
	"Wind",
	"Sher",
	"Gates",
	"Orp",
	"Brom",
	"Lewis",
	"Whit",
	"White",
	"Worm",
	"Tyne",
	"Avon",
	"Stan"
};

static const char *name_additional_english_1b1[] = {
	"Wr",
	"B",
	"C",
	"Ch",
	"Br",
	"D",
	"Dr",
	"F",
	"Fr",
	"Fl",
	"G",
	"Gr",
	"H",
	"L",
	"M",
	"N",
	"P",
	"Pr",
	"Pl",
	"R",
	"S",
	"S",
	"Sl",
	"T",
	"Tr",
	"W"
};

static const char *name_additional_english_1b2[] = {
	"ar",
	"a",
	"e",
	"in",
	"on",
	"u",
	"o",
	"ee",
	"es",
	"ea",
	"un",
	"en"
};

static const char *name_additional_english_1b3a[] = {
	"n",
	"d",
	"",
	"t",
	"",
	""
};

static const char *name_additional_english_1b3b[] = {
	"ning",
	"ding",
	"fing"
};

static const char *name_additional_english_2[] = {
	"ville",
	"ham",
	"field",
	"ton",
	"town",
	"borough",
	"bridge",
	"bury",
	"wood",
	"ditch",
	"ford",
	"hall",
	"dean",
	"leigh",
	"dore",
	"ston",
	"stow",
	"church",
	"wich",
	"low",
	"way",
	"stone",
	"minster",
	"ley",
	"head",
	"bourne",
	"pool",
	"worth",
	"hill",
	"well",
	"hattan",
	"burg",
	"berg",
	"burgh",
	"port",
	"stoke",
	"haven",
	"stable",
	"stock",
	"side",
	"brook",
	"don",
	"den",
	"down",
	"nor",
	"grove",
	"combe",
	"by",
	"say",
	"ney",
	"chester",
	"dale",
	"ness",
	"shaw",
	"thwaite"
};

static const char *name_additional_english_3[] = {
	"-on-sea",
	" Bay",
	" Market",
	" Beeches",
	" Common",
	" Park",
	" Heath",
	" Marsh",
	" Green",
	" Castle",
	" End",
	" Rivers",
	" Cross",
	" Bridge",
	" Falls",
	" City",
	" Ridge",
	" Springs"
};

static const char *name_austrian_a1[] = {
	"Bad ",
	"Deutsch ",
	"Gross ",
	"Klein ",
	"Markt ",
	"Maria "
};

static const char *name_austrian_a2[] = {
	"Aus",
	"Alten",
	"Braun",
	"Vösl",
	"Mittern",
	"Nuss",
	"Neu",
	"Walters",
	"Breiten",
	"Eisen",
	"Feld",
	"Mittern",
	"Gall",
	"Obern",
	"Grat",
	"Heiligen",
	"Hof",
	"Holla",
	"Stein",
	"Eber",
	"Eggen",
	"Enzers",
	"Frauen",
	"Herren",
	"Hof",
	"Hütt",
	"Kaisers",
	"Königs",
	"Knittel",
	"Lang",
	"Ober",
	"Ollers",
	"Pfaffen",
	"Potten",
	"Salz",
	"Schwarz",
	"Stocker",
	"Unter",
	"Utten",
	"Vösen",
	"Vill",
	"Weissen"
};

static const char *name_austrian_a3[] = {
	"see",
	"bach",
	"dorf",
	"ach",
	"stein",
	"hofen",
	"au",
	"ach",
	"kirch",
	"kirchen",
	"kreuz",
	"brunn",
	"siedl",
	"markt",
	"wang",
	"haag"
};

static const char *name_austrian_a4[] = {
	"Bruck",
	"Brunn",
	"Gams",
	"Grein",
	"Ried",
	"Faak",
	"Zell",
	"Spital",
	"Kirchberg",
	"Saal",
	"Taferl",
	"Wald"
};

static const char *name_austrian_a5[] = {
	"St. ",
	"Sankt "
};

static const char *name_austrian_a6[] = {
	"Aegyd",
	"Andrä",
	"Georgen",
	"Jakob",
	"Johann",
	"Leonhard",
	"Marein",
	"Lorenzen",
	"Margarethen",
	"Martin",
	"Michael",
	"Nikolai",
	"Oswald",
	"Peter",
	"Pölten",
	"Stefan",
	"Stephan",
	"Thomas",
	"Veit",
	"Wolfgang"
};

static const char *name_austrian_f1[] = {
	" an der ",
	" ob der "
};

static const char *name_austrian_f2[] = {
	"Donau",
	"Steyr",
	"Lafnitz",
	"Leitha",
	"Thaya",
	"Gail",
	"Drau",
	"Salzach",
	"Ybbs",
	"Traisen",
	"Enns",
	"Mur",
	"Ill"
};

static const char *name_austrian_b1[] = {
	" am "
};

static const char *name_austrian_b2[] = {
	"Brenner",
	"Dachstein",
	"Gebirge",
	"Grossglockner",
	"Hausruck",
	"Semmering",
	"Wagram",
	"Wechsel",
	"Wilden Kaiser",
	"Ziller"
};

static const char *name_german_real[] = {
	"Berlin",
	"Bonn",
	"Bremen",
	"Cottbus",
	"Chemnitz",
	"Dortmund",
	"Dresden",
	"Erfurt",
	"Erlangen",
	"Essen",
	"Fulda",
	"Gera",
	"Kassel",
	"Kiel",
	"Köln",
	"Lübeck",
	"Magdeburg",
	"München",
	"Potsdam",
	"Stuttgart",
	"Wiesbaden"
};

static const char *name_german_pre[] = {
	"Bad ",
	"Klein ",
	"Neu "
};

static const char *name_german_1[] = {
	"Alb",
	"Als",
	"Ander",
	"Arns",
	"Bruns",
	"Bam",
	"Biele",
	"Cloppen",
	"Co",
	"Duis",
	"Düssel",
	"Dannen",
	"Elb",
	"Els",
	"Elster",
	"Eichen",
	"Ems",
	"Fahr",
	"Falken",
	"Flens",
	"Frank",
	"Frei",
	"Freuden",
	"Fried",
	"Fürsten",
	"Hahn",
	"Ham",
	"Harz",
	"Heidel",
	"Hers",
	"Herz",
	"Holz",
	"Hildes",
	"Inns",
	"Ilsen",
	"Ingols",
	"Kel",
	"Kies",
	"Korn",
	"Kor",
	"Kreuz",
	"Kulm",
	"Langen",
	"Lim",
	"Lohr",
	"Lüne",
	"Mel",
	"Michels",
	"Mühl",
	"Naum",
	"Nest",
	"Nord",
	"Nort",
	"Nien",
	"Nidda",
	"Nieder",
	"Nürn",
	"Ober",
	"Offen",
	"Osna",
	"Olden",
	"Ols",
	"Oranien",
	"Pader",
	"Quedlin",
	"Quer",
	"Ravens",
	"Regens",
	"Rott",
	"Ros",
	"Rüssels",
	"Saal",
	"Saar",
	"Salz",
	"Schöne",
	"Schwein",
	"Sonder",
	"Sonnen",
	"Stein",
	"Strals",
	"Straus",
	"Süd",
	"Ton",
	"Unter",
	"Ur",
	"Vor",
	"Wald",
	"War",
	"Wert",
	"Wester",
	"Witten",
	"Wolfs",
	"Würz"
};

static const char *name_german_2[] = {
	"bach",
	"berg",
	"brück",
	"brücken",
	"burg",
	"dorf",
	"feld",
	"furt",
	"hausen",
	"haven",
	"heim",
	"horst",
	"mund",
	"münster",
	"stadt",
	"wald"
};

static const char *name_german_3_an_der[] = {
	" an der "
};

static const char *name_german_3_am[] = {
	" am "
};

static const char *name_german_4_an_der[] = {
	"Oder",
	"Spree",
	"Donau",
	"Saale",
	"Elbe"
};

static const char *name_german_4_am[] = {
	"Main"
};

static const char *name_spanish_real[] = {
	"Caracas",
	"Maracay",
	"Maracaibo",
	"Velencia",
	"El Dorado",
	"Morrocoy",
	"Cata",
	"Cataito",
	"Ciudad Bolivar",
	"Barquisimeto",
	"Merida",
	"Puerto Ordaz",
	"Santa Elena",
	"San Juan",
	"San Luis",
	"San Rafael",
	"Santiago",
	"Barcelona",
	"Barinas",
	"San Cristobal",
	"San Fransisco",
	"San Martin",
	"Guayana",
	"San Carlos",
	"El Limon",
	"Coro",
	"Corocoro",
	"Puerto Ayacucho",
	"Elorza",
	"Arismendi",
	"Trujillo",
	"Carupano",
	"Anaco",
	"Lima",
	"Cuzco",
	"Iquitos",
	"Callao",
	"Huacho",
	"Camana",
	"Puerto Chala",
	"Santa Cruz",
	"Quito",
	"Cuenca",
	"Huacho",
	"Tulcan",
	"Esmereldas",
	"Ibarra",
	"San Lorenzo",
	"Macas",
	"Morana",
	"Machala",
	"Zamora",
	"Latacunga",
	"Tena",
	"Cochabamba",
	"Ascencion",
	"Magdalena",
	"Santa Ana",
	"Manoa",
	"Sucre",
	"Oruro",
	"Uyuni",
	"Potosi",
	"Tupiza",
	"La Quiaca",
	"Yacuiba",
	"San Borja",
	"Fuerte Olimpio",
	"Fortin Esteros",
	"Campo Grande",
	"Bogota",
	"El Banco",
	"Zaragosa",
	"Neiva",
	"Mariano",
	"Cali",
	"La Palma",
	"Andoas",
	"Barranca",
	"Montevideo",
	"Valdivia",
	"Arica",
	"Temuco",
	"Tocopilla",
	"Mendoza",
	"Santa Rosa"
};

static const char *name_french_real[] = {
	"Agincourt",
	"Lille",
	"Dinan",
	"Aubusson",
	"Rodez",
	"Bergerac",
	"Bordeaux",
	"Bayonne",
	"Montpellier",
	"Montelimar",
	"Valence",
	"Digne",
	"Nice",
	"Cannes",
	"St. Tropez",
	"Marseilles",
	"Narbonne",
	"Sète",
	"Aurillac",
	"Gueret",
	"Le Creusot",
	"Nevers",
	"Auxerre",
	"Versailles",
	"Meaux",
	"Châlons",
	"Compiègne",
	"Metz",
	"Chaumont",
	"Langres",
	"Bourg",
	"Lyons",
	"Vienne",
	"Grenoble",
	"Toulon",
	"Rennes",
	"Le Mans",
	"Angers",
	"Nantes",
	"Châteauroux",
	"Orléans",
	"Lisieux",
	"Cherbourg",
	"Morlaix",
	"Cognac",
	"Agen",
	"Tulle",
	"Blois",
	"Troyes",
	"Charolles",
	"Grenoble",
	"Chambéry",
	"Tours",
	"St. Brieuc",
	"St. Malo",
	"La Rochelle",
	"St. Flour",
	"Le Puy",
	"Vichy",
	"St. Valery",
	"Beaujolais",
	"Narbonne",
	"Albi",
	"St. Valery",
	"Biarritz",
	"Béziers",
	"Nîmes",
	"Chamonix",
	"Angoulème",
	"Alençon"
};

static const char *name_silly_1[] = {
	"Binky",
	"Blubber",
	"Bumble",
	"Crinkle",
	"Crusty",
	"Dangle",
	"Dribble",
	"Flippety",
	"Google",
	"Muffin",
	"Nosey",
	"Pinker",
	"Quack",
	"Rumble",
	"Sleepy",
	"Sliggles",
	"Snooze",
	"Teddy",
	"Tinkle",
	"Twister",
	"Pinker",
	"Hippo",
	"Itchy",
	"Jelly",
	"Jingle",
	"Jolly",
	"Kipper",
	"Lazy",
	"Frogs",
	"Mouse",
	"Quack",
	"Cheeky",
	"Lumpy",
	"Grumpy",
	"Mangle",
	"Fiddle",
	"Slugs",
	"Noodles",
	"Poodles",
	"Shiver",
	"Rumble",
	"Pixie",
	"Puddle",
	"Riddle",
	"Rattle",
	"Rickety",
	"Waffle",
	"Sagging",
	"Sausage",
	"Egg",
	"Sleepy",
	"Scatter",
	"Scramble",
	"Silly",
	"Simple",
	"Trickle",
	"Slippery",
	"Slimey",
	"Slumber",
	"Soggy",
	"Sliggles",
	"Splutter",
	"Sulky",
	"Swindle",
	"Swivel",
	"Tasty",
	"Tangle",
	"Toggle",
	"Trotting",
	"Tumble",
	"Snooze",
	"Water",
	"Windy",
	"Amble",
	"Bubble",
	"Cheery",
	"Cheese",
	"Cockle",
	"Cracker",
	"Crumple",
	"Teddy",
	"Evil",
	"Fairy",
	"Falling",
	"Fishy",
	"Fizzle",
	"Frosty",
	"Griddle"
};

static const char *name_silly_2[] = {
	"ton",
	"bury",
	"bottom",
	"ville",
	"well",
	"weed",
	"worth",
	"wig",
	"wick",
	"wood",
	"pool",
	"head",
	"burg",
	"gate",
	"bridge"
};

static const char *name_swedish_1[] = {
	"Gamla ",
	"Lilla ",
	"Nya ",
	"Stora "
};

static const char *name_swedish_2[] = {
	"Boll",
	"Bor",
	"Ed",
	"En",
	"Erik",
	"Es",
	"Fin",
	"Fisk",
	"Grön",
	"Hag",
	"Halm",
	"Karl",
	"Kram",
	"Kung",
	"Land",
	"Lid",
	"Lin",
	"Mal",
	"Malm",
	"Marie",
	"Ner",
	"Norr",
	"Oskar",
	"Sand",
	"Skog",
	"Stock",
	"Stor",
	"Ström",
	"Sund",
	"Söder",
	"Tall",
	"Tratt",
	"Troll",
	"Upp",
	"Var",
	"Väster",
	"Ängel",
	"Öster"
};

static const char *name_swedish_2a[] = {
	"B",
	"Br",
	"D",
	"Dr",
	"Dv",
	"F",
	"Fj",
	"Fl",
	"Fr",
	"G",
	"Gl",
	"Gn",
	"Gr",
	"H",
	"J",
	"K",
	"Kl",
	"Kn",
	"Kr",
	"Kv",
	"L",
	"M",
	"N",
	"P",
	"Pl",
	"Pr",
	"R",
	"S",
	"Sk",
	"Skr",
	"Sl",
	"Sn",
	"Sp",
	"Spr",
	"St",
	"Str",
	"Sv",
	"T",
	"Tr",
	"Tv",
	"V",
	"Vr"
};

static const char *name_swedish_2b[] = {
	"a",
	"e",
	"i",
	"o",
	"u",
	"y",
	"å",
	"ä",
	"ö"
};

static const char *name_swedish_2c[] = {
	"ck",
	"d",
	"dd",
	"g",
	"gg",
	"l",
	"ld",
	"m",
	"n",
	"nd",
	"ng",
	"nn",
	"p",
	"pp",
	"r",
	"rd",
	"rk",
	"rp",
	"rr",
	"rt",
	"s",
	"sk",
	"st",
	"t",
	"tt",
	"v"
};

static const char *name_swedish_3[] = {
	"arp",
	"berg",
	"boda",
	"borg",
	"bro",
	"bukten",
	"by",
	"byn",
	"fors",
	"hammar",
	"hamn",
	"holm",
	"hus",
	"hättan",
	"kulle",
	"köping",
	"lund",
	"löv",
	"sala",
	"skrona",
	"slätt",
	"spång",
	"stad",
	"sund",
	"svall",
	"svik",
	"såker",
	"udde",
	"valla",
	"viken",
	"älv",
	"ås"
};

static const char *name_dutch_1[] = {
	"Nieuw ",
	"Oud ",
	"Groot ",
	"Zuid ",
	"Noord ",
	"Oost ",
	"West ",
	"Klein "
};

static const char *name_dutch_2[] = {
	"Hoog",
	"Laag",
	"Zuider",
	"Zuid",
	"Ooster",
	"Oost",
	"Wester",
	"West",
	"Hoofd",
	"Midden",
	"Eind",
	"Amster",
	"Amstel",
	"Dord",
	"Rotter",
	"Haar",
	"Til",
	"Enk",
	"Dok",
	"Veen",
	"Leidsch",
	"Lely",
	"En",
	"Kaats",
	"U",
	"Maas",
	"Mar",
	"Bla",
	"Al",
	"Alk",
	"Eer",
	"Drie",
	"Ter",
	"Groes",
	"Goes",
	"Soest",
	"Coe",
	"Uit",
	"Zwaag",
	"Hellen",
	"Slie",
	"IJ",
	"Grubben",
	"Groen",
	"Lek",
	"Ridder",
	"Schie",
	"Olde",
	"Roose",
	"Haar",
	"Til",
	"Loos",
	"Hil"
};

static const char *name_dutch_3[] = {
	"Drog",
	"Nat",
	"Valk",
	"Bob",
	"Dedem",
	"Kollum",
	"Best",
	"Hoend",
	"Leeuw",
	"Graaf",
	"Uithuis",
	"Purm",
	"Hard",
	"Hell",
	"Werk",
	"Spijk",
	"Vink",
	"Wams",
	"Heerhug",
	"Koning"
};

static const char *name_dutch_4[] = {
	"e",
	"er",
	"el",
	"en",
	"o",
	"s"
};

static const char *name_dutch_5[] = {
	"stad",
	"vorst",
	"dorp",
	"dam",
	"beek",
	"doorn",
	"zijl",
	"zijlen",
	"lo",
	"muiden",
	"meden",
	"vliet",
	"nisse",
	"daal",
	"vorden",
	"vaart",
	"mond",
	"zaal",
	"water",
	"duinen",
	"heuvel",
	"geest",
	"kerk",
	"meer",
	"maar",
	"hoorn",
	"rade",
	"wijk",
	"berg",
	"heim",
	"sum",
	"richt",
	"burg",
	"recht",
	"drecht",
	"trecht",
	"tricht",
	"dricht",
	"lum",
	"rum",
	"halen",
	"oever",
	"wolde",
	"veen",
	"hoven",
	"gast",
	"kum",
	"hage",
	"dijk",
	"zwaag",
	"pomp",
	"huizen",
	"bergen",
	"schede",
	"mere",
	"end"
};

static const char *name_finnish_real[] = {
	"Aijala",
	"Kisko",
	"Espoo",
	"Helsinki",
	"Tapiola",
	"Järvelä",
	"Lahti",
	"Kotka",
	"Hamina",
	"Loviisa",
	"Kouvola",
	"Tampere",
	"Oulu",
	"Salo",
	"Malmi",
	"Pelto",
	"Koski",
	"Iisalmi",
	"Raisio",
	"Taavetti",
	"Joensuu",
	"Imatra",
	"Tapanila",
	"Pasila",
	"Turku",
	"Kupittaa",
	"Vaasa",
	"Pori",
	"Rauma",
	"Kolari",
	"Lieksa"
};

static const char *name_finnish_1[] = {
	"Hiekka",
	"Haapa",
	"Mylly",
	"Sauna",
	"Uusi",
	"Vanha",
	"Kesä",
	"Kuusi",
	"Pelto",
	"Tuomi",
	"Terva",
	"Olki",
	"Heinä",
	"Seinä",
	"Rova",
	"Koivu",
	"Kokko",
	"Mänty",
	"Pihlaja",
	"Petäjä",
	"Kielo",
	"Kauha",
	"Viita",
	"Kivi",
	"Riihi",
	"Ääne",
	"Niini"
};

static const char *name_finnish_2[] = {
	"Lappeen",
	"Lohjan",
	"Savon",
	"Lapin",
	"Pitäjän",
	"Martin",
	"Kuusan",
	"Kemi",
	"Keri",
	"Hämeen",
	"Kangas"
};

static const char *name_finnish_3[] = {
	"harju",
	"linna",
	"järvi",
	"kallio",
	"mäki",
	"nummi",
	"joki",
	"kylä",
	"lampi",
	"lahti",
	"metsä",
	"suo",
	"laakso",
	"niitty",
	"luoto",
	"hovi",
	"ranta",
	"koski",
	"salo"
};

static const char *name_polish_1_m[] = {
	"Wielki ",
	"Mały ",
	"Zły ",
	"Dobry ",
	"Nowy ",
	"Stary ",
	"Złoty ",
	"Zielony ",
	"Biały ",
	"Modry ",
	"Dębowy "
};

static const char *name_polish_1_f[] = {
	"Wielka ",
	"Mała ",
	"Zła ",
	"Dobra ",
	"Nowa ",
	"Stara ",
	"Złota ",
	"Zielona ",
	"Biała ",
	"Modra ",
	"Dębowa "
};

static const char *name_polish_1_n[] = {
	"Wielkie ",
	"Małe ",
	"Złe ",
	"Dobre ",
	"Nowe ",
	"Stare ",
	"Złote ",
	"Zielone ",
	"Białe ",
	"Modre ",
	"Dębowe "
};

static const char *name_polish_2_o[] = {
	"Frombork",
	"Gniezno",
	"Olsztyn",
	"Toruń",
	"Bydgoszcz",
	"Terespol",
	"Kraków",
	"Poznań",
	"Wrocław",
	"Katowice",
	"Cieszyn",
	"Bytom",
	"Frombork",
	"Hel",
	"Konin",
	"Lublin",
	"Malbork",
	"Sopot",
	"Sosnowiec",
	"Gdańsk",
	"Gdynia",
	"Sieradz",
	"Sandomierz",
	"Szczyrk",
	"Szczytno",
	"Szczecin",
	"Zakopane",
	"Szklarska Poręba",
	"Bochnia",
	"Golub-Dobrzyn",
	"Chojnice",
	"Ostrowiec",
	"Otwock",
	"Wolsztyn"
};

static const char *name_polish_2_m[] = {
	"Jarocin",
	"Gogolin",
	"Tomaszów",
	"Piotrków",
	"Lidzbark",
	"Rypin",
	"Radzymin",
	"Wołomin",
	"Pruszków",
	"Olsztynek",
	"Rypin",
	"Cisek",
	"Krotoszyn",
	"Stoczek",
	"Lubin",
	"Lubicz",
	"Milicz",
	"Targ",
	"Ostrów",
	"Ozimek",
	"Puck",
	"Rzepin",
	"Siewierz",
	"Stargard",
	"Starogard",
	"Turek",
	"Tymbark",
	"Wolsztyn",
	"Strzepcz",
	"Strzebielin",
	"Sochaczew",
	"Grębocin",
	"Gniew",
	"Lubliniec",
	"Lubasz",
	"Lutomiersk",
	"Niemodlin",
	"Przeworsk",
	"Ursus",
	"Tyczyn",
	"Sztum",
	"Szczebrzeszyn",
	"Wolin",
	"Wrzeszcz",
	"Zgierz",
	"Zieleniec",
	"Drobin",
	"Garwolin"
};

static const char *name_polish_2_f[] = {
	"Szprotawa",
	"Pogorzelica",
	"Motława",
	"Lubawa",
	"Nidzica",
	"Kruszwica",
	"Bierawa",
	"Brodnica",
	"Chojna",
	"Krzepica",
	"Ruda",
	"Rumia",
	"Tuchola",
	"Trzebinia",
	"Ustka",
	"Warszawa",
	"Bobowa",
	"Dukla",
	"Krynica",
	"Murowana",
	"Niemcza",
	"Zaspa",
	"Zawoja",
	"Wola",
	"Limanowa",
	"Rabka",
	"Skawina",
	"Pilawa"
};

static const char *name_polish_2_n[] = {
	"Lipsko",
	"Pilzno",
	"Przodkowo",
	"Strzelno",
	"Susz",
	"Jaworzno",
	"Choszczno",
	"Mogilno",
	"Luzino",
	"Miasto",
	"Dziadowo",
	"Kowalewo",
	"Legionowo",
	"Miastko",
	"Zabrze",
	"Zawiercie",
	"Kochanowo",
	"Miechucino",
	"Mirachowo",
	"Robakowo",
	"Kosakowo",
	"Borne",
	"Braniewo",
	"Sulinowo",
	"Chmielno",
	"Jastrzębie",
	"Gryfino",
	"Koronowo",
	"Lubichowo",
	"Opoczno"
};

static const char *name_polish_3_m[] = {
	" Wybudowanie",
	" Świętokrzyski",
	" Górski",
	" Morski",
	" Zdrój",
	" Wody",
	" Bajoro",
	" Krajeński",
	" Śląski",
	" Mazowiecki",
	" Pomorski",
	" Wielki",
	" Maly",
	" Warmiński",
	" Mazurski",
	" Mniejszy",
	" Większy",
	" Górny",
	" Dolny",
	" Wielki",
	" Stary",
	" Nowy",
	" Wielkopolski",
	" Wzgórze",
	" Mosty",
	" Kujawski",
	" Małopolski",
	" Podlaski",
	" Lesny"
};

static const char *name_polish_3_f[] = {
	" Wybudowanie",
	" Świętokrzyska",
	" Górska",
	" Morska",
	" Zdrój",
	" Woda",
	" Bajoro",
	" Krajeńska",
	" Śląska",
	" Mazowiecka",
	" Pomorska",
	" Wielka",
	" Mała",
	" Warmińska",
	" Mazurska",
	" Mniejsza",
	" Większa",
	" Górna",
	" Dolna",
	" Wielka",
	" Stara",
	" Nowa",
	" Wielkopolska",
	" Wzgórza",
	" Mosty",
	" Kujawska",
	" Malopolska",
	" Podlaska",
	" Leśna"
};

static const char *name_polish_3_n[] = {
	" Wybudowanie",
	" Świetokrzyskie",
	" Górskie",
	" Morskie",
	" Zdrój",
	" Wody",
	" Bajoro",
	" Krajeńskie",
	" Śląskie",
	" Mazowieckie",
	" Pomorskie",
	" Wielkie",
	" Małe",
	" Warmińskie ",
	" Mazurskie ",
	" Mniejsze",
	" Większe",
	" Górne",
	" Dolne",
	" Wielkie",
	" Stare",
	" Nowe",
	" Wielkopolskie",
	" Wzgórze",
	" Mosty",
	" Kujawskie",
	" Małopolskie",
	" Podlaskie",
	" Leśne"
};

static const char *name_czech_real[] = {
	"Aš",
	"Benešov",
	"Beroun",
	"Bezdružice",
	"Blansko",
	"Břeclav",
	"Brno",
	"Bruntál",
	"Česká Lípa",
	"České Budějovice",
	"Český Krumlov",
	"Děčín",
	"Domažlice",
	"Dubí",
	"Frýdek-Místek",
	"Havlíčkův Brod",
	"Hodonín",
	"Hradec Králové",
	"Humpolec",
	"Cheb",
	"Chomutov",
	"Chrudim",
	"Jablonec nad Nisou",
	"Jeseník",
	"Jičín",
	"Jihlava",
	"Jindřichův Hradec",
	"Karlovy Vary",
	"Karviná",
	"Kladno",
	"Klatovy",
	"Kolín",
	"Kosmonosy",
	"Kroměříž",
	"Kutná Hora",
	"Liberec",
	"Litoměřice",
	"Louny",
	"Manětín",
	"Mělník",
	"Mladá Boleslav",
	"Most",
	"Náchod",
	"Nový Jičín",
	"Nymburk",
	"Olomouc",
	"Opava",
	"Oráčov",
	"Ostrava",
	"Pardubice",
	"Pelhřimov",
	"Polžice",
	"Písek",
	"Plzeň",
	"Praha",
	"Prachatice",
	"Přerov",
	"Příbram",
	"Prostějov",
	"Rakovník",
	"Rokycany",
	"Rudná",
	"Rychnov nad Kněžnou",
	"Semily",
	"Sokolov",
	"Strakonice",
	"Středokluky",
	"Šumperk",
	"Svitavy",
	"Tábor",
	"Tachov",
	"Teplice",
	"Třebíč",
	"Trutnov",
	"Uherské Hradiště",
	"Ústí nad Labem",
	"Ústí nad Orlicí",
	"Vsetín",
	"Vyškov",
	"Žďár nad Sázavou",
	"Zlín",
	"Znojmo"
};


/* The advanced hyperintelligent Czech town names generator! */
/* The tables and MakeCzechTownName() is (c) Petr Baudis 2005 (GPL'd)
 * Feel free to ask me about anything unclear or if you need help
 * with cloning this for your own language. */

// Sing., pl.
typedef enum CzechGender {
	CZG_SMASC,
	CZG_SFEM,
	CZG_SNEUT,
	CZG_PMASC,
	CZG_PFEM,
	CZG_PNEUT,
	// Special for substantive stems - the ending chooses the gender.
	CZG_FREE,
	// Like CZG_FREE, but disallow CZG_SNEUT.
	CZG_NFREE
} CzechGender;
typedef enum CzechPattern {
	CZP_JARNI,
	CZP_MLADY,
	CZP_PRIVL
} CzechPattern;
/* [CzechGender][CzechPattern] - replaces the last character of the adjective
 * by this. */
// XXX: [CZG_SMASC][CZP_PRIVL] needs special handling: -ovX -> -uv.
static const char *name_czech_patmod[][3] = {
	/* CZG_SMASC */ { "í", "ý", "X" },
	/* CZG_SFEM */  { "í", "á", "a" },
	/* CZG_SNEUT */ { "í", "é", "o" },
	/* CZG_PMASC */ { "í", "é", "y" },
	/* CZG_PFEM */  { "í", "é", "y" },
	/* CZG_PNEUT */ { "í", "á", "a" }
};

// This way the substantives can choose only some adjectives/endings:
// At least one of these flags must be satisfied:
typedef enum CzechAllow {
	CZA_SHORT = 1,
	CZA_MIDDLE = 2,
	CZA_LONG = 4,
	CZA_ALL = ~0
} CzechAllow;
// All these flags must be satisfied (in the stem->others direction):
typedef enum CzechChoose {
	CZC_NONE = 0, // No requirements.
	CZC_COLOR = 1,
	CZC_POSTFIX = 2, // Matched if postfix was inserted.
	CZC_NOPOSTFIX = 4, // Matched if no postfix was inserted.
	CZC_ANY = ~0
} CzechChoose;

typedef struct CzechNameSubst {
	CzechGender gender;
	CzechAllow allow;
	CzechChoose choose;
	const char *name;
} CzechNameSubst;

typedef struct CzechNameAdj {
	CzechPattern pattern;
	CzechChoose choose;
	const char *name;
} CzechNameAdj;

// Some of items which should be common are doubled.
static const CzechNameAdj name_czech_adj[] = {
	{ CZP_JARNI, CZC_ANY, "Horní" },
	{ CZP_JARNI, CZC_ANY, "Horní" },
	{ CZP_JARNI, CZC_ANY, "Dolní" },
	{ CZP_JARNI, CZC_ANY, "Dolní" },
	{ CZP_JARNI, CZC_ANY, "Přední" },
	{ CZP_JARNI, CZC_ANY, "Zadní" },
	{ CZP_JARNI, CZC_ANY, "Kostelní" },
	{ CZP_JARNI, CZC_ANY, "Havraní" },
	{ CZP_JARNI, CZC_ANY, "Říční" },
	{ CZP_JARNI, CZC_ANY, "Jezerní" },
	{ CZP_MLADY, CZC_ANY, "Velký" },
	{ CZP_MLADY, CZC_ANY, "Velký" },
	{ CZP_MLADY, CZC_ANY, "Malý" },
	{ CZP_MLADY, CZC_ANY, "Malý" },
	{ CZP_MLADY, CZC_ANY, "Vysoký" },
	{ CZP_MLADY, CZC_ANY, "Český" },
	{ CZP_MLADY, CZC_ANY, "Moravský" },
	{ CZP_MLADY, CZC_ANY, "Slovácký" },
	{ CZP_MLADY, CZC_ANY, "Slezský" },
	{ CZP_MLADY, CZC_ANY, "Uherský" },
	{ CZP_MLADY, CZC_ANY, "Starý" },
	{ CZP_MLADY, CZC_ANY, "Starý" },
	{ CZP_MLADY, CZC_ANY, "Nový" },
	{ CZP_MLADY, CZC_ANY, "Nový" },
	{ CZP_MLADY, CZC_ANY, "Mladý" },
	{ CZP_MLADY, CZC_ANY, "Královský" },
	{ CZP_MLADY, CZC_ANY, "Kamenný" },
	{ CZP_MLADY, CZC_ANY, "Cihlový" },
	{ CZP_MLADY, CZC_ANY, "Divný" },
	{ CZP_MLADY, CZC_COLOR, "Červená" },
	{ CZP_MLADY, CZC_COLOR, "Červená" },
	{ CZP_MLADY, CZC_COLOR, "Červená" },
	{ CZP_MLADY, CZC_COLOR, "Zelená" },
	{ CZP_MLADY, CZC_COLOR, "Žlutá" },
	{ CZP_MLADY, CZC_COLOR, "Sivá" },
	{ CZP_MLADY, CZC_COLOR, "Šedá" },
	{ CZP_MLADY, CZC_COLOR, "Bílá" },
	{ CZP_MLADY, CZC_COLOR, "Bílá" },
	{ CZP_MLADY, CZC_COLOR, "Modrá" },
	{ CZP_MLADY, CZC_COLOR, "Růžová" },
	{ CZP_MLADY, CZC_COLOR, "Černá" },
	{ CZP_PRIVL, CZC_ANY, "Králova" },
	{ CZP_PRIVL, CZC_ANY, "Janova" },
	{ CZP_PRIVL, CZC_ANY, "Karlova" },
	{ CZP_PRIVL, CZC_ANY, "Kryštofova" },
	{ CZP_PRIVL, CZC_ANY, "Jiříkova" },
	{ CZP_PRIVL, CZC_ANY, "Petrova" },
	{ CZP_PRIVL, CZC_ANY, "Sudovo" },
};

// Considered a stem for choose/allow matching purposes.
static const CzechNameSubst name_czech_subst_full[] = {
	{ CZG_SMASC, CZA_ALL, CZC_COLOR, "Sedlec" },
	{ CZG_SMASC, CZA_ALL, CZC_COLOR, "Brod" },
	{ CZG_SMASC, CZA_ALL, CZC_COLOR, "Brod" },
	{ CZG_SMASC, CZA_ALL, CZC_NONE, "Úval" },
	{ CZG_SMASC, CZA_ALL, CZC_COLOR, "Žďár" },
	{ CZG_SMASC, CZA_ALL, CZC_COLOR, "Smrk" },
	{ CZG_SFEM,  CZA_ALL, CZC_COLOR, "Hora" },
	{ CZG_SFEM,  CZA_ALL, CZC_COLOR, "Lhota" },
	{ CZG_SFEM,  CZA_ALL, CZC_COLOR, "Lhota" },
	{ CZG_SFEM,  CZA_ALL, CZC_COLOR, "Hlava" },
	{ CZG_SFEM,  CZA_ALL, CZC_COLOR, "Lípa" },
	{ CZG_SNEUT, CZA_ALL, CZC_COLOR, "Pole" },
	{ CZG_SNEUT, CZA_ALL, CZC_COLOR, "Údolí" },
	{ CZG_PMASC, CZA_ALL, CZC_NONE, "Úvaly" },
	{ CZG_PFEM,  CZA_ALL, CZC_COLOR, "Luka" },
	{ CZG_PNEUT, CZA_ALL, CZC_COLOR, "Pole" },
};

// TODO: More stems needed. --pasky
static const CzechNameSubst name_czech_subst_stem[] = {
	{ CZG_SMASC,             CZA_MIDDLE,            CZC_COLOR, "Kostel" },
	{ CZG_SMASC,             CZA_MIDDLE,            CZC_COLOR, "Klášter" },
	{ CZG_SMASC, CZA_SHORT,                         CZC_COLOR, "Lhot" },
	{ CZG_SFEM,  CZA_SHORT,                         CZC_COLOR, "Lhot" },
	{ CZG_SFEM,  CZA_SHORT,                         CZC_COLOR, "Hur" },
	{ CZG_FREE,              CZA_MIDDLE | CZA_LONG, CZC_NONE, "Sedl" },
	{ CZG_FREE,  CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_COLOR, "Hrad" },
	{ CZG_NFREE,             CZA_MIDDLE,            CZC_NONE, "Pras" },
	{ CZG_NFREE,             CZA_MIDDLE,            CZC_NONE, "Baž" },
	{ CZG_NFREE,             CZA_MIDDLE,            CZC_NONE, "Tes" },
	{ CZG_NFREE,             CZA_MIDDLE,            CZC_NONE, "Už" },
	{ CZG_NFREE,             CZA_MIDDLE | CZA_LONG, CZC_POSTFIX, "Bř" },
	{ CZG_NFREE,             CZA_MIDDLE | CZA_LONG, CZC_NONE, "Vod" },
	{ CZG_NFREE,             CZA_MIDDLE | CZA_LONG, CZC_NONE, "Jan" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Prach" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Kunr" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Strak" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Vít" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Vyš" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Žat" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Žer" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Střed" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Harv" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Pruh" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Tach" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Písn" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Jin" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Jes" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Jar" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Sok" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Hod" },
	{ CZG_NFREE,                          CZA_LONG, CZC_NONE, "Net" },
	{ CZG_FREE,                           CZA_LONG, CZC_NONE, "Praž" },
	{ CZG_FREE,                           CZA_LONG, CZC_NONE, "Nerat" },
	{ CZG_FREE,                           CZA_LONG, CZC_NONE, "Kral" },
	{ CZG_FREE,                           CZA_LONG, CZC_NONE, "Hut" },
	{ CZG_FREE,                           CZA_LONG, CZC_NOPOSTFIX, "Pan" },
	{ CZG_FREE,  CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_NOPOSTFIX, "Odstřed" },
	{ CZG_FREE,  CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_COLOR, "Mrat" },
	{ CZG_FREE,                           CZA_LONG, CZC_COLOR, "Hlav" },
	{ CZG_FREE,  CZA_SHORT | CZA_MIDDLE,            CZC_NONE, "Měř" },
	{ CZG_FREE,              CZA_MIDDLE | CZA_LONG, CZC_NONE, "Lip" },
};

// Optional postfix inserted between stem and ending.
static const char *name_czech_subst_postfix[] = {
	"av", "an", "at",
	"ov", "on", "ot",
	"ev", "en", "et",
};

// This array must have the both neutral genders at the end!
static const CzechNameSubst name_czech_subst_ending[] = {
	{ CZG_SMASC, CZA_SHORT | CZA_MIDDLE,            CZC_ANY, "ec" },
	{ CZG_SMASC, CZA_SHORT | CZA_MIDDLE,            CZC_ANY, "ín" },
	{ CZG_SMASC, CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_ANY, "ov" },
	{ CZG_SMASC, CZA_SHORT       |        CZA_LONG, CZC_ANY, "kov" },
	{ CZG_SMASC,                          CZA_LONG, CZC_POSTFIX, "ín" },
	{ CZG_SMASC,                          CZA_LONG, CZC_POSTFIX, "ník" },
	{ CZG_SMASC,                          CZA_LONG, CZC_ANY, "burk" },
	{ CZG_SFEM,  CZA_SHORT,                         CZC_ANY, "ka" },
	{ CZG_SFEM,              CZA_MIDDLE,            CZC_ANY, "inka" },
	{ CZG_SFEM,              CZA_MIDDLE,            CZC_ANY, "ná" },
	{ CZG_SFEM,                           CZA_LONG, CZC_ANY, "ava" },
	{ CZG_PMASC,                          CZA_LONG, CZC_POSTFIX, "íky" },
	{ CZG_PMASC,                          CZA_LONG, CZC_ANY, "upy" },
	{ CZG_PMASC,                          CZA_LONG, CZC_ANY, "olupy" },
	{ CZG_PFEM,                           CZA_LONG, CZC_ANY, "avy" },
	{ CZG_PFEM,  CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_ANY, "ice" },
	{ CZG_PFEM,  CZA_SHORT | CZA_MIDDLE | CZA_LONG, CZC_ANY, "ičky" },
	{ CZG_PNEUT, CZA_SHORT | CZA_MIDDLE,            CZC_ANY, "na" },
	{ CZG_SNEUT, CZA_SHORT | CZA_MIDDLE,            CZC_ANY, "no" },
	{ CZG_SNEUT,                          CZA_LONG, CZC_ANY, "iště" },
};

static const char *name_czech_suffix[] = {
	"nad Cidlinou",
	"nad Dyjí",
	"nad Jihlavou",
	"nad Labem",
	"nad Lesy",
	"nad Moravou",
	"nad Nisou",
	"nad Odrou",
	"nad Ostravicí",
	"nad Sázavou",
	"nad Vltavou",
	"pod Pradědem",
	"pod Radhoštěm",
	"pod Řípem",
	"pod Sněžkou",
	"pod Špičákem",
	"pod Sedlem",
	"v Čechách",
	"na Moravě",
};



static const char *name_romanian_real[]= {
	"Adjud",
	"Alba Iulia",
	"Alexandria",
	"Babadag",
	"Bacãu",
	"Baia Mare",
	"Bãile Herculane",
	"Bãilesti",
	"Bârlad",
	"Bicaz",
	"Bistrita",
	"Blaj",
	"Borsec",
	"Botosani",
	"Brãila",
	"Brasov",
	"Bucuresti",
	"Buftea",
	"Buzãu",
	"Cãlãrasi",
	"Caransebes",
	"Cernavodã",
	"Cluj-Napoca",
	"Constanta",
	"Covasna",
	"Craiova",
	"Dej",
	"Deva",
	"Dorohoi",
	"Dr.-Tr. Severin",
	"Drãgãsani",
	"Fãgãras",
	"Fãlticeni",
	"Fetesti",
	"Focsani",
	"Galati",
	"Gheorgheni",
	"Giurgiu",
	"Hârsova",
	"Hunedoara",
	"Husi",
	"Iasi",
	"Isaccea",
	"Lugoj",
	"Mãcin",
	"Mangalia",
	"Medgidia",
	"Medias",
	"Miercurea Ciuc",
	"Mizil",
	"Motru",
	"Nãsãud",
	"Nãvodari",
	"Odobesti",
	"Oltenita",
	"Onesti",
	"Oradea",
	"Orsova",
	"Petrosani",
	"Piatra Neamt",
	"Pitesti",
	"Ploiesti",
	"Predeal",
	"Râmnicu Vâlcea",
	"Reghin",
	"Resita",
	"Roman",
	"Rosiorii de Vede",
	"Satu Mare",
	"Sebes",
	"Sfântu Gheorghe",
	"Sibiu",
	"Sighisoara",
	"Sinaia",
	"Slatina",
	"Slobozia",
	"Sovata",
	"Suceava",
	"Sulina",
	"Tãndãrei",
	"Târgoviste",
	"Târgu Jiu",
	"Târgu Mures",
	"Tecuci",
	"Timisoara",
	"Tulcea",
	"Turda",
	"Turnu Mãgurele",
	"Urziceni",
	"Vaslui",
	"Vatra Dornei",
	"Victoria",
	"Videle",
	"Zalãu"
};

static const char *name_slovak_real[] = {
	"Bratislava",
	"Banovce nad Bebravou",
	"Banska Bystrica",
	"Banska Stiavnica",
	"Bardejov",
	"Brezno",
	"Brezova pod Bradlom",
	"Bytca",
	"Cadca",
	"Cierna nad Tisou",
	"Detva",
	"Detva",
	"Dolny Kubin",
	"Dolny Kubin",
	"Dunajska Streda",
	"Gabcikovo",
	"Galanta",
	"Gbely",
	"Gelnica",
	"Handlova",
	"Hlohovec",
	"Holic",
	"Humenne",
	"Hurbanovo",
	"Kezmarok",
	"Komarno",
	"Kosice",
	"Kremnica",
	"Krompachy",
	"Kuty",
	"Leopoldov",
	"Levoca",
	"Liptovsky Mikulas",
	"Lucenec",
	"Malacky",
	"Martin",
	"Medzilaborce",
	"Michalovce",
	"Modra",
	"Myjava",
	"Namestovo",
	"Nitra",
	"Nova Bana",
	"Nove Mesto nad Vahom",
	"Nove Zamky",
	"Partizanske",
	"Pezinok",
	"Piestany",
	"Poltar",
	"Poprad",
	"Povazska Bystrica",
	"Prievidza",
	"Puchov",
	"Revuca",
	"Rimavska Sobota",
	"Roznava",
	"Ruzomberok",
	"Sabinov",
	"Sala",
	"Senec",
	"Senica",
	"Sered",
	"Skalica",
	"Sladkovicovo",
	"Smolenice",
	"Snina",
	"Stara Lubovna",
	"Stara Tura",
	"Strazske",
	"Stropkov",
	"Stupava",
	"Sturovo",
	"Sulekovo",
	"Topolcany",
	"Trebisov",
	"Trencin",
	"Trnava",
	"Turcianske Teplice",
	"Tvrdosin",
	"Vrable",
	"Vranov nad Toplov",
	"Zahorska Bystrica",
	"Zdiar",
	"Ziar nad Hronom",
	"Zilina",
	"Zlate Moravce",
	"Zvolen"
};

static const char *name_norwegian_1[] = {
	"Arna",
	"Aust",
	"Bjørk",
	"Bjørn",
	"Brand",
	"Bøver",
	"Drag",
	"Drø",
	"Eids",
	"Egge",
	"Fager",
	"Finns",
	"Flat",
	"Foll",
	"Foss",
	"Fugle",
	"Furu",
	"Gaus",
	"Galte",
	"Geir",
	"Gløs",
	"Gran",
	"Grind",
	"Grims",
	"Grøn",
	"Grøt",
	"Gulle",
	"Haka",
	"Hammer",
	"Haug",
	"Hol",
	"Hon",
	"Hop",
	"Hov",
	"Jess",
	"Kabel",
	"Kjerns",
	"Kjerring",
	"Knatte",
	"Krok",
	"Køy",
	"Lang",
	"Lauv",
	"Leir",
	"Lund",
	"Logn",
	"Lo",
	"Lyng",
	"Løn",
	"Mesna",
	"Mel",
	"Mo",
	"Nar",
	"Nitte",
	"Nord",
	"Odd",
	"Ola",
	"Otte",
	"Ran",
	"Rev",
	"Rog",
	"Roms",
	"Rosen",
	"Sand",
	"Sau",
	"Sel",
	"Sol",
	"Sjur",
	"Skår",
	"Slått",
	"Stjør",
	"Stor",
	"Svart",
	"Svens",
	"Svin",
	"Sylte",
	"Syn",
	"Tran",
	"Vass",
	"Ved",
	"Vest",
	"Vesle",
	"Vik",
	"Våg"
};

static const char *name_norwegian_2[] = {
	"aker",
	"anger",
	"bakken",
	"bekk",
	"berg",
	"botn",
	"breen",
	"bu",
	"bugen",
	"by",
	"bygd",
	"bø",
	"dal",
	"egga",
	"eid",
	"elv",
	"enga",
	"foss",
	"fjell",
	"fjord",
	"foten",
	"gard",
	"grend",
	"hammer",
	"haug",
	"havn",
	"heim",
	"hella",
	"hovda",
	"høa",
	"høgda",
	"kampen",
	"kjølen",
	"kollen",
	"kroken",
	"land",
	"lia",
	"mark",
	"moen",
	"myr",
	"nes",
	"nuten",
	"osen",
	"rike",
	"rud",
	"sand",
	"set",
	"sjøen",
	"skogen",
	"slette",
	"snipa",
	"stad",
	"stua",
	"stulen",
	"sund",
	"svingen",
	"sætra",
	"tinden",
	"tun",
	"vang",
	"vatn",
	"veid",
	"vik",
	"voll",
	"våg",
	"um",
	"åsen"
};

static const char *name_norwegian_real[] = {
	"Alta",
	"Arendal",
	"Askim",
	"Bergen",
	"Bodø",
	"Brevik",
	"Bryne",
	"Brønnøysund",
	"Drammen",
	"Drøbak",
	"Egersund",
	"Elverum",
	"Farsund",
	"Fauske",
	"Finnsnes",
	"Flekkefjord",
	"Flora",
	"Fosnavåg",
	"Fredrikstad",
	"Førde",
	"Gjøvik",
	"Grimstad",
	"Halden",
	"Hamar",
	"Hammerfest",
	"Harstad",
	"Haugesund",
	"Holmestrand",
	"Horten",
	"Jørpeland",
	"Kirkenes",
	"Kolvereid",
	"Kongsberg",
	"Kongsvinger",
	"Kopervik",
	"Kragerø",
	"Kristiansand",
	"Kristiansund",
	"Langesund",
	"Larvik",
	"Leirvik",
	"Leknes",
	"Levanger",
	"Lillehammer",
	"Lillesand",
	"Lillestrøm",
	"Lyngdal",
	"Lørenskog",
	"Mandal",
	"Mo i Rana",
	"Molde",
	"Mosjøen",
	"Moss",
	"Mysen",
	"Måløy",
	"Namsos",
	"Narvik",
	"Notodden",
	"Odda",
	"Oslo",
	"Otta",
	"Porsgrunn",
	"Ringerike",
	"Risør",
	"Rjukan",
	"Sandefjord",
	"Sandnes",
	"Sandnessjøen",
	"Sandvika",
	"Sarpsborg",
	"Sauda",
	"Ski",
	"Skien",
	"Skudeneshavn",
	"Sortland",
	"Stathelle",
	"Stavanger",
	"Steinkjer",
	"Stjørdal",
	"Stokmarknes",
	"Stord",
	"Svelvik",
	"Svolvær",
	"Tromsø",
	"Trondheim",
	"Tvedestrand",
	"Tønsberg",
	"Ulsteinvik",
	"Vadsø",
	"Vardø",
	"Verdalsøra",
	"Åkrehamn",
	"Ålesund",
	"Åndalsnes"
};

static const char *name_hungarian_1[] = {
	"Nagy-",
	"Kis-",
	"Felső-",
	"Alsó-",
	"Új-"
};

static const char *name_hungarian_2[] = {
	"Bodrog",
	"Dráva",
	"Duna",
	"Hejő",
	"Hernád",
	"Rába",
	"Sajó",
	"Szamos",
	"Tisza",
	"Zala",
	"Balaton",
	"Fertő",
	"Bakony",
	"Cserhát",
	"Bihar",
	"Hajdú",
	"Jász",
	"Kun",
	"Magyar",
	"Nógrád",
	"Nyír",
	"Somogy",
	"Székely",
	"Buda",
	"Győr",
	"Pest",
	"Fehér",
	"Cserép",
	"Erdő",
	"Hegy",
	"Homok",
	"Mező",
	"Puszta",
	"Sár",
	"Császár",
	"Herceg",
	"Király",
	"Nemes",
	"Püspök",
	"Szent",
	"Almás",
	"Szilvás",
	"Agg",
	"Aranyos",
	"Békés",
	"Egyházas",
	"Gagy",
	"Heves",
	"Kapos",
	"Tápió",
	"Torna",
	"Vas",
	"Vámos",
	"Vásáros"
};

static const char *name_hungarian_3[] = {
	"apáti",
	"bába",
	"bikk",
	"dob",
	"fa",
	"föld",
	"hegyes",
	"kak",
	"kereszt",
	"kürt",
	"ladány",
	"mérges",
	"szalonta",
	"telek",
	"vas",
	"völgy"
};

static const char *name_hungarian_4[] = {
	"alja",
	"egyháza",
	"háza",
	"úr",
	"vár"
};

static const char *name_hungarian_real[] = {
	"Ajka",
	"Aszód",
	"Badacsony",
	"Baja",
	"Budapest",
	"Debrecen",
	"Eger",
	"Fonyód",
	"Gödöllő",
	"Győr",
	"Gyula",
	"Karcag",
	"Kecskemét",
	"Keszthely",
	"Kisköre",
	"Kocsord",
	"Komárom",
	"Kőszeg",
	"Makó",
	"Mohács",
	"Miskolc",
	"Ózd",
	"Paks",
	"Pápa",
	"Pécs",
	"Polgár",
	"Sarkad",
	"Siófok",
	"Szeged",
	"Szentes",
	"Szolnok",
	"Tihany",
	"Tokaj",
	"Vác",
	"Záhony",
	"Zirc"
};

static const char *name_swiss_real[] = {
	"Aarau",
	"Aesch",
	"Altdorf",
	"Arosa",
	"Appenzell",
	"Arbon",
	"Altstätten",
	"Baar",
	"Baden",
	"Bellinzona",
	"Brig-Glis",
	"Bienne",
	"Bulle",
	"Binningen",
	"Burgdorf",
	"Bern",
	"Basel",
	"Bülach",
	"Carouge",
	"Cham",
	"Chiasso",
	"Chur",
	"Davos",
	"Delémont",
	"Dietikon",
	"Dübendorf",
	"Emmen",
	"Freienbach-Pfäffikon",
	"Fribourg",
	"Frauenfeld",
	"Genève",
	"Glarus",
	"Gossau",
	"Grenchen",
	"Herisau",
	"Horgen",
	"Horw",
	"Illnau-Effretikon",
	"Ittigen",
	"Jona",
	"Kriens",
	"Kloten",
	"Köniz",
	"Kreuzlingen",
	"Küsnacht",
	"Agen",
	"Lancy",
	"La Chaux-de-Fonds",
	"Lenzburg",
	"Lugano",
	"Langenthal",
	"Littau",
	"Le Locle",
	"La Neuveville",
	"Locarno",
	"Liestal",
	"La Tour-de-Peilz",
	"Lausanne",
	"Lyss",
	"Luzern",
	"Martigny",
	"Münchenstein",
	"Meyrin",
	"Montreux",
	"Monthey",
	"Morges",
	"Murten",
	"Moutier",
	"Muttenz",
	"Neuchâtel",
	"Neuhausen am Rheinfall",
	"Nyon",
	"Olten",
	"Onex",
	"Opfikon",
	"Ostermundigen",
	"Payerne",
	"Peseux",
	"Prilly",
	"Pully",
	"Rapperswil",
	"Richterswil",
	"Regensdorf",
	"Rheinfelden",
	"Riehen",
	"Renens",
	"Romanshorn",
	"Rorschach",
	"Stans",
	"Schaffhausen",
	"Steffisburg",
	"St. Gallen",
	"Schlieren",
	"Sierre",
	"Solothurn",
	"St. Moritz",
	"Sion",
	"Spiez",
	"Stäfa",
	"Sursee",
	"Schwyz",
	"Thalwil",
	"Thônex",
	"Thun",
	"Uster",
	"Uzwil",
	"Vernier",
	"Volketswil",
	"Versoix",
	"Vevey",
	"Wädenswil",
	"Wettingen",
	"Wil",
	"Wallisellen",
	"Winterthur",
	"Wohlen",
	"Worb",
	"Wetzikon",
	"Yverdon-les-Bains",
	"Zollikon",
	"Zofingen",
	"Zürich",
	"Zug",
};

static const char *name_danish_1[] = {
	"Gamle ",
	"Lille ",
	"Nye ",
	"Store ",
	"Kirke ",
	"Nørre ",
	"Vester ",
	"Sønder ",
	"Øster ",
	"Hvide ",
	"Høje ",
	"Kongens ",
};

static const char *name_danish_2[] = {
	"Ager",
	"Alle",
	"Aske",
	"Balle",
	"Bede",
	"Birke",
	"Bjerring",
	"Bjæver",
	"Blommens",
	"Blok",
	"Bolder",
	"Bred",
	"Charlotten",
	"Christians",
	"Danne",
	"Diana",
	"Es",
	"Fredens",
	"Frederiks",
	"Fugle",
	"Fåre",
	"Gille",
	"Gis",
	"Givs",
	"Glams",
	"Glo",
	"Guld",
	"Had",
	"Haralds",
	"Hassel",
	"Hede",
	"Helle",
	"Hessel",
	"Hjorts",
	"Hol",
	"Horn",
	"Humle",
	"Høj",
	"Hør",
	"Is",
	"Jyde",
	"Jægers",
	"Karls",
	"Klov",
	"Kokke",
	"Kvist",
	"Lang",
	"Lange",
	"Mari",
	"Nord",
	"Ny",
	"Oks",
	"Ring",
	"Røde",
	"Rung",
	"Rør",
	"Rud",
	"Saks",
	"Salt",
	"Skam",
	"Silke",
	"Skod",
	"Skæl",
	"Skær",
	"Sol",
	"Svend",
	"Svine",
	"Strand",
	"Stubbe",
	"Ting",
	"Tjære",
	"Tore",
	"Uger",
	"Ulf",
	"Val",
	"Vand",
	"Vej",
	"Vor",
	"Vær",
	"Ør",
	"Ål"
};

static const char *name_danish_3[] = {
	"basse",
	"borg",
	"berg",
	"bro",
	"by",
	"havn",
	"strup",
	"holm",
	"hus",
	"købing",
	"lund",
	"lunde",
	"sund",
	"ovre",
	"høj",
	"dal",
	"sted",
	"sten",
	"løse",
	"rød",
	"magle",
	"sø",
	"bjerg",
	"bæk",
	"drup",
	"lev",
	"bo",
	"lyst",
	"feld",
	"skov"
};

static const char *name_turkish_prefix[] = {
	"Akça",
	"Altın",
	"Bahçe",
	"Boz",
	"Büyük",
	"Çay",
	"Doğu",
	"Eski",
	"Güzel",
	"Kızıl",
	"Küçük",
	"Orta",
	"Sarı",
	"Sultan",
	"Ulu",
	"Yeni"
};

static const char *name_turkish_middle[] = {
	"agaç",
	"ayva",
	"çam",
	"elma",
	"kurt",
	"pazar",
	"yalı"
};

static const char *name_turkish_suffix[] = {
	"dere",
	"hisar",
	"kale",
	"kaya",
	"kent",
	"köy",
	"ova",
	"özü",
	"ören",
	"pazar",
	"saray",
	"tepe",
	"yer",
	"yurt"
};

static const char *name_turkish_real[] = {
	"Adana",
	"Adıyaman",
	"Afyon",
	"Ağrı",
	"Amasya",
	"Antalya",
	"Artvin",
	"Balıkesir",
	"Bilecik",
	"Bitlis",
	"Bolu",
	"Burdur",
	"Bursa",
	"Çanakkale",
	"Çankırı",
	"Denizli",
	"Diyarbakır",
	"Edirne",
	"Elazığ",
	"Erzurum",
	"Eskisehir",
	"Giresun",
	"Gümüşhane",
	"Hatay",
	"Isparta",
	"İçel",
	"İstanbul",
	"İzmir",
	"Kars",
	"Kastamonu",
	"Kayseri",
	"Kirklareli",
	"Kocaeli",
	"Konya",
	"Kütahya",
	"Malatya",
	"Manisa",
	"Kahramanmaraş",
	"Mardin",
	"Muğla",
	"Muş",
	"Nevşehir",
	"Niğde",
	"Rize",
	"Sakarya",
	"Samsun",
	"Siirt",
	"Sinop",
	"Sivas",
	"Trabzon",
	"Şanlıurfa",
	"Van",
	"Yozgat",
	"Zonguldak",
	"Aksaray",
	"Bayburt",
	"Karaman",
	"Şırnak",
	"Bartın",
	"Ardahan",
	"Iğdır",
	"Yalova",
	"Karabük",
	"Osmaniye",
	"Düzce"
};

static const char *name_italian_real[] = {
	"Roma",
	"Milano",
	"Napoli",
	"Torino",
	"Venezia",
	"Firenze",
	"Palermo",
	"Genova",
	"Parma",
	"Bologna",
	"Bari",
	"Cagliari",
	"Sassari",
	"Pisa",
	"Aosta",
	"Brescia",
	"Verona",
	"Bolzano",
	"Padova",
	"Udine",
	"Trieste",
	"Livorno",
	"Ancona",
	"Perugia",
	"Pescara",
	"L'Aquila",
	"Campobasso",
	"Potenza",
	"Cosenza",
	"Reggio Calabria",
	"Catania",
	"Caltanisetta",
	"Agrigento",
	"La Spezia",
	"Modena",
	"Vicenza",
	"Mantova",
	"Cremona",
	"Piacenza",
	"Reggio Emilia",
	"Foggia",
	"Benevento",
	"Salerno",
	"Catanzaro",
	"Lecce",
	"Como",
	"Lecco",
	"Sondrio",
	"Trento",
	"Desenzano",
	"Cuneo",
	"Asti",
	"Lodi",
	"Novara",
	"Biella",
	"Vercelli",
	"Rieti",
	"Nuoro",
	"Oristano",
	"Matera",
	"Taranto",
	"Varese",
	"Bergamo",
	"Pavia",
	"Caserta",
	"Frosinone",
	"Latina",
	"Enna",
	"Ragusa",
	"Siracusa",
	"Pordenone",
	"Imperia",
	"Verbania",
	"Alessandria",
	"Messina",
	"Siena",
	"Arezzo",
	"Grosseto",
};

static const char *name_italian_pref[] = {
	"Alpe ",
	"Borgo ",
	"Cascina ",
	"Castel ",
	"Fonte ",
	"Forte ",
	"Malga ",
	"Pieve ",
	"Poggio ",
	"Rocca ",
	"Villa ",
	"Villar ",
};

static const char *name_italian_1m[] = {
	"Bel",
	"Borgo",
	"Bosco",
	"Campo",
	"Capo",
	"Casal",
	"Castel",
	"Colle",
	"Fiume",
	"Fonte",
	"Lago",
	"Mezzo",
	"Monte",
	"Mon",
	"Orto",
	"Passo",
	"Prato",
	"Poggio",
	"Ponte",
	"Pozzo",
	"Sasso",
	"Tra",
	"Tre",
	"Ver",
	"Vico",
};

static const char *name_italian_1f[] = {
	"Acqua",
	"Bra",
	"Cala",
	"Casa",
	"Chiesa",
	"Citta",
	"Civita",
	"Corte",
	"Costa",
	"Croce",
	"Fontana",
	"Grotta",
	"Guardia",
	"Mezza",
	"Palma",
	"Pietra",
	"Ripa",
	"Rocca",
	"Serra",
	"Torre",
	"Val",
	"Valle",
	"Villa",
};

static const char *name_italian_2[] = {
	"bell",
	"bianc",
	"cald",
	"chiar",
	"cort",
	"ferrat",
	"fier",
	"fredd",
	"gioios",
	"grec",
	"guzz",
	"lung",
	"long",
	"migli",
	"negr",
	"ner",
	"nov",
	"nuov",
	"ross",
	"rotond",
	"scur",
	"secc",
	"sett",
	"vecchi",
	"ventos",
	"vers",
	"viv",
};

static const char *name_italian_2i[] = {
	"",
	"breve",
	"brevi",
	"chiari",
	"ferro",
	"fieschi",
	"fiore",
	"fonte",
	"forte",
	"gate",
	"leone",
	"maggiore",
	"minore",
	"mole",
	"monte",
	"poli",
	"scuri",
	"terra",
	"te",
	"torrione",
	"vento",
	"verde",
	"versiere",
};


static const char *name_italian_3[] = {
	" Marittimo",
	" Marittima",
	" del Capo",
	" del Monte",
	" di Sopra",
	" di Sotto",
	" sui Monti",
	" dei Marmi",
	" dei Sassi",
	" delle Fonti",
	" sui Prati",
	" a Mare",
	" Superiore",
	" Inferiore",
	" Terme",
	" Alta",
	" Bassa",
	" Brianza",
	" Vesuviano",
	" Scrivia",
	" Ticino",
};

static const char *name_italian_river1[] = {
	" del",
	" sul",
	" al",
	" nel",
};

static const char *name_italian_river2[] = {
	"l'Adda",
	"l'Adige",
	"le Alpi",
	"l'Arno",
	" Bormida",
	" Brenta",
	"la Dora Baltea",
	" Lambro",
	" Mincio",
	" Naviglio",
	"l'Oglio",
	"l'Olona",
	"l'Ombrone",
	" Panaro",
	" Piave",
	" Po",
	" Reno",
	" Scrivia",
	" Secchia",
	" Serio",
	" Tagliamento",
	" Tanaro",
	" Taro",
	" Ticino",
	" Tevere",
};

static const char *name_catalan_real[] = {
	"Barcelona",
	"Hospitalet",
	"Cerdanyola",
	"Martorell",
	"Badalona",
	"Tarragona",
	"Lleida",
	"Girona",
	"Sabadell",
	"Terrassa",
	"Reus",
	"Valls",
	"Vic",
	"Vielha",
	"Amposta",
	"Tortosa",
	"Berga",
	"Olot",
	"Mollerussa",
	"Banyoles",
	"Figueres",
	"Balaguer",
	"Vilafranca del Penedès",
	"La seu d'Urgell",
	"Pont de Suert",
	"Igualada",
	"Manresa",
	"Solsona",
	"Les borges blanques",
	"Tremp",
	"Sort",
	"Colera",
	"Portbou",
	"El Vendrell",
	"Falset",
	"Ripoll",
	"Cervera",
	"Gandesa",
	"Mataró",
	"Montblanc",
	"Vilanova i la Geltrú",
	"Tàrrega",
	"Camprodon",
	"Campdevànol",
	"Cambrils",
	"Begur",
	"Set Cases",
	"Palafrugell",
	"Begues",
	"El Bruc",
	"Cadaqués",
	"Collbató",
	"Cervelló",
	"Esparraguera",
	"Abrera",
	"Alp",
	"Das",
	"Cercs",
	"Manlleu",
	"Masnou",
	"Molins de rei",
	"Monistrol",
	"Rocallaura",
	"Rubí",
	"Ripollet",
	"Sitges",
	"Roses",
};

static const char *name_catalan_pref[] = {
	"Pont de ",
	"Parets de ",
	"Canet de ",
	"Castellar de ",
	"Corbera de ",
	"Arenys de ",
	"Calella de ",
	"La seu de ",
	"La bisbal de ",
	"Torroella de ",
	"Port de ",
	"Vilafranca de ",
	"Vilanova de ",
	"Caldes de ",
	"La Conca de ",
	"Olesa de ",
	"La Roca de ",
	"Sant Esteve de ",
	"Sant Andreu de ",
	"Sant Jordi de ",
	"Sant Joan de ",
	"Sant Feliu de ",
	"Sant Quirze de ",
	"Sant Sadurní de ",
	"Santa Coloma de ",
	"Santa Margarida de ",
	"Santa Maria de ",
	"Sant Martí de ",
	"Sant Pere de ",
	"Sant Julià de ",
	"Sant Vicenç de ",

};

static const char *name_catalan_1m[] = {
	"Torrent",
	"Cami",
	"Mont",
	"Bell",
	"Puig",
	"Riu",
};

static const char *name_catalan_1f[] = {
	"Aigua",
	"Selva ",
	"Vall",
	"Serra",
	"Torre",
	"Riba",
	"Vall",
	"Terra",
};

static const char *name_catalan_2m[] = {
	"alt",
	"baix",
	"fosc",
	"pelat",
	"ventós",
	"negre",
	"roig",
	"gris",
};

static const char *name_catalan_2f[] = {
	"baixa",
	"alta",
	"fosca",
	"clara",
	"negra",
	"roja",
	"grisa",
	"freda",
};

static const char *name_catalan_3[] = {
	" despí",
	" desvern",
	" del camí",
	" de Mar",
	" de Dalt",
	" de Baix",
	" del Vallès",
	" de Berguedà",
	" de Conflent",
	" de la plana",
};

static const char *name_catalan_river1[] = {
	" d'Anoia",
	" de Ter",
	" de Llobregat",
	" d'Ebre",
	" de Segre",
	" de Francolí",
};
