/* $Id: resize_window_widgets.h 6569 2006-09-29 10:54:59Z bjarni $ */

/** @file resize_window_widgets.h */


#ifndef RESIZE_WINDOW_WIDGET_H
#define RESIZE_WINDOW_WIDGET_H
#include "stdafx.h"
#include "window.h"

enum {
	WIDGET_DEFINE_MOVE_NONE   = 0 << 0,
	WIDGET_DEFINE_MOVE_RIGHT  = 1 << 0,
	WIDGET_DEFINE_MOVE_LEFT   = 1 << 1,
	WIDGET_DEFINE_MOVE_TOP    = 1 << 2,
	WIDGET_DEFINE_MOVE_BOTTOM = 1 << 3,

	WIDGET_MOVE_NONE               = WIDGET_DEFINE_MOVE_NONE,
	WIDGET_STRETCH_RIGHT           = WIDGET_DEFINE_MOVE_RIGHT,
	WIDGET_MOVE_RIGHT              = WIDGET_DEFINE_MOVE_RIGHT | WIDGET_DEFINE_MOVE_LEFT,
	WIDGET_STRETCH_DOWN            = WIDGET_DEFINE_MOVE_BOTTOM,
	WIDGET_MOVE_DOWN               = WIDGET_DEFINE_MOVE_BOTTOM | WIDGET_DEFINE_MOVE_TOP,
	WIDGET_STRETCH_DOWN_RIGHT      = WIDGET_STRETCH_DOWN | WIDGET_STRETCH_RIGHT,
	WIDGET_MOVE_DOWN_RIGHT         = WIDGET_MOVE_RIGHT | WIDGET_MOVE_DOWN,
	WIDGET_MOVE_RIGHT_STRETCH_DOWN = WIDGET_MOVE_RIGHT | WIDGET_STRETCH_DOWN,
	WIDGET_MOVE_DOWN_STRETCH_RIGHT = WIDGET_MOVE_DOWN  | WIDGET_STRETCH_RIGHT,
};

void ResizeWindowWidgets(Window *w, const byte *resizearray, int16 length, byte horizontal, int16 vertical);

#endif
