/* $Id: station_land.h 3447 2006-01-26 19:06:16Z Darkvater $ */

#define TILE_SEQ_END()	{ 0x80, 0, 0, 0, 0, 0, 0 }

static const DrawTileSeqStruct _station_display_datas_0[] = {
	{  0,  0,  0, 16,  5,  2, SPR_RAIL_PLATFORM_X_REAR  | PALETTE_MODIFIER_COLOR },
	{  0, 11,  0, 16,  5,  2, SPR_RAIL_PLATFORM_X_FRONT | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_1[] = {
	{  0,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_Y_REAR  | PALETTE_MODIFIER_COLOR },
	{ 11,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_Y_FRONT | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_2[] = {
	{  0,  0,  0, 16,  5,  2, SPR_RAIL_PLATFORM_BUILDING_X | PALETTE_MODIFIER_COLOR },
	{  0, 11,  0, 16,  5,  2, SPR_RAIL_PLATFORM_X_FRONT    | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_3[] = {
	{  0,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_BUILDING_Y | PALETTE_MODIFIER_COLOR },
	{ 11,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_Y_FRONT    | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_4[] = {
	{  0,  0,  0, 16,  5,  7, SPR_RAIL_PLATFORM_PILLARS_X_REAR | PALETTE_MODIFIER_COLOR },
	{  0, 11,  0, 16,  5,  2, SPR_RAIL_PLATFORM_X_FRONT        | PALETTE_MODIFIER_COLOR },
	{  0,  0, 16, 16, 16, 10, SPR_RAIL_ROOF_STRUCTURE_X_TILE_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,0x80, 0,  0,  0, SPR_RAIL_ROOF_GLASS_X_TILE_A     | PALETTE_TO_TRANSPARENT },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_5[] = {
	{  0,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_PILLARS_Y_REAR | PALETTE_MODIFIER_COLOR },
	{ 11,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_Y_FRONT        | PALETTE_MODIFIER_COLOR },
	{  0,  0, 16, 16, 16, 10, SPR_RAIL_ROOF_STRUCTURE_Y_TILE_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,0x80, 0,  0,  0, SPR_RAIL_ROOF_GLASS_Y_TILE_A     | PALETTE_TO_TRANSPARENT },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_6[] = {
	{  0,  0,  0, 16,  5,  2, SPR_RAIL_PLATFORM_X_REAR          | PALETTE_MODIFIER_COLOR },
	{  0, 11,  0, 16,  5,  2, SPR_RAIL_PLATFORM_PILLARS_X_FRONT | PALETTE_MODIFIER_COLOR },
	{  0,  0, 16, 16, 16, 10, SPR_RAIL_ROOF_STRUCTURE_X_TILE_B  | PALETTE_MODIFIER_COLOR },
	{  0,  0,0x80, 0,  0,  0, SPR_RAIL_ROOF_GLASS_X_TILE_B      | PALETTE_TO_TRANSPARENT },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_7[] = {
	{  0,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_Y_REAR          | PALETTE_MODIFIER_COLOR },
	{ 11,  0,  0,  5, 16,  2, SPR_RAIL_PLATFORM_PILLARS_Y_FRONT | PALETTE_MODIFIER_COLOR },
	{  0,  0, 16, 16, 16, 10, SPR_RAIL_ROOF_STRUCTURE_Y_TILE_B  | PALETTE_MODIFIER_COLOR },
	{  0,  0,0x80, 0,  0,  0, SPR_RAIL_ROOF_GLASS_Y_TILE_B      | PALETTE_TO_TRANSPARENT },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_8[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_9[] = {
	{  0,  0,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_10[] = {
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_11[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_12[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_13[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_14[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_15[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_16[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_17[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_18[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_19[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_20[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_21[] = {
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_22[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_23[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_24[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_25[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_26[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_27[] = {
	{  2,  0,  0, 11, 16, 40, SPR_AIRPORT_TERMINAL_A | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_28[] = {
	{  3,  3,  0, 10, 10, 60, SPR_AIRPORT_TOWER | PALETTE_MODIFIER_COLOR },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_29[] = {
	{  0,  1,  0, 14, 14, 30, SPR_AIRPORT_CONCOURSE | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_30[] = {
	{  3,  3,  0, 10, 11, 35, SPR_AIRPORT_TERMINAL_B | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_31[] = {
	{  0,  3,  0, 16, 11, 40, SPR_AIRPORT_TERMINAL_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_32[] = {
	{ 14,  0,  0,  2, 16, 28, SPR_AIRPORT_HANGAR_FRONT | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0,  2, 16, 28, SPR_AIRPORT_HANGAR_REAR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_33[] = {
	{  7, 11,  0,  3,  3, 14, SPR_AIRPORT_JETWAY_1 },
	{  0,  0,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_34[] = {
	{  2,  7,  0,  3,  3, 14, SPR_AIRPORT_JETWAY_2 },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_35[] = {
	{  3,  2,  0,  3,  3, 14, SPR_AIRPORT_JETWAY_3 },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_36[] = {
	{  0,  8,  0, 14,  3, 14, SPR_AIRPORT_PASSENGER_TUNNEL },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_37[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_38[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_39[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_1 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_40[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_2 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_41[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_3 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_42[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_4 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_43[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_5 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_44[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_6 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_45[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_7 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_46[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_8 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_47[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_9 },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_48[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_A },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_49[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_B },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_50[] = {
	{  7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_C },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_51[] = {
	{  7,  7,  0,  2,  2, 70, SPR_UNMOVABLE_TRANSMITTER },
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_52[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_53[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_54[] = {
	{  0,  0,  0, 15, 15, 30, SPR_AIRFIELD_TERM_C_BUILD | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_55[] = {
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_56[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_57[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_58[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	{  4, 11,  0,  1,  1, 20, SPR_AIRFIELD_WIND_1 | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_59[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	{  4, 11,  0,  1,  1, 20, SPR_AIRFIELD_WIND_2 | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_60[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	{  4, 11,  0,  1,  1, 20, SPR_AIRFIELD_WIND_3 | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_61[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	{  4, 11,  0,  1,  1, 20, SPR_AIRFIELD_WIND_4 | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_62[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_63[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_64[] = {
	{  0, 15,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_65[] = {
	{ 14,  0,  0,  2, 16, 28, SPR_AIRFIELD_HANGAR_FRONT | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0,  2, 16, 28, SPR_AIRFIELD_HANGAR_REAR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_66[] = {
	{  0,  0,  0, 16, 16, 60, SPR_HELIPORT | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_67[] = {
	{  0, 15,  0, 13,  1, 10, SPR_TRUCK_STOP_NE_BUILD_A | PALETTE_MODIFIER_COLOR },
	{ 13,  0,  0,  3, 16, 10, SPR_TRUCK_STOP_NE_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  2,  0,  0, 11,  1, 10, SPR_TRUCK_STOP_NE_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_68[] = {
	{ 15,  3,  0,  1, 13, 10, SPR_TRUCK_STOP_SE_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0, 16,  3, 10, SPR_TRUCK_STOP_SE_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  0,  3,  0,  1, 11, 10, SPR_TRUCK_STOP_SE_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_69[] = {
	{  3,  0,  0, 13,  1, 10, SPR_TRUCK_STOP_SW_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0,  3, 16, 10, SPR_TRUCK_STOP_SW_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  3, 15,  0, 11,  1, 10, SPR_TRUCK_STOP_SW_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_70[] = {
	{  0,  0,  0,  1, 13, 10, SPR_TRUCK_STOP_NW_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0, 13,  0, 16,  3, 10, SPR_TRUCK_STOP_NW_BUILD_B | PALETTE_MODIFIER_COLOR },
	{ 15,  2,  0,  1, 11, 10, SPR_TRUCK_STOP_NW_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_71[] = {
	{  2,  0,  0, 11,  1, 10, SPR_BUS_STOP_NE_BUILD_A | PALETTE_MODIFIER_COLOR },
	{ 13,  0,  0,  3, 16, 10, SPR_BUS_STOP_NE_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  0, 13,  0, 13,  3, 10, SPR_BUS_STOP_NE_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_72[] = {
	{  0,  3,  0,  1, 11, 10, SPR_BUS_STOP_SE_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0, 16,  3, 10, SPR_BUS_STOP_SE_BUILD_B | PALETTE_MODIFIER_COLOR },
	{ 13,  3,  0,  3, 13, 10, SPR_BUS_STOP_SE_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_73[] = {
	{  3, 15,  0, 11,  1, 10, SPR_BUS_STOP_SW_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0,  3, 16, 10, SPR_BUS_STOP_SW_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  3,  0,  0, 13,  3, 10, SPR_BUS_STOP_SW_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_74[] = {
	{ 15,  2,  0,  1, 11, 10, SPR_BUS_STOP_NW_BUILD_A | PALETTE_MODIFIER_COLOR },
	{  0, 13,  0, 16,  3, 10, SPR_BUS_STOP_NW_BUILD_B | PALETTE_MODIFIER_COLOR },
	{  0,  0,  0,  3, 13, 10, SPR_BUS_STOP_NW_BUILD_C | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_75[] = {
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_76[] = {
	{  0,  4,  0, 16,  8,  8, SPR_DOCK_SLOPE_NE },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_77[] = {
	{  4,  0,  0,  8, 16,  8, SPR_DOCK_SLOPE_SE },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_78[] = {
	{  0,  4,  0, 16,  8,  8, SPR_DOCK_SLOPE_SW },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_79[] = {
	{  4,  0,  0,  8, 16,  8, SPR_DOCK_SLOPE_NW },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_80[] = {
	{  0,  4,  0, 16,  8,  8, SPR_DOCK_FLAT_X },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_81[] = {
	{  4,  0,  0,  8, 16,  8, SPR_DOCK_FLAT_Y },
	TILE_SEQ_END()
};

static const DrawTileSeqStruct _station_display_datas_82[] = {
	TILE_SEQ_END()
};

// end of runway
static const DrawTileSeqStruct _station_display_datas_083[] = {
	TILE_SEQ_END()
};

// runway tiles
static const DrawTileSeqStruct _station_display_datas_084[] = {
	TILE_SEQ_END()
};

// control tower with concrete underground and no fence
// concrete underground
static const DrawTileSeqStruct _station_display_datas_085[] = {
	{  3,  3,  0, 10, 10, 60, SPR_AIRPORT_TOWER | PALETTE_MODIFIER_COLOR },  // control tower
	TILE_SEQ_END()
};

// new airportdepot, facing west
// concrete underground
static const DrawTileSeqStruct _station_display_datas_086[] = {
	{ 14, 0,  0,  2, 16, 28, SPR_AIRFIELD_HANGAR_FRONT | PALETTE_MODIFIER_COLOR },
	{  0, 0,  0,  2, 16, 28, SPR_AIRFIELD_HANGAR_REAR },
	TILE_SEQ_END()
};

// asphalt tile with fences in north
// concrete underground
static const DrawTileSeqStruct _station_display_datas_087[] = {
	{  0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// end of runway
static const DrawTileSeqStruct _station_display_datas_088[] = {
	{  0,  0,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR }, // fences
	TILE_SEQ_END()
};

// runway tiles
static const DrawTileSeqStruct _station_display_datas_089[] = {
	{  0,  0,  0, 16,  1,  6, SPR_AIRPORT_FENCE_X | PALETTE_MODIFIER_COLOR }, // fences
	TILE_SEQ_END()
};

// turning radar with concrete underground fences on south -- needs 12 tiles
// concrete underground
//BEGIN
static const DrawTileSeqStruct _station_display_datas_090[] = {
	{  7, 7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_1 },   // turning radar
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },  //fences
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_091[] = {
	{  7, 7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_2 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_092[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_3 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_093[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_4 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_094[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_5 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_095[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_6 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_096[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_7 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_097[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_8 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_098[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_9 },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_099[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_A },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0100[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_B },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0101[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_C },
	{ 15, 0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};
//END

// turning radar with concrete underground fences on north -- needs 12 tiles
// concrete underground
//BEGIN
static const DrawTileSeqStruct _station_display_datas_0102[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_1 },   // turning radar
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0103[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_2 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0104[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_3 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0105[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_4 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0106[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_5 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0107[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_6 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0108[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_7 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0109[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_8 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0110[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_9 },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0111[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_A },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0112[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_B },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};

// concrete underground
static const DrawTileSeqStruct _station_display_datas_0113[] = {
	{ 7,  7,  0,  2,  2,  8, SPR_AIRPORT_RADAR_C },
	{ 0,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },
	TILE_SEQ_END()
};
//END

// helipad for international airport
// concrete underground
static const DrawTileSeqStruct _station_display_datas_0114[] = {
	{ 10,  6,  0,  0,  0,  0, SPR_AIRPORT_HELIPAD },
	{ 15,  0,  0,  1, 16,  6, SPR_AIRPORT_FENCE_Y | PALETTE_MODIFIER_COLOR },	// fences bottom
	TILE_SEQ_END()
};

static const DrawTileSprites _station_display_datas[] = {
	{ SPR_RAIL_TRACK_X,              _station_display_datas_0 },
	{ SPR_RAIL_TRACK_Y,              _station_display_datas_1 },
	{ SPR_RAIL_TRACK_X,              _station_display_datas_2 },
	{ SPR_RAIL_TRACK_Y,              _station_display_datas_3 },
	{ SPR_RAIL_TRACK_X,              _station_display_datas_4 },
	{ SPR_RAIL_TRACK_Y,              _station_display_datas_5 },
	{ SPR_RAIL_TRACK_X,              _station_display_datas_6 },
	{ SPR_RAIL_TRACK_Y,              _station_display_datas_7 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_8 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_9 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_10 },
	{ SPR_AIRPORT_AIRCRAFT_STAND,    _station_display_datas_11 },
	{ SPR_AIRPORT_TAXIWAY_NS_WEST,   _station_display_datas_12 },
	{ SPR_AIRPORT_TAXIWAY_EW_SOUTH,  _station_display_datas_13 },
	{ SPR_AIRPORT_TAXIWAY_XING_SOUTH,_station_display_datas_14 },
	{ SPR_AIRPORT_TAXIWAY_XING_WEST, _station_display_datas_15 },
	{ SPR_AIRPORT_TAXIWAY_NS_CTR,    _station_display_datas_16 },
	{ SPR_AIRPORT_TAXIWAY_XING_EAST, _station_display_datas_17 },
	{ SPR_AIRPORT_TAXIWAY_NS_EAST,   _station_display_datas_18 },
	{ SPR_AIRPORT_TAXIWAY_EW_NORTH,  _station_display_datas_19 },
	{ SPR_AIRPORT_TAXIWAY_EW_CTR,    _station_display_datas_20 },
	{ SPR_AIRPORT_TAXIWAY_EW_NORTH,  _station_display_datas_21 },
	{ SPR_AIRPORT_RUNWAY_EXIT_A,     _station_display_datas_22 },
	{ SPR_AIRPORT_RUNWAY_EXIT_B,     _station_display_datas_23 },
	{ SPR_AIRPORT_RUNWAY_EXIT_C,     _station_display_datas_24 },
	{ SPR_AIRPORT_RUNWAY_EXIT_D,     _station_display_datas_25 },
	{ SPR_AIRPORT_RUNWAY_END,        _station_display_datas_26 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_27 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_28 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_29 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_30 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_31 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_32 },
	{ SPR_AIRPORT_AIRCRAFT_STAND,    _station_display_datas_33 },
	{ SPR_AIRPORT_AIRCRAFT_STAND,    _station_display_datas_34 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_35 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_36 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_37 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_38 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_39 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_40 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_41 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_42 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_43 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_44 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_45 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_46 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_47 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_48 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_49 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_50 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_51 },
	{ SPR_AIRFIELD_TERM_A,           _station_display_datas_52 },
	{ SPR_AIRFIELD_TERM_B,           _station_display_datas_53 },
	{ SPR_AIRFIELD_TERM_C_GROUND | PALETTE_MODIFIER_COLOR, _station_display_datas_54 },
	{ SPR_AIRFIELD_APRON_A,          _station_display_datas_55 },
	{ SPR_AIRFIELD_APRON_B,          _station_display_datas_56 },
	{ SPR_AIRFIELD_APRON_C,          _station_display_datas_57 },
	{ SPR_AIRFIELD_APRON_D,          _station_display_datas_58 },
	{ SPR_AIRFIELD_APRON_D,          _station_display_datas_59 },
	{ SPR_AIRFIELD_APRON_D,          _station_display_datas_60 },
	{ SPR_AIRFIELD_APRON_D,          _station_display_datas_61 },
	{ SPR_AIRFIELD_RUNWAY_NEAR_END,  _station_display_datas_62 },
	{ SPR_AIRFIELD_RUNWAY_MIDDLE,    _station_display_datas_63 },
	{ SPR_AIRFIELD_RUNWAY_FAR_END,   _station_display_datas_64 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_65 },
	{ SPR_FLAT_GRASS_TILE,           _station_display_datas_66 },
	{ SPR_TRUCK_STOP_NE_GROUND | PALETTE_MODIFIER_COLOR, _station_display_datas_67 },
	{ SPR_TRUCK_STOP_SE_GROUND | PALETTE_MODIFIER_COLOR, _station_display_datas_68 },
	{ SPR_TRUCK_STOP_SW_GROUND | PALETTE_MODIFIER_COLOR, _station_display_datas_69 },
	{ SPR_TRUCK_STOP_NW_GROUND | PALETTE_MODIFIER_COLOR, _station_display_datas_70 },
	{ SPR_BUS_STOP_NE_GROUND   | PALETTE_MODIFIER_COLOR, _station_display_datas_71 },
	{ SPR_BUS_STOP_SE_GROUND   | PALETTE_MODIFIER_COLOR, _station_display_datas_72 },
	{ SPR_BUS_STOP_SW_GROUND   | PALETTE_MODIFIER_COLOR, _station_display_datas_73 },
	{ SPR_BUS_STOP_NW_GROUND   | PALETTE_MODIFIER_COLOR, _station_display_datas_74 },
	{ SPR_FLAT_WATER_TILE,           _station_display_datas_75 },
	{ SPR_SHORE_TILEH_3,             _station_display_datas_76 },
	{ SPR_SHORE_TILEH_9,             _station_display_datas_77 },
	{ SPR_SHORE_TILEH_12,            _station_display_datas_78 },
	{ SPR_SHORE_TILEH_6,             _station_display_datas_79 },
	{ SPR_FLAT_WATER_TILE,           _station_display_datas_80 },
	{ SPR_FLAT_WATER_TILE,           _station_display_datas_81 },
	{ SPR_BUOY,                      _station_display_datas_82 },
	{ SPR_AIRPORT_RUNWAY_END,        _station_display_datas_083 },
	{ SPR_AIRPORT_RUNWAY_EXIT_B,     _station_display_datas_084 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_085 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_086 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_087 },
	{ SPR_AIRPORT_RUNWAY_END,        _station_display_datas_088 },
	{ SPR_AIRPORT_RUNWAY_EXIT_B,     _station_display_datas_089 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_090 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_091 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_092 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_093 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_094 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_095 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_096 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_097 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_098 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_099 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0100 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0101 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0102 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0103 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0104 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0105 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0106 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0107 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0108 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0109 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0110 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0111 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0112 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0113 },
	{ SPR_AIRPORT_APRON,             _station_display_datas_0114 },
};
