/* $Id: industry_map.h 4087 2006-03-24 13:46:45Z tron $ */

#include "industry.h"
#include "macros.h"
#include "tile.h"


static inline uint GetIndustryIndex(TileIndex t)
{
	return _m[t].m2;
}

static inline Industry* GetIndustryByTile(TileIndex t)
{
	return GetIndustry(GetIndustryIndex(t));
}


static inline bool IsIndustryCompleted(TileIndex tile)
{
	return HASBIT(_m[tile].m1, 7);
}


static inline void MakeIndustry(TileIndex t, uint index, uint gfx)
{
	SetTileType(t, MP_INDUSTRY);
	_m[t].m1 = 0;
	_m[t].m2 = index;
	_m[t].m3 = 0;
	_m[t].m4 = 0;
	_m[t].m5 = gfx;
}
