/* $Id: bridge_land.h 3108 2005-10-31 10:23:58Z tron $ */

/** @file bridge_land.h This file contains all the sprites for bridges
  * It consists of a number of arrays.
  * <ul><li>_bridge_sprite_table_n_m. Defines all the sprites of a bridge besides the pylons.
  * n defines the number of the bridge type, m the number of the section. the highest m for
  * each bridge set defines the heads.<br>
  * Sprites for middle secionts are arranged in groups of four, the elements are:
  * <ol><li>Element containing the track. This element is logically behind the vehicle.</li>
  * <li>Element containing the structure that is logically between the vehicle and the camera</li>
  * <li>Element containing the pylons.</li></ol>
  * First group is for railway in X direction, second for railway in Y direction, two groups each follow for road, monorail and maglev<p>
  * <br>Elements for heads are arranged in groups of eight:
  * <ol><li>X direction, north end, flat</li>
  * <li>Y direction, north end, flat</li>
  * <li>X direction, south end, flat</li>
  * <li>Y direction, south end, flat</li>
  * <li>X direction, north end, sloped</li>
  * <li>Y direction, north end, sloped</li>
  * <li>X direction, south end, sloped</li>
  * <li>Y direction, south end, sloped</li></ol>
  * This is repeated 4 times, for rail, road, monorail, maglev</li>
  * <li>_bridge_sprite_table_n_poles. Defines all the sprites needed for the pylons. The first 6 elements are for each
  * bridge piece (max 5 currently) in X direction, the next 6 elements are for the bridge pieces in Y direction.
  * The last two elements are used for cantilever bridges</li>
  * </ul>
  */

static const SpriteID _bridge_land_below[] = {
	SPR_FLAT_GRASS_TILE, SPR_FLAT_WATER_TILE, SPR_FLAT_SNOWY_TILE, SPR_FLAT_WATER_TILE
};

static const PalSpriteID _bridge_sprite_table_2_0[] = {
	    0x9C3,     0x9C7,     0x9C9,       0x0,     0x9C4,     0x9C8,     0x9CA,       0x0,
	    0x9C5,     0x9C7,     0x9C9,       0x0,     0x9C6,     0x9C8,     0x9CA,       0x0,
	   0x10E4,     0x9C7,     0x9C9,       0x0,    0x10E5,     0x9C8,     0x9CA,       0x0,
	   0x110C,     0x9C7,     0x9C9,       0x0,    0x110D,     0x9C8,     0x9CA,       0x0,
};

static const PalSpriteID _bridge_sprite_table_2_1[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_31D, 0x990 | PALETTE_31D, 0x98D | PALETTE_31D, 0x98F | PALETTE_31D, 0x992 | PALETTE_31D, 0x994 | PALETTE_31D, 0x991 | PALETTE_31D, 0x993 | PALETTE_31D,
	0x10E7 | PALETTE_31D, 0x10E9 | PALETTE_31D, 0x10E6 | PALETTE_31D, 0x10E8 | PALETTE_31D, 0x10EB | PALETTE_31D, 0x10ED | PALETTE_31D, 0x10EA | PALETTE_31D, 0x10EC | PALETTE_31D,
	0x110F | PALETTE_31D, 0x1111 | PALETTE_31D, 0x110E | PALETTE_31D, 0x1110 | PALETTE_31D, 0x1113 | PALETTE_31D, 0x1115 | PALETTE_31D, 0x1112 | PALETTE_31D, 0x1114 | PALETTE_31D,
};

static const PalSpriteID _bridge_sprite_table_2_poles[] = {
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 5,
	0x0,

	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 2,
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_4_0[] = {
	    0x9A9,     0x99F,     0x9B1,       0x0,     0x9A5,     0x997,     0x9AD,       0x0,
	    0x99D,     0x99F,     0x9B1,       0x0,     0x995,     0x997,     0x9AD,       0x0,
	   0x10F2,     0x99F,     0x9B1,       0x0,    0x10EE,     0x997,     0x9AD,       0x0,
	   0x111A,     0x99F,     0x9B1,       0x0,    0x1116,     0x997,     0x9AD,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_1[] = {
	    0x9AA,     0x9A0,     0x9B2,       0x0,     0x9A6,     0x998,     0x9AE,       0x0,
	    0x99E,     0x9A0,     0x9B2,       0x0,     0x996,     0x998,     0x9AE,       0x0,
	   0x10F3,     0x9A0,     0x9B2,       0x0,    0x10EF,     0x998,     0x9AE,       0x0,
	   0x111B,     0x9A0,     0x9B2,       0x0,    0x1117,     0x998,     0x9AE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_2[] = {
	    0x9AC,     0x9A4,     0x9B4,       0x0,     0x9A8,     0x99C,     0x9B0,       0x0,
	    0x9A2,     0x9A4,     0x9B4,       0x0,     0x99A,     0x99C,     0x9B0,       0x0,
	   0x10F5,     0x9A4,     0x9B4,       0x0,    0x10F1,     0x99C,     0x9B0,       0x0,
	   0x111D,     0x9A4,     0x9B4,       0x0,    0x1119,     0x99C,     0x9B0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_3[] = {
	    0x9AB,     0x9A3,     0x9B3,       0x0,     0x9A7,     0x99B,     0x9AF,       0x0,
	    0x9A1,     0x9A3,     0x9B3,       0x0,     0x999,     0x99B,     0x9AF,       0x0,
	   0x10F4,     0x9A3,     0x9B3,       0x0,    0x10F0,     0x99B,     0x9AF,       0x0,
	   0x111C,     0x9A3,     0x9B3,       0x0,    0x1118,     0x99B,     0x9AF,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_4[] = {
	    0x9B6,     0x9BA,     0x9BC,       0x0,     0x9B5,     0x9B9,     0x9BB,       0x0,
	    0x9B8,     0x9BA,     0x9BC,       0x0,     0x9B7,     0x9B9,     0x9BB,       0x0,
	   0x10F7,     0x9BA,     0x9BC,       0x0,    0x10F6,     0x9B9,     0x9BB,       0x0,
	   0x111F,     0x9BA,     0x9BC,       0x0,    0x111E,     0x9B9,     0x9BB,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_5[] = {
	    0x9BD,     0x9C1,       0x0,       0x0,     0x9BE,     0x9C2,       0x0,       0x0,
	    0x9BF,     0x9C1,       0x0,       0x0,     0x9C0,     0x9C2,       0x0,       0x0,
	   0x10F8,     0x9C1,       0x0,       0x0,    0x10F9,     0x9C2,       0x0,       0x0,
	   0x1120,     0x9C1,       0x0,       0x0,    0x1121,     0x9C2,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_4_6[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	    0x98E,     0x990,     0x98D,     0x98F,     0x992,     0x994,     0x991,     0x993,
	   0x10E7,    0x10E9,    0x10E6,    0x10E8,    0x10EB,    0x10ED,    0x10EA,    0x10EC,
	   0x110F,    0x1111,    0x110E,    0x1110,    0x1113,    0x1115,    0x1112,    0x1114,
};

static const PalSpriteID _bridge_sprite_table_4_poles[] = {
	SPR_PILLARS_BASE + 6 * 0 + 3,
	SPR_PILLARS_BASE + 6 * 0 + 4,
	SPR_PILLARS_BASE + 6 * 0 + 4,
	SPR_PILLARS_BASE + 6 * 0 + 3,
	SPR_PILLARS_BASE + 6 * 0 + 5,
	0x0,

	SPR_PILLARS_BASE + 6 * 0 + 0,
	SPR_PILLARS_BASE + 6 * 0 + 1,
	SPR_PILLARS_BASE + 6 * 0 + 1,
	SPR_PILLARS_BASE + 6 * 0 + 0,
	SPR_PILLARS_BASE + 6 * 0 + 2,
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_5_0[] = {
	0x9A9 | PALETTE_TO_STRUCT_YELLOW, 0x99F | PALETTE_TO_STRUCT_YELLOW, 0x9B1 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9A5 | PALETTE_TO_STRUCT_YELLOW, 0x997 | PALETTE_TO_STRUCT_YELLOW, 0x9AD | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x99D | PALETTE_TO_STRUCT_YELLOW, 0x99F | PALETTE_TO_STRUCT_YELLOW, 0x9B1 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x995 | PALETTE_TO_STRUCT_YELLOW, 0x997 | PALETTE_TO_STRUCT_YELLOW, 0x9AD | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x10F2 | PALETTE_TO_STRUCT_YELLOW, 0x99F | PALETTE_TO_STRUCT_YELLOW, 0x9B1 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x10EE | PALETTE_TO_STRUCT_YELLOW, 0x997 | PALETTE_TO_STRUCT_YELLOW, 0x9AD | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x111A | PALETTE_TO_STRUCT_YELLOW, 0x99F | PALETTE_TO_STRUCT_YELLOW, 0x9B1 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x1116 | PALETTE_TO_STRUCT_YELLOW, 0x997 | PALETTE_TO_STRUCT_YELLOW, 0x9AD | PALETTE_TO_STRUCT_YELLOW,       0x0,
	SPR_PILLARS_BASE + 2
};

static const PalSpriteID _bridge_sprite_table_5_1[] = {
	0x9AA | PALETTE_TO_STRUCT_YELLOW, 0x9A0 | PALETTE_TO_STRUCT_YELLOW, 0x9B2 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9A6 | PALETTE_TO_STRUCT_YELLOW, 0x998 | PALETTE_TO_STRUCT_YELLOW, 0x9AE | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x99E | PALETTE_TO_STRUCT_YELLOW, 0x9A0 | PALETTE_TO_STRUCT_YELLOW, 0x9B2 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x996 | PALETTE_TO_STRUCT_YELLOW, 0x998 | PALETTE_TO_STRUCT_YELLOW, 0x9AE | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x10F3 | PALETTE_TO_STRUCT_YELLOW, 0x9A0 | PALETTE_TO_STRUCT_YELLOW, 0x9B2 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x10EF | PALETTE_TO_STRUCT_YELLOW, 0x998 | PALETTE_TO_STRUCT_YELLOW, 0x9AE | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x111B | PALETTE_TO_STRUCT_YELLOW, 0x9A0 | PALETTE_TO_STRUCT_YELLOW, 0x9B2 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x1117 | PALETTE_TO_STRUCT_YELLOW, 0x998 | PALETTE_TO_STRUCT_YELLOW, 0x9AE | PALETTE_TO_STRUCT_YELLOW,       0x0,
	SPR_PILLARS_BASE + 3
};

static const PalSpriteID _bridge_sprite_table_5_2[] = {
	0x9AC | PALETTE_TO_STRUCT_YELLOW, 0x9A4 | PALETTE_TO_STRUCT_YELLOW, 0x9B4 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9A8 | PALETTE_TO_STRUCT_YELLOW, 0x99C | PALETTE_TO_STRUCT_YELLOW, 0x9B0 | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x9A2 | PALETTE_TO_STRUCT_YELLOW, 0x9A4 | PALETTE_TO_STRUCT_YELLOW, 0x9B4 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x99A | PALETTE_TO_STRUCT_YELLOW, 0x99C | PALETTE_TO_STRUCT_YELLOW, 0x9B0 | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x10F5 | PALETTE_TO_STRUCT_YELLOW, 0x9A4 | PALETTE_TO_STRUCT_YELLOW, 0x9B4 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x10F1 | PALETTE_TO_STRUCT_YELLOW, 0x99C | PALETTE_TO_STRUCT_YELLOW, 0x9B0 | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x111D | PALETTE_TO_STRUCT_YELLOW, 0x9A4 | PALETTE_TO_STRUCT_YELLOW, 0x9B4 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x1119 | PALETTE_TO_STRUCT_YELLOW, 0x99C | PALETTE_TO_STRUCT_YELLOW, 0x9B0 | PALETTE_TO_STRUCT_YELLOW,       0x0,
	SPR_PILLARS_BASE + 3
};

static const PalSpriteID _bridge_sprite_table_5_3[] = {
	0x9AB | PALETTE_TO_STRUCT_YELLOW, 0x9A3 | PALETTE_TO_STRUCT_YELLOW, 0x9B3 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9A7 | PALETTE_TO_STRUCT_YELLOW, 0x99B | PALETTE_TO_STRUCT_YELLOW, 0x9AF | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x9A1 | PALETTE_TO_STRUCT_YELLOW, 0x9A3 | PALETTE_TO_STRUCT_YELLOW, 0x9B3 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x999 | PALETTE_TO_STRUCT_YELLOW, 0x99B | PALETTE_TO_STRUCT_YELLOW, 0x9AF | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x10F4 | PALETTE_TO_STRUCT_YELLOW, 0x9A3 | PALETTE_TO_STRUCT_YELLOW, 0x9B3 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x10F0 | PALETTE_TO_STRUCT_YELLOW, 0x99B | PALETTE_TO_STRUCT_YELLOW, 0x9AF | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x111C | PALETTE_TO_STRUCT_YELLOW, 0x9A3 | PALETTE_TO_STRUCT_YELLOW, 0x9B3 | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x1118 | PALETTE_TO_STRUCT_YELLOW, 0x99B | PALETTE_TO_STRUCT_YELLOW, 0x9AF | PALETTE_TO_STRUCT_YELLOW,       0x0,
	SPR_PILLARS_BASE + 2
};

static const PalSpriteID _bridge_sprite_table_5_4[] = {
	0x9B6 | PALETTE_TO_STRUCT_YELLOW, 0x9BA | PALETTE_TO_STRUCT_YELLOW, 0x9BC | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9B5 | PALETTE_TO_STRUCT_YELLOW, 0x9B9 | PALETTE_TO_STRUCT_YELLOW, 0x9BB | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x9B8 | PALETTE_TO_STRUCT_YELLOW, 0x9BA | PALETTE_TO_STRUCT_YELLOW, 0x9BC | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x9B7 | PALETTE_TO_STRUCT_YELLOW, 0x9B9 | PALETTE_TO_STRUCT_YELLOW, 0x9BB | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x10F7 | PALETTE_TO_STRUCT_YELLOW, 0x9BA | PALETTE_TO_STRUCT_YELLOW, 0x9BC | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x10F6 | PALETTE_TO_STRUCT_YELLOW, 0x9B9 | PALETTE_TO_STRUCT_YELLOW, 0x9BB | PALETTE_TO_STRUCT_YELLOW,       0x0,
	0x111F | PALETTE_TO_STRUCT_YELLOW, 0x9BA | PALETTE_TO_STRUCT_YELLOW, 0x9BC | PALETTE_TO_STRUCT_YELLOW,       0x0, 0x111E | PALETTE_TO_STRUCT_YELLOW, 0x9B9 | PALETTE_TO_STRUCT_YELLOW, 0x9BB | PALETTE_TO_STRUCT_YELLOW,       0x0,
	SPR_PILLARS_BASE + 5, 0x0, 0x0, 0x0, SPR_PILLARS_BASE + 4
};

static const PalSpriteID _bridge_sprite_table_5_5[] = {
	0x9BD | PALETTE_TO_STRUCT_YELLOW, 0x9C1 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0, 0x9BE | PALETTE_TO_STRUCT_YELLOW, 0x9C2 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
	0x9BF | PALETTE_TO_STRUCT_YELLOW, 0x9C1 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0, 0x9C0 | PALETTE_TO_STRUCT_YELLOW, 0x9C2 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
	0x10F8 | PALETTE_TO_STRUCT_YELLOW, 0x9C1 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0, 0x10F9 | PALETTE_TO_STRUCT_YELLOW, 0x9C2 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
	0x1120 | PALETTE_TO_STRUCT_YELLOW, 0x9C1 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0, 0x1121 | PALETTE_TO_STRUCT_YELLOW, 0x9C2 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
	0x0, SPR_PILLARS_BASE + 2
};

static const PalSpriteID _bridge_sprite_table_5_6[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_TO_STRUCT_YELLOW, 0x990 | PALETTE_TO_STRUCT_YELLOW, 0x98D | PALETTE_TO_STRUCT_YELLOW, 0x98F | PALETTE_TO_STRUCT_YELLOW, 0x992 | PALETTE_TO_STRUCT_YELLOW, 0x994 | PALETTE_TO_STRUCT_YELLOW, 0x991 | PALETTE_TO_STRUCT_YELLOW, 0x993 | PALETTE_TO_STRUCT_YELLOW,
	0x10E7 | PALETTE_TO_STRUCT_YELLOW, 0x10E9 | PALETTE_TO_STRUCT_YELLOW, 0x10E6 | PALETTE_TO_STRUCT_YELLOW, 0x10E8 | PALETTE_TO_STRUCT_YELLOW, 0x10EB | PALETTE_TO_STRUCT_YELLOW, 0x10ED | PALETTE_TO_STRUCT_YELLOW, 0x10EA | PALETTE_TO_STRUCT_YELLOW, 0x10EC | PALETTE_TO_STRUCT_YELLOW,
	0x110F | PALETTE_TO_STRUCT_YELLOW, 0x1111 | PALETTE_TO_STRUCT_YELLOW, 0x110E | PALETTE_TO_STRUCT_YELLOW, 0x1110 | PALETTE_TO_STRUCT_YELLOW, 0x1113 | PALETTE_TO_STRUCT_YELLOW, 0x1115 | PALETTE_TO_STRUCT_YELLOW, 0x1112 | PALETTE_TO_STRUCT_YELLOW, 0x1114 | PALETTE_TO_STRUCT_YELLOW,
	0x0, SPR_PILLARS_BASE + 2,
};

static const PalSpriteID _bridge_sprite_table_5_poles[] = {
	SPR_PILLARS_BASE + 6 * 0 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 4 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 4 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 5 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	0x0,

	SPR_PILLARS_BASE + 6 * 0 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 1 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 1 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 0 + 2 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_3_0[] = {
	0x9A9 | PALETTE_TO_STRUCT_CONCRETE, 0x99F | PALETTE_TO_STRUCT_CONCRETE, 0x9B1 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9A5 | PALETTE_TO_STRUCT_CONCRETE, 0x997 | PALETTE_TO_STRUCT_CONCRETE, 0x9AD | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x99D | PALETTE_TO_STRUCT_CONCRETE, 0x99F | PALETTE_TO_STRUCT_CONCRETE, 0x9B1 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x995 | PALETTE_TO_STRUCT_CONCRETE, 0x997 | PALETTE_TO_STRUCT_CONCRETE, 0x9AD | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x10F2 | PALETTE_TO_STRUCT_CONCRETE, 0x99F | PALETTE_TO_STRUCT_CONCRETE, 0x9B1 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x10EE | PALETTE_TO_STRUCT_CONCRETE, 0x997 | PALETTE_TO_STRUCT_CONCRETE, 0x9AD | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x111A | PALETTE_TO_STRUCT_CONCRETE, 0x99F | PALETTE_TO_STRUCT_CONCRETE, 0x9B1 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x1116 | PALETTE_TO_STRUCT_CONCRETE, 0x997 | PALETTE_TO_STRUCT_CONCRETE, 0x9AD | PALETTE_TO_STRUCT_CONCRETE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_1[] = {
	0x9AA | PALETTE_TO_STRUCT_CONCRETE, 0x9A0 | PALETTE_TO_STRUCT_CONCRETE, 0x9B2 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9A6 | PALETTE_TO_STRUCT_CONCRETE, 0x998 | PALETTE_TO_STRUCT_CONCRETE, 0x9AE | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x99E | PALETTE_TO_STRUCT_CONCRETE, 0x9A0 | PALETTE_TO_STRUCT_CONCRETE, 0x9B2 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x996 | PALETTE_TO_STRUCT_CONCRETE, 0x998 | PALETTE_TO_STRUCT_CONCRETE, 0x9AE | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x10F3 | PALETTE_TO_STRUCT_CONCRETE, 0x9A0 | PALETTE_TO_STRUCT_CONCRETE, 0x9B2 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x10EF | PALETTE_TO_STRUCT_CONCRETE, 0x998 | PALETTE_TO_STRUCT_CONCRETE, 0x9AE | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x111B | PALETTE_TO_STRUCT_CONCRETE, 0x9A0 | PALETTE_TO_STRUCT_CONCRETE, 0x9B2 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x1117 | PALETTE_TO_STRUCT_CONCRETE, 0x998 | PALETTE_TO_STRUCT_CONCRETE, 0x9AE | PALETTE_TO_STRUCT_CONCRETE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_2[] = {
	0x9AC | PALETTE_TO_STRUCT_CONCRETE, 0x9A4 | PALETTE_TO_STRUCT_CONCRETE, 0x9B4 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9A8 | PALETTE_TO_STRUCT_CONCRETE, 0x99C | PALETTE_TO_STRUCT_CONCRETE, 0x9B0 | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x9A2 | PALETTE_TO_STRUCT_CONCRETE, 0x9A4 | PALETTE_TO_STRUCT_CONCRETE, 0x9B4 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x99A | PALETTE_TO_STRUCT_CONCRETE, 0x99C | PALETTE_TO_STRUCT_CONCRETE, 0x9B0 | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x10F5 | PALETTE_TO_STRUCT_CONCRETE, 0x9A4 | PALETTE_TO_STRUCT_CONCRETE, 0x9B4 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x10F1 | PALETTE_TO_STRUCT_CONCRETE, 0x99C | PALETTE_TO_STRUCT_CONCRETE, 0x9B0 | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x111D | PALETTE_TO_STRUCT_CONCRETE, 0x9A4 | PALETTE_TO_STRUCT_CONCRETE, 0x9B4 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x1119 | PALETTE_TO_STRUCT_CONCRETE, 0x99C | PALETTE_TO_STRUCT_CONCRETE, 0x9B0 | PALETTE_TO_STRUCT_CONCRETE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_3[] = {
	0x9AB | PALETTE_TO_STRUCT_CONCRETE, 0x9A3 | PALETTE_TO_STRUCT_CONCRETE, 0x9B3 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9A7 | PALETTE_TO_STRUCT_CONCRETE, 0x99B | PALETTE_TO_STRUCT_CONCRETE, 0x9AF | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x9A1 | PALETTE_TO_STRUCT_CONCRETE, 0x9A3 | PALETTE_TO_STRUCT_CONCRETE, 0x9B3 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x999 | PALETTE_TO_STRUCT_CONCRETE, 0x99B | PALETTE_TO_STRUCT_CONCRETE, 0x9AF | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x10F4 | PALETTE_TO_STRUCT_CONCRETE, 0x9A3 | PALETTE_TO_STRUCT_CONCRETE, 0x9B3 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x10F0 | PALETTE_TO_STRUCT_CONCRETE, 0x99B | PALETTE_TO_STRUCT_CONCRETE, 0x9AF | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x111C | PALETTE_TO_STRUCT_CONCRETE, 0x9A3 | PALETTE_TO_STRUCT_CONCRETE, 0x9B3 | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x1118 | PALETTE_TO_STRUCT_CONCRETE, 0x99B | PALETTE_TO_STRUCT_CONCRETE, 0x9AF | PALETTE_TO_STRUCT_CONCRETE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_4[] = {
	0x9B6 | PALETTE_TO_STRUCT_CONCRETE, 0x9BA | PALETTE_TO_STRUCT_CONCRETE, 0x9BC | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9B5 | PALETTE_TO_STRUCT_CONCRETE, 0x9B9 | PALETTE_TO_STRUCT_CONCRETE, 0x9BB | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x9B8 | PALETTE_TO_STRUCT_CONCRETE, 0x9BA | PALETTE_TO_STRUCT_CONCRETE, 0x9BC | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x9B7 | PALETTE_TO_STRUCT_CONCRETE, 0x9B9 | PALETTE_TO_STRUCT_CONCRETE, 0x9BB | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x10F7 | PALETTE_TO_STRUCT_CONCRETE, 0x9BA | PALETTE_TO_STRUCT_CONCRETE, 0x9BC | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x10F6 | PALETTE_TO_STRUCT_CONCRETE, 0x9B9 | PALETTE_TO_STRUCT_CONCRETE, 0x9BB | PALETTE_TO_STRUCT_CONCRETE,       0x0,
	0x111F | PALETTE_TO_STRUCT_CONCRETE, 0x9BA | PALETTE_TO_STRUCT_CONCRETE, 0x9BC | PALETTE_TO_STRUCT_CONCRETE,       0x0, 0x111E | PALETTE_TO_STRUCT_CONCRETE, 0x9B9 | PALETTE_TO_STRUCT_CONCRETE, 0x9BB | PALETTE_TO_STRUCT_CONCRETE,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_5[] = {
	0x9BD | PALETTE_TO_STRUCT_CONCRETE, 0x9C1 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0, 0x9BE | PALETTE_TO_STRUCT_CONCRETE, 0x9C2 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0,
	0x9BF | PALETTE_TO_STRUCT_CONCRETE, 0x9C1 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0, 0x9C0 | PALETTE_TO_STRUCT_CONCRETE, 0x9C2 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0,
	0x10F8 | PALETTE_TO_STRUCT_CONCRETE, 0x9C1 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0, 0x10F9 | PALETTE_TO_STRUCT_CONCRETE, 0x9C2 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0,
	0x1120 | PALETTE_TO_STRUCT_CONCRETE, 0x9C1 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0, 0x1121 | PALETTE_TO_STRUCT_CONCRETE, 0x9C2 | PALETTE_TO_STRUCT_CONCRETE,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_3_6[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_TO_STRUCT_CONCRETE, 0x990 | PALETTE_TO_STRUCT_CONCRETE, 0x98D | PALETTE_TO_STRUCT_CONCRETE, 0x98F | PALETTE_TO_STRUCT_CONCRETE, 0x992 | PALETTE_TO_STRUCT_CONCRETE, 0x994 | PALETTE_TO_STRUCT_CONCRETE, 0x991 | PALETTE_TO_STRUCT_CONCRETE, 0x993 | PALETTE_TO_STRUCT_CONCRETE,
	0x10E7 | PALETTE_TO_STRUCT_CONCRETE, 0x10E9 | PALETTE_TO_STRUCT_CONCRETE, 0x10E6 | PALETTE_TO_STRUCT_CONCRETE, 0x10E8 | PALETTE_TO_STRUCT_CONCRETE, 0x10EB | PALETTE_TO_STRUCT_CONCRETE, 0x10ED | PALETTE_TO_STRUCT_CONCRETE, 0x10EA | PALETTE_TO_STRUCT_CONCRETE, 0x10EC | PALETTE_TO_STRUCT_CONCRETE,
	0x110F | PALETTE_TO_STRUCT_CONCRETE, 0x1111 | PALETTE_TO_STRUCT_CONCRETE, 0x110E | PALETTE_TO_STRUCT_CONCRETE, 0x1110 | PALETTE_TO_STRUCT_CONCRETE, 0x1113 | PALETTE_TO_STRUCT_CONCRETE, 0x1115 | PALETTE_TO_STRUCT_CONCRETE, 0x1112 | PALETTE_TO_STRUCT_CONCRETE, 0x1114 | PALETTE_TO_STRUCT_CONCRETE,
	0x0, SPR_PILLARS_BASE + 2,
};

static const PalSpriteID _bridge_sprite_table_3_poles[] = {
	SPR_PILLARS_BASE + 6 * 0 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 4 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 4 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 5 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	0x0,

	SPR_PILLARS_BASE + 6 * 0 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 1 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 1 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	SPR_PILLARS_BASE + 6 * 0 + 2 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_CONCRETE),
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_1_1[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_TO_STRUCT_RED, 0x990 | PALETTE_TO_STRUCT_RED, 0x98D | PALETTE_TO_STRUCT_RED, 0x98F | PALETTE_TO_STRUCT_RED, 0x992 | PALETTE_TO_STRUCT_RED, 0x994 | PALETTE_TO_STRUCT_RED, 0x991 | PALETTE_TO_STRUCT_RED, 0x993 | PALETTE_TO_STRUCT_RED,
	0x10E7 | PALETTE_TO_STRUCT_RED, 0x10E9 | PALETTE_TO_STRUCT_RED, 0x10E6 | PALETTE_TO_STRUCT_RED, 0x10E8 | PALETTE_TO_STRUCT_RED, 0x10EB | PALETTE_TO_STRUCT_RED, 0x10ED | PALETTE_TO_STRUCT_RED, 0x10EA | PALETTE_TO_STRUCT_RED, 0x10EC | PALETTE_TO_STRUCT_RED,
	0x110F | PALETTE_TO_STRUCT_RED, 0x1111 | PALETTE_TO_STRUCT_RED, 0x110E | PALETTE_TO_STRUCT_RED, 0x1110 | PALETTE_TO_STRUCT_RED, 0x1113 | PALETTE_TO_STRUCT_RED, 0x1115 | PALETTE_TO_STRUCT_RED, 0x1112 | PALETTE_TO_STRUCT_RED, 0x1114 | PALETTE_TO_STRUCT_RED,
};

static const PalSpriteID _bridge_sprite_table_1_poles[] = {
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 4,
	SPR_PILLARS_BASE + 6 * 3 + 4,
	SPR_PILLARS_BASE + 6 * 3 + 3,
	SPR_PILLARS_BASE + 6 * 3 + 5,
	0x0,

	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 1,
	SPR_PILLARS_BASE + 6 * 3 + 1,
	SPR_PILLARS_BASE + 6 * 3 + 0,
	SPR_PILLARS_BASE + 6 * 3 + 2,
	0x0,

	0x0,
	0x0,
};


static const PalSpriteID _bridge_sprite_table_6_0[] = {
	    0x9CD,     0x9D9,       0x0,       0x0,     0x9CE,     0x9DA,       0x0,       0x0,
	    0x9D3,     0x9D9,       0x0,       0x0,     0x9D4,     0x9DA,       0x0,       0x0,
	   0x10FC,     0x9D9,       0x0,       0x0,    0x10FD,     0x9DA,       0x0,       0x0,
	   0x1124,     0x9D9,       0x0,       0x0,    0x1125,     0x9DA,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_6_1[] = {
	    0x9CB,     0x9D7,     0x9DD,       0x0,     0x9D0,     0x9DC,     0x9E0,       0x0,
	    0x9D1,     0x9D7,     0x9DD,       0x0,     0x9D6,     0x9DC,     0x9E0,       0x0,
	   0x10FA,     0x9D7,     0x9DD,       0x0,    0x10FF,     0x9DC,     0x9E0,       0x0,
	   0x1122,     0x9D7,     0x9DD,       0x0,    0x1127,     0x9DC,     0x9E0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_6_2[] = {
	    0x9CC,     0x9D8,     0x9DE,       0x0,     0x9CF,     0x9DB,     0x9DF,       0x0,
	    0x9D2,     0x9D8,     0x9DE,       0x0,     0x9D5,     0x9DB,     0x9DF,       0x0,
	   0x10FB,     0x9D8,     0x9DE,       0x0,    0x10FE,     0x9DB,     0x9DF,       0x0,
	   0x1123,     0x9D8,     0x9DE,       0x0,    0x1126,     0x9DB,     0x9DF,       0x0,
};

static const PalSpriteID _bridge_sprite_table_6_3[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	    0x98E,     0x990,     0x98D,     0x98F,     0x992,     0x994,     0x991,     0x993,
	   0x10E7,    0x10E9,    0x10E6,    0x10E8,    0x10EB,    0x10ED,    0x10EA,    0x10EC,
	   0x110F,    0x1111,    0x110E,    0x1110,    0x1113,    0x1115,    0x1112,    0x1114,
};

static const PalSpriteID _bridge_sprite_table_6_poles[] = {
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	2526,
	2528,
};


static const PalSpriteID _bridge_sprite_table_7_0[] = {
	0x9CD | PALETTE_TO_STRUCT_BROWN, 0x9D9 | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0, 0x9CE | PALETTE_TO_STRUCT_BROWN, 0x9DA | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0,
	0x9D3 | PALETTE_TO_STRUCT_BROWN, 0x9D9 | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0, 0x9D4 | PALETTE_TO_STRUCT_BROWN, 0x9DA | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0,
	0x10FC | PALETTE_TO_STRUCT_BROWN, 0x9D9 | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0, 0x10FD | PALETTE_TO_STRUCT_BROWN, 0x9DA | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0,
	0x1124 | PALETTE_TO_STRUCT_BROWN, 0x9D9 | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0, 0x1125 | PALETTE_TO_STRUCT_BROWN, 0x9DA | PALETTE_TO_STRUCT_BROWN,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_7_1[] = {
	0x9CB | PALETTE_TO_STRUCT_BROWN, 0x9D7 | PALETTE_TO_STRUCT_BROWN, 0x9DD | PALETTE_TO_STRUCT_BROWN,       0x0, 0x9D0 | PALETTE_TO_STRUCT_BROWN, 0x9DC | PALETTE_TO_STRUCT_BROWN, 0x9E0 | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x9D1 | PALETTE_TO_STRUCT_BROWN, 0x9D7 | PALETTE_TO_STRUCT_BROWN, 0x9DD | PALETTE_TO_STRUCT_BROWN,       0x0, 0x9D6 | PALETTE_TO_STRUCT_BROWN, 0x9DC | PALETTE_TO_STRUCT_BROWN, 0x9E0 | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x10FA | PALETTE_TO_STRUCT_BROWN, 0x9D7 | PALETTE_TO_STRUCT_BROWN, 0x9DD | PALETTE_TO_STRUCT_BROWN,       0x0, 0x10FF | PALETTE_TO_STRUCT_BROWN, 0x9DC | PALETTE_TO_STRUCT_BROWN, 0x9E0 | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x1122 | PALETTE_TO_STRUCT_BROWN, 0x9D7 | PALETTE_TO_STRUCT_BROWN, 0x9DD | PALETTE_TO_STRUCT_BROWN,       0x0, 0x1127 | PALETTE_TO_STRUCT_BROWN, 0x9DC | PALETTE_TO_STRUCT_BROWN, 0x9E0 | PALETTE_TO_STRUCT_BROWN,       0x0,
};

static const PalSpriteID _bridge_sprite_table_7_2[] = {
	0x9CC | PALETTE_TO_STRUCT_BROWN, 0x9D8 | PALETTE_TO_STRUCT_BROWN, 0x9DE | PALETTE_TO_STRUCT_BROWN,       0x0, 0x9CF | PALETTE_TO_STRUCT_BROWN, 0x9DB | PALETTE_TO_STRUCT_BROWN, 0x9DF | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x9D2 | PALETTE_TO_STRUCT_BROWN, 0x9D8 | PALETTE_TO_STRUCT_BROWN, 0x9DE | PALETTE_TO_STRUCT_BROWN,       0x0, 0x9D5 | PALETTE_TO_STRUCT_BROWN, 0x9DB | PALETTE_TO_STRUCT_BROWN, 0x9DF | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x10FB | PALETTE_TO_STRUCT_BROWN, 0x9D8 | PALETTE_TO_STRUCT_BROWN, 0x9DE | PALETTE_TO_STRUCT_BROWN,       0x0, 0x10FE | PALETTE_TO_STRUCT_BROWN, 0x9DB | PALETTE_TO_STRUCT_BROWN, 0x9DF | PALETTE_TO_STRUCT_BROWN,       0x0,
	0x1123 | PALETTE_TO_STRUCT_BROWN, 0x9D8 | PALETTE_TO_STRUCT_BROWN, 0x9DE | PALETTE_TO_STRUCT_BROWN,       0x0, 0x1126 | PALETTE_TO_STRUCT_BROWN, 0x9DB | PALETTE_TO_STRUCT_BROWN, 0x9DF | PALETTE_TO_STRUCT_BROWN,       0x0,
};

static const PalSpriteID _bridge_sprite_table_7_3[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_TO_STRUCT_BROWN, 0x990 | PALETTE_TO_STRUCT_BROWN, 0x98D | PALETTE_TO_STRUCT_BROWN, 0x98F | PALETTE_TO_STRUCT_BROWN, 0x992 | PALETTE_TO_STRUCT_BROWN, 0x994 | PALETTE_TO_STRUCT_BROWN, 0x991 | PALETTE_TO_STRUCT_BROWN, 0x993 | PALETTE_TO_STRUCT_BROWN,
	0x10E7 | PALETTE_TO_STRUCT_BROWN, 0x10E9 | PALETTE_TO_STRUCT_BROWN, 0x10E6 | PALETTE_TO_STRUCT_BROWN, 0x10E8 | PALETTE_TO_STRUCT_BROWN, 0x10EB | PALETTE_TO_STRUCT_BROWN, 0x10ED | PALETTE_TO_STRUCT_BROWN, 0x10EA | PALETTE_TO_STRUCT_BROWN, 0x10EC | PALETTE_TO_STRUCT_BROWN,
	0x110F | PALETTE_TO_STRUCT_BROWN, 0x1111 | PALETTE_TO_STRUCT_BROWN, 0x110E | PALETTE_TO_STRUCT_BROWN, 0x1110 | PALETTE_TO_STRUCT_BROWN, 0x1113 | PALETTE_TO_STRUCT_BROWN, 0x1115 | PALETTE_TO_STRUCT_BROWN, 0x1112 | PALETTE_TO_STRUCT_BROWN, 0x1114 | PALETTE_TO_STRUCT_BROWN,
};

static const PalSpriteID _bridge_sprite_table_7_poles[] = {
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	2526,
	2528,
};

static const PalSpriteID _bridge_sprite_table_8_0[] = {
	0x9CD | PALETTE_TO_STRUCT_RED, 0x9D9 | PALETTE_TO_STRUCT_RED,       0x0,       0x0, 0x9CE | PALETTE_TO_STRUCT_RED, 0x9DA | PALETTE_TO_STRUCT_RED,       0x0,       0x0,
	0x9D3 | PALETTE_TO_STRUCT_RED, 0x9D9 | PALETTE_TO_STRUCT_RED,       0x0,       0x0, 0x9D4 | PALETTE_TO_STRUCT_RED, 0x9DA | PALETTE_TO_STRUCT_RED,       0x0,       0x0,
	0x10FC | PALETTE_TO_STRUCT_RED, 0x9D9 | PALETTE_TO_STRUCT_RED,       0x0,       0x0, 0x10FD | PALETTE_TO_STRUCT_RED, 0x9DA | PALETTE_TO_STRUCT_RED,       0x0,       0x0,
	0x1124 | PALETTE_TO_STRUCT_RED, 0x9D9 | PALETTE_TO_STRUCT_RED,       0x0,       0x0, 0x1125 | PALETTE_TO_STRUCT_RED, 0x9DA | PALETTE_TO_STRUCT_RED,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_8_1[] = {
	0x9CB | PALETTE_TO_STRUCT_RED, 0x9D7 | PALETTE_TO_STRUCT_RED, 0x9DD | PALETTE_TO_STRUCT_RED,       0x0, 0x9D0 | PALETTE_TO_STRUCT_RED, 0x9DC | PALETTE_TO_STRUCT_RED, 0x9E0 | PALETTE_TO_STRUCT_RED,       0x0,
	0x9D1 | PALETTE_TO_STRUCT_RED, 0x9D7 | PALETTE_TO_STRUCT_RED, 0x9DD | PALETTE_TO_STRUCT_RED,       0x0, 0x9D6 | PALETTE_TO_STRUCT_RED, 0x9DC | PALETTE_TO_STRUCT_RED, 0x9E0 | PALETTE_TO_STRUCT_RED,       0x0,
	0x10FA | PALETTE_TO_STRUCT_RED, 0x9D7 | PALETTE_TO_STRUCT_RED, 0x9DD | PALETTE_TO_STRUCT_RED,       0x0, 0x10FF | PALETTE_TO_STRUCT_RED, 0x9DC | PALETTE_TO_STRUCT_RED, 0x9E0 | PALETTE_TO_STRUCT_RED,       0x0,
	0x1122 | PALETTE_TO_STRUCT_RED, 0x9D7 | PALETTE_TO_STRUCT_RED, 0x9DD | PALETTE_TO_STRUCT_RED,       0x0, 0x1127 | PALETTE_TO_STRUCT_RED, 0x9DC | PALETTE_TO_STRUCT_RED, 0x9E0 | PALETTE_TO_STRUCT_RED,       0x0,
};

static const PalSpriteID _bridge_sprite_table_8_2[] = {
	0x9CC | PALETTE_TO_STRUCT_RED, 0x9D8 | PALETTE_TO_STRUCT_RED, 0x9DE | PALETTE_TO_STRUCT_RED,       0x0, 0x9CF | PALETTE_TO_STRUCT_RED, 0x9DB | PALETTE_TO_STRUCT_RED, 0x9DF | PALETTE_TO_STRUCT_RED,       0x0,
	0x9D2 | PALETTE_TO_STRUCT_RED, 0x9D8 | PALETTE_TO_STRUCT_RED, 0x9DE | PALETTE_TO_STRUCT_RED,       0x0, 0x9D5 | PALETTE_TO_STRUCT_RED, 0x9DB | PALETTE_TO_STRUCT_RED, 0x9DF | PALETTE_TO_STRUCT_RED,       0x0,
	0x10FB | PALETTE_TO_STRUCT_RED, 0x9D8 | PALETTE_TO_STRUCT_RED, 0x9DE | PALETTE_TO_STRUCT_RED,       0x0, 0x10FE | PALETTE_TO_STRUCT_RED, 0x9DB | PALETTE_TO_STRUCT_RED, 0x9DF | PALETTE_TO_STRUCT_RED,       0x0,
	0x1123 | PALETTE_TO_STRUCT_RED, 0x9D8 | PALETTE_TO_STRUCT_RED, 0x9DE | PALETTE_TO_STRUCT_RED,       0x0, 0x1126 | PALETTE_TO_STRUCT_RED, 0x9DB | PALETTE_TO_STRUCT_RED, 0x9DF | PALETTE_TO_STRUCT_RED,       0x0,
};

static const PalSpriteID _bridge_sprite_table_8_3[] = {
	    0x986,     0x988,     0x985,     0x987,     0x98A,     0x98C,     0x989,     0x98B,
	0x98E | PALETTE_TO_STRUCT_RED, 0x990 | PALETTE_TO_STRUCT_RED, 0x98D | PALETTE_TO_STRUCT_RED, 0x98F | PALETTE_TO_STRUCT_RED, 0x992 | PALETTE_TO_STRUCT_RED, 0x994 | PALETTE_TO_STRUCT_RED, 0x991 | PALETTE_TO_STRUCT_RED, 0x993 | PALETTE_TO_STRUCT_RED,
	0x10E7 | PALETTE_TO_STRUCT_RED, 0x10E9 | PALETTE_TO_STRUCT_RED, 0x10E6 | PALETTE_TO_STRUCT_RED, 0x10E8 | PALETTE_TO_STRUCT_RED, 0x10EB | PALETTE_TO_STRUCT_RED, 0x10ED | PALETTE_TO_STRUCT_RED, 0x10EA | PALETTE_TO_STRUCT_RED, 0x10EC | PALETTE_TO_STRUCT_RED,
	0x110F | PALETTE_TO_STRUCT_RED, 0x1111 | PALETTE_TO_STRUCT_RED, 0x110E | PALETTE_TO_STRUCT_RED, 0x1110 | PALETTE_TO_STRUCT_RED, 0x1113 | PALETTE_TO_STRUCT_RED, 0x1115 | PALETTE_TO_STRUCT_RED, 0x1112 | PALETTE_TO_STRUCT_RED, 0x1114 | PALETTE_TO_STRUCT_RED,
};

static const PalSpriteID _bridge_sprite_table_8_poles[] = {
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	0x0,
	0x0,
	0x0,
	0x0,
	0x0,
	0x0,

	2526,
	2528,
};

static const PalSpriteID _bridge_sprite_table_0_0[] = {
	    0x9F2,     0x9F6,     0x9F8,       0x0,     0x9F1,     0x9F5,     0x9F7,       0x0,
	    0x9F4,     0x9F6,     0x9F8,       0x0,     0x9F3,     0x9F5,     0x9F7,       0x0,
	   0x1109,     0x9F6,     0x9F8,       0x0,    0x1108,     0x9F5,     0x9F7,       0x0,
	   0x1131,     0x9F6,     0x9F8,       0x0,    0x1130,     0x9F5,     0x9F7,       0x0,
};

static const PalSpriteID _bridge_sprite_table_0_1[] = {
	    0x9EE,     0x9ED,     0x9F0,     0x9EF,     0x9EA,     0x9E9,     0x9EB,     0x9EC,
	    0x9E6,     0x9E5,     0x9E8,     0x9E7,     0x9E2,     0x9E1,     0x9E3,     0x9E4,
	   0x1105,    0x1104,    0x1107,    0x1106,    0x1101,    0x1100,    0x1102,    0x1103,
	   0x112D,    0x112C,    0x112F,    0x112E,    0x1129,    0x1128,    0x112A,    0x112B,
};

static const PalSpriteID _bridge_sprite_table_0_poles[] = {
	SPR_PILLARS_BASE + 6 * 1 + 3,
	SPR_PILLARS_BASE + 6 * 1 + 3,
	SPR_PILLARS_BASE + 6 * 1 + 3,
	SPR_PILLARS_BASE + 6 * 1 + 3,
	SPR_PILLARS_BASE + 6 * 1 + 5,
	0x0,

	SPR_PILLARS_BASE + 6 * 1 + 0,
	SPR_PILLARS_BASE + 6 * 1 + 0,
	SPR_PILLARS_BASE + 6 * 1 + 0,
	SPR_PILLARS_BASE + 6 * 1 + 0,
	SPR_PILLARS_BASE + 6 * 1 + 2,
	0x0,

	0x0,
	0x0,
};


static const PalSpriteID _bridge_sprite_table_1_0[] = {
	0x9BD | PALETTE_TO_STRUCT_RED, 0x9C1 | PALETTE_TO_STRUCT_RED,     0x9C9,       0x0, 0x9BE | PALETTE_TO_STRUCT_RED, 0x9C2 | PALETTE_TO_STRUCT_RED,     0x9CA,       0x0,
	0x9BF | PALETTE_TO_STRUCT_RED, 0x9C1 | PALETTE_TO_STRUCT_RED,     0x9C9,       0x0, 0x9C0 | PALETTE_TO_STRUCT_RED, 0x9C2 | PALETTE_TO_STRUCT_RED,     0x9CA,       0x0,
	0x10F8 | PALETTE_TO_STRUCT_RED, 0x9C1 | PALETTE_TO_STRUCT_RED,     0x9C9,       0x0, 0x10F9 | PALETTE_TO_STRUCT_RED, 0x9C2 | PALETTE_TO_STRUCT_RED,     0x9CA,       0x0,
	0x1120 | PALETTE_TO_STRUCT_RED, 0x9C1 | PALETTE_TO_STRUCT_RED,     0x9C9,       0x0, 0x1121 | PALETTE_TO_STRUCT_RED, 0x9C2 | PALETTE_TO_STRUCT_RED,     0x9CA,       0x0,
};

static const PalSpriteID _bridge_sprite_table_9_0[] = {
	    0x9F9,     0x9FD,     0x9C9,       0x0,     0x9FA,     0x9FE,     0x9CA,       0x0,
	    0x9FB,     0x9FD,     0x9C9,       0x0,     0x9FC,     0x9FE,     0x9CA,       0x0,
	   0x110A,     0x9FD,     0x9C9,       0x0,    0x110B,     0x9FE,     0x9CA,       0x0,
	   0x1132,     0x9FD,     0x9C9,       0x0,    0x1133,     0x9FE,     0x9CA,       0x0,
};

static const PalSpriteID _bridge_sprite_table_10_0[] = {
	    0xA0B,     0xA01,       0x0,       0x0,     0xA0C,     0xA02,       0x0,       0x0,
	    0xA11,     0xA01,       0x0,       0x0,     0xA12,     0xA02,       0x0,       0x0,
	    0xA17,     0xA01,       0x0,       0x0,     0xA18,     0xA02,       0x0,       0x0,
	    0xA1D,     0xA01,       0x0,       0x0,     0xA1E,     0xA02,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_10_1[] = {
	    0xA09,     0x9FF,     0xA05,       0x0,     0xA0E,     0xA04,     0xA08,       0x0,
	    0xA0F,     0x9FF,     0xA05,       0x0,     0xA14,     0xA04,     0xA08,       0x0,
	    0xA15,     0x9FF,     0xA05,       0x0,     0xA1A,     0xA04,     0xA08,       0x0,
	    0xA1B,     0x9FF,     0xA05,       0x0,     0xA20,     0xA04,     0xA08,       0x0,
};

static const PalSpriteID _bridge_sprite_table_10_2[] = {
	    0xA0A,     0xA00,     0xA06,       0x0,     0xA0D,     0xA03,     0xA07,       0x0,
	    0xA10,     0xA00,     0xA06,       0x0,     0xA13,     0xA03,     0xA07,       0x0,
	    0xA16,     0xA00,     0xA06,       0x0,     0xA19,     0xA03,     0xA07,       0x0,
	    0xA1C,     0xA00,     0xA06,       0x0,     0xA1F,     0xA03,     0xA07,       0x0,
};

static const PalSpriteID _bridge_sprite_table_10_poles[] = {
	SPR_PILLARS_BASE + 6 * 2 + 3,
	SPR_PILLARS_BASE + 6 * 2 + 3,
	SPR_PILLARS_BASE + 6 * 2 + 3,
	SPR_PILLARS_BASE + 6 * 2 + 3,
	SPR_PILLARS_BASE + 6 * 2 + 5,
	0x0,

	SPR_PILLARS_BASE + 6 * 2 + 0,
	SPR_PILLARS_BASE + 6 * 2 + 0,
	SPR_PILLARS_BASE + 6 * 2 + 0,
	SPR_PILLARS_BASE + 6 * 2 + 0,
	SPR_PILLARS_BASE + 6 * 2 + 2,
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_11_0[] = {
    0xA0B | PALETTE_TO_STRUCT_YELLOW,     0xA01 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,     0xA0C | PALETTE_TO_STRUCT_YELLOW,     0xA02 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
    0xA11 | PALETTE_TO_STRUCT_YELLOW,     0xA01 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,     0xA12 | PALETTE_TO_STRUCT_YELLOW,     0xA02 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
    0xA17 | PALETTE_TO_STRUCT_YELLOW,     0xA01 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,     0xA18 | PALETTE_TO_STRUCT_YELLOW,     0xA02 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
    0xA1D | PALETTE_TO_STRUCT_YELLOW,     0xA01 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,     0xA1E | PALETTE_TO_STRUCT_YELLOW,     0xA02 | PALETTE_TO_STRUCT_YELLOW,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_11_1[] = {
    0xA09 | PALETTE_TO_STRUCT_YELLOW,     0x9FF | PALETTE_TO_STRUCT_YELLOW,     0xA05 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA0E | PALETTE_TO_STRUCT_YELLOW,     0xA04 | PALETTE_TO_STRUCT_YELLOW,     0xA08 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA0F | PALETTE_TO_STRUCT_YELLOW,     0x9FF | PALETTE_TO_STRUCT_YELLOW,     0xA05 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA14 | PALETTE_TO_STRUCT_YELLOW,     0xA04 | PALETTE_TO_STRUCT_YELLOW,     0xA08 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA15 | PALETTE_TO_STRUCT_YELLOW,     0x9FF | PALETTE_TO_STRUCT_YELLOW,     0xA05 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA1A | PALETTE_TO_STRUCT_YELLOW,     0xA04 | PALETTE_TO_STRUCT_YELLOW,     0xA08 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA1B | PALETTE_TO_STRUCT_YELLOW,     0x9FF | PALETTE_TO_STRUCT_YELLOW,     0xA05 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA20 | PALETTE_TO_STRUCT_YELLOW,     0xA04 | PALETTE_TO_STRUCT_YELLOW,     0xA08 | PALETTE_TO_STRUCT_YELLOW,       0x0,
};

static const PalSpriteID _bridge_sprite_table_11_2[] = {
    0xA0A | PALETTE_TO_STRUCT_YELLOW,     0xA00 | PALETTE_TO_STRUCT_YELLOW,     0xA06 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA0D | PALETTE_TO_STRUCT_YELLOW,     0xA03 | PALETTE_TO_STRUCT_YELLOW,     0xA07 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA10 | PALETTE_TO_STRUCT_YELLOW,     0xA00 | PALETTE_TO_STRUCT_YELLOW,     0xA06 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA13 | PALETTE_TO_STRUCT_YELLOW,     0xA03 | PALETTE_TO_STRUCT_YELLOW,     0xA07 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA16 | PALETTE_TO_STRUCT_YELLOW,     0xA00 | PALETTE_TO_STRUCT_YELLOW,     0xA06 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA19 | PALETTE_TO_STRUCT_YELLOW,     0xA03 | PALETTE_TO_STRUCT_YELLOW,     0xA07 | PALETTE_TO_STRUCT_YELLOW,       0x0,
    0xA1C | PALETTE_TO_STRUCT_YELLOW,     0xA00 | PALETTE_TO_STRUCT_YELLOW,     0xA06 | PALETTE_TO_STRUCT_YELLOW,       0x0,     0xA1F | PALETTE_TO_STRUCT_YELLOW,     0xA03 | PALETTE_TO_STRUCT_YELLOW,     0xA07 | PALETTE_TO_STRUCT_YELLOW,       0x0,
};

static const PalSpriteID _bridge_sprite_table_11_poles[] = {
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 5 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	0x0,

	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	SPR_PILLARS_BASE + 6 * 2 + 2 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_YELLOW),
	0x0,

	0x0,
	0x0,
};

static const PalSpriteID _bridge_sprite_table_12_0[] = {
    0xA0B | PALETTE_TO_STRUCT_GREY,     0xA01 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,     0xA0C | PALETTE_TO_STRUCT_GREY,     0xA02 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,
    0xA11 | PALETTE_TO_STRUCT_GREY,     0xA01 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,     0xA12 | PALETTE_TO_STRUCT_GREY,     0xA02 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,
    0xA17 | PALETTE_TO_STRUCT_GREY,     0xA01 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,     0xA18 | PALETTE_TO_STRUCT_GREY,     0xA02 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,
    0xA1D | PALETTE_TO_STRUCT_GREY,     0xA01 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,     0xA1E | PALETTE_TO_STRUCT_GREY,     0xA02 | PALETTE_TO_STRUCT_GREY,       0x0,       0x0,
};

static const PalSpriteID _bridge_sprite_table_12_1[] = {
    0xA09 | PALETTE_TO_STRUCT_GREY,     0x9FF | PALETTE_TO_STRUCT_GREY,     0xA05 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA0E | PALETTE_TO_STRUCT_GREY,     0xA04 | PALETTE_TO_STRUCT_GREY,     0xA08 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA0F | PALETTE_TO_STRUCT_GREY,     0x9FF | PALETTE_TO_STRUCT_GREY,     0xA05 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA14 | PALETTE_TO_STRUCT_GREY,     0xA04 | PALETTE_TO_STRUCT_GREY,     0xA08 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA15 | PALETTE_TO_STRUCT_GREY,     0x9FF | PALETTE_TO_STRUCT_GREY,     0xA05 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA1A | PALETTE_TO_STRUCT_GREY,     0xA04 | PALETTE_TO_STRUCT_GREY,     0xA08 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA1B | PALETTE_TO_STRUCT_GREY,     0x9FF | PALETTE_TO_STRUCT_GREY,     0xA05 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA20 | PALETTE_TO_STRUCT_GREY,     0xA04 | PALETTE_TO_STRUCT_GREY,     0xA08 | PALETTE_TO_STRUCT_GREY,       0x0,
};

static const PalSpriteID _bridge_sprite_table_12_2[] = {
    0xA0A | PALETTE_TO_STRUCT_GREY,     0xA00 | PALETTE_TO_STRUCT_GREY,     0xA06 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA0D | PALETTE_TO_STRUCT_GREY,     0xA03 | PALETTE_TO_STRUCT_GREY,     0xA07 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA10 | PALETTE_TO_STRUCT_GREY,     0xA00 | PALETTE_TO_STRUCT_GREY,     0xA06 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA13 | PALETTE_TO_STRUCT_GREY,     0xA03 | PALETTE_TO_STRUCT_GREY,     0xA07 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA16 | PALETTE_TO_STRUCT_GREY,     0xA00 | PALETTE_TO_STRUCT_GREY,     0xA06 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA19 | PALETTE_TO_STRUCT_GREY,     0xA03 | PALETTE_TO_STRUCT_GREY,     0xA07 | PALETTE_TO_STRUCT_GREY,       0x0,
    0xA1C | PALETTE_TO_STRUCT_GREY,     0xA00 | PALETTE_TO_STRUCT_GREY,     0xA06 | PALETTE_TO_STRUCT_GREY,       0x0,     0xA1F | PALETTE_TO_STRUCT_GREY,     0xA03 | PALETTE_TO_STRUCT_GREY,     0xA07 | PALETTE_TO_STRUCT_GREY,       0x0,
};

static const PalSpriteID _bridge_sprite_table_12_poles[] = {
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 3 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 5 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	0x0,

	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 0 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	SPR_PILLARS_BASE + 6 * 2 + 2 + (PALETTE_MODIFIER_COLOR | PALETTE_TO_STRUCT_GREY),
	0x0,

	0x0,
	0x0,
};

static const uint32 * const _bridge_sprite_table_2[] = {
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_1,
};

static const uint32 * const _bridge_sprite_table_4[] = {
	_bridge_sprite_table_4_0,
	_bridge_sprite_table_4_1,
	_bridge_sprite_table_4_2,
	_bridge_sprite_table_4_3,
	_bridge_sprite_table_4_4,
	_bridge_sprite_table_4_5,
	_bridge_sprite_table_4_6,
};

static const uint32 * const _bridge_sprite_table_5[] = {
	_bridge_sprite_table_5_0,
	_bridge_sprite_table_5_1,
	_bridge_sprite_table_5_2,
	_bridge_sprite_table_5_3,
	_bridge_sprite_table_5_4,
	_bridge_sprite_table_5_5,
	_bridge_sprite_table_5_6,
};

static const uint32 * const _bridge_sprite_table_3[] = {
	_bridge_sprite_table_3_0,
	_bridge_sprite_table_3_1,
	_bridge_sprite_table_3_2,
	_bridge_sprite_table_3_3,
	_bridge_sprite_table_3_4,
	_bridge_sprite_table_3_5,
	_bridge_sprite_table_3_6,
};

static const uint32 * const _bridge_sprite_table_6[] = {
	_bridge_sprite_table_6_0,
	_bridge_sprite_table_6_1,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_3,
};

static const uint32 * const _bridge_sprite_table_7[] = {
	_bridge_sprite_table_7_0,
	_bridge_sprite_table_7_1,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_3,
};

static const uint32 * const _bridge_sprite_table_8[] = {
	_bridge_sprite_table_8_0,
	_bridge_sprite_table_8_1,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_3,
};

static const uint32 * const _bridge_sprite_table_0[] = {
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_1,
};

static const uint32 * const _bridge_sprite_table_1[] = {
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_1,
};

static const uint32 * const _bridge_sprite_table_9[] = {
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_4_6,
};

static const uint32 * const _bridge_sprite_table_10[] = {
	_bridge_sprite_table_10_0,
	_bridge_sprite_table_10_1,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_4_6,
};

static const uint32 * const _bridge_sprite_table_11[] = {
	_bridge_sprite_table_11_0,
	_bridge_sprite_table_11_1,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_5_6,
};

static const uint32 * const _bridge_sprite_table_12[] = {
	_bridge_sprite_table_12_0,
	_bridge_sprite_table_12_1,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_3_6,
};

static const uint32 * const * const _bridge_sprite_table[MAX_BRIDGES] = {
	_bridge_sprite_table_0,
	_bridge_sprite_table_1,
	_bridge_sprite_table_2,
	_bridge_sprite_table_3,
	_bridge_sprite_table_4,
	_bridge_sprite_table_5,
	_bridge_sprite_table_6,
	_bridge_sprite_table_7,
	_bridge_sprite_table_8,
	_bridge_sprite_table_9,
	_bridge_sprite_table_10,
	_bridge_sprite_table_11,
	_bridge_sprite_table_12
};

static const uint32 * const _bridge_poles_table[] = {
	_bridge_sprite_table_0_poles,
	_bridge_sprite_table_1_poles,
	_bridge_sprite_table_2_poles,
	_bridge_sprite_table_3_poles,
	_bridge_sprite_table_4_poles,
	_bridge_sprite_table_5_poles,
	_bridge_sprite_table_6_poles,
	_bridge_sprite_table_7_poles,
	_bridge_sprite_table_8_poles,
	_bridge_sprite_table_2_poles,
	_bridge_sprite_table_10_poles,
	_bridge_sprite_table_11_poles,
	_bridge_sprite_table_12_poles
};
