#include "stdafx.h"
#include "ttd.h"
#include "string.h"
#include "table/strings.h"
#include "command.h"
#include "player.h"
#include "gfx.h"
#include "window.h"
#include "gui.h"
#include "saveload.h"
#include "economy.h"
#include "network.h"

/** Change the player's face.
 * @param x,y unused
 * @param p1 unused
 * @param p2 face bitmasked
 */
int32 CmdSetPlayerFace(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	if (flags & DC_EXEC) {
		GetPlayer(_current_player)->face = p2;
		MarkWholeScreenDirty();
	}
	return 0;
}

/** Change the player's company-colour
 * @param x,y unused
 * @param p1 unused
 * @param p2 new colour for vehicles, property, etc.
 */
int32 CmdSetPlayerColor(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Player *p, *pp;

	p = GetPlayer(_current_player);

	/* Ensure no two companies have the same colour */
	FOR_ALL_PLAYERS(pp) {
		if (pp->is_active && pp != p && pp->player_color == (byte)p2)
			return CMD_ERROR;
	}

	if (flags & DC_EXEC) {
		_player_colors[_current_player] = (byte)p2;
		p->player_color = (byte)p2;
		MarkWholeScreenDirty();
	}
	return 0;
}

/** Increase the loan of your company.
 * @param x,y unused
 * @param p1 unused
 * @param p2 when set, loans the maximum amount in one go (press CTRL)
 */
int32 CmdIncreaseLoan(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Player *p;

	p = GetPlayer(_current_player);

	if (p->current_loan >= _economy.max_loan) {
		SetDParam(0, _economy.max_loan);
		return_cmd_error(STR_702B_MAXIMUM_PERMITTED_LOAN);
	}

	if (flags & DC_EXEC) {
		/* Loan the maximum amount or not? */
		int32 loan = (p2) ? _economy.max_loan - p->current_loan : IS_HUMAN_PLAYER(_current_player) ? 10000 : 50000;

		p->money64 += loan;
		p->current_loan += loan;
		UpdatePlayerMoney32(p);
		InvalidatePlayerWindows(p);
	}

	return 0;
}

/** Decrease the loan of your company.
 * @param x,y unused
 * @param p1 unused
 * @param p2 when set, pays back the maximum loan permitting money (press CTRL)
 */
int32 CmdDecreaseLoan(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	Player *p;
	int32 loan;

	p = GetPlayer(_current_player);

	if (p->current_loan == 0) return_cmd_error(STR_702D_LOAN_ALREADY_REPAYED);

	loan = p->current_loan;

	/* p2 is true while CTRL is pressed (repay all possible loan, or max money you have)
	 * Repay any loan in chunks of 10.000 pounds */
	if (p2) {
		loan = min(loan, p->player_money);
		loan = max(loan, 10000);
		loan -= loan % 10000;
	} else {
		loan = (_patches.ainew_active) ? min(loan, 10000) : min(loan, IS_HUMAN_PLAYER(_current_player) ? 10000 : 50000);
	}

	if (p->player_money < loan) {
		SetDParam(0, loan);
		return_cmd_error(STR_702E_REQUIRED);
	}

	if (flags & DC_EXEC) {
		p->money64 -= loan;
		p->current_loan -= loan;
		UpdatePlayerMoney32(p);
		InvalidatePlayerWindows(p);
	}
	return 0;
}

/** Change the name of the company.
 * @param x,y unused
 * @param p1 unused
 * @param p2 unused
 */
int32 CmdChangeCompanyName(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	StringID str;
	Player *p;

	str = AllocateNameUnique((const char*)_decode_parameters, 4);
	if (str == 0) return CMD_ERROR;

	if (flags & DC_EXEC) {
		p = DEREF_PLAYER(_current_player);
		DeleteName(p->name_1);
		p->name_1 = str;
		MarkWholeScreenDirty();
	} else
		DeleteName(str);

	return 0;
}

/** Change the name of the president.
 * @param x,y unused
 * @param p1 unused
 * @param p2 unused
 */
int32 CmdChangePresidentName(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	StringID str;
	Player *p;

	str = AllocateNameUnique((const char*)_decode_parameters, 4);
	if (str == 0) return CMD_ERROR;

	if (flags & DC_EXEC) {
		p = DEREF_PLAYER(_current_player);
		DeleteName(p->president_name_1);
		p->president_name_1 = str;

		if (p->name_1 == STR_SV_UNNAMED) {
			ttd_strlcat((char*)_decode_parameters, " Transport", sizeof(_decode_parameters));
			DoCommandByTile(0, 0, 0, DC_EXEC, CMD_CHANGE_COMPANY_NAME);
		}
		MarkWholeScreenDirty();
	} else
		DeleteName(str);

	return 0;
}

// p1 = 0   decrease pause counter
// p1 = 1   increase pause counter
int32 CmdPause(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	if (flags & DC_EXEC) {
		_pause += (p1 == 1) ? 1 : -1;
		if (_pause == (byte)-1) _pause = 0;
		InvalidateWindow(WC_STATUS_BAR, 0);
		InvalidateWindow(WC_MAIN_TOOLBAR, 0);
	}
	return 0;
}


int32 CmdMoneyCheat(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	SET_EXPENSES_TYPE(EXPENSES_OTHER);
	return (int32)p1;
}

int32 CmdGiveMoney(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	SET_EXPENSES_TYPE(EXPENSES_OTHER);

	p1 = clamp(p1, 0, 0xFFFFFF); // Clamp between 16 million and 0

	if (p1 == 0)
		return CMD_ERROR;

	if (flags & DC_EXEC) {
		// Add money to player
		byte old_cp = _current_player;
		_current_player = p2;
		SubtractMoneyFromPlayer(-(int32)p1);
		_current_player = old_cp;
	}

	// Subtract money from local-player
	return (int32)p1;
}

int32 CmdChangeDifficultyLevel(int x, int y, uint32 flags, uint32 p1, uint32 p2)
{
	if (flags & DC_EXEC) {
		if (p1 != (uint32)-1L) {
			((int*)&_opt_ptr->diff)[p1] = p2;
			_opt_ptr->diff_level = 3;
		} else
			_opt_ptr->diff_level = p2;

		// If we are a network-client, update the difficult setting (if it is open)
		if (_networking && !_network_server && FindWindowById(WC_GAME_OPTIONS, 0) != NULL)
			ShowGameDifficulty();
	}
	return 0;
}
