/* $Id: station_gui.h 18277 2009-11-24 18:05:55Z rubidium $ */

/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file station_gui.h Contains enums and function declarations connected with stations GUI */

#ifndef STATION_GUI_H
#define STATION_GUI_H

#include "command_type.h"
#include "station_type.h"

/** Enum for StationView, referring to _station_view_widgets and _station_view_expanded_widgets */
enum StationViewWidgets {
	SVW_CAPTION    =  0, ///< Caption of the window
	SVW_WAITING    =  1, ///< List of waiting cargo
	SVW_SCROLLBAR  =  2, ///< Scrollbar
	SVW_ACCEPTLIST =  3, ///< List of accepted cargos
	SVW_RATINGLIST =  3, ///< Ratings of cargos
	SVW_LOCATION   =  4, ///< 'Location' button
	SVW_RATINGS    =  5, ///< 'Ratings' button
	SVW_ACCEPTS    =  5, ///< 'Accepts' button
	SVW_RENAME     =  6, ///< 'Rename' button
	SVW_TRAINS     =  7, ///< List of scheduled trains button
	SVW_ROADVEHS,        ///< List of scheduled road vehs button
	SVW_PLANES,          ///< List of scheduled planes button
	SVW_SHIPS,           ///< List of scheduled ships button
};

enum StationCoverageType {
	SCT_PASSENGERS_ONLY,
	SCT_NON_PASSENGERS_ONLY,
	SCT_ALL
};

int DrawStationCoverageAreaText(int left, int right, int top, StationCoverageType sct, int rad, bool supplies);
void CheckRedrawStationCoverage(const Window *w);

void ShowSelectStationIfNeeded(CommandContainer cmd, TileArea ta);
void ShowSelectWaypointIfNeeded(CommandContainer cmd, TileArea ta);

#endif /* STATION_GUI_H */
