/* $Id: sdl_s.cpp 17140 2009-08-09 23:04:08Z rubidium $ */

/** @file sdl_s.cpp Playing sound via SDL. */

#ifdef WITH_SDL

#include "../stdafx.h"

#include "../mixer.h"
#include "../sdl.h"
#include "sdl_s.h"
#include <SDL.h>

static FSoundDriver_SDL iFSoundDriver_SDL;

static void CDECL fill_sound_buffer(void *userdata, Uint8 *stream, int len)
{
	MxMixSamples(stream, len / 4);
}

const char *SoundDriver_SDL::Start(const char * const *parm)
{
	SDL_AudioSpec spec;

	const char *s = SdlOpen(SDL_INIT_AUDIO);
	if (s != NULL) return s;

	spec.freq = GetDriverParamInt(parm, "hz", 44100);
	spec.format = AUDIO_S16SYS;
	spec.channels = 2;
	spec.samples = 512;
	spec.callback = fill_sound_buffer;
	MxInitialize(spec.freq);
	SDL_CALL SDL_OpenAudio(&spec, &spec);
	SDL_CALL SDL_PauseAudio(0);
	return NULL;
}

void SoundDriver_SDL::Stop()
{
	SDL_CALL SDL_CloseAudio();
	SdlClose(SDL_INIT_AUDIO);
}

#endif /* WITH_SDL */
