/* $Id: vehicle_type.h 16428 2009-05-26 11:19:04Z rubidium $ */

/** @file vehicle_type.h Types related to vehicles. */

#ifndef VEHICLE_TYPE_H
#define VEHICLE_TYPE_H

#include "core/enum_type.hpp"

typedef uint16 VehicleID;

enum VehicleType {
	VEH_TRAIN,
	VEH_ROAD,
	VEH_SHIP,
	VEH_AIRCRAFT,
	VEH_EFFECT,
	VEH_DISASTER,
	VEH_END,
	VEH_INVALID = 0xFF,
};
DECLARE_POSTFIX_INCREMENT(VehicleType);
/** It needs to be 8bits, because we save and load it as such */
typedef SimpleTinyEnumT<VehicleType, byte> VehicleTypeByte;

struct Vehicle;
struct Train;
struct RoadVehicle;
struct Ship;
struct Aircraft;

struct BaseVehicle
{
	VehicleTypeByte type;    ///< Type of vehicle
};

static const VehicleID INVALID_VEHICLE = 0xFFFF;

/** Pathfinding option states */
enum {
	VPF_OPF  = 0, ///< The Original PathFinder
	VPF_NTP  = 0, ///< New Train Pathfinder, replacing OPF for trains
	VPF_NPF  = 1, ///< New PathFinder
	VPF_YAPF = 2, ///< Yet Another PathFinder
};

/* Flags to add to p2 for goto depot commands
 * Note: bits 8-10 are used for VLW flags */
enum DepotCommand {
	DEPOT_SERVICE       = (1 << 0), ///< The vehicle will leave the depot right after arrival (serivce only)
	DEPOT_MASS_SEND     = (1 << 1), ///< Tells that it's a mass send to depot command (type in VLW flag)
	DEPOT_DONT_CANCEL   = (1 << 2), ///< Don't cancel current goto depot command if any
	DEPOT_LOCATE_HANGAR = (1 << 3), ///< Find another airport if the target one lacks a hangar
	DEPOT_COMMAND_MASK  = 0xF,
};

enum {
	MAX_LENGTH_VEHICLE_NAME_BYTES  =  31, ///< The maximum length of a vehicle name in bytes including '\0'
	MAX_LENGTH_VEHICLE_NAME_PIXELS = 150, ///< The maximum length of a vehicle name in pixels
};

enum TrainAccelerationModel {
	TAM_ORIGINAL,
	TAM_REALISTIC,
};

#endif /* VEHICLE_TYPE_H */
