/* $Id: window_func.h 13028 2008-05-10 12:30:27Z rubidium $ */

/** @file window_func.h Window functions not directly related to making/drawing windows. */

#ifndef WINDOW_FUNC_H
#define WINDOW_FUNC_H

#include "window_type.h"
#include "player_type.h"

void SetWindowDirty(const Window *w);

Window *FindWindowById(WindowClass cls, WindowNumber number);
void ChangeWindowOwner(PlayerID old_player, PlayerID new_player);

void ResizeWindow(Window *w, int x, int y);
int PositionMainToolbar(Window *w);

void InitWindowSystem();
void UnInitWindowSystem();
void ResetWindowSystem();
void SetupColorsAndInitialWindow();
void InputLoop();

void InvalidateThisWindowData(Window *w, int data = 0);
void InvalidateWindowData(WindowClass cls, WindowNumber number, int data = 0);
void InvalidateWindowClassesData(WindowClass cls, int data = 0);

void DeleteNonVitalWindows();
void DeleteAllNonVitalWindows();
void HideVitalWindows();
void ShowVitalWindows();

void InvalidateWindowWidget(WindowClass cls, WindowNumber number, byte widget_index);
void InvalidateWindow(WindowClass cls, WindowNumber number);
void InvalidateWindowClasses(WindowClass cls);

void DeleteWindowById(WindowClass cls, WindowNumber number);
void DeleteWindowByClass(WindowClass cls);

#endif /* WINDOW_FUNC_H */
