#ifndef VEHICLE_GUI_H
#define VEHICLE_GUI_H

struct vehiclelist_d;

void DrawVehicleProfitButton(Vehicle *v, int x, int y);
void InitializeVehiclesGuiList();

/* sorter stuff */
void RebuildVehicleLists(void);
void ResortVehicleLists(void);

void BuildVehicleList(struct vehiclelist_d *vl, int type, int owner, int station);
void SortVehicleList(struct vehiclelist_d *vl);

typedef struct SortStruct { // store owner through sorting process
	uint32	index;
	byte		owner;
} SortStruct;

int CDECL GeneralOwnerSorter(const void *a, const void *b);
void VehicleSorter(SortStruct *firstelement, uint32 n, uint16 size);
VARDEF uint32	_internal_name_sorter_id;	// internal StringID for default vehicle-names
VARDEF uint32	_last_vehicle_idx;				// cached index to hopefully speed up name-sorting
VARDEF bool		_internal_sort_order;			// descending/ascending

#define PERIODIC_RESORT_DAYS 10
#define DEF_SORTER(yyyy) int CDECL yyyy(const void *a, const void *b)

DEF_SORTER(VehicleUnsortedSorter);
DEF_SORTER(VehicleNumberSorter);
DEF_SORTER(VehicleNameSorter);
DEF_SORTER(VehicleAgeSorter);
DEF_SORTER(VehicleProfitThisYearSorter);
DEF_SORTER(VehicleProfitLastYearSorter);
DEF_SORTER(VehicleCargoSorter);
DEF_SORTER(VehicleReliabilitySorter);
DEF_SORTER(VehicleMaxSpeedSorter);

typedef DEF_SORTER(VehicleSortListingTypeFunctions);

#define SORT_BY_UNSORTED 0
extern VehicleSortListingTypeFunctions * const _vehicle_sorter[];
extern const StringID _vehicle_sort_listing[];

enum VehicleSortTypes {
	VEHTRAIN		= 0,
	VEHROAD			= 1,
	VEHSHIP			= 2,
	VEHAIRCRAFT	= 3
};

enum {
  PLY_WND_PRC__OFFSET_TOP_WIDGET	= 26,
	PLY_WND_PRC__SIZE_OF_ROW_SMALL	= 26,
  PLY_WND_PRC__SIZE_OF_ROW_BIG		= 36,
};

#endif /* VEHICLE_GUI_H */
