/* $Id: bridge_land.h 12118 2008-02-12 03:05:27Z belugas $ */

/** @file bridge_land.h This file contains all the sprites for bridges
 * It consists of a number of arrays.
 * <ul><li>_bridge_sprite_table_n_m. Defines all the sprites of a bridge besides the pylons.
 * n defines the number of the bridge type, m the number of the section. the highest m for
 * each bridge set defines the heads.<br>
 * Sprites for middle secionts are arranged in groups of four, the elements are:
 * <ol><li>Element containing the track. This element is logically behind the vehicle.</li>
 * <li>Element containing the structure that is logically between the vehicle and the camera</li>
 * <li>Element containing the pylons.</li></ol>
 * First group is for railway in X direction, second for railway in Y direction, two groups each follow for road, monorail and maglev<p>
 * <br>Elements for heads are arranged in groups of eight:
 * <ol><li>X direction, north end, flat</li>
 * <li>Y direction, north end, flat</li>
 * <li>X direction, south end, flat</li>
 * <li>Y direction, south end, flat</li>
 * <li>X direction, north end, sloped</li>
 * <li>Y direction, north end, sloped</li>
 * <li>X direction, south end, sloped</li>
 * <li>Y direction, south end, sloped</li></ol>
 * This is repeated 4 times, for rail, road, monorail, maglev</li>
 * </ul>
 */

static const PalSpriteID _bridge_sprite_table_2_0[] = {
	{  0x9C3, PAL_NONE }, {  0x9C7, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9C4, PAL_NONE }, {  0x9C8, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9C5, PAL_NONE }, {  0x9C7, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9C6, PAL_NONE }, {  0x9C8, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10E4, PAL_NONE }, {  0x9C7, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10E5, PAL_NONE }, {  0x9C8, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x110C, PAL_NONE }, {  0x9C7, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x110D, PAL_NONE }, {  0x9C8, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_2_1[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_WHITE }, {  0x990, PALETTE_TO_STRUCT_WHITE }, {  0x98D, PALETTE_TO_STRUCT_WHITE }, {  0x98F, PALETTE_TO_STRUCT_WHITE },
	{  0x992, PALETTE_TO_STRUCT_WHITE }, {  0x994, PALETTE_TO_STRUCT_WHITE }, {  0x991, PALETTE_TO_STRUCT_WHITE }, {  0x993, PALETTE_TO_STRUCT_WHITE },
	{ 0x10E7, PALETTE_TO_STRUCT_WHITE }, { 0x10E9, PALETTE_TO_STRUCT_WHITE }, { 0x10E6, PALETTE_TO_STRUCT_WHITE }, { 0x10E8, PALETTE_TO_STRUCT_WHITE },
	{ 0x10EB, PALETTE_TO_STRUCT_WHITE }, { 0x10ED, PALETTE_TO_STRUCT_WHITE }, { 0x10EA, PALETTE_TO_STRUCT_WHITE }, { 0x10EC, PALETTE_TO_STRUCT_WHITE },
	{ 0x110F, PALETTE_TO_STRUCT_WHITE }, { 0x1111, PALETTE_TO_STRUCT_WHITE }, { 0x110E, PALETTE_TO_STRUCT_WHITE }, { 0x1110, PALETTE_TO_STRUCT_WHITE },
	{ 0x1113, PALETTE_TO_STRUCT_WHITE }, { 0x1115, PALETTE_TO_STRUCT_WHITE }, { 0x1112, PALETTE_TO_STRUCT_WHITE }, { 0x1114, PALETTE_TO_STRUCT_WHITE },
};

static const PalSpriteID _bridge_sprite_table_4_0[] = {
	{  0x9A9, PAL_NONE }, {  0x99F, PAL_NONE }, {  0x9B1, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A5, PAL_NONE }, {  0x997, PAL_NONE }, {  0x9AD, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x99D, PAL_NONE }, {  0x99F, PAL_NONE }, {  0x9B1, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x995, PAL_NONE }, {  0x997, PAL_NONE }, {  0x9AD, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F2, PAL_NONE }, {  0x99F, PAL_NONE }, {  0x9B1, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10EE, PAL_NONE }, {  0x997, PAL_NONE }, {  0x9AD, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111A, PAL_NONE }, {  0x99F, PAL_NONE }, {  0x9B1, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1116, PAL_NONE }, {  0x997, PAL_NONE }, {  0x9AD, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_1[] = {
	{  0x9AA, PAL_NONE }, {  0x9A0, PAL_NONE }, {  0x9B2, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A6, PAL_NONE }, {  0x998, PAL_NONE }, {  0x9AE, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x99E, PAL_NONE }, {  0x9A0, PAL_NONE }, {  0x9B2, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x996, PAL_NONE }, {  0x998, PAL_NONE }, {  0x9AE, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F3, PAL_NONE }, {  0x9A0, PAL_NONE }, {  0x9B2, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10EF, PAL_NONE }, {  0x998, PAL_NONE }, {  0x9AE, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111B, PAL_NONE }, {  0x9A0, PAL_NONE }, {  0x9B2, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1117, PAL_NONE }, {  0x998, PAL_NONE }, {  0x9AE, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_2[] = {
	{  0x9AC, PAL_NONE }, {  0x9A4, PAL_NONE }, {  0x9B4, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A8, PAL_NONE }, {  0x99C, PAL_NONE }, {  0x9B0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A2, PAL_NONE }, {  0x9A4, PAL_NONE }, {  0x9B4, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x99A, PAL_NONE }, {  0x99C, PAL_NONE }, {  0x9B0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F5, PAL_NONE }, {  0x9A4, PAL_NONE }, {  0x9B4, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F1, PAL_NONE }, {  0x99C, PAL_NONE }, {  0x9B0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111D, PAL_NONE }, {  0x9A4, PAL_NONE }, {  0x9B4, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1119, PAL_NONE }, {  0x99C, PAL_NONE }, {  0x9B0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_3[] = {
	{  0x9AB, PAL_NONE }, {  0x9A3, PAL_NONE }, {  0x9B3, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A7, PAL_NONE }, {  0x99B, PAL_NONE }, {  0x9AF, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9A1, PAL_NONE }, {  0x9A3, PAL_NONE }, {  0x9B3, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x999, PAL_NONE }, {  0x99B, PAL_NONE }, {  0x9AF, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F4, PAL_NONE }, {  0x9A3, PAL_NONE }, {  0x9B3, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F0, PAL_NONE }, {  0x99B, PAL_NONE }, {  0x9AF, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111C, PAL_NONE }, {  0x9A3, PAL_NONE }, {  0x9B3, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1118, PAL_NONE }, {  0x99B, PAL_NONE }, {  0x9AF, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_4[] = {
	{  0x9B6, PAL_NONE }, {  0x9BA, PAL_NONE }, {  0x9BC, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9B5, PAL_NONE }, {  0x9B9, PAL_NONE }, {  0x9BB, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9B8, PAL_NONE }, {  0x9BA, PAL_NONE }, {  0x9BC, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9B7, PAL_NONE }, {  0x9B9, PAL_NONE }, {  0x9BB, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F7, PAL_NONE }, {  0x9BA, PAL_NONE }, {  0x9BC, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F6, PAL_NONE }, {  0x9B9, PAL_NONE }, {  0x9BB, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111F, PAL_NONE }, {  0x9BA, PAL_NONE }, {  0x9BC, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x111E, PAL_NONE }, {  0x9B9, PAL_NONE }, {  0x9BB, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_5[] = {
	{  0x9BD, PAL_NONE }, {  0x9C1, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9BE, PAL_NONE }, {  0x9C2, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9BF, PAL_NONE }, {  0x9C1, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9C0, PAL_NONE }, {  0x9C2, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F8, PAL_NONE }, {  0x9C1, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F9, PAL_NONE }, {  0x9C2, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1120, PAL_NONE }, {  0x9C1, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1121, PAL_NONE }, {  0x9C2, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_4_6[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PAL_NONE }, {  0x990, PAL_NONE }, {  0x98D, PAL_NONE }, {  0x98F, PAL_NONE },
	{  0x992, PAL_NONE }, {  0x994, PAL_NONE }, {  0x991, PAL_NONE }, {  0x993, PAL_NONE },
	{ 0x10E7, PAL_NONE }, { 0x10E9, PAL_NONE }, { 0x10E6, PAL_NONE }, { 0x10E8, PAL_NONE },
	{ 0x10EB, PAL_NONE }, { 0x10ED, PAL_NONE }, { 0x10EA, PAL_NONE }, { 0x10EC, PAL_NONE },
	{ 0x110F, PAL_NONE }, { 0x1111, PAL_NONE }, { 0x110E, PAL_NONE }, { 0x1110, PAL_NONE },
	{ 0x1113, PAL_NONE }, { 0x1115, PAL_NONE }, { 0x1112, PAL_NONE }, { 0x1114, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_0[] = {
	{  0x9A9, PALETTE_TO_STRUCT_YELLOW }, { 0x99F, PALETTE_TO_STRUCT_YELLOW }, { 0x9B1, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{  0x9A5, PALETTE_TO_STRUCT_YELLOW }, { 0x997, PALETTE_TO_STRUCT_YELLOW }, { 0x9AD, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{  0x99D, PALETTE_TO_STRUCT_YELLOW }, { 0x99F, PALETTE_TO_STRUCT_YELLOW }, { 0x9B1, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{  0x995, PALETTE_TO_STRUCT_YELLOW }, { 0x997, PALETTE_TO_STRUCT_YELLOW }, { 0x9AD, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{ 0x10F2, PALETTE_TO_STRUCT_YELLOW }, { 0x99F, PALETTE_TO_STRUCT_YELLOW }, { 0x9B1, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{ 0x10EE, PALETTE_TO_STRUCT_YELLOW }, { 0x997, PALETTE_TO_STRUCT_YELLOW }, { 0x9AD, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{ 0x111A, PALETTE_TO_STRUCT_YELLOW }, { 0x99F, PALETTE_TO_STRUCT_YELLOW }, { 0x9B1, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
	{ 0x1116, PALETTE_TO_STRUCT_YELLOW }, { 0x997, PALETTE_TO_STRUCT_YELLOW }, { 0x9AD, PALETTE_TO_STRUCT_YELLOW }, {  0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_1[] = {
	{  0x9AA, PALETTE_TO_STRUCT_YELLOW }, { 0x9A0, PALETTE_TO_STRUCT_YELLOW }, { 0x9B2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9A6, PALETTE_TO_STRUCT_YELLOW }, { 0x998, PALETTE_TO_STRUCT_YELLOW }, { 0x9AE, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x99E, PALETTE_TO_STRUCT_YELLOW }, { 0x9A0, PALETTE_TO_STRUCT_YELLOW }, { 0x9B2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x996, PALETTE_TO_STRUCT_YELLOW }, { 0x998, PALETTE_TO_STRUCT_YELLOW }, { 0x9AE, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F3, PALETTE_TO_STRUCT_YELLOW }, { 0x9A0, PALETTE_TO_STRUCT_YELLOW }, { 0x9B2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10EF, PALETTE_TO_STRUCT_YELLOW }, { 0x998, PALETTE_TO_STRUCT_YELLOW }, { 0x9AE, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x111B, PALETTE_TO_STRUCT_YELLOW }, { 0x9A0, PALETTE_TO_STRUCT_YELLOW }, { 0x9B2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x1117, PALETTE_TO_STRUCT_YELLOW }, { 0x998, PALETTE_TO_STRUCT_YELLOW }, { 0x9AE, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_2[] = {
	{  0x9AC, PALETTE_TO_STRUCT_YELLOW }, { 0x9A4, PALETTE_TO_STRUCT_YELLOW }, { 0x9B4, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9A8, PALETTE_TO_STRUCT_YELLOW }, { 0x99C, PALETTE_TO_STRUCT_YELLOW }, { 0x9B0, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9A2, PALETTE_TO_STRUCT_YELLOW }, { 0x9A4, PALETTE_TO_STRUCT_YELLOW }, { 0x9B4, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x99A, PALETTE_TO_STRUCT_YELLOW }, { 0x99C, PALETTE_TO_STRUCT_YELLOW }, { 0x9B0, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F5, PALETTE_TO_STRUCT_YELLOW }, { 0x9A4, PALETTE_TO_STRUCT_YELLOW }, { 0x9B4, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F1, PALETTE_TO_STRUCT_YELLOW }, { 0x99C, PALETTE_TO_STRUCT_YELLOW }, { 0x9B0, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x111D, PALETTE_TO_STRUCT_YELLOW }, { 0x9A4, PALETTE_TO_STRUCT_YELLOW }, { 0x9B4, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x1119, PALETTE_TO_STRUCT_YELLOW }, { 0x99C, PALETTE_TO_STRUCT_YELLOW }, { 0x9B0, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_3[] = {
	{  0x9AB, PALETTE_TO_STRUCT_YELLOW }, { 0x9A3, PALETTE_TO_STRUCT_YELLOW }, { 0x9B3, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9A7, PALETTE_TO_STRUCT_YELLOW }, { 0x99B, PALETTE_TO_STRUCT_YELLOW }, { 0x9AF, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9A1, PALETTE_TO_STRUCT_YELLOW }, { 0x9A3, PALETTE_TO_STRUCT_YELLOW }, { 0x9B3, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x999, PALETTE_TO_STRUCT_YELLOW }, { 0x99B, PALETTE_TO_STRUCT_YELLOW }, { 0x9AF, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F4, PALETTE_TO_STRUCT_YELLOW }, { 0x9A3, PALETTE_TO_STRUCT_YELLOW }, { 0x9B3, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F0, PALETTE_TO_STRUCT_YELLOW }, { 0x99B, PALETTE_TO_STRUCT_YELLOW }, { 0x9AF, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x111C, PALETTE_TO_STRUCT_YELLOW }, { 0x9A3, PALETTE_TO_STRUCT_YELLOW }, { 0x9B3, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x1118, PALETTE_TO_STRUCT_YELLOW }, { 0x99B, PALETTE_TO_STRUCT_YELLOW }, { 0x9AF, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_4[] = {
	{  0x9B6, PALETTE_TO_STRUCT_YELLOW }, { 0x9BA, PALETTE_TO_STRUCT_YELLOW }, { 0x9BC, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9B5, PALETTE_TO_STRUCT_YELLOW }, { 0x9B9, PALETTE_TO_STRUCT_YELLOW }, { 0x9BB, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9B8, PALETTE_TO_STRUCT_YELLOW }, { 0x9BA, PALETTE_TO_STRUCT_YELLOW }, { 0x9BC, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{  0x9B7, PALETTE_TO_STRUCT_YELLOW }, { 0x9B9, PALETTE_TO_STRUCT_YELLOW }, { 0x9BB, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F7, PALETTE_TO_STRUCT_YELLOW }, { 0x9BA, PALETTE_TO_STRUCT_YELLOW }, { 0x9BC, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x10F6, PALETTE_TO_STRUCT_YELLOW }, { 0x9B9, PALETTE_TO_STRUCT_YELLOW }, { 0x9BB, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x111F, PALETTE_TO_STRUCT_YELLOW }, { 0x9BA, PALETTE_TO_STRUCT_YELLOW }, { 0x9BC, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
	{ 0x111E, PALETTE_TO_STRUCT_YELLOW }, { 0x9B9, PALETTE_TO_STRUCT_YELLOW }, { 0x9BB, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_5[] = {
	{  0x9BD, PALETTE_TO_STRUCT_YELLOW }, { 0x9C1, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{  0x9BE, PALETTE_TO_STRUCT_YELLOW }, { 0x9C2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{  0x9BF, PALETTE_TO_STRUCT_YELLOW }, { 0x9C1, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{  0x9C0, PALETTE_TO_STRUCT_YELLOW }, { 0x9C2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{ 0x10F8, PALETTE_TO_STRUCT_YELLOW }, { 0x9C1, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{ 0x10F9, PALETTE_TO_STRUCT_YELLOW }, { 0x9C2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{ 0x1120, PALETTE_TO_STRUCT_YELLOW }, { 0x9C1, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
	{ 0x1121, PALETTE_TO_STRUCT_YELLOW }, { 0x9C2, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_5_6[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_YELLOW }, {  0x990, PALETTE_TO_STRUCT_YELLOW }, {  0x98D, PALETTE_TO_STRUCT_YELLOW }, {  0x98F, PALETTE_TO_STRUCT_YELLOW },
	{  0x992, PALETTE_TO_STRUCT_YELLOW }, {  0x994, PALETTE_TO_STRUCT_YELLOW }, {  0x991, PALETTE_TO_STRUCT_YELLOW }, {  0x993, PALETTE_TO_STRUCT_YELLOW },
	{ 0x10E7, PALETTE_TO_STRUCT_YELLOW }, { 0x10E9, PALETTE_TO_STRUCT_YELLOW }, { 0x10E6, PALETTE_TO_STRUCT_YELLOW }, { 0x10E8, PALETTE_TO_STRUCT_YELLOW },
	{ 0x10EB, PALETTE_TO_STRUCT_YELLOW }, { 0x10ED, PALETTE_TO_STRUCT_YELLOW }, { 0x10EA, PALETTE_TO_STRUCT_YELLOW }, { 0x10EC, PALETTE_TO_STRUCT_YELLOW },
	{ 0x110F, PALETTE_TO_STRUCT_YELLOW }, { 0x1111, PALETTE_TO_STRUCT_YELLOW }, { 0x110E, PALETTE_TO_STRUCT_YELLOW }, { 0x1110, PALETTE_TO_STRUCT_YELLOW },
	{ 0x1113, PALETTE_TO_STRUCT_YELLOW }, { 0x1115, PALETTE_TO_STRUCT_YELLOW }, { 0x1112, PALETTE_TO_STRUCT_YELLOW }, { 0x1114, PALETTE_TO_STRUCT_YELLOW },
};

static const PalSpriteID _bridge_sprite_table_3_0[] = {
	{  0x9A9, PALETTE_TO_STRUCT_CONCRETE }, { 0x99F, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A5, PALETTE_TO_STRUCT_CONCRETE }, { 0x997, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AD, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x99D, PALETTE_TO_STRUCT_CONCRETE }, { 0x99F, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x995, PALETTE_TO_STRUCT_CONCRETE }, { 0x997, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AD, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F2, PALETTE_TO_STRUCT_CONCRETE }, { 0x99F, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10EE, PALETTE_TO_STRUCT_CONCRETE }, { 0x997, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AD, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111A, PALETTE_TO_STRUCT_CONCRETE }, { 0x99F, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x1116, PALETTE_TO_STRUCT_CONCRETE }, { 0x997, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AD, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_1[] = {
	{  0x9AA, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A0, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A6, PALETTE_TO_STRUCT_CONCRETE }, { 0x998, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AE, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x99E, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A0, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x996, PALETTE_TO_STRUCT_CONCRETE }, { 0x998, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AE, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F3, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A0, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10EF, PALETTE_TO_STRUCT_CONCRETE }, { 0x998, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AE, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111B, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A0, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x1117, PALETTE_TO_STRUCT_CONCRETE }, { 0x998, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AE, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_2[] = {
	{  0x9AC, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A4, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B4, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A8, PALETTE_TO_STRUCT_CONCRETE }, { 0x99C, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B0, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A2, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A4, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B4, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x99A, PALETTE_TO_STRUCT_CONCRETE }, { 0x99C, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B0, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F5, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A4, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B4, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F1, PALETTE_TO_STRUCT_CONCRETE }, { 0x99C, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B0, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111D, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A4, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B4, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x1119, PALETTE_TO_STRUCT_CONCRETE }, { 0x99C, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B0, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_3[] = {
	{  0x9AB, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A3, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B3, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A7, PALETTE_TO_STRUCT_CONCRETE }, { 0x99B, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AF, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9A1, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A3, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B3, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x999, PALETTE_TO_STRUCT_CONCRETE }, { 0x99B, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AF, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F4, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A3, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B3, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F0, PALETTE_TO_STRUCT_CONCRETE }, { 0x99B, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AF, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111C, PALETTE_TO_STRUCT_CONCRETE }, { 0x9A3, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B3, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x1118, PALETTE_TO_STRUCT_CONCRETE }, { 0x99B, PALETTE_TO_STRUCT_CONCRETE }, { 0x9AF, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_4[] = {
	{  0x9B6, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BA, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BC, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9B5, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B9, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BB, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9B8, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BA, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BC, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{  0x9B7, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B9, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BB, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F7, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BA, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BC, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x10F6, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B9, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BB, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111F, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BA, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BC, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
	{ 0x111E, PALETTE_TO_STRUCT_CONCRETE }, { 0x9B9, PALETTE_TO_STRUCT_CONCRETE }, { 0x9BB, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_5[] = {
	{  0x9BD, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9BE, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9BF, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9C0, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x10F8, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x10F9, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x1120, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C1, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x1121, PALETTE_TO_STRUCT_CONCRETE }, { 0x9C2, PALETTE_TO_STRUCT_CONCRETE }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_3_6[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_CONCRETE }, {  0x990, PALETTE_TO_STRUCT_CONCRETE }, {  0x98D, PALETTE_TO_STRUCT_CONCRETE }, {  0x98F, PALETTE_TO_STRUCT_CONCRETE },
	{  0x992, PALETTE_TO_STRUCT_CONCRETE }, {  0x994, PALETTE_TO_STRUCT_CONCRETE }, {  0x991, PALETTE_TO_STRUCT_CONCRETE }, {  0x993, PALETTE_TO_STRUCT_CONCRETE },
	{ 0x10E7, PALETTE_TO_STRUCT_CONCRETE }, { 0x10E9, PALETTE_TO_STRUCT_CONCRETE }, { 0x10E6, PALETTE_TO_STRUCT_CONCRETE }, { 0x10E8, PALETTE_TO_STRUCT_CONCRETE },
	{ 0x10EB, PALETTE_TO_STRUCT_CONCRETE }, { 0x10ED, PALETTE_TO_STRUCT_CONCRETE }, { 0x10EA, PALETTE_TO_STRUCT_CONCRETE }, { 0x10EC, PALETTE_TO_STRUCT_CONCRETE },
	{ 0x110F, PALETTE_TO_STRUCT_CONCRETE }, { 0x1111, PALETTE_TO_STRUCT_CONCRETE }, { 0x110E, PALETTE_TO_STRUCT_CONCRETE }, { 0x1110, PALETTE_TO_STRUCT_CONCRETE },
	{ 0x1113, PALETTE_TO_STRUCT_CONCRETE }, { 0x1115, PALETTE_TO_STRUCT_CONCRETE }, { 0x1112, PALETTE_TO_STRUCT_CONCRETE }, { 0x1114, PALETTE_TO_STRUCT_CONCRETE },
};

static const PalSpriteID _bridge_sprite_table_1_1[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_RED }, {  0x990, PALETTE_TO_STRUCT_RED }, {  0x98D, PALETTE_TO_STRUCT_RED }, {  0x98F, PALETTE_TO_STRUCT_RED },
	{  0x992, PALETTE_TO_STRUCT_RED }, {  0x994, PALETTE_TO_STRUCT_RED }, {  0x991, PALETTE_TO_STRUCT_RED }, {  0x993, PALETTE_TO_STRUCT_RED },
	{ 0x10E7, PALETTE_TO_STRUCT_RED }, { 0x10E9, PALETTE_TO_STRUCT_RED }, { 0x10E6, PALETTE_TO_STRUCT_RED }, { 0x10E8, PALETTE_TO_STRUCT_RED },
	{ 0x10EB, PALETTE_TO_STRUCT_RED }, { 0x10ED, PALETTE_TO_STRUCT_RED }, { 0x10EA, PALETTE_TO_STRUCT_RED }, { 0x10EC, PALETTE_TO_STRUCT_RED },
	{ 0x110F, PALETTE_TO_STRUCT_RED }, { 0x1111, PALETTE_TO_STRUCT_RED }, { 0x110E, PALETTE_TO_STRUCT_RED }, { 0x1110, PALETTE_TO_STRUCT_RED },
	{ 0x1113, PALETTE_TO_STRUCT_RED }, { 0x1115, PALETTE_TO_STRUCT_RED }, { 0x1112, PALETTE_TO_STRUCT_RED }, { 0x1114, PALETTE_TO_STRUCT_RED },
};

static const PalSpriteID _bridge_sprite_table_6_0[] = {
	{  0x9CD, PAL_NONE }, {  0x9D9, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9CE, PAL_NONE }, {  0x9DA, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D3, PAL_NONE }, {  0x9D9, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D4, PAL_NONE }, {  0x9DA, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FC, PAL_NONE }, {  0x9D9, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FD, PAL_NONE }, {  0x9DA, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1124, PAL_NONE }, {  0x9D9, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1125, PAL_NONE }, {  0x9DA, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_6_1[] = {
	{  0x9CB, PAL_NONE }, {  0x9D7, PAL_NONE }, {  0x9DD, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D0, PAL_NONE }, {  0x9DC, PAL_NONE }, {  0x9E0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D1, PAL_NONE }, {  0x9D7, PAL_NONE }, {  0x9DD, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D6, PAL_NONE }, {  0x9DC, PAL_NONE }, {  0x9E0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FA, PAL_NONE }, {  0x9D7, PAL_NONE }, {  0x9DD, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FF, PAL_NONE }, {  0x9DC, PAL_NONE }, {  0x9E0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1122, PAL_NONE }, {  0x9D7, PAL_NONE }, {  0x9DD, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1127, PAL_NONE }, {  0x9DC, PAL_NONE }, {  0x9E0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_6_2[] = {
	{  0x9CC, PAL_NONE }, {  0x9D8, PAL_NONE }, {  0x9DE, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9CF, PAL_NONE }, {  0x9DB, PAL_NONE }, {  0x9DF, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D2, PAL_NONE }, {  0x9D8, PAL_NONE }, {  0x9DE, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D5, PAL_NONE }, {  0x9DB, PAL_NONE }, {  0x9DF, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FB, PAL_NONE }, {  0x9D8, PAL_NONE }, {  0x9DE, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FE, PAL_NONE }, {  0x9DB, PAL_NONE }, {  0x9DF, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1123, PAL_NONE }, {  0x9D8, PAL_NONE }, {  0x9DE, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1126, PAL_NONE }, {  0x9DB, PAL_NONE }, {  0x9DF, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_6_3[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PAL_NONE }, {  0x990, PAL_NONE }, {  0x98D, PAL_NONE }, {  0x98F, PAL_NONE },
	{  0x992, PAL_NONE }, {  0x994, PAL_NONE }, {  0x991, PAL_NONE }, {  0x993, PAL_NONE },
	{ 0x10E7, PAL_NONE }, { 0x10E9, PAL_NONE }, { 0x10E6, PAL_NONE }, { 0x10E8, PAL_NONE },
	{ 0x10EB, PAL_NONE }, { 0x10ED, PAL_NONE }, { 0x10EA, PAL_NONE }, { 0x10EC, PAL_NONE },
	{ 0x110F, PAL_NONE }, { 0x1111, PAL_NONE }, { 0x110E, PAL_NONE }, { 0x1110, PAL_NONE },
	{ 0x1113, PAL_NONE }, { 0x1115, PAL_NONE }, { 0x1112, PAL_NONE }, { 0x1114, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_7_0[] = {
	{  0x9CD, PALETTE_TO_STRUCT_BROWN }, { 0x9D9, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9CE, PALETTE_TO_STRUCT_BROWN }, { 0x9DA, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D3, PALETTE_TO_STRUCT_BROWN }, { 0x9D9, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9D4, PALETTE_TO_STRUCT_BROWN }, { 0x9DA, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FC, PALETTE_TO_STRUCT_BROWN }, { 0x9D9, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10FD, PALETTE_TO_STRUCT_BROWN }, { 0x9DA, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1124, PALETTE_TO_STRUCT_BROWN }, { 0x9D9, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1125, PALETTE_TO_STRUCT_BROWN }, { 0x9DA, PALETTE_TO_STRUCT_BROWN }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_7_1[] = {
	{  0x9CB, PALETTE_TO_STRUCT_BROWN }, { 0x9D7, PALETTE_TO_STRUCT_BROWN }, { 0x9DD, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9D0, PALETTE_TO_STRUCT_BROWN }, { 0x9DC, PALETTE_TO_STRUCT_BROWN }, { 0x9E0, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9D1, PALETTE_TO_STRUCT_BROWN }, { 0x9D7, PALETTE_TO_STRUCT_BROWN }, { 0x9DD, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9D6, PALETTE_TO_STRUCT_BROWN }, { 0x9DC, PALETTE_TO_STRUCT_BROWN }, { 0x9E0, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x10FA, PALETTE_TO_STRUCT_BROWN }, { 0x9D7, PALETTE_TO_STRUCT_BROWN }, { 0x9DD, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x10FF, PALETTE_TO_STRUCT_BROWN }, { 0x9DC, PALETTE_TO_STRUCT_BROWN }, { 0x9E0, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x1122, PALETTE_TO_STRUCT_BROWN }, { 0x9D7, PALETTE_TO_STRUCT_BROWN }, { 0x9DD, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x1127, PALETTE_TO_STRUCT_BROWN }, { 0x9DC, PALETTE_TO_STRUCT_BROWN }, { 0x9E0, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_7_2[] = {
	{  0x9CC, PALETTE_TO_STRUCT_BROWN }, { 0x9D8, PALETTE_TO_STRUCT_BROWN }, { 0x9DE, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9CF, PALETTE_TO_STRUCT_BROWN }, { 0x9DB, PALETTE_TO_STRUCT_BROWN }, { 0x9DF, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9D2, PALETTE_TO_STRUCT_BROWN }, { 0x9D8, PALETTE_TO_STRUCT_BROWN }, { 0x9DE, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{  0x9D5, PALETTE_TO_STRUCT_BROWN }, { 0x9DB, PALETTE_TO_STRUCT_BROWN }, { 0x9DF, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x10FB, PALETTE_TO_STRUCT_BROWN }, { 0x9D8, PALETTE_TO_STRUCT_BROWN }, { 0x9DE, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x10FE, PALETTE_TO_STRUCT_BROWN }, { 0x9DB, PALETTE_TO_STRUCT_BROWN }, { 0x9DF, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x1123, PALETTE_TO_STRUCT_BROWN }, { 0x9D8, PALETTE_TO_STRUCT_BROWN }, { 0x9DE, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
	{ 0x1126, PALETTE_TO_STRUCT_BROWN }, { 0x9DB, PALETTE_TO_STRUCT_BROWN }, { 0x9DF, PALETTE_TO_STRUCT_BROWN }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_7_3[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_BROWN }, {  0x990, PALETTE_TO_STRUCT_BROWN }, {  0x98D, PALETTE_TO_STRUCT_BROWN }, {  0x98F, PALETTE_TO_STRUCT_BROWN },
	{  0x992, PALETTE_TO_STRUCT_BROWN }, {  0x994, PALETTE_TO_STRUCT_BROWN }, {  0x991, PALETTE_TO_STRUCT_BROWN }, {  0x993, PALETTE_TO_STRUCT_BROWN },
	{ 0x10E7, PALETTE_TO_STRUCT_BROWN }, { 0x10E9, PALETTE_TO_STRUCT_BROWN }, { 0x10E6, PALETTE_TO_STRUCT_BROWN }, { 0x10E8, PALETTE_TO_STRUCT_BROWN },
	{ 0x10EB, PALETTE_TO_STRUCT_BROWN }, { 0x10ED, PALETTE_TO_STRUCT_BROWN }, { 0x10EA, PALETTE_TO_STRUCT_BROWN }, { 0x10EC, PALETTE_TO_STRUCT_BROWN },
	{ 0x110F, PALETTE_TO_STRUCT_BROWN }, { 0x1111, PALETTE_TO_STRUCT_BROWN }, { 0x110E, PALETTE_TO_STRUCT_BROWN }, { 0x1110, PALETTE_TO_STRUCT_BROWN },
	{ 0x1113, PALETTE_TO_STRUCT_BROWN }, { 0x1115, PALETTE_TO_STRUCT_BROWN }, { 0x1112, PALETTE_TO_STRUCT_BROWN }, { 0x1114, PALETTE_TO_STRUCT_BROWN },
};

static const PalSpriteID _bridge_sprite_table_8_0[] = {
	{  0x9CD, PALETTE_TO_STRUCT_RED }, { 0x9D9, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9CE, PALETTE_TO_STRUCT_RED }, { 0x9DA, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9D3, PALETTE_TO_STRUCT_RED }, { 0x9D9, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{  0x9D4, PALETTE_TO_STRUCT_RED }, { 0x9DA, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x10FC, PALETTE_TO_STRUCT_RED }, { 0x9D9, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x10FD, PALETTE_TO_STRUCT_RED }, { 0x9DA, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x1124, PALETTE_TO_STRUCT_RED }, { 0x9D9, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
	{ 0x1125, PALETTE_TO_STRUCT_RED }, { 0x9DA, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE }, {      0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_8_1[] = {
	{  0x9CB, PALETTE_TO_STRUCT_RED }, { 0x9D7, PALETTE_TO_STRUCT_RED }, { 0x9DD, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9D0, PALETTE_TO_STRUCT_RED }, { 0x9DC, PALETTE_TO_STRUCT_RED }, { 0x9E0, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9D1, PALETTE_TO_STRUCT_RED }, { 0x9D7, PALETTE_TO_STRUCT_RED }, { 0x9DD, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9D6, PALETTE_TO_STRUCT_RED }, { 0x9DC, PALETTE_TO_STRUCT_RED }, { 0x9E0, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x10FA, PALETTE_TO_STRUCT_RED }, { 0x9D7, PALETTE_TO_STRUCT_RED }, { 0x9DD, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x10FF, PALETTE_TO_STRUCT_RED }, { 0x9DC, PALETTE_TO_STRUCT_RED }, { 0x9E0, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x1122, PALETTE_TO_STRUCT_RED }, { 0x9D7, PALETTE_TO_STRUCT_RED }, { 0x9DD, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x1127, PALETTE_TO_STRUCT_RED }, { 0x9DC, PALETTE_TO_STRUCT_RED }, { 0x9E0, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_8_2[] = {
	{  0x9CC, PALETTE_TO_STRUCT_RED }, { 0x9D8, PALETTE_TO_STRUCT_RED }, { 0x9DE, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9CF, PALETTE_TO_STRUCT_RED }, { 0x9DB, PALETTE_TO_STRUCT_RED }, { 0x9DF, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9D2, PALETTE_TO_STRUCT_RED }, { 0x9D8, PALETTE_TO_STRUCT_RED }, { 0x9DE, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{  0x9D5, PALETTE_TO_STRUCT_RED }, { 0x9DB, PALETTE_TO_STRUCT_RED }, { 0x9DF, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x10FB, PALETTE_TO_STRUCT_RED }, { 0x9D8, PALETTE_TO_STRUCT_RED }, { 0x9DE, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x10FE, PALETTE_TO_STRUCT_RED }, { 0x9DB, PALETTE_TO_STRUCT_RED }, { 0x9DF, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x1123, PALETTE_TO_STRUCT_RED }, { 0x9D8, PALETTE_TO_STRUCT_RED }, { 0x9DE, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
	{ 0x1126, PALETTE_TO_STRUCT_RED }, { 0x9DB, PALETTE_TO_STRUCT_RED }, { 0x9DF, PALETTE_TO_STRUCT_RED }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_8_3[] = {
	{  0x986, PAL_NONE }, {  0x988, PAL_NONE }, {  0x985, PAL_NONE }, {  0x987, PAL_NONE },
	{  0x98A, PAL_NONE }, {  0x98C, PAL_NONE }, {  0x989, PAL_NONE }, {  0x98B, PAL_NONE },
	{  0x98E, PALETTE_TO_STRUCT_RED }, {  0x990, PALETTE_TO_STRUCT_RED }, {  0x98D, PALETTE_TO_STRUCT_RED }, {  0x98F, PALETTE_TO_STRUCT_RED },
	{  0x992, PALETTE_TO_STRUCT_RED }, {  0x994, PALETTE_TO_STRUCT_RED }, {  0x991, PALETTE_TO_STRUCT_RED }, {  0x993, PALETTE_TO_STRUCT_RED },
	{ 0x10E7, PALETTE_TO_STRUCT_RED }, { 0x10E9, PALETTE_TO_STRUCT_RED }, { 0x10E6, PALETTE_TO_STRUCT_RED }, { 0x10E8, PALETTE_TO_STRUCT_RED },
	{ 0x10EB, PALETTE_TO_STRUCT_RED }, { 0x10ED, PALETTE_TO_STRUCT_RED }, { 0x10EA, PALETTE_TO_STRUCT_RED }, { 0x10EC, PALETTE_TO_STRUCT_RED },
	{ 0x110F, PALETTE_TO_STRUCT_RED }, { 0x1111, PALETTE_TO_STRUCT_RED }, { 0x110E, PALETTE_TO_STRUCT_RED }, { 0x1110, PALETTE_TO_STRUCT_RED },
	{ 0x1113, PALETTE_TO_STRUCT_RED }, { 0x1115, PALETTE_TO_STRUCT_RED }, { 0x1112, PALETTE_TO_STRUCT_RED }, { 0x1114, PALETTE_TO_STRUCT_RED },
};

static const PalSpriteID _bridge_sprite_table_0_0[] = {
	{  0x9F2, PAL_NONE }, {  0x9F6, PAL_NONE }, {  0x9F8, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9F1, PAL_NONE }, {  0x9F5, PAL_NONE }, {  0x9F7, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9F4, PAL_NONE }, {  0x9F6, PAL_NONE }, {  0x9F8, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9F3, PAL_NONE }, {  0x9F5, PAL_NONE }, {  0x9F7, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1109, PAL_NONE }, {  0x9F6, PAL_NONE }, {  0x9F8, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1108, PAL_NONE }, {  0x9F5, PAL_NONE }, {  0x9F7, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1131, PAL_NONE }, {  0x9F6, PAL_NONE }, {  0x9F8, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1130, PAL_NONE }, {  0x9F5, PAL_NONE }, {  0x9F7, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_0_1[] = {
	{  0x9EE, PAL_NONE }, {  0x9ED, PAL_NONE }, {  0x9F0, PAL_NONE }, {  0x9EF, PAL_NONE },
	{  0x9EA, PAL_NONE }, {  0x9E9, PAL_NONE }, {  0x9EB, PAL_NONE }, {  0x9EC, PAL_NONE },
	{  0x9E6, PAL_NONE }, {  0x9E5, PAL_NONE }, {  0x9E8, PAL_NONE }, {  0x9E7, PAL_NONE },
	{  0x9E2, PAL_NONE }, {  0x9E1, PAL_NONE }, {  0x9E3, PAL_NONE }, {  0x9E4, PAL_NONE },
	{ 0x1105, PAL_NONE }, { 0x1104, PAL_NONE }, { 0x1107, PAL_NONE }, { 0x1106, PAL_NONE },
	{ 0x1101, PAL_NONE }, { 0x1100, PAL_NONE }, { 0x1102, PAL_NONE }, { 0x1103, PAL_NONE },
	{ 0x112D, PAL_NONE }, { 0x112C, PAL_NONE }, { 0x112F, PAL_NONE }, { 0x112E, PAL_NONE },
	{ 0x1129, PAL_NONE }, { 0x1128, PAL_NONE }, { 0x112A, PAL_NONE }, { 0x112B, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_1_0[] = {
	{  0x9BD, PALETTE_TO_STRUCT_RED }, { 0x9C1, PALETTE_TO_STRUCT_RED }, {     0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9BE, PALETTE_TO_STRUCT_RED }, { 0x9C2, PALETTE_TO_STRUCT_RED }, {     0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9BF, PALETTE_TO_STRUCT_RED }, { 0x9C1, PALETTE_TO_STRUCT_RED }, {     0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9C0, PALETTE_TO_STRUCT_RED }, { 0x9C2, PALETTE_TO_STRUCT_RED }, {     0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F8, PALETTE_TO_STRUCT_RED }, { 0x9C1, PALETTE_TO_STRUCT_RED }, {     0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x10F9, PALETTE_TO_STRUCT_RED }, { 0x9C2, PALETTE_TO_STRUCT_RED }, {     0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1120, PALETTE_TO_STRUCT_RED }, { 0x9C1, PALETTE_TO_STRUCT_RED }, {     0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1121, PALETTE_TO_STRUCT_RED }, { 0x9C2, PALETTE_TO_STRUCT_RED }, {     0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_9_0[] = {
	{  0x9F9, PAL_NONE }, {  0x9FD, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9FA, PAL_NONE }, {  0x9FE, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9FB, PAL_NONE }, {  0x9FD, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{  0x9FC, PAL_NONE }, {  0x9FE, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x110A, PAL_NONE }, {  0x9FD, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x110B, PAL_NONE }, {  0x9FE, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1132, PAL_NONE }, {  0x9FD, PAL_NONE }, {  0x9C9, PAL_NONE }, {    0x0, PAL_NONE },
	{ 0x1133, PAL_NONE }, {  0x9FE, PAL_NONE }, {  0x9CA, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_10_0[] = {
	{  0xA0B, PAL_NONE }, {  0xA01, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA0C, PAL_NONE }, {  0xA02, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA11, PAL_NONE }, {  0xA01, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA12, PAL_NONE }, {  0xA02, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA17, PAL_NONE }, {  0xA01, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA18, PAL_NONE }, {  0xA02, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1D, PAL_NONE }, {  0xA01, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1E, PAL_NONE }, {  0xA02, PAL_NONE }, {    0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_10_1[] = {
	{  0xA09, PAL_NONE }, {  0x9FF, PAL_NONE }, {  0xA05, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA0E, PAL_NONE }, {  0xA04, PAL_NONE }, {  0xA08, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA0F, PAL_NONE }, {  0x9FF, PAL_NONE }, {  0xA05, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA14, PAL_NONE }, {  0xA04, PAL_NONE }, {  0xA08, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA15, PAL_NONE }, {  0x9FF, PAL_NONE }, {  0xA05, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1A, PAL_NONE }, {  0xA04, PAL_NONE }, {  0xA08, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1B, PAL_NONE }, {  0x9FF, PAL_NONE }, {  0xA05, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA20, PAL_NONE }, {  0xA04, PAL_NONE }, {  0xA08, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_10_2[] = {
	{  0xA0A, PAL_NONE }, {  0xA00, PAL_NONE }, {  0xA06, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA0D, PAL_NONE }, {  0xA03, PAL_NONE }, {  0xA07, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA10, PAL_NONE }, {  0xA00, PAL_NONE }, {  0xA06, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA13, PAL_NONE }, {  0xA03, PAL_NONE }, {  0xA07, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA16, PAL_NONE }, {  0xA00, PAL_NONE }, {  0xA06, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA19, PAL_NONE }, {  0xA03, PAL_NONE }, {  0xA07, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1C, PAL_NONE }, {  0xA00, PAL_NONE }, {  0xA06, PAL_NONE }, {    0x0, PAL_NONE },
	{  0xA1F, PAL_NONE }, {  0xA03, PAL_NONE }, {  0xA07, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_11_0[] = {
    {  0xA0B, PALETTE_TO_STRUCT_YELLOW }, {     0xA01, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA0C, PALETTE_TO_STRUCT_YELLOW }, {     0xA02, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA11, PALETTE_TO_STRUCT_YELLOW }, {     0xA01, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA12, PALETTE_TO_STRUCT_YELLOW }, {     0xA02, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA17, PALETTE_TO_STRUCT_YELLOW }, {     0xA01, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA18, PALETTE_TO_STRUCT_YELLOW }, {     0xA02, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA1D, PALETTE_TO_STRUCT_YELLOW }, {     0xA01, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA1E, PALETTE_TO_STRUCT_YELLOW }, {     0xA02, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_11_1[] = {
    {  0xA09, PALETTE_TO_STRUCT_YELLOW }, {     0x9FF, PALETTE_TO_STRUCT_YELLOW }, {     0xA05, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA0E, PALETTE_TO_STRUCT_YELLOW }, {     0xA04, PALETTE_TO_STRUCT_YELLOW }, {     0xA08, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA0F, PALETTE_TO_STRUCT_YELLOW }, {     0x9FF, PALETTE_TO_STRUCT_YELLOW }, {     0xA05, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA14, PALETTE_TO_STRUCT_YELLOW }, {     0xA04, PALETTE_TO_STRUCT_YELLOW }, {     0xA08, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA15, PALETTE_TO_STRUCT_YELLOW }, {     0x9FF, PALETTE_TO_STRUCT_YELLOW }, {     0xA05, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA1A, PALETTE_TO_STRUCT_YELLOW }, {     0xA04, PALETTE_TO_STRUCT_YELLOW }, {     0xA08, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA1B, PALETTE_TO_STRUCT_YELLOW }, {     0x9FF, PALETTE_TO_STRUCT_YELLOW }, {     0xA05, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA20, PALETTE_TO_STRUCT_YELLOW }, {     0xA04, PALETTE_TO_STRUCT_YELLOW }, {     0xA08, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_11_2[] = {
    {  0xA0A, PALETTE_TO_STRUCT_YELLOW }, {     0xA00, PALETTE_TO_STRUCT_YELLOW }, {     0xA06, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA0D, PALETTE_TO_STRUCT_YELLOW }, {     0xA03, PALETTE_TO_STRUCT_YELLOW }, {     0xA07, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA10, PALETTE_TO_STRUCT_YELLOW }, {     0xA00, PALETTE_TO_STRUCT_YELLOW }, {     0xA06, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA13, PALETTE_TO_STRUCT_YELLOW }, {     0xA03, PALETTE_TO_STRUCT_YELLOW }, {     0xA07, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA16, PALETTE_TO_STRUCT_YELLOW }, {     0xA00, PALETTE_TO_STRUCT_YELLOW }, {     0xA06, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA19, PALETTE_TO_STRUCT_YELLOW }, {     0xA03, PALETTE_TO_STRUCT_YELLOW }, {     0xA07, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA1C, PALETTE_TO_STRUCT_YELLOW }, {     0xA00, PALETTE_TO_STRUCT_YELLOW }, {     0xA06, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
    {  0xA1F, PALETTE_TO_STRUCT_YELLOW }, {     0xA03, PALETTE_TO_STRUCT_YELLOW }, {     0xA07, PALETTE_TO_STRUCT_YELLOW }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_12_0[] = {
    {  0xA0B, PALETTE_TO_STRUCT_GREY }, {     0xA01, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA0C, PALETTE_TO_STRUCT_GREY }, {     0xA02, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA11, PALETTE_TO_STRUCT_GREY }, {     0xA01, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA12, PALETTE_TO_STRUCT_GREY }, {     0xA02, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA17, PALETTE_TO_STRUCT_GREY }, {     0xA01, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA18, PALETTE_TO_STRUCT_GREY }, {     0xA02, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA1D, PALETTE_TO_STRUCT_GREY }, {     0xA01, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
    {  0xA1E, PALETTE_TO_STRUCT_GREY }, {     0xA02, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE }, {    0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_12_1[] = {
    {  0xA09, PALETTE_TO_STRUCT_GREY }, {     0x9FF, PALETTE_TO_STRUCT_GREY }, {     0xA05, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA0E, PALETTE_TO_STRUCT_GREY }, {     0xA04, PALETTE_TO_STRUCT_GREY }, {     0xA08, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA0F, PALETTE_TO_STRUCT_GREY }, {     0x9FF, PALETTE_TO_STRUCT_GREY }, {     0xA05, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA14, PALETTE_TO_STRUCT_GREY }, {     0xA04, PALETTE_TO_STRUCT_GREY }, {     0xA08, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA15, PALETTE_TO_STRUCT_GREY }, {     0x9FF, PALETTE_TO_STRUCT_GREY }, {     0xA05, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA1A, PALETTE_TO_STRUCT_GREY }, {     0xA04, PALETTE_TO_STRUCT_GREY }, {     0xA08, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA1B, PALETTE_TO_STRUCT_GREY }, {     0x9FF, PALETTE_TO_STRUCT_GREY }, {     0xA05, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA20, PALETTE_TO_STRUCT_GREY }, {     0xA04, PALETTE_TO_STRUCT_GREY }, {     0xA08, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
};

static const PalSpriteID _bridge_sprite_table_12_2[] = {
    {  0xA0A, PALETTE_TO_STRUCT_GREY }, {     0xA00, PALETTE_TO_STRUCT_GREY }, {     0xA06, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA0D, PALETTE_TO_STRUCT_GREY }, {     0xA03, PALETTE_TO_STRUCT_GREY }, {     0xA07, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA10, PALETTE_TO_STRUCT_GREY }, {     0xA00, PALETTE_TO_STRUCT_GREY }, {     0xA06, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA13, PALETTE_TO_STRUCT_GREY }, {     0xA03, PALETTE_TO_STRUCT_GREY }, {     0xA07, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA16, PALETTE_TO_STRUCT_GREY }, {     0xA00, PALETTE_TO_STRUCT_GREY }, {     0xA06, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA19, PALETTE_TO_STRUCT_GREY }, {     0xA03, PALETTE_TO_STRUCT_GREY }, {     0xA07, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA1C, PALETTE_TO_STRUCT_GREY }, {     0xA00, PALETTE_TO_STRUCT_GREY }, {     0xA06, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
    {  0xA1F, PALETTE_TO_STRUCT_GREY }, {     0xA03, PALETTE_TO_STRUCT_GREY }, {     0xA07, PALETTE_TO_STRUCT_GREY }, {       0x0, PAL_NONE },
};

static const PalSpriteID * const _bridge_sprite_table_2[] = {
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_0,
	_bridge_sprite_table_2_1,
};

static const PalSpriteID * const _bridge_sprite_table_4[] = {
	_bridge_sprite_table_4_0,
	_bridge_sprite_table_4_1,
	_bridge_sprite_table_4_2,
	_bridge_sprite_table_4_3,
	_bridge_sprite_table_4_4,
	_bridge_sprite_table_4_5,
	_bridge_sprite_table_4_6,
};

static const PalSpriteID * const _bridge_sprite_table_5[] = {
	_bridge_sprite_table_5_0,
	_bridge_sprite_table_5_1,
	_bridge_sprite_table_5_2,
	_bridge_sprite_table_5_3,
	_bridge_sprite_table_5_4,
	_bridge_sprite_table_5_5,
	_bridge_sprite_table_5_6,
};

static const PalSpriteID * const _bridge_sprite_table_3[] = {
	_bridge_sprite_table_3_0,
	_bridge_sprite_table_3_1,
	_bridge_sprite_table_3_2,
	_bridge_sprite_table_3_3,
	_bridge_sprite_table_3_4,
	_bridge_sprite_table_3_5,
	_bridge_sprite_table_3_6,
};

static const PalSpriteID * const _bridge_sprite_table_6[] = {
	_bridge_sprite_table_6_0,
	_bridge_sprite_table_6_1,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_2,
	_bridge_sprite_table_6_3,
};

static const PalSpriteID * const _bridge_sprite_table_7[] = {
	_bridge_sprite_table_7_0,
	_bridge_sprite_table_7_1,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_2,
	_bridge_sprite_table_7_3,
};

static const PalSpriteID * const _bridge_sprite_table_8[] = {
	_bridge_sprite_table_8_0,
	_bridge_sprite_table_8_1,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_2,
	_bridge_sprite_table_8_3,
};

static const PalSpriteID * const _bridge_sprite_table_0[] = {
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_0,
	_bridge_sprite_table_0_1,
};

static const PalSpriteID * const _bridge_sprite_table_1[] = {
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_0,
	_bridge_sprite_table_1_1,
};

static const PalSpriteID * const _bridge_sprite_table_9[] = {
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_9_0,
	_bridge_sprite_table_4_6,
};

static const PalSpriteID * const _bridge_sprite_table_10[] = {
	_bridge_sprite_table_10_0,
	_bridge_sprite_table_10_1,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_10_2,
	_bridge_sprite_table_4_6,
};

static const PalSpriteID * const _bridge_sprite_table_11[] = {
	_bridge_sprite_table_11_0,
	_bridge_sprite_table_11_1,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_11_2,
	_bridge_sprite_table_5_6,
};

static const PalSpriteID * const _bridge_sprite_table_12[] = {
	_bridge_sprite_table_12_0,
	_bridge_sprite_table_12_1,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_12_2,
	_bridge_sprite_table_3_6,
};

static const PalSpriteID * const * const _bridge_sprite_table[MAX_BRIDGES] = {
	_bridge_sprite_table_0,
	_bridge_sprite_table_1,
	_bridge_sprite_table_2,
	_bridge_sprite_table_3,
	_bridge_sprite_table_4,
	_bridge_sprite_table_5,
	_bridge_sprite_table_6,
	_bridge_sprite_table_7,
	_bridge_sprite_table_8,
	_bridge_sprite_table_9,
	_bridge_sprite_table_10,
	_bridge_sprite_table_11,
	_bridge_sprite_table_12
};

/** Describes the data that defines each bridge in the game
 * @param y   year of availablity
 * @param mnl minimum length
 * @param mxl maximum length
 * @param p   price
 * @param mxs maximum speed allowed
 * @param spr sprite to use in purchase GUI
 * @param plt palette for the sprite in purchase GUI
 * @param dsc description of the bridge in purchase GUI
 * @param nrl description of the rail bridge in query tool
 * @param nrd description of the road bridge in query tool
 */
#define MB(y, mnl, mxl, p, mxs, spr, plt, dsc, nrl, nrd) \
	{y, mnl, mxl, p, mxs, spr, plt, dsc, { nrl, nrd }, NULL, 0}

const BridgeSpec _orig_bridge[] = {
/*
	       year of availablity
	       |  minimum length
	       |  |   maximum length
	       |  |   |    price
	       |  |   |    |    maximum speed
	       |  |   |    |    |  sprite to use in GUI
	       |  |   |    |    |  |      palette in GUI
	   string with description        name on rail                             name on road
	   |                              |                                        | */
	MB(    0, 0, 16,  80,  32, 0xA24, PAL_NONE,
	   STR_5012_WOODEN,               STR_501F_WOODEN_RAIL_BRIDGE,             STR_5025_WOODEN_ROAD_BRIDGE),

	MB(    0, 0,  2, 112,  48, 0xA26, PALETTE_TO_STRUCT_RED,
	   STR_5013_CONCRETE,             STR_5020_CONCRETE_RAIL_BRIDGE,           STR_5026_CONCRETE_ROAD_BRIDGE),

	MB( 1930, 0,  5, 144,  64, 0xA25, PAL_NONE,
	   STR_500F_GIRDER_STEEL,         STR_501C_STEEL_GIRDER_RAIL_BRIDGE,       STR_5022_STEEL_GIRDER_ROAD_BRIDGE),

	MB(    0, 2, 10, 168,  80, 0xA22, PALETTE_TO_STRUCT_CONCRETE,
	   STR_5011_SUSPENSION_CONCRETE,  STR_501E_REINFORCED_CONCRETE_SUSPENSION, STR_5024_REINFORCED_CONCRETE_SUSPENSION),

	MB( 1930, 3, 16, 185,  96, 0xA22, PAL_NONE,
	   STR_500E_SUSPENSION_STEEL,     STR_501B_STEEL_SUSPENSION_RAIL_BRIDGE,   STR_5021_STEEL_SUSPENSION_ROAD_BRIDGE),

	MB( 1930, 3, 16, 192, 112, 0xA22, PALETTE_TO_STRUCT_YELLOW,
	   STR_500E_SUSPENSION_STEEL,     STR_501B_STEEL_SUSPENSION_RAIL_BRIDGE,   STR_5021_STEEL_SUSPENSION_ROAD_BRIDGE),

	MB( 1930, 3,  7, 224, 160, 0xA23, PAL_NONE,
	   STR_5010_CANTILEVER_STEEL,     STR_501D_STEEL_CANTILEVER_RAIL_BRIDGE,   STR_5023_STEEL_CANTILEVER_ROAD_BRIDGE),

	MB( 1930, 3,  8, 232, 208, 0xA23, PALETTE_TO_STRUCT_BROWN,
	   STR_5010_CANTILEVER_STEEL,     STR_501D_STEEL_CANTILEVER_RAIL_BRIDGE,   STR_5023_STEEL_CANTILEVER_ROAD_BRIDGE),

	MB( 1930, 3,  9, 248, 240, 0xA23, PALETTE_TO_STRUCT_RED,
	   STR_5010_CANTILEVER_STEEL,     STR_501D_STEEL_CANTILEVER_RAIL_BRIDGE,   STR_5023_STEEL_CANTILEVER_ROAD_BRIDGE),

	MB( 1930, 0,  2, 240, 256, 0xA27, PAL_NONE,
	   STR_500F_GIRDER_STEEL,         STR_501C_STEEL_GIRDER_RAIL_BRIDGE,       STR_5022_STEEL_GIRDER_ROAD_BRIDGE),

	MB( 1995, 2, 16, 255, 320, 0xA28, PAL_NONE,
	   STR_5014_TUBULAR_STEEL,        STR_5027_TUBULAR_RAIL_BRIDGE,            STR_5028_TUBULAR_ROAD_BRIDGE),

	MB( 2005, 2, 32, 380, 512, 0xA28, PALETTE_TO_STRUCT_YELLOW,
	   STR_5014_TUBULAR_STEEL,        STR_5027_TUBULAR_RAIL_BRIDGE,            STR_5028_TUBULAR_ROAD_BRIDGE),

	MB( 2010, 2, 32, 510, 608, 0xA28, PALETTE_TO_STRUCT_GREY,
	   STR_BRIDGE_TUBULAR_SILICON,    STR_5027_TUBULAR_RAIL_BRIDGE,            STR_5028_TUBULAR_ROAD_BRIDGE)
};

#undef MB

