/* $Id: gui.h 11669 2007-12-19 23:26:02Z rubidium $ */

/** @file gui.h */

#ifndef GUI_H
#define GUI_H

#include "string.h"
#include "window_type.h"
#include "rail_type.h"
#include "road_type.h"
#include "vehicle_type.h"

/* main_gui.cpp */
void CcPlaySound10(bool success, TileIndex tile, uint32 p1, uint32 p2);
void CcBuildCanal(bool success, TileIndex tile, uint32 p1, uint32 p2);
void CcTerraform(bool success, TileIndex tile, uint32 p1, uint32 p2);

/* settings_gui.cpp */
void ShowGameOptions();
void ShowGameDifficulty();
void ShowPatchesSelection();
void DrawArrowButtons(int x, int y, int ctab, byte state, bool clickable_left, bool clickable_right);

/* graph_gui.cpp */
void ShowOperatingProfitGraph();
void ShowIncomeGraph();
void ShowDeliveredCargoGraph();
void ShowPerformanceHistoryGraph();
void ShowCompanyValueGraph();
void ShowCargoPaymentRates();
void ShowCompanyLeagueTable();
void ShowPerformanceRatingDetail();

/* news_gui.cpp */
void ShowLastNewsMessage();
void ShowMessageOptions();
void ShowMessageHistory();

/* rail_gui.cpp */
void ShowBuildRailToolbar(RailType railtype, int button);
void PlaceProc_BuyLand(TileIndex tile);
void ReinitGuiAfterToggleElrail(bool disable);

/* train_gui.cpp */
void ShowOrdersWindow(const Vehicle *v);

/* road_gui.cpp */
void ShowBuildRoadToolbar(RoadType roadtype);
void ShowBuildRoadScenToolbar();

/* dock_gui.cpp */
void ShowBuildDocksToolbar();

/* aircraft_gui.cpp */
void ShowBuildAirToolbar();

/* terraform_gui.cpp */
void ShowTerraformToolbar(Window *link = NULL);

/* tgp_gui.cpp */
void ShowGenerateLandscape();
void ShowHeightmapLoad();

void PlaceProc_DemolishArea(TileIndex tile);
void PlaceProc_LevelLand(TileIndex tile);
bool GUIPlaceProcDragXY(const WindowEvent *e);

/** Drag and drop selection process, or, what to do with an area of land when
 * you've selected it. */
enum {
	DDSP_DEMOLISH_AREA,
	DDSP_LEVEL_AREA,
	DDSP_CREATE_DESERT,
	DDSP_CREATE_ROCKS,
	DDSP_CREATE_WATER,
	DDSP_PLANT_TREES,
	DDSP_BUILD_BRIDGE,

	/* Rail specific actions */
	DDSP_PLACE_RAIL_NE,
	DDSP_PLACE_RAIL_NW,
	DDSP_PLACE_AUTORAIL,
	DDSP_BUILD_SIGNALS,
	DDSP_BUILD_STATION,
	DDSP_REMOVE_STATION,
	DDSP_CONVERT_RAIL,

	/* Road specific actions */
	DDSP_PLACE_ROAD_X_DIR,
	DDSP_PLACE_ROAD_Y_DIR,
	DDSP_PLACE_AUTOROAD,
};

/* misc_gui.cpp */
void PlaceLandBlockInfo();
void ShowAboutWindow();
void ShowBuildTreesToolbar();
void ShowBuildTreesScenToolbar();
void ShowTownDirectory();
void ShowIndustryDirectory();
void ShowSubsidiesList();
void ShowPlayerStations(PlayerID player);
void ShowPlayerFinances(PlayerID player);
void ShowPlayerCompany(PlayerID player);

void ShowEstimatedCostOrIncome(Money cost, int x, int y);
void ShowErrorMessage(StringID msg_1, StringID msg_2, int x, int y);

void ShowSmallMap();
void ShowExtraViewPortWindow();
void SetVScrollCount(Window *w, int num);
void SetVScroll2Count(Window *w, int num);
void SetHScrollCount(Window *w, int num);

void ShowCheatWindow();

void BuildFileList();
void SetFiosType(const byte fiostype);

/* FIOS_TYPE_FILE, FIOS_TYPE_OLDFILE etc. different colours */
extern const TextColour _fios_colors[];

/* bridge_gui.cpp */
void ShowBuildBridgeWindow(uint start, uint end, byte type);

void ShowBuildIndustryWindow();
void ShowMusicWindow();

/* main_gui.cpp */
void HandleOnEditText(const char *str);
VARDEF bool _station_show_coverage;
VARDEF PlaceProc *_place_proc;

/* vehicle_gui.cpp */
void InitializeGUI();

void ShowPlayerGroup(PlayerID player, VehicleType veh);

#endif /* GUI_H */
