require("Payment.nut");

class Vehicle
{
	vehicleID = null;
	
	constructor(vehicleID)
    {
        this.vehicleID = vehicleID;
    }
	
	function IsRoadVehicle();
	function IsRunningVehicle();
	function OnForeignRoad();
}

function Vehicle::IsRoadVehicle()
{
	return GSVehicle.GetState(this.vehicleID) == GSVehicle.VS_RUNNING;
}

function Vehicle::IsRunningVehicle()
{
	return GSVehicle.GetVehicleType(this.vehicleID) == GSVehicle.VT_ROAD;
}

function Vehicle::OnForeignRoad()
{
	local tileID = GSVehicle.GetLocation(this.vehicleID);
	local tileOwnerCompanyID = GSTile.GetOwner(tileID);
	
	if (tileOwnerCompanyID != GSCompany.COMPANY_INVALID)
	{
		local vehicleOwnerCompanyID = GSVehicle.GetOwner(this.vehicleID);
		
		if (tileOwnerCompanyID != vehicleOwnerCompanyID)
			return Payment(vehicleOwnerCompanyID, tileOwnerCompanyID);
	}
	
	return null;
}