class CompanyValue extends GSInfo
{
    function GetAuthor()        { return "Samu"; }
    function GetName()          { return "Company Value GS"; }
    function GetDescription()   { return "Offers two goal modes based on company values."; }
    function GetVersion()       { return 2; }
    function MinVersionToLoad() { return 1; }
    function GetDate()          { return "2018-02-18"; }
    function GetShortName()     { return "CVGS"; }
    function CreateInstance()   { return "CompanyValue"; }
    function GetAPIVersion()    { return "1.4"; }
    function GetURL()           { return "https://www.tt-forums.net/viewtopic.php?f=65&t=82633"; }

    function GetSettings()
    {
        AddSetting({
            name = "goal_mode",
            description = "Goal mode",
            min_value = 0,
            max_value = 1,
            easy_value = 1, 
            medium_value = 1, 
            hard_value = 1, 
            custom_value = 0, 
            step_size = 1,
            flags = CONFIG_NONE
        });
        AddLabels("goal_mode", {
            _0 = "Only rank companies by their values",
            _1 = "Reach target company value below"
        });

        AddSetting({
            name = "goal_value", 
            description = "Target company value (in thousand )",
            min_value = 500,
            max_value = 999999999,
            easy_value = 12500,
            medium_value = 100000,
            hard_value = 500000,
            custom_value = 10000000,
            step_size = 250,
            flags = CONFIG_INGAME
        });

        AddSetting({
            name = "debug_messages",
            description = "Amount of debug messages to log",
            min_value = 0,
            max_value = 3,
            easy_value = 0,
            medium_value = 0,
            hard_value = 0,
            custom_value = 3,
            step_size = 1,
            flags = CONFIG_INGAME
        });
        AddLabels("debug_messages", {
            _0 = "Essential",
            _1 = "Normal",
            _2 = "Too many",
            _3 = "Insane"
        });
    }
}

RegisterGS(CompanyValue());