/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import ic2.core.IC2;
import ic2.core.block.personal.IPersonalBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public final class StackUtil {
    public static AdjacentInv getAdjacentInventory(TileEntity source, Direction direction) {
        TileEntity target = direction.applyToTileEntity(source);
        if (!(target instanceof IInventory)) {
            return null;
        }
        IInventory inventory = (IInventory)target;
        if (target instanceof TileEntityChest) {
            for (Direction direction2 : Direction.directions) {
                TileEntity target2;
                if (direction2 == Direction.YN || direction2 == Direction.YP || !((target2 = direction2.applyToTileEntity(target)) instanceof TileEntityChest)) continue;
                inventory = new InventoryLargeChest("", inventory, (IInventory)target2);
                break;
            }
        }
        if (target instanceof IPersonalBlock) {
            if (source instanceof IPersonalBlock) {
                if (!((IPersonalBlock)target).permitsAccess(((IPersonalBlock)source).getOwner())) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new AdjacentInv(inventory, direction);
    }

    public static List<AdjacentInv> getAdjacentInventories(TileEntity source) {
        ArrayList<AdjacentInv> inventories = new ArrayList<AdjacentInv>();
        for (Direction direction : Direction.directions) {
            AdjacentInv inventory = StackUtil.getAdjacentInventory(source, direction);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        Collections.sort(inventories, new Comparator<AdjacentInv>(){

            @Override
            public int compare(AdjacentInv a, AdjacentInv b) {
                if (a.inv instanceof IPersonalBlock || !(b.inv instanceof IPersonalBlock)) {
                    return -1;
                }
                if (b.inv instanceof IPersonalBlock || !(a.inv instanceof IPersonalBlock)) {
                    return 1;
                }
                return b.inv.func_70302_i_() - a.inv.func_70302_i_();
            }
        });
        return inventories;
    }

    public static int distribute(TileEntity source, ItemStack itemStack, boolean simulate) {
        int transferred = 0;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            int amount = StackUtil.putInInventory(inventory.inv, inventory.dir.getInverse(), itemStack, simulate);
            transferred += amount;
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a != 0) continue;
            break;
        }
        itemStack.field_77994_a += transferred;
        return transferred;
    }

    public static ItemStack fetch(TileEntity source, ItemStack itemStack, boolean simulate) {
        ItemStack ret = null;
        int oldStackSize = itemStack.field_77994_a;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            ItemStack transferred = StackUtil.getFromInventory(inventory.inv, inventory.dir.getInverse(), itemStack, itemStack.field_77994_a, true, simulate);
            if (transferred == null) continue;
            if (ret == null) {
                ret = transferred;
            } else {
                ret.field_77994_a += transferred.field_77994_a;
                itemStack.field_77994_a -= transferred.field_77994_a;
            }
            if (itemStack.field_77994_a > 0) continue;
            break;
        }
        itemStack.field_77994_a = oldStackSize;
        return ret;
    }

    public static int transfer(IInventory src, IInventory dst, Direction dir, int amount) {
        int[] srcSlots = StackUtil.getInventorySlots(src, dir, false, true);
        int[] dstSlots = StackUtil.getInventorySlots(dst, dir.getInverse(), true, false);
        ISidedInventory dstSided = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        int dstVanillaSide = dir.getInverse().toSideValue();
        int total = amount;
        block0: for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.func_70301_a(srcSlot);
            int srcTransfer = Math.min(amount, srcStack.field_77994_a);
            assert (srcTransfer > 0);
            for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < dstSlots.length; ++i) {
                    int transfer;
                    int dstSlot = dstSlots[i];
                    if (dstSlot < 0) continue;
                    ItemStack dstStack = dst.func_70301_a(dstSlot);
                    if (pass == 0 && (dstStack == null || !StackUtil.isStackEqualStrict(srcStack, dstStack)) || pass == 1 && dstStack != null || !dst.func_94041_b(dstSlot, srcStack) || dstSided != null && !dstSided.func_102007_a(dstSlot, srcStack, dstVanillaSide)) continue;
                    assert (srcTransfer > 0);
                    if (dstStack == null) {
                        transfer = Math.min(srcTransfer, dst.func_70297_j_());
                        dst.func_70299_a(dstSlot, StackUtil.copyWithSize(srcStack, transfer));
                    } else {
                        transfer = Math.min(srcTransfer, Math.min(dstStack.func_77976_d(), dst.func_70297_j_()) - dstStack.field_77994_a);
                        if (transfer <= 0) {
                            dstSlots[i] = -1;
                            continue;
                        }
                        dstStack.field_77994_a += transfer;
                    }
                    assert (transfer > 0);
                    srcStack.field_77994_a -= transfer;
                    amount -= transfer;
                    if ((srcTransfer -= transfer) <= 0) {
                        if (srcStack.field_77994_a <= 0) {
                            src.func_70299_a(srcSlot, null);
                        }
                        if (amount > 0) continue block0;
                        break block0;
                    }
                    assert (srcStack.field_77994_a > 0);
                    assert (amount > 0);
                }
            }
        }
        amount = total - amount;
        assert (amount >= 0);
        if (amount > 0) {
            src.func_70296_d();
            dst.func_70296_d();
        }
        return amount;
    }

    public static void distributeDrop(TileEntity source, List<ItemStack> itemStacks) {
        Iterator<ItemStack> it = itemStacks.iterator();
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            int amount = StackUtil.distribute(source, itemStack, false);
            if (amount == itemStack.field_77994_a) {
                it.remove();
                continue;
            }
            itemStack.field_77994_a -= amount;
        }
        for (ItemStack itemStack : itemStacks) {
            StackUtil.dropAsEntity(source.func_145831_w(), source.field_145851_c, source.field_145848_d, source.field_145849_e, itemStack);
        }
        itemStacks.clear();
    }

    public static ItemStack getFromInventory(IInventory inv, Direction side, ItemStack itemStackDestination, int max, boolean ignoreMaxStackSize, boolean simulate) {
        if (itemStackDestination != null && !ignoreMaxStackSize) {
            max = Math.min(max, itemStackDestination.func_77976_d() - itemStackDestination.field_77994_a);
        }
        ItemStack ret = null;
        for (int i : StackUtil.getInventorySlots(inv, side, false, true)) {
            if (max <= 0) break;
            ItemStack stack = inv.func_70301_a(i);
            assert (stack != null);
            if (itemStackDestination != null && !StackUtil.isStackEqualStrict(stack, itemStackDestination)) continue;
            if (ret == null) {
                ret = StackUtil.copyWithSize(stack, 0);
                if (itemStackDestination == null) {
                    if (!ignoreMaxStackSize) {
                        max = Math.min(max, ret.func_77976_d());
                    }
                    itemStackDestination = ret;
                }
            }
            int transfer = Math.min(max, stack.field_77994_a);
            if (!simulate) {
                stack.field_77994_a -= transfer;
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(i, null);
                }
            }
            max -= transfer;
            ret.field_77994_a += transfer;
        }
        if (!simulate && ret != null) {
            inv.func_70296_d();
        }
        return ret;
    }

    public static int putInInventory(IInventory inv, Direction side, ItemStack itemStackSource, boolean simulate) {
        int transfer;
        ItemStack itemStack;
        int[] slots;
        if (itemStackSource == null) {
            return 0;
        }
        int toTransfer = itemStackSource.field_77994_a;
        int vanillaSide = side.toSideValue();
        for (int i : slots = StackUtil.getInventorySlots(inv, side, true, false)) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, itemStackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(i, itemStackSource, vanillaSide) || (itemStack = inv.func_70301_a(i)) == null || !StackUtil.isStackEqualStrict(itemStack, itemStackSource)) continue;
            transfer = Math.min(toTransfer, itemStack.func_77976_d() - itemStack.field_77994_a);
            if (!simulate) {
                itemStack.field_77994_a += transfer;
            }
            toTransfer -= transfer;
        }
        for (int i : slots) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, itemStackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_102007_a(i, itemStackSource, vanillaSide) || (itemStack = inv.func_70301_a(i)) != null) continue;
            transfer = Math.min(toTransfer, itemStackSource.func_77976_d());
            if (!simulate) {
                ItemStack dest = StackUtil.copyWithSize(itemStackSource, transfer);
                inv.func_70299_a(i, dest);
            }
            toTransfer -= transfer;
        }
        if (!simulate && toTransfer != itemStackSource.field_77994_a) {
            inv.func_70296_d();
        }
        return itemStackSource.field_77994_a - toTransfer;
    }

    public static int[] getInventorySlots(IInventory inv, Direction side, boolean checkInsert, boolean checkExtract) {
        int[] ret;
        ISidedInventory sidedInv;
        if (inv.func_70297_j_() <= 0) {
            return new int[0];
        }
        if (inv instanceof ISidedInventory) {
            sidedInv = (ISidedInventory)inv;
            ret = sidedInv.func_94128_d(side.toSideValue());
        } else {
            sidedInv = null;
            ret = new int[inv.func_70302_i_()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = i;
            }
        }
        if (checkInsert || checkExtract) {
            int writeIdx = 0;
            int vanillaSide = side.toSideValue();
            for (int readIdx = 0; readIdx < ret.length; ++readIdx) {
                int slot = ret[readIdx];
                ItemStack stack = inv.func_70301_a(slot);
                if (checkExtract && (stack == null || stack.field_77994_a <= 0 || sidedInv != null && !sidedInv.func_102008_b(slot, stack, vanillaSide)) || checkInsert && stack != null && (stack.field_77994_a >= stack.func_77976_d() || stack.field_77994_a >= inv.func_70297_j_() || sidedInv != null && !sidedInv.func_102007_a(slot, stack, vanillaSide))) continue;
                ret[writeIdx] = slot;
                ++writeIdx;
            }
            if (writeIdx != ret.length) {
                int[] retResized = new int[writeIdx];
                System.arraycopy(ret, 0, retResized, 0, writeIdx);
                ret = retResized;
            }
        }
        return ret;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static ItemStack copyWithWildCard(ItemStack itemStack) {
        ItemStack ret = itemStack.func_77946_l();
        Items.field_151100_aR.setDamage(ret, Short.MAX_VALUE);
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 == null && stack2 == null || stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() && !stack1.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j());
    }

    public static boolean isStackEqualStrict(ItemStack stack1, ItemStack stack2) {
        return StackUtil.isStackEqual(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isTagEqual(ItemStack a, ItemStack b) {
        boolean bEmpty;
        boolean aEmpty = !a.func_77942_o() || a.func_77978_p().func_82582_d();
        boolean bl = bEmpty = !b.func_77942_o() || b.func_77978_p().func_82582_d();
        if (aEmpty != bEmpty) {
            return false;
        }
        if (aEmpty) {
            return true;
        }
        return a.func_77978_p().equals((Object)b.func_77978_p());
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtil.getBlock(stack);
    }

    public static boolean damageItemStack(ItemStack itemStack, int amount) {
        if (itemStack.func_96631_a(amount, IC2.random)) {
            --itemStack.field_77994_a;
            itemStack.func_77964_b(0);
            return itemStack.field_77994_a <= 0;
        }
        return false;
    }

    public static boolean check2(Iterable<List<ItemStack>> list) {
        for (List<ItemStack> list2 : list) {
            if (StackUtil.check(list2)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack[] array) {
        return StackUtil.check(Arrays.asList(array));
    }

    public static boolean check(Iterable<ItemStack> list) {
        for (ItemStack stack : list) {
            if (StackUtil.check(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack stack) {
        return stack.func_77973_b() != null;
    }

    public static String toStringSafe2(Iterable<List<ItemStack>> list) {
        String ret = "[";
        for (List<ItemStack> list2 : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(list2);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack[] array) {
        return StackUtil.toStringSafe(Arrays.asList(array));
    }

    public static String toStringSafe(Iterable<ItemStack> list) {
        String ret = "[";
        for (ItemStack stack : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(stack);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return stack.field_77994_a + "x(null)@(unknown)";
        }
        return stack.toString();
    }

    public static void consumeInventoryItem(EntityPlayer player, ItemStack itemStack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(itemStack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            return;
        }
    }

    public static boolean storeInventoryItem(ItemStack stack, EntityPlayer player, boolean simulate) {
        if (simulate) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack invStack = player.field_71071_by.field_70462_a[i];
                if (invStack != null && (!StackUtil.isStackEqualStrict(stack, invStack) || invStack.field_77994_a + stack.field_77994_a > invStack.func_77976_d())) continue;
                return true;
            }
        } else if (player.field_71071_by.func_70441_a(stack)) {
            if (!IC2.platform.isRendering()) {
                player.field_71070_bA.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public static class AdjacentInv {
        public final IInventory inv;
        public final Direction dir;

        private AdjacentInv(IInventory inv, Direction dir) {
            this.inv = inv;
            this.dir = dir;
        }
    }
}

