/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import ic2.core.AdvCraftingRecipeManager;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class Rezepte {
    public static void registerCraftingRecipes() {
        Recipes.advRecipes = new AdvCraftingRecipeManager();
        Config shapedRecipes = new Config("shaped recipes");
        Config shapelessRecipes = new Config("shapeless recipes");
        try {
            shapedRecipes.load(Rezepte.class.getResourceAsStream("/assets/ic2/config/shaped_recipes.ini"));
            shapelessRecipes.load(Rezepte.class.getResourceAsStream("/assets/ic2/config/shapeless_recipes.ini"));
        }
        catch (Exception e) {
            IC2.log.warn(LogCategory.Recipe, e, "Recipe loading failed.");
        }
        List<IRecipeInput> disabled = ConfigUtil.asRecipeInputList(MainConfig.get(), "recipes/disable");
        Rezepte.loadRecipes(shapedRecipes, true, disabled);
        Rezepte.loadRecipes(shapelessRecipes, false, disabled);
    }

    public static void loadRecipes(Config config, boolean shaped) {
        Rezepte.loadRecipes(config, shaped, new ArrayList<IRecipeInput>());
    }

    private static void loadRecipes(Config config, boolean shaped, List<IRecipeInput> disabled) throws Config.ParseException {
        Iterator<Config.Value> it = config.valueIterator();
        while (it.hasNext()) {
            Config.Value value = it.next();
            Rezepte.loadRecipe(value, shaped, disabled);
        }
    }

    private static void loadRecipe(Config.Value value, boolean shaped, List<IRecipeInput> disabled) {
        ItemStack output;
        try {
            output = ConfigUtil.asStack(value.name);
        }
        catch (ParseException e) {
            throw new Config.ParseException("invalid key", value, e);
        }
        if (output == null) {
            IC2.log.warn(LogCategory.Recipe, new Config.ParseException("invalid output specified: " + value.name, value), "Skipping recipe for %s due to unresolvable output", value.name);
            return;
        }
        for (IRecipeInput disable : disabled) {
            if (!disable.matches(output)) continue;
            return;
        }
        boolean requireIc2Circuits = ConfigUtil.getBool(MainConfig.get(), "recipes/requireIc2Circuits");
        try {
            for (String majorPart : value.getString().split("\\s*,\\s*")) {
                boolean first = true;
                ArrayList<Object> inputs = new ArrayList<Object>();
                int count = 1;
                boolean hidden = false;
                for (String part : Rezepte.splitWhitespace(majorPart)) {
                    if (part.startsWith("@")) {
                        if (part.startsWith("@count:")) {
                            count = Integer.parseInt(part.substring(7));
                            continue;
                        }
                        if (part.equals("@hidden")) {
                            hidden = true;
                            continue;
                        }
                        throw new Config.ParseException("invalid attribute: " + part, value);
                    }
                    if (shaped && first) {
                        first = false;
                        if (part.startsWith("\"")) {
                            if (!part.endsWith("\"")) {
                                throw new Config.ParseException("missing end quote: " + part, value);
                            }
                            part = part.substring(1, part.length() - 1);
                        }
                        String[] rows = part.split("\\|");
                        Integer width = null;
                        for (String row : rows) {
                            if (width != null && width.intValue() != row.length()) {
                                throw new Config.ParseException("inconsistent recipe row width", value);
                            }
                            width = row.length();
                        }
                        inputs.addAll(Arrays.asList(rows));
                        continue;
                    }
                    ArrayList<IRecipeInput> input = new ArrayList<IRecipeInput>();
                    boolean first2 = true;
                    String[] arr$ = part.split("\\s*\\|\\s*");
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        IRecipeInput cInput;
                        String subPart;
                        String ingredient = subPart = arr$[i$];
                        if (shaped && first2) {
                            first2 = false;
                            int pos = ingredient.indexOf(":");
                            if (pos != 1) {
                                throw new Config.ParseException("no valid pattern index character found: " + part, value);
                            }
                            inputs.add(Character.valueOf(ingredient.charAt(0)));
                            ingredient = ingredient.substring(2);
                        }
                        if ((cInput = ConfigUtil.asRecipeInput(ingredient)) == null) {
                            throw new Config.ParseException("can't find ingredient for " + ingredient, value);
                        }
                        if (cInput instanceof RecipeInputOreDict) {
                            RecipeInputOreDict odInput = (RecipeInputOreDict)cInput;
                            if (odInput.input.equals("circuitBasic") && requireIc2Circuits) {
                                cInput = new RecipeInputItemStack(Ic2Items.electronicCircuit);
                            } else if (odInput.input.equals("circuitAdvanced") && requireIc2Circuits) {
                                cInput = new RecipeInputItemStack(Ic2Items.advancedCircuit);
                            }
                        }
                        input.add(cInput);
                    }
                    if (input.size() == 1) {
                        inputs.add(input.get(0));
                        continue;
                    }
                    inputs.add(input);
                }
                output = StackUtil.copyWithSize(output, count);
                if (hidden) {
                    inputs.add(hidden);
                }
                if (shaped) {
                    AdvRecipe.addAndRegister(output, inputs.toArray());
                    continue;
                }
                AdvShapelessRecipe.addAndRegister(output, inputs.toArray());
            }
        }
        catch (Config.ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Config.ParseException("generic parse error", value, e);
        }
    }

    private static List<String> splitWhitespace(String str) {
        String dummy = str.replaceAll("\\\\.", "xx");
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = dummy.charAt(i);
            if (c == '\"') {
                quoted = !quoted;
            }
            boolean split = false;
            if (!quoted && Character.isWhitespace(c)) {
                split = true;
            }
            if (split) {
                if (current.length() <= 0) continue;
                ret.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(str.charAt(i));
        }
        if (current.length() > 0) {
            ret.add(current.toString());
        }
        return ret;
    }
}

