/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.crop.TileEntityCrop;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockCrop
extends BlockMultiID {
    public static TileEntityCrop tempStore;
    private static final int textureIndexStick = 0;
    private static final int textureIndexStickUpgraded = 1;

    public BlockCrop(InternalName internalName1) {
        super(internalName1, Material.field_151585_k, ItemBlockIC2.class);
        this.func_149711_c(0.8f);
        this.func_149752_b(0.2f);
        this.func_149672_a(field_149779_h);
        Ic2Items.crop = new ItemStack((Block)this, 1, 0);
        GameRegistry.registerTileEntity(TileEntityCrop.class, (String)"TECrop");
    }

    @Override
    public String getTextureFolder(int id) {
        return "crop";
    }

    @Override
    public int getTextureIndex(int meta) {
        if (meta == 0 || meta == 1) {
            return meta;
        }
        if (meta > 1 && meta <= 11) {
            return meta;
        }
        return 0;
    }

    @Override
    public String getTextureName(int index) {
        switch (index) {
            case 0: {
                return InternalName.stick.name();
            }
            case 1: {
                return InternalName.stick.name() + "." + InternalName.upgraded.name();
            }
        }
        if (index > 1 && index <= 6) {
            return "weed." + (index - 1);
        }
        if (index > 6 && index <= 11) {
            return "infested." + (index - 6);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        Crops.instance.startSpriteRegistration(iconRegister);
    }

    @Override
    public Class<? extends TileEntity> getTeClass(int meta, MutableObject<Class<?>[]> ctorArgTypes, MutableObject<Object[]> ctorArgs) {
        return TileEntityCrop.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe(iBlockAccess, x, y, z);
        if (te == null) {
            return null;
        }
        CropCard crop = te.getCrop();
        if (crop == null) {
            if (!te.upgraded) {
                return this.func_149691_a(side, 0);
            }
            return this.func_149691_a(side, 1);
        }
        return crop.getSprite(te);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(IBlockAccess iBlockAccess, int x, int y, int z, int side, int layer) {
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe(iBlockAccess, x, y, z);
        if (te == null) {
            return null;
        }
        switch (layer) {
            case 0: {
                if (te.getvisualweedlevel() <= 0) break;
                return this.func_149691_a(side, te.getvisualweedlevel() + 1);
            }
            case 1: {
                if (te.getvisualInfestedlevel() <= 0) break;
                return this.func_149691_a(side, te.getvisualInfestedlevel() + 6);
            }
        }
        return null;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak && super.func_149742_c(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        if (world.func_147439_a(x, y - 1, z) != Blocks.field_150458_ak) {
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
        } else {
            TileEntityCrop te = (TileEntityCrop)this.getOwnTe((IBlockAccess)world, x, y, z);
            if (te == null) {
                return;
            }
            te.onNeighbourChange();
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        double d = 0.2;
        return AxisAlignedBB.func_72330_a((double)d, (double)0.0, (double)d, (double)(1.0 - d), (double)0.7, (double)(1.0 - d));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onEntityCollision(entity);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("crop");
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe(blockAccess, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.emitRedstone();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        tempStore = (TileEntityCrop)this.getOwnTe((IBlockAccess)world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        if (tempStore != null) {
            tempStore.onBlockDestroyed();
        }
    }

    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe(blockAccess, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.getEmittedLight();
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.leftClick(player);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityCrop te = (TileEntityCrop)this.getOwnTe((IBlockAccess)world, x, y, z);
        if (te == null) {
            return false;
        }
        return te.rightClick(player);
    }
}

