/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTesla
extends TileEntityBlock
implements IEnergySink {
    public double energy = 0.0;
    public int ticker = 0;
    public int maxEnergy = 10000;
    public boolean addedToEnergyNet = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!IC2.platform.isSimulating() || !this.redstoned()) {
            return;
        }
        if (this.energy < (double)TileEntityTesla.getCost()) {
            return;
        }
        int damage = (int)this.energy / TileEntityTesla.getCost();
        this.energy -= 1.0;
        if (this.ticker++ % 32 == 0 && this.shock(damage)) {
            this.energy = 0.0;
        }
    }

    public boolean shock(int damage) {
        boolean shock = false;
        List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5)));
        for (int l = 0; l < list1.size(); ++l) {
            EntityLivingBase victim = (EntityLivingBase)list1.get(l);
            if (ItemArmorHazmat.hasCompleteHazmat(victim)) continue;
            shock = true;
            victim.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
            for (int i = 0; i < damage; ++i) {
                this.field_145850_b.func_72869_a("reddust", victim.field_70165_t + (double)this.field_145850_b.field_73012_v.nextFloat(), victim.field_70163_u + (double)(this.field_145850_b.field_73012_v.nextFloat() * 2.0f), victim.field_70161_v + (double)this.field_145850_b.field_73012_v.nextFloat(), 0.0, 0.0, 1.0);
            }
        }
        return shock;
    }

    public boolean redstoned() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static int getCost() {
        return 400;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return (double)this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return 2;
    }
}

