/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerSolarDestiller;
import ic2.core.block.machine.gui.GuiSolarDestiller;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.item.IUpgradeItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntitySolarDestiller
extends TileEntityInventory
implements IHasGui,
IFluidHandler,
IUpgradableBlock {
    public final FluidTank inputTank = new FluidTank(10000);
    public final FluidTank outputTank = new FluidTank(10000);
    private int tickrate;
    private int updateTicker;
    private boolean sunIsVisible = false;
    public final InvSlotOutput wateroutputSlot;
    public final InvSlotOutput destiwateroutputSlott;
    public final InvSlotConsumableLiquidByList waterinputSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "waterinputSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, FluidRegistry.WATER);
    public final InvSlotConsumableLiquidByTank destiwaterinputSlot = new InvSlotConsumableLiquidByTank(this, "destiwaterinputSlot", 2, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.outputTank);
    public final InvSlotUpgrade upgradeSlot;

    public TileEntitySolarDestiller() {
        this.wateroutputSlot = new InvSlotOutput(this, "wateroutputSlot", 3, 1);
        this.destiwateroutputSlott = new InvSlotOutput(this, "destiwateroutputSlott", 4, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 7, 3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.tickrate = this.getTickRate();
        this.updateTicker = IC2.random.nextInt(this.tickrate);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inputTank.readFromNBT(nbttagcompound.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbttagcompound.func_74775_l("outputTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound inputTankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTag);
        nbttagcompound.func_74782_a("inputTank", (NBTBase)inputTankTag);
        NBTTagCompound outputTankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTag);
        nbttagcompound.func_74782_a("outputTank", (NBTBase)outputTankTag);
    }

    public void func_145845_h() {
        RecipeOutput outputoutputSlot;
        super.func_145845_h();
        RecipeOutput outputinputSlot = this.processInputSlot(true);
        if (outputinputSlot != null) {
            this.processInputSlot(false);
            List<ItemStack> processResult = outputinputSlot.items;
            this.wateroutputSlot.add(processResult);
        }
        this.updateSunVisibility();
        if (this.updateTicker++ >= this.tickrate - 1) {
            if (this.sunIsVisible && this.inputTank.getFluidAmount() > 0 && this.outputTank.getFluidAmount() < 10000) {
                this.inputTank.drain(1, true);
                this.outputTank.fill(new FluidStack(BlocksItems.getFluid(InternalName.fluidDistilledWater), 1), true);
            }
            this.updateTicker = 0;
        }
        if ((outputoutputSlot = this.processOutputSlot(true)) != null) {
            this.processOutputSlot(false);
            List<ItemStack> processResult = outputoutputSlot.items;
            this.destiwateroutputSlott.add(processResult);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            super.func_70296_d();
        }
    }

    private RecipeOutput processInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.waterinputSlot.isEmpty() && this.waterinputSlot.transferToTank((IFluidTank)this.inputTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.wateroutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    private RecipeOutput processOutputSlot(boolean simulate) {
        MutableObject output;
        if (!this.destiwaterinputSlot.isEmpty() && this.destiwaterinputSlot.transferFromTank((IFluidTank)this.outputTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.destiwateroutputSlott.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    private static int getskylight(World world, int x, int z) {
        return world.func_72957_l(x, 255, z);
    }

    public void updateSunVisibility() {
        this.sunIsVisible = TileEntitySolarDestiller.isSunVisible(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public static boolean isSunVisible(World world, int x, int y, int z) {
        return TileEntitySolarDestiller.getskylight(world, x, z) > 4 && !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z) && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
    }

    @Override
    public String func_145825_b() {
        return "Solar Destiller";
    }

    public ContainerBase<TileEntitySolarDestiller> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarDestiller(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSolarDestiller(new ContainerSolarDestiller(entityPlayer, this));
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int getTickRate() {
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e), (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) {
            return 36;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e), (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 144;
        }
        return 72;
    }

    public int gaugeLiquidScaled(int i, int tank) {
        switch (tank) {
            case 0: {
                if (this.inputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
            }
            case 1: {
                if (this.outputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
            }
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.inputTank.getInfo(), this.outputTank.getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == FluidRegistry.WATER.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack fluidStack = this.outputTank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.isFluidEqual(new FluidStack(fluid, 1));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.outputTank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.outputTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }

    public boolean work() {
        return this.inputTank.getFluidAmount() > 0 && this.outputTank.getFluidAmount() < 1000 && this.sunIsVisible;
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.fluidEjectorUpgrade);
        itemstack.add(Ic2Items.ejectorUpgrade);
        itemstack.add(Ic2Items.pullingUpgrade);
        return itemstack;
    }

    @Override
    public double getEnergy() {
        return 40.0;
    }

    @Override
    public boolean useEnergy(double amount) {
        return true;
    }

    @Override
    public void setRedstonePowered(boolean redstone) {
    }
}

