/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IPatternStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerReplicator;
import ic2.core.block.machine.gui.GuiReplicator;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.item.IUpgradeItem;
import ic2.core.util.StackUtil;
import ic2.core.uu.UuIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityReplicator
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
INetworkClientTileEntityEventListener {
    private static final double uuPerTickBase = 1.0E-4;
    private static final double euPerTickBase = 512.0;
    private static final int defaultTier = 4;
    private static final int defaultEnergyStorage = 2000000;
    private double uuPerTick = 1.0E-4;
    private double euPerTick = 512.0;
    private double extraUuStored = 0.0;
    public double uuProcessed = 0.0;
    public ItemStack pattern;
    private Mode mode = Mode.STOPPED;
    public int index;
    public boolean redstonePowered = false;
    public int maxIndex;
    public double patternUu;
    public double patternEu;
    public final InvSlotConsumableLiquid fluidSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluid", 0, 1, BlocksItems.getFluid(InternalName.fluidUuMatter));
    public final InvSlotOutput cellSlot = new InvSlotOutput(this, "cell", 0, 1);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "output", 0, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);

    public TileEntityReplicator() {
        super(2000000, 4, 0, 16);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.needsFluid()) {
            needsInvUpdate = this.gainFluid();
        }
        boolean newActive = false;
        if (this.mode != Mode.STOPPED && this.energy >= this.euPerTick && this.pattern != null && this.outputSlot.canAdd(this.pattern)) {
            boolean finish;
            double uuRemaining = this.patternUu - this.uuProcessed;
            if (uuRemaining <= this.uuPerTick) {
                finish = true;
            } else {
                uuRemaining = this.uuPerTick;
                finish = false;
            }
            if (this.consumeUu(uuRemaining)) {
                newActive = true;
                this.energy -= this.euPerTick;
                this.uuProcessed += uuRemaining;
                if (finish) {
                    this.uuProcessed = 0.0;
                    if (this.mode == Mode.SINGLE) {
                        this.mode = Mode.STOPPED;
                    } else {
                        this.refreshInfo();
                    }
                    if (this.pattern != null) {
                        this.outputSlot.add(this.pattern);
                        needsInvUpdate = true;
                    }
                }
            }
        }
        this.setActive(newActive);
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    private boolean consumeUu(double amount) {
        if (amount <= this.extraUuStored) {
            this.extraUuStored -= amount;
            return true;
        }
        int toDrain = (int)Math.ceil((amount -= this.extraUuStored) * 1000.0);
        FluidStack drained = this.fluidTank.drain(toDrain, false);
        if (drained != null && drained.getFluid() == BlocksItems.getFluid(InternalName.fluidUuMatter) && drained.amount == toDrain) {
            this.fluidTank.drain(toDrain, true);
            this.extraUuStored = amount < 0.0 ? -(amount -= (double)drained.amount / 1000.0) : 0.0;
            return true;
        }
        return false;
    }

    public void refreshInfo() {
        IPatternStorage storage = this.getPatternStorage();
        ItemStack oldPattern = this.pattern;
        if (storage == null) {
            this.pattern = null;
        } else {
            List<ItemStack> patterns = storage.getPatterns();
            if (this.index < 0 || this.index >= patterns.size()) {
                this.index = 0;
            }
            this.maxIndex = patterns.size();
            if (patterns.isEmpty()) {
                this.pattern = null;
            } else {
                this.pattern = patterns.get(this.index);
                this.patternUu = UuIndex.instance.getInBuckets(this.pattern);
                if (!StackUtil.isStackEqual(this.pattern, oldPattern)) {
                    this.uuProcessed = 0.0;
                    this.mode = Mode.STOPPED;
                }
            }
        }
        if (this.pattern == null) {
            this.uuProcessed = 0.0;
            this.mode = Mode.STOPPED;
        }
    }

    public IPatternStorage getPatternStorage() {
        for (Direction direction : Direction.directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IPatternStorage)) continue;
            return (IPatternStorage)target;
        }
        return null;
    }

    public void setOverclockRates() {
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(stack, this), stack.field_77994_a);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(stack, this) * stack.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(stack, this), stack.field_77994_a);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(stack, this) * stack.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(stack, this), stack.field_77994_a);
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
        }
        this.uuPerTick = 1.0E-4 / processTimeMultiplier;
        this.euPerTick = (512.0 + (double)extraEnergyDemand) * energyDemandMultiplier;
        this.setTier(TileEntityReplicator.applyModifier(4, extraTier, 1.0));
        this.maxEnergy = TileEntityReplicator.applyModifier(2000000, extraEnergyStorage, energyStorageMultiplier);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiReplicator(new ContainerReplicator(entityPlayer, this));
    }

    public ContainerBase<TileEntityReplicator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerReplicator(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
            this.refreshInfo();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public boolean gainFluid() {
        boolean ret = false;
        MutableObject output = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.cellSlot.canAdd((ItemStack)output.getValue()))) {
            ret = this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.cellSlot.add((ItemStack)output.getValue());
            }
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.extraUuStored = nbttagcompound.func_74769_h("extraUuStored");
        this.uuProcessed = nbttagcompound.func_74769_h("uuProcessed");
        this.index = nbttagcompound.func_74762_e("index");
        int modeIdx = nbttagcompound.func_74762_e("mode");
        this.mode = modeIdx < Mode.values().length ? Mode.values()[modeIdx] : Mode.STOPPED;
        NBTTagCompound contentTag = nbttagcompound.func_74775_l("pattern");
        this.pattern = ItemStack.func_77949_a((NBTTagCompound)contentTag);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("extraUuStored", this.extraUuStored);
        nbttagcompound.func_74780_a("uuProcessed", this.uuProcessed);
        nbttagcompound.func_74768_a("index", this.index);
        nbttagcompound.func_74768_a("mode", this.mode.ordinal());
        if (this.pattern != null) {
            NBTTagCompound contentTag = new NBTTagCompound();
            this.pattern.func_77955_b(contentTag);
            nbttagcompound.func_74782_a("pattern", (NBTBase)contentTag);
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: 
            case 1: {
                List<ItemStack> patterns;
                IPatternStorage storage;
                if (this.mode != Mode.STOPPED || (storage = this.getPatternStorage()) == null || (patterns = storage.getPatterns()).isEmpty()) break;
                this.index = event == 0 ? (this.index <= 0 ? patterns.size() - 1 : --this.index) : (this.index >= patterns.size() - 1 ? 0 : ++this.index);
                this.refreshInfo();
                break;
            }
            case 3: {
                if (this.mode == Mode.STOPPED) break;
                this.uuProcessed = 0.0;
                this.mode = Mode.STOPPED;
                break;
            }
            case 4: {
                if (this.pattern == null) break;
                this.mode = Mode.SINGLE;
                break;
            }
            case 5: {
                if (this.pattern == null) break;
                this.mode = Mode.CONTINUOUS;
            }
        }
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return BlocksItems.getFluid(InternalName.fluidUuMatter) == fluid;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Replicator";
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstonePowered) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public void setRedstonePowered(boolean redstone) {
        if (this.redstonePowered != redstone) {
            this.redstonePowered = redstone;
        }
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.overclockerUpgrade);
        itemstack.add(Ic2Items.transformerUpgrade);
        itemstack.add(Ic2Items.energyStorageUpgrade);
        itemstack.add(Ic2Items.ejectorUpgrade);
        itemstack.add(Ic2Items.redstoneinvUpgrade);
        itemstack.add(Ic2Items.pullingUpgrade);
        return itemstack;
    }

    public static enum Mode {
        STOPPED,
        SINGLE,
        CONTINUOUS;

    }
}

