/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.container.ContainerMetalFormer;
import ic2.core.block.machine.gui.GuiMetalFormer;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMetalFormer
extends TileEntityStandardMachine
implements INetworkClientTileEntityEventListener {
    private int mode;
    private static final int EventSwitch = 0;

    public TileEntityMetalFormer() {
        super(10, 200, 1);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.metalformerExtruding);
    }

    public static void init() {
        Recipes.metalformerExtruding = new BasicMachineRecipeManager();
        Recipes.metalformerCutting = new BasicMachineRecipeManager();
        Recipes.metalformerRolling = new BasicMachineRecipeManager();
        TileEntityMetalFormer.addRecipeExtruding("ingotTin", 1, StackUtil.copyWithSize(Ic2Items.tinCableItem, 3));
        TileEntityMetalFormer.addRecipeExtruding("ingotCopper", 1, StackUtil.copyWithSize(Ic2Items.copperCableItem, 3));
        TileEntityMetalFormer.addRecipeExtruding(new ItemStack(Items.field_151043_k), 1, StackUtil.copyWithSize(Ic2Items.goldCableItem, 4));
        TileEntityMetalFormer.addRecipeExtruding(new ItemStack(Items.field_151042_j), 1, StackUtil.copyWithSize(Ic2Items.ironCableItem, 4));
        TileEntityMetalFormer.addRecipeExtruding("plateIron", 1, Ic2Items.fuelRod);
        TileEntityMetalFormer.addRecipeExtruding("plateTin", 1, StackUtil.copyWithSize(Ic2Items.cell, 3));
        TileEntityMetalFormer.addRecipeExtruding(Ic2Items.casingiron, 1, StackUtil.copyWithSize(Ic2Items.ironFence, 1));
        TileEntityMetalFormer.addRecipeExtruding(Ic2Items.casingtin, 1, Ic2Items.tinCan);
        TileEntityMetalFormer.addRecipeExtruding(new ItemStack(Blocks.field_150339_S), 1, Ic2Items.ironshaft);
        TileEntityMetalFormer.addRecipeExtruding("blockSteel", 1, Ic2Items.steelshaft);
        TileEntityMetalFormer.addRecipeRolling(new ItemStack(Items.field_151042_j), 1, Ic2Items.plateiron);
        TileEntityMetalFormer.addRecipeRolling(new ItemStack(Items.field_151043_k), 1, Ic2Items.plategold);
        TileEntityMetalFormer.addRecipeRolling("ingotCopper", 1, Ic2Items.platecopper);
        TileEntityMetalFormer.addRecipeRolling("ingotBronze", 1, Ic2Items.platebronze);
        TileEntityMetalFormer.addRecipeRolling("ingotLead", 1, Ic2Items.platelead);
        TileEntityMetalFormer.addRecipeRolling("ingotTin", 1, Ic2Items.platetin);
        TileEntityMetalFormer.addRecipeRolling("ingotSteel", 1, Ic2Items.plateadviron);
        TileEntityMetalFormer.addRecipeRolling("plateIron", 1, StackUtil.copyWithSize(Ic2Items.casingiron, 2));
        TileEntityMetalFormer.addRecipeRolling("plateGold", 1, StackUtil.copyWithSize(Ic2Items.casinggold, 2));
        TileEntityMetalFormer.addRecipeRolling("plateSteel", 1, StackUtil.copyWithSize(Ic2Items.casingadviron, 2));
        TileEntityMetalFormer.addRecipeRolling("plateBronze", 1, StackUtil.copyWithSize(Ic2Items.casingbronze, 2));
        TileEntityMetalFormer.addRecipeRolling("plateTin", 1, StackUtil.copyWithSize(Ic2Items.casingtin, 2));
        TileEntityMetalFormer.addRecipeRolling("plateCopper", 1, StackUtil.copyWithSize(Ic2Items.casingcopper, 2));
        TileEntityMetalFormer.addRecipeRolling("plateLead", 1, StackUtil.copyWithSize(Ic2Items.casinglead, 2));
        TileEntityMetalFormer.addRecipeCutting("plateTin", 1, StackUtil.copyWithSize(Ic2Items.tinCableItem, 3));
        TileEntityMetalFormer.addRecipeCutting("plateCopper", 1, StackUtil.copyWithSize(Ic2Items.copperCableItem, 3));
        TileEntityMetalFormer.addRecipeCutting("plateGold", 1, StackUtil.copyWithSize(Ic2Items.goldCableItem, 4));
        TileEntityMetalFormer.addRecipeCutting("plateIron", 1, StackUtil.copyWithSize(Ic2Items.ironCableItem, 4));
        if (ConfigUtil.getBool(MainConfig.get(), "recipes/allowCoinCrafting")) {
            TileEntityMetalFormer.addRecipeCutting(Ic2Items.casingiron, 1, StackUtil.copyWithSize(Ic2Items.coin, 2));
        }
    }

    public static void addRecipeExtruding(ItemStack input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeExtruding(new RecipeInputItemStack(input, amount), output);
    }

    public static void addRecipeExtruding(String input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeExtruding(new RecipeInputOreDict(input, amount), output);
    }

    public static void addRecipeExtruding(IRecipeInput input, ItemStack output) {
        Recipes.metalformerExtruding.addRecipe(input, null, output);
    }

    public static void addRecipeCutting(ItemStack input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeCutting(new RecipeInputItemStack(input, amount), output);
    }

    public static void addRecipeCutting(String input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeCutting(new RecipeInputOreDict(input, amount), output);
    }

    public static void addRecipeCutting(IRecipeInput input, ItemStack output) {
        Recipes.metalformerCutting.addRecipe(input, null, output);
    }

    public static void addRecipeRolling(ItemStack input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeRolling(new RecipeInputItemStack(input, amount), output);
    }

    public static void addRecipeRolling(String input, int amount, ItemStack output) {
        TileEntityMetalFormer.addRecipeRolling(new RecipeInputOreDict(input, amount), output);
    }

    public static void addRecipeRolling(IRecipeInput input, ItemStack output) {
        Recipes.metalformerRolling.addRecipe(input, null, output);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setMode(nbttagcompound.func_74762_e("mode"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("mode", this.mode);
    }

    @Override
    public String func_145825_b() {
        return "MetalFormer";
    }

    public ContainerBase<TileEntityMetalFormer> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMetalFormer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMetalFormer(new ContainerMetalFormer(entityPlayer, this));
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.cycleMode();
            }
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("mode")) {
            this.setMode(this.mode);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode1) {
        InvSlotProcessableGeneric slot = (InvSlotProcessableGeneric)this.inputSlot;
        switch (mode1) {
            case 0: {
                slot.setRecipeManager(Recipes.metalformerExtruding);
                break;
            }
            case 1: {
                slot.setRecipeManager(Recipes.metalformerRolling);
                break;
            }
            case 2: {
                slot.setRecipeManager(Recipes.metalformerCutting);
                break;
            }
            default: {
                throw new RuntimeException("invalid mode: " + mode1);
            }
        }
        this.mode = mode1;
    }

    private void cycleMode() {
        this.setMode((this.getMode() + 1) % 3);
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.overclockerUpgrade);
        itemstack.add(Ic2Items.transformerUpgrade);
        itemstack.add(Ic2Items.energyStorageUpgrade);
        itemstack.add(Ic2Items.ejectorUpgrade);
        itemstack.add(Ic2Items.pullingUpgrade);
        return itemstack;
    }
}

