/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerMagnetizer;
import ic2.core.block.machine.gui.GuiMagnetizer;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.item.IUpgradeItem;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetizer
extends TileEntityElectricMachine
implements IHasGui,
IUpgradableBlock {
    public InvSlotUpgrade upgradeSlot;
    private int ticker = IC2.random.nextInt(16);
    private boolean redstonePowered;
    private int overclockers;
    public static final int defaultMaxEnergy = 100;
    public static final int defaultTier = 1;

    public TileEntityMagnetizer() {
        super(100, 1, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.overclockers = 0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        boolean redstonePowered = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraEnergyStorage += upgrade.getExtraEnergyStorage(stack, this) * stack.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(stack, this), stack.field_77994_a);
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
            if (upgrade.useRedstoneinverter(stack, this)) {
                redstonePowered = true;
            }
            if (!StackUtil.isStackEqual(stack, Ic2Items.overclockerUpgrade)) continue;
            this.overclockers += stack.field_77994_a;
        }
        this.setRedstonePowered(redstonePowered);
        this.setTier(TileEntityStandardMachine.applyModifier(1, extraTier, 1.0));
        this.maxEnergy = TileEntityStandardMachine.applyModifier(100, extraEnergyStorage, energyStorageMultiplier);
    }

    @Override
    public void func_145845_h() {
        int need;
        int y;
        super.func_145845_h();
        if (this.ticker++ % 16 != 0 || this.isRedstonePowered()) {
            return;
        }
        Direction dir = Direction.fromSideValue(this.getFacing());
        int x = this.field_145851_c + dir.xOffset;
        int z = this.field_145849_e + dir.zOffset;
        double multiplier = 1.0 + 0.1 * (double)this.overclockers;
        for (y = this.field_145848_d; y > 0 && y >= this.field_145848_d - this.distance() && !(this.energy < multiplier) && StackUtil.equals(this.field_145850_b.func_147439_a(x, y, z), Ic2Items.ironFence); --y) {
            need = 15 - this.field_145850_b.func_72805_g(x, y, z);
            if (need <= 0) continue;
            if ((double)need * multiplier > this.energy) {
                need = MathHelper.func_76128_c((double)(this.energy / multiplier));
            }
            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) + need, 7);
            this.energy -= (double)need * multiplier;
        }
        for (y = this.field_145848_d; y < IC2.getWorldHeight(this.field_145850_b) && y <= this.field_145848_d + this.distance() && !(this.energy < multiplier) && StackUtil.equals(this.field_145850_b.func_147439_a(x, y, z), Ic2Items.ironFence); ++y) {
            need = 15 - this.field_145850_b.func_72805_g(x, y, z);
            if (need <= 0) continue;
            if ((double)need * multiplier > this.energy) {
                need = MathHelper.func_76128_c((double)(this.energy / multiplier));
            }
            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) + need, 7);
            this.energy -= (double)need * multiplier;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public String func_145825_b() {
        return "Magnetizer";
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && side != 0 && side != 1;
    }

    private int distance() {
        return 20 + this.overclockers;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnetizer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMagnetizer(new ContainerMagnetizer(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public void setRedstonePowered(boolean redstone) {
        this.redstonePowered = redstone;
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(Ic2Items.transformerUpgrade);
        list.add(Ic2Items.energyStorageUpgrade);
        list.add(Ic2Items.redstoneinvUpgrade);
        list.add(Ic2Items.overclockerUpgrade);
        return list;
    }

    @Override
    public boolean isRedstonePowered() {
        boolean ret = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.redstonePowered ? !ret : ret;
    }
}

