/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IHeatSource;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerBlastFurnace;
import ic2.core.block.machine.gui.GuiBlastFurnace;
import ic2.core.item.IUpgradeItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlastFurnace
extends TileEntityInventory
implements IHasGui,
IUpgradableBlock {
    public boolean outOfAir = false;
    public int progress = 0;
    public final int maxprogress;
    private boolean newActive = false;
    public boolean redstonePowered = false;
    public int heat = 0;
    public static int maxHeat = 50000;
    public final InvSlotConsumable inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "InputSlot", 0, 1, Recipes.blastfurance);
    public final InvSlotConsumable airSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "AirSlot", 1, 1, Ic2Items.airCell);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "OuputSlot", 2, 1);
    public final InvSlotOutput slagOutputSlot;
    public final InvSlotOutput airOutputSlot = new InvSlotOutput(this, "AirOutputSlot", 3, 1);
    public final InvSlotUpgrade upgradeSlot;

    public TileEntityBlastFurnace() {
        this.slagOutputSlot = new InvSlotOutput(this, "OuputslagSlot", 4, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 5, 2);
        this.maxprogress = 6000;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("heat");
        this.progress = nbttagcompound.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("heat", this.heat);
        nbttagcompound.func_74768_a("progress", this.progress);
    }

    public static void init() {
        Recipes.blastfurance = new BasicMachineRecipeManager();
        TileEntityBlastFurnace.addRecipe("dustIron", 1, Ic2Items.advIronIngot, Ic2Items.slag);
        TileEntityBlastFurnace.addRecipe("crushedIron", 1, Ic2Items.advIronIngot, Ic2Items.slag);
        TileEntityBlastFurnace.addRecipe("crushedPurifiedIron", 1, Ic2Items.advIronIngot, Ic2Items.slag);
        TileEntityBlastFurnace.addRecipe(new ItemStack(Items.field_151042_j), 1, Ic2Items.advIronIngot, Ic2Items.slag);
        TileEntityBlastFurnace.addRecipe(new ItemStack(Blocks.field_150366_p), 1, Ic2Items.advIronIngot, Ic2Items.slag);
    }

    public static void addRecipe(ItemStack input, int amount, ItemStack ... output) {
        TileEntityBlastFurnace.addRecipe(new RecipeInputItemStack(input, amount), output);
    }

    public static void addRecipe(String input, int amount, ItemStack ... output) {
        TileEntityBlastFurnace.addRecipe(new RecipeInputOreDict(input, amount), output);
    }

    public static void addRecipe(IRecipeInput input, ItemStack ... output) {
        Recipes.blastfurance.addRecipe(input, null, output);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.heatup();
        if (this.isHot()) {
            this.newActive = this.work();
        }
        if (this.getActive() != this.newActive) {
            this.setActive(this.newActive);
        }
        this.redstonePowered = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            if (((IUpgradeItem)stack.func_77973_b()).useRedstoneinverter(stack, this)) {
                this.redstonePowered = true;
            }
            if (!((IUpgradeItem)stack.func_77973_b()).onTick(stack, this)) continue;
            super.func_70296_d();
        }
        this.setRedstonePowered(this.redstonePowered);
    }

    private boolean work() {
        if (!this.outputSlot.canAdd(Ic2Items.advIronIngot) || !this.slagOutputSlot.canAdd(Ic2Items.slag)) {
            return false;
        }
        if (this.progress == 0 && !this.inputSlot.isEmpty()) {
            this.inputSlot.consume(1);
            ++this.progress;
            return true;
        }
        if ((this.progress == 1 || this.progress == 1000 || this.progress == 2000 || this.progress == 3000 || this.progress == 4000 || this.progress == 5000) && !this.airSlot.isEmpty() && this.airOutputSlot.canAdd(Ic2Items.cell)) {
            this.airSlot.consume(1);
            this.airOutputSlot.add(Ic2Items.cell);
            ++this.progress;
            if (this.outOfAir) {
                this.outOfAir = false;
            }
            return true;
        }
        if (this.progress >= this.maxprogress) {
            this.outputSlot.add(Ic2Items.advIronIngot);
            this.slagOutputSlot.add(Ic2Items.slag);
            this.progress = 0;
            return false;
        }
        if (this.progress != 0 && this.progress != 1 && this.progress != 1000 && this.progress != 2000 && this.progress != 3000 && this.progress != 4000 && this.progress != 5000) {
            ++this.progress;
            return true;
        }
        if (this.progress != 0 && !this.outOfAir) {
            this.outOfAir = true;
        }
        return false;
    }

    private void heatup() {
        boolean coolingPerTick = true;
        int heatRequested = 0;
        int gainhU = 0;
        if (!(this.inputSlot.isEmpty() && this.progress < 1 || this.heat > maxHeat)) {
            heatRequested = maxHeat - this.heat + 100;
        } else if (this.isRedstonePowered() && this.heat <= maxHeat) {
            heatRequested = maxHeat - this.heat + 100;
        }
        if (heatRequested > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof IHeatSource) {
                gainhU = ((IHeatSource)te).requestHeat(dir.getOpposite(), heatRequested);
                this.heat += gainhU;
            }
            if (gainhU == 0) {
                this.heat -= Math.min(this.heat, 1);
            }
        } else {
            this.heat -= Math.min(this.heat, 1);
        }
    }

    public boolean isHot() {
        return this.heat >= maxHeat;
    }

    public int gaugeHeatScaled(int i) {
        return i * this.heat / maxHeat;
    }

    public int gaugeprogress(int i) {
        return this.progress * i / this.maxprogress;
    }

    public int getprogresspercent() {
        return (int)((float)this.progress / (float)this.maxprogress * 100.0f);
    }

    public int getheatpercent() {
        return (int)((float)this.heat / (float)maxHeat * 100.0f);
    }

    public ContainerBase<TileEntityBlastFurnace> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBlastFurnace(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiBlastFurnace(new ContainerBlastFurnace(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Blast Furnace";
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
    }

    @Override
    public double getEnergy() {
        return 40.0;
    }

    @Override
    public boolean useEnergy(double amount) {
        return true;
    }

    public boolean isRedstonePowered() {
        if (this.redstonePowered) {
            return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setRedstonePowered(boolean redstone) {
        if (this.redstonePowered != redstone) {
            this.redstonePowered = redstone;
        }
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.ejectorUpgrade);
        itemstack.add(Ic2Items.redstoneinvUpgrade);
        itemstack.add(Ic2Items.pullingUpgrade);
        return itemstack;
    }
}

