/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.Ic2Player;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerAdvMiner;
import ic2.core.block.machine.gui.GuiAdvMiner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.init.MainConfig;
import ic2.core.item.IUpgradeItem;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityAdvMiner
extends TileEntityElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener,
IUpgradableBlock {
    private final List<ItemStack> itemstack = new ArrayList<ItemStack>();
    private int currectblockscanncount;
    private int blockscanncount;
    public final int defaultTier;
    public final int workTick;
    public boolean blacklist = true;
    public boolean silktouch = false;
    public boolean redstonePowered = false;
    public int energyConsume = 512;
    public int xcounter = 99;
    public int zcounter = 99;
    private int minelayer = -1;
    private int minetargetX = -1;
    private int minetargetZ = -1;
    private short ticker = 0;
    public final InvSlotConsumableId scannerSlot = new InvSlotConsumableId((TileEntityInventory)this, "scanner", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.odScanner.func_77973_b(), Ic2Items.ovScanner.func_77973_b());
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    public final InvSlot ListSlot = new InvSlot(this, "list", 8, null, 15);

    public TileEntityAdvMiner() {
        super(4000000, 3, 0);
        this.defaultTier = 3;
        this.workTick = 20;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            if (this.minelayer < 0) {
                this.minelayer = this.field_145848_d - 1;
            }
            this.setUpgradestat();
        }
    }

    private void chargeTool() {
        if (!this.scannerSlot.isEmpty()) {
            this.energy -= ElectricItem.manager.charge(this.scannerSlot.get(), this.energy, 2, false, false);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.chargeTool();
        this.setUpgradestat();
        if (this.work()) {
            this.func_70296_d();
            if (!this.getActive()) {
                this.setActive(true);
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
    }

    private boolean work() {
        if (this.energy < (double)this.energyConsume) {
            return false;
        }
        if (!this.isRedstonePowered()) {
            return false;
        }
        if (this.minelayer == 0) {
            return false;
        }
        if (this.scannerSlot.isEmpty()) {
            return false;
        }
        if (this.scannerSlot.get().func_77973_b() instanceof ItemScanner && !((ItemScanner)this.scannerSlot.get().func_77973_b()).haveChargeforScan(this.scannerSlot.get())) {
            return false;
        }
        int range = 0;
        if (this.scannerSlot.get().func_77973_b() == Ic2Items.odScanner.func_77973_b()) {
            range = 16;
        }
        if (this.scannerSlot.get().func_77973_b() == Ic2Items.ovScanner.func_77973_b()) {
            range = 32;
        }
        if (this.ticker == this.workTick) {
            this.currectblockscanncount = this.blockscanncount;
            while (this.minelayer > 0 && this.currectblockscanncount > 0) {
                Block block;
                if (this.xcounter == 99) {
                    this.xcounter = 0 - range / 2;
                }
                if (this.zcounter == 99) {
                    this.zcounter = 0 - range / 2;
                }
                if (this.xcounter <= range / 2) {
                    if (this.zcounter < range / 2) {
                        this.minetargetX = this.field_145851_c - this.xcounter;
                        this.minetargetZ = this.field_145849_e - this.zcounter;
                        ++this.zcounter;
                    } else {
                        this.minetargetX = this.field_145851_c - this.xcounter;
                        this.minetargetZ = this.field_145849_e - this.zcounter;
                        ++this.xcounter;
                        this.zcounter = 0 - range / 2;
                    }
                } else {
                    --this.minelayer;
                    this.xcounter = 0 - range / 2;
                    this.zcounter = 0 - range / 2;
                    continue;
                }
                if (this.scannerSlot.get().func_77973_b() instanceof ItemScanner) {
                    ((ItemScanner)this.scannerSlot.get().func_77973_b()).discharge(this.scannerSlot.get(), 64);
                }
                if (!(block = this.field_145850_b.func_147439_a(this.minetargetX, this.minelayer, this.minetargetZ)).isAir((IBlockAccess)this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ) && this.canMine(this.minetargetX, this.minelayer, this.minetargetZ, block)) {
                    this.doMine(block);
                    break;
                }
                --this.currectblockscanncount;
            }
            this.ticker = 0;
        } else {
            this.ticker = (short)(this.ticker + 1);
        }
        return true;
    }

    public void doMine(Block block) {
        if (this.silktouch && block.canSilkHarvest(this.field_145850_b, (EntityPlayer)new Ic2Player(this.field_145850_b), this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ))) {
            if (Item.func_150898_a((Block)block) != null && StackUtil.check(new ItemStack(Item.func_150898_a((Block)block), 1, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ)))) {
                StackUtil.distribute(this, new ItemStack(Item.func_150898_a((Block)block), 1, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ)), false);
            }
        } else {
            StackUtil.distributeDrop(this, block.getDrops(this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ), 0));
        }
        this.field_145850_b.func_147468_f(this.minetargetX, this.minelayer, this.minetargetZ);
        this.energy -= (double)this.energyConsume;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMine(int x, int y, int z, Block block) {
        this.itemstack.clear();
        if (block.hasTileEntity(this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ))) {
            ItemStack stack = new ItemStack(block, 1, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ));
            int max = 0;
            for (Map.Entry<IRecipeInput, Integer> entry : IC2.valuableOres.entrySet()) {
                if (!entry.getKey().matches(stack)) continue;
                ++max;
            }
            if (max == 0) {
                return false;
            }
        }
        if (block instanceof IFluidBlock || block instanceof BlockFluidClassic || block instanceof BlockStaticLiquid || block instanceof BlockDynamicLiquid) {
            return false;
        }
        if (block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f) {
            return false;
        }
        if (this.silktouch && block.canSilkHarvest(this.field_145850_b, (EntityPlayer)new Ic2Player(this.field_145850_b), this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ))) {
            if (Item.func_150898_a((Block)block) == null) return false;
            if (!StackUtil.check(new ItemStack(Item.func_150898_a((Block)block), 1, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ)))) return false;
            this.itemstack.add(new ItemStack(Item.func_150898_a((Block)block), 1, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ)));
        } else {
            this.itemstack.addAll(block.getDrops(this.field_145850_b, this.minetargetX, this.minelayer, this.minetargetZ, this.field_145850_b.func_72805_g(this.minetargetX, this.minelayer, this.minetargetZ), 0));
        }
        if (this.itemstack.isEmpty()) return false;
        if (this.blacklist) {
            for (int i = 0; i < this.ListSlot.size(); ++i) {
                if (this.ListSlot.get(i) == null || !StackUtil.isStackEqual(this.itemstack.get(0), this.ListSlot.get(i))) continue;
                return false;
            }
            return true;
        } else {
            for (int i = 0; i < this.ListSlot.size(); ++i) {
                if (this.ListSlot.get(i) == null || !StackUtil.isStackEqual(this.itemstack.get(0), this.ListSlot.get(i))) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.minelayer = nbtTagCompound.func_74762_e("minelayer");
        this.xcounter = nbtTagCompound.func_74762_e("xcounter");
        this.zcounter = nbtTagCompound.func_74762_e("zcounter");
        this.blacklist = nbtTagCompound.func_74767_n("blacklist");
        this.silktouch = nbtTagCompound.func_74767_n("silktouch");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("minelayer", this.minelayer);
        nbtTagCompound.func_74768_a("xcounter", this.xcounter);
        nbtTagCompound.func_74768_a("zcounter", this.zcounter);
        nbtTagCompound.func_74757_a("blacklist", this.blacklist);
        nbtTagCompound.func_74757_a("silktouch", this.silktouch);
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                if (this.getActive()) break;
                this.minelayer = this.field_145848_d - 1;
                this.xcounter = 99;
                this.zcounter = 99;
                break;
            }
            case 1: {
                if (this.getActive()) break;
                this.blacklist = !this.blacklist;
                break;
            }
            case 2: {
                if (this.getActive()) break;
                this.silktouch = !this.silktouch;
            }
        }
    }

    public void setUpgradestat() {
        int extraTier = 0;
        int scannMultiplier = 1;
        this.redstonePowered = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
            if (stack.func_77960_j() == 0) {
                scannMultiplier += stack.field_77994_a;
            }
            if (!((IUpgradeItem)stack.func_77973_b()).useRedstoneinverter(stack, this)) continue;
            this.redstonePowered = true;
        }
        this.setTier(TileEntityAdvMiner.applyModifier(this.defaultTier, extraTier, 1.0));
        this.blockscanncount = 5 * scannMultiplier;
        this.setRedstonePowered(this.redstonePowered);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public ContainerBase<TileEntityAdvMiner> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAdvMiner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiAdvMiner(new ContainerAdvMiner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstonePowered) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public void setRedstonePowered(boolean redstone) {
        if (this.redstonePowered != redstone) {
            this.redstonePowered = redstone;
        }
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public String func_145825_b() {
        return "AdvMiner";
    }

    public int getminelayer() {
        return this.minelayer;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        float energyRetainedInStorageBlockDrops = ConfigUtil.getFloat(MainConfig.get(), "balance/energyRetainedInStorageBlockDrops");
        if (energyRetainedInStorageBlockDrops > 0.0f) {
            NBTTagCompound nbttagcompound = StackUtil.getOrCreateNbtData(ret);
            nbttagcompound.func_74780_a("energy", this.energy * (double)energyRetainedInStorageBlockDrops);
        }
        return ret;
    }

    @Override
    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> itemstack = new ArrayList<ItemStack>();
        itemstack.add(Ic2Items.overclockerUpgrade);
        itemstack.add(Ic2Items.redstoneinvUpgrade);
        return itemstack;
    }
}

