/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.util.LogCategory;
import ic2.core.util.Vector3;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.oredict.OreDictionary;

public final class Util {
    private static final Map<Class<?>, Boolean> checkedClasses = new HashMap();

    public static int roundToNegInf(float x) {
        int ret = (int)x;
        if ((float)ret > x) {
            --ret;
        }
        return ret;
    }

    public static int roundToNegInf(double x) {
        int ret = (int)x;
        if ((double)ret > x) {
            --ret;
        }
        return ret;
    }

    public static int limit(int value, int min, int max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static double limit(double value, double min, double max) {
        if (Double.isNaN(value) || value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static double map(double value, double srcMax, double dstMax) {
        if (value < 0.0 || Double.isNaN(value)) {
            value = 0.0;
        }
        if (value > srcMax) {
            value = srcMax;
        }
        return value / srcMax * dstMax;
    }

    public static double lerp(double start, double end, double fraction) {
        assert (fraction >= 0.0 && fraction <= 1.0);
        return start + (end - start) * fraction;
    }

    public static int square(int x) {
        return x * x;
    }

    public static double square(double x) {
        return x * x;
    }

    public static boolean isSimilar(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    public static int countInArray(Object[] oa, Class<?> cls) {
        int ret = 0;
        for (Object o : oa) {
            if (!cls.isAssignableFrom(o.getClass())) continue;
            ++ret;
        }
        return ret;
    }

    public static InternalName getColorName(int color) {
        switch (color) {
            case 0: {
                return InternalName.black;
            }
            case 1: {
                return InternalName.red;
            }
            case 2: {
                return InternalName.green;
            }
            case 3: {
                return InternalName.brown;
            }
            case 4: {
                return InternalName.blue;
            }
            case 5: {
                return InternalName.purple;
            }
            case 6: {
                return InternalName.cyan;
            }
            case 7: {
                return InternalName.lightGray;
            }
            case 8: {
                return InternalName.gray;
            }
            case 9: {
                return InternalName.pink;
            }
            case 10: {
                return InternalName.lime;
            }
            case 11: {
                return InternalName.yellow;
            }
            case 12: {
                return InternalName.lightBlue;
            }
            case 13: {
                return InternalName.magenta;
            }
            case 14: {
                return InternalName.orange;
            }
            case 15: {
                return InternalName.white;
            }
        }
        return null;
    }

    public static boolean inDev() {
        return System.getProperty("INDEV") != null;
    }

    public static boolean hasAssertions() {
        boolean ret = false;
        if (!$assertionsDisabled) {
            ret = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return ret;
    }

    public static boolean matchesOD(ItemStack stack, Object match) {
        if (match instanceof ItemStack) {
            return stack == null || stack.func_77969_a((ItemStack)match);
        }
        if (match instanceof String) {
            if (stack == null) {
                return false;
            }
            for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)oreId).equals(match)) continue;
                return true;
            }
            return false;
        }
        return stack == match;
    }

    public static String asString(TileEntity te) {
        if (te == null) {
            return null;
        }
        return te + " (" + Util.formatPosition(te) + ")";
    }

    public static String formatPosition(TileEntity te) {
        return Util.formatPosition((IBlockAccess)te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static String formatPosition(IBlockAccess world, int x, int y, int z) {
        int dimId = world instanceof World && ((World)world).field_73011_w != null ? ((World)world).field_73011_w.field_76574_g : Integer.MIN_VALUE;
        return Util.formatPosition(dimId, x, y, z);
    }

    public static String formatPosition(int dimId, int x, int y, int z) {
        return "dim " + dimId + ": " + x + "/" + y + "/" + z;
    }

    public static String toSiString(double value, int digits) {
        int dVal;
        String si;
        double mul;
        if (value == 0.0) {
            return "0 ";
        }
        if (Double.isNaN(value)) {
            return "NaN ";
        }
        String ret = "";
        if (value < 0.0) {
            ret = "-";
            value = -value;
        }
        if (Double.isInfinite(value)) {
            return ret + "\u221e ";
        }
        double log = Math.log10(value);
        if (log >= 0.0) {
            int reduce = (int)Math.floor(log / 3.0);
            mul = 1.0 / Math.pow(10.0, reduce * 3);
            switch (reduce) {
                case 0: {
                    si = "";
                    break;
                }
                case 1: {
                    si = "k";
                    break;
                }
                case 2: {
                    si = "M";
                    break;
                }
                case 3: {
                    si = "G";
                    break;
                }
                case 4: {
                    si = "T";
                    break;
                }
                case 5: {
                    si = "P";
                    break;
                }
                case 6: {
                    si = "E";
                    break;
                }
                case 7: {
                    si = "Z";
                    break;
                }
                case 8: {
                    si = "Y";
                    break;
                }
                default: {
                    si = "E" + reduce * 3;
                    break;
                }
            }
        } else {
            int expand = (int)Math.ceil(-log / 3.0);
            mul = Math.pow(10.0, expand * 3);
            switch (expand) {
                case 0: {
                    si = "";
                    break;
                }
                case 1: {
                    si = "m";
                    break;
                }
                case 2: {
                    si = "\u00b5";
                    break;
                }
                case 3: {
                    si = "n";
                    break;
                }
                case 4: {
                    si = "p";
                    break;
                }
                case 5: {
                    si = "f";
                    break;
                }
                case 6: {
                    si = "a";
                    break;
                }
                case 7: {
                    si = "z";
                    break;
                }
                case 8: {
                    si = "y";
                    break;
                }
                default: {
                    si = "E-" + expand * 3;
                }
            }
        }
        int iVal = (int)Math.floor(value *= mul);
        value -= (double)iVal;
        int iDigits = 1;
        if (iVal > 0) {
            iDigits = (int)((double)iDigits + Math.floor(Math.log10(iVal)));
        }
        if ((double)(dVal = (int)Math.round(value * (mul = Math.pow(10.0, digits - iDigits)))) >= mul) {
            dVal = (int)((double)dVal - mul);
            iDigits = 1;
            if (++iVal > 0) {
                iDigits = (int)((double)iDigits + Math.floor(Math.log10(iVal)));
            }
        }
        ret = ret + Integer.toString(iVal);
        if (digits > iDigits && dVal != 0) {
            ret = ret + String.format(".%0" + (digits - iDigits) + "d", dVal);
        }
        ret = ret.replaceFirst("(\\.\\d*?)0+$", "$1");
        return ret + " " + si;
    }

    public static void exit(int status) {
        Method exit = null;
        try {
            exit = Class.forName("java.lang.Shutdown").getDeclaredMethod("exit", Integer.TYPE);
            exit.setAccessible(true);
        }
        catch (Exception e) {
            IC2.log.warn(LogCategory.General, e, "Method lookup failed.");
            try {
                Field security = System.class.getDeclaredField("security");
                security.setAccessible(true);
                security.set(null, null);
                exit = System.class.getMethod("exit", Integer.TYPE);
            }
            catch (Exception f) {
                throw new Error(f);
            }
        }
        try {
            exit.invoke(null, status);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static MovingObjectPosition traceEntities(EntityPlayer player, boolean alwaysCollide) {
        Vector3 start = new Vector3(player.field_70165_t, player.field_70163_u + (double)(player.field_70170_p.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e()), player.field_70161_v);
        double distance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0;
        return Util.traceEntities(player.field_70170_p, start.toVec3(), new Vector3(player.func_70040_Z()).scale(distance).add(start).toVec3(), (Entity)player, alwaysCollide);
    }

    public static MovingObjectPosition traceEntities(EntityPlayer player, Vec3 end, boolean alwaysCollide) {
        Vector3 start = new Vector3(player.field_70165_t, player.field_70163_u + (double)(player.field_70170_p.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e()), player.field_70161_v);
        return Util.traceEntities(player.field_70170_p, start.toVec3(), end, (Entity)player, alwaysCollide);
    }

    public static MovingObjectPosition traceEntities(World world, Vec3 start, Vec3 end, Entity exclude, boolean alwaysCollide) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)Math.min(start.field_72450_a, end.field_72450_a), (double)Math.min(start.field_72448_b, end.field_72448_b), (double)Math.min(start.field_72449_c, end.field_72449_c), (double)Math.max(start.field_72450_a, end.field_72450_a), (double)Math.max(start.field_72448_b, end.field_72448_b), (double)Math.max(start.field_72449_c, end.field_72449_c));
        List entities = world.func_72839_b(exclude, aabb);
        MovingObjectPosition closest = null;
        double minDist = Double.POSITIVE_INFINITY;
        for (Entity entity : entities) {
            double distance;
            MovingObjectPosition pos;
            if (!alwaysCollide && !entity.func_70067_L() || (pos = entity.field_70121_D.func_72327_a(start, end)) == null || !((distance = start.func_72436_e(pos.field_72307_f)) < minDist)) continue;
            pos.field_72308_g = entity;
            pos.field_72313_a = MovingObjectPosition.MovingObjectType.ENTITY;
            minDist = distance;
            closest = pos;
        }
        return closest;
    }

    public static Chunk getLoadedChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = null;
        if (world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer cps = (ChunkProviderServer)world.func_72863_F();
            try {
                chunk = (Chunk)cps.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ));
            }
            catch (NoSuchFieldError e) {
                if (cps.func_73149_a(chunkX, chunkZ)) {
                    chunk = cps.func_73154_d(chunkX, chunkZ);
                }
            }
        } else {
            chunk = world.func_72964_e(chunkX, chunkZ);
        }
        if (chunk instanceof EmptyChunk) {
            return null;
        }
        return chunk;
    }

    public static boolean checkMcCoordBounds(int x, int y, int z) {
        return Util.checkMcCoordBounds(x, z) && y >= 0 && y < 256;
    }

    public static boolean checkMcCoordBounds(int x, int z) {
        return x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000;
    }

    public static boolean checkInterfaces(Class<?> cls) {
        Boolean cached = checkedClasses.get(cls);
        if (cached != null) {
            return cached;
        }
        HashSet interfaces = new HashSet();
        Class<?> c = cls;
        do {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
            }
        } while ((c = c.getSuperclass()) != null);
        boolean result = true;
        for (Class clazz : interfaces) {
            for (Method method : clazz.getMethods()) {
                boolean found = false;
                c = cls;
                do {
                    try {
                        Method match = c.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        if (match.getReturnType() != method.getReturnType()) continue;
                        found = true;
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                } while ((c = c.getSuperclass()) != null);
                if (found) continue;
                IC2.log.info(LogCategory.General, "Can't find method %s.%s in %s.", method.getDeclaringClass(), method.getName(), cls.getName());
                result = false;
            }
        }
        checkedClasses.put(cls, result);
        return result;
    }
}

