/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.item.IItemHudInfo;
import ic2.core.Ic2Items;
import ic2.core.block.IUpgradableBlock;
import ic2.core.init.InternalName;
import ic2.core.item.IUpgradeItem;
import ic2.core.item.ItemIC2;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemUpgradeModule
extends ItemIC2
implements IUpgradeItem,
IItemHudInfo {
    private static DecimalFormat decimalformat = new DecimalFormat("0.##");
    private final int fluidAmountPerTick;

    public ItemUpgradeModule(InternalName internalName) {
        super(internalName);
        this.func_77627_a(true);
        Ic2Items.overclockerUpgrade = new ItemStack((Item)this, 1, Type.Overclocker.ordinal());
        Ic2Items.transformerUpgrade = new ItemStack((Item)this, 1, Type.Transformer.ordinal());
        Ic2Items.energyStorageUpgrade = new ItemStack((Item)this, 1, Type.EnergyStorage.ordinal());
        Ic2Items.ejectorUpgrade = new ItemStack((Item)this, 1, Type.Ejector.ordinal());
        Ic2Items.fluidEjectorUpgrade = new ItemStack((Item)this, 1, Type.FluidEjector.ordinal());
        Ic2Items.redstoneinvUpgrade = new ItemStack((Item)this, 1, Type.RedstoneInverter.ordinal());
        this.fluidAmountPerTick = 50;
    }

    @Override
    public String getTextureFolder() {
        return "upgrade";
    }

    @Override
    public String getTextureName(int index) {
        if (index < Type.Values.length) {
            return super.getTextureName(index);
        }
        if (index < Type.Values.length + 6) {
            return InternalName.ejectorUpgrade.name() + "." + (index - Type.Values.length);
        }
        if (index < Type.Values.length + 12) {
            return InternalName.fluidEjectorUpgrade.name() + "." + (index - Type.Values.length - 6);
        }
        return null;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return null;
        }
        switch (type) {
            case Ejector: 
            case FluidEjector: {
                byte dir = StackUtil.getOrCreateNbtData(stack).func_74771_c("dir");
                if (dir < 1 || dir > 6) break;
                int textureIndex = Type.Values.length + dir - 1;
                switch (type) {
                    case Ejector: {
                        textureIndex += 0;
                        break;
                    }
                    case FluidEjector: {
                        textureIndex += 6;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return super.func_77617_a(textureIndex);
            }
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public List<String> getHudInfo(ItemStack stack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add("Maschine Upgrade");
        return info;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return null;
        }
        InternalName ret = null;
        switch (type) {
            case Overclocker: {
                ret = InternalName.overclockerUpgrade;
                break;
            }
            case Transformer: {
                ret = InternalName.transformerUpgrade;
                break;
            }
            case EnergyStorage: {
                ret = InternalName.energyStorageUpgrade;
                break;
            }
            case Ejector: {
                ret = InternalName.ejectorUpgrade;
                break;
            }
            case FluidEjector: {
                ret = InternalName.fluidEjectorUpgrade;
                break;
            }
            case RedstoneInverter: {
                ret = InternalName.redstoneinvUpgrade;
            }
        }
        return "ic2." + ret.name();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return;
        }
        super.func_77624_a(stack, player, list, par4);
        switch (type) {
            case Overclocker: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.time", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(this.getProcessTimeMultiplier(stack, null), stack.field_77994_a))}));
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.overclocker.power", (Object[])new Object[]{decimalformat.format(100.0 * Math.pow(this.getEnergyDemandMultiplier(stack, null), stack.field_77994_a))}));
                break;
            }
            case Transformer: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.transformer", (Object[])new Object[]{this.getExtraTier(stack, null) * stack.field_77994_a}));
                break;
            }
            case EnergyStorage: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.storage", (Object[])new Object[]{this.getExtraEnergyStorage(stack, null) * stack.field_77994_a}));
                break;
            }
            case Ejector: 
            case FluidEjector: {
                String side;
                switch (StackUtil.getOrCreateNbtData(stack).func_74771_c("dir") - 1) {
                    case 0: {
                        side = "ic2.dir.west";
                        break;
                    }
                    case 1: {
                        side = "ic2.dir.east";
                        break;
                    }
                    case 2: {
                        side = "ic2.dir.bottom";
                        break;
                    }
                    case 3: {
                        side = "ic2.dir.top";
                        break;
                    }
                    case 4: {
                        side = "ic2.dir.north";
                        break;
                    }
                    case 5: {
                        side = "ic2.dir.south";
                        break;
                    }
                    default: {
                        side = "ic2.tooltip.upgrade.ejector.anyside";
                    }
                }
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.ejector", (Object[])new Object[]{StatCollector.func_74838_a((String)side)}));
                break;
            }
            case RedstoneInverter: {
                list.add(StatCollector.func_74837_a((String)"ic2.tooltip.upgrade.redstone", (Object[])new Object[0]));
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return false;
        }
        switch (type) {
            case Ejector: 
            case FluidEjector: {
                int dir = 1 + Direction.fromSideValue(side).ordinal();
                NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
                if (nbtData.func_74771_c("dir") == dir) {
                    nbtData.func_74774_a("dir", (byte)0);
                } else {
                    nbtData.func_74774_a("dir", (byte)dir);
                }
                return true;
            }
        }
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            ItemStack stack = new ItemStack((Item)this, 1, meta);
            if (this.func_77667_c(stack) == null) continue;
            itemList.add(stack);
        }
    }

    @Override
    public boolean useRedstoneinverter(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return false;
        }
        switch (type) {
            case RedstoneInverter: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getExtraProcessTime(ItemStack stack, IUpgradableBlock parent) {
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case Overclocker: {
                return 0.7;
            }
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack stack, IUpgradableBlock parent) {
        return 0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case Overclocker: {
                return 1.6;
            }
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case EnergyStorage: {
                return 10000;
            }
        }
        return 0;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack stack, IUpgradableBlock parent) {
        return 1.0;
    }

    @Override
    public int getExtraTier(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case Transformer: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean onTick(ItemStack stack, IUpgradableBlock parent) {
        Type type = this.getType(stack.func_77960_j());
        if (type == null) {
            return false;
        }
        boolean ret = false;
        switch (type) {
            case Ejector: {
                for (int i = 0; i < parent.getOutputSize(); ++i) {
                    ItemStack output = parent.getOutput(i);
                    if (output == null || !(parent.getEnergy() >= 20.0)) continue;
                    int amount = Math.min(output.field_77994_a, (int)(parent.getEnergy() / 20.0));
                    byte rawDir = StackUtil.getOrCreateNbtData(stack).func_74771_c("dir");
                    if (rawDir < 1 || rawDir > 6) {
                        amount = StackUtil.distribute((TileEntity)parent, StackUtil.copyWithSize(output, amount), false);
                    } else {
                        Direction dir = Direction.directions[rawDir - 1];
                        IInventory inv = StackUtil.getAdjacentInventory((TileEntity)parent, dir);
                        if (inv == null) continue;
                        amount = StackUtil.putInInventory(inv, dir.getInverse(), StackUtil.copyWithSize(output, amount), false);
                    }
                    if (amount == 0) continue;
                    output.field_77994_a -= amount;
                    if (output.field_77994_a <= 0) {
                        parent.setOutput(i, null);
                    }
                    parent.useEnergy(20 * amount);
                    ret = true;
                }
                break;
            }
            case FluidEjector: {
                if (!(parent instanceof IFluidHandler)) {
                    return false;
                }
                IFluidHandler fParent = (IFluidHandler)parent;
                byte rawDir = StackUtil.getOrCreateNbtData(stack).func_74771_c("dir");
                if (rawDir < 1 || rawDir > 6) {
                    ret = LiquidUtil.distributeAll(fParent, this.fluidAmountPerTick) > 0;
                    break;
                }
                Direction dir = Direction.directions[rawDir - 1];
                TileEntity te = dir.applyToTileEntity((TileEntity)parent);
                if (!(te instanceof IFluidHandler)) {
                    return false;
                }
                IFluidHandler target = (IFluidHandler)te;
                ret = LiquidUtil.transfer(fParent, dir, target, this.fluidAmountPerTick) != null;
                break;
            }
            default: {
                return false;
            }
        }
        return ret;
    }

    @Override
    public void onProcessEnd(ItemStack stack, IUpgradableBlock parent, List<ItemStack> output) {
    }

    private Type getType(int meta) {
        if (meta < 0 || meta >= Type.Values.length) {
            return null;
        }
        return Type.Values[meta];
    }

    private static enum Type {
        Overclocker,
        Transformer,
        EnergyStorage,
        Ejector,
        FluidEjector,
        RedstoneInverter;

        public static final Type[] Values;

        static {
            Values = Type.values();
        }
    }
}

