/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ICustomDamageItem;
import ic2.core.init.InternalName;
import ic2.core.item.ItemGradual;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemGradualInt
extends ItemGradual
implements ICustomDamageItem {
    private final int maxDmg;

    public ItemGradualInt(InternalName internalName, int maxdmg) {
        super(internalName);
        this.maxDmg = maxdmg;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        return nbt.func_74762_e("advDmg");
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.maxDmg;
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74768_a("advDmg", damage);
        int maxStackDamage = stack.func_77958_k();
        if (maxStackDamage > 2) {
            stack.func_77964_b(1 + (int)Util.map(damage, this.maxDmg, maxStackDamage - 2));
        }
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        this.setCustomDamage(stack, this.getCustomDamage(stack) + damage);
        return true;
    }

    public int getControlTagOfStack(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        return nbtData.func_74762_e("tag");
    }

    public void setControlTagOfStack(ItemStack stack, int tag) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        nbtData.func_74768_a("tag", tag);
    }
}

