/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.chunk.Chunk;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    private AudioSource audioSource = null;
    private static final int EventTeleport = 0;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.targetSet = nbttagcompound.func_74767_n("targetSet");
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("targetSet", this.targetSet);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
    }

    @Override
    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.targetSet) {
                boolean prevWorldChunkLoadOverride = this.field_145850_b.field_72987_B;
                this.field_145850_b.field_72987_B = true;
                Chunk chunk = this.field_145850_b.func_72863_F().func_73154_d(this.targetX >> 4, this.targetZ >> 4);
                this.field_145850_b.field_72987_B = prevWorldChunkLoadOverride;
                if (chunk == null || !StackUtil.equals(chunk.func_150810_a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF), Ic2Items.teleporter) || chunk.func_76628_c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.func_77960_j()) {
                    this.targetSet = false;
                    this.setActive(false);
                } else {
                    this.setActive(true);
                    List entitiesNearby = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2)));
                    if (!entitiesNearby.isEmpty()) {
                        double minDistanceSquared = Double.MAX_VALUE;
                        Entity closestEntity = null;
                        for (Entity entity : entitiesNearby) {
                            double distSquared;
                            if (entity.field_70154_o != null || !((distSquared = ((double)this.field_145851_c - entity.field_70165_t) * ((double)this.field_145851_c - entity.field_70165_t) + ((double)(this.field_145848_d + 1) - entity.field_70163_u) * ((double)(this.field_145848_d + 1) - entity.field_70163_u) + ((double)this.field_145849_e - entity.field_70161_v) * ((double)this.field_145849_e - entity.field_70161_v)) < minDistanceSquared)) continue;
                            minDistanceSquared = distSquared;
                            closestEntity = entity;
                        }
                        this.teleport(closestEntity);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (IC2.platform.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void teleport(Entity user) {
        double distance = Math.sqrt((this.field_145851_c - this.targetX) * (this.field_145851_c - this.targetX) + (this.field_145848_d - this.targetY) * (this.field_145848_d - this.targetY) + (this.field_145849_e - this.targetZ) * (this.field_145849_e - this.targetZ));
        int weight = this.getWeightOf(user);
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        if (user instanceof EntityPlayerMP) {
            ((EntityPlayerMP)user).func_70634_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.func_70033_W(), (double)this.targetZ + 0.5);
        } else {
            user.func_70080_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.func_70033_W(), (double)this.targetZ + 0.5, user.field_70177_z, user.field_70125_A);
        }
        IC2.network.get().initiateTileEntityEvent(this, 0, true);
        if (user instanceof EntityPlayer && distance >= 1000.0) {
            IC2.achievements.issueAchievement((EntityPlayer)user, "teleportFarAway");
        }
    }

    public void spawnBlueParticles(int n, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            this.field_145850_b.func_72869_a("reddust", (double)((float)x + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)(y + 1) + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)z + this.field_145850_b.field_73012_v.nextFloat()), -1.0, 0.0, 1.0);
            this.field_145850_b.func_72869_a("reddust", (double)((float)x + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)(y + 2) + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)z + this.field_145850_b.field_73012_v.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void consumeEnergy(int energy) {
        LinkedList<IEnergyStorage> energySources = new LinkedList<IEnergyStorage>();
        for (Direction direction : Direction.directions) {
            IEnergyStorage energySource;
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(energySource = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toForgeDirection()) || energySource.getStored() <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it = energySources.iterator();
            while (it.hasNext()) {
                IEnergyStorage energySource = (IEnergyStorage)it.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource.getStored() <= drain) {
                    energy -= energySource.getStored();
                    energySource.setStored(0);
                    it.remove();
                    continue;
                }
                energy -= drain;
                energySource.addEnergy(-drain);
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : Direction.directions) {
            IEnergyStorage storage;
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(storage = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toForgeDirection())) continue;
            energy += storage.getStored();
        }
        return energy;
    }

    public int getWeightOf(Entity user) {
        boolean teleporterUseInventoryWeight = ConfigUtil.getBool(MainConfig.get(), "balance/teleporterUseInventoryWeight");
        int weight = 0;
        Entity ce = user;
        while (ce != null) {
            int i;
            if (ce instanceof EntityItem) {
                ItemStack is = ((EntityItem)ce).func_92059_d();
                weight += 100 * is.field_77994_a / is.func_77976_d();
            } else if (ce instanceof EntityAnimal || ce instanceof EntityMinecart || ce instanceof EntityBoat) {
                weight += 100;
            } else if (ce instanceof EntityPlayer) {
                weight += 1000;
                if (teleporterUseInventoryWeight) {
                    InventoryPlayer inv = ((EntityPlayer)ce).field_71071_by;
                    for (i = 0; i < inv.field_70462_a.length; ++i) {
                        if (inv.field_70462_a[i] == null) continue;
                        weight += 100 * inv.field_70462_a[i].field_77994_a / inv.field_70462_a[i].func_77976_d();
                    }
                }
            } else if (ce instanceof EntityGhast) {
                weight += 2500;
            } else if (ce instanceof EntityDragon) {
                weight += 10000;
            } else if (ce instanceof EntityCreature) {
                weight += 500;
            }
            if (teleporterUseInventoryWeight && ce instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)ce;
                int n = i = ce instanceof EntityPlayer ? 1 : 0;
                while (i <= 4) {
                    ItemStack item = living.func_71124_b(i);
                    if (item != null) {
                        weight += 100 * item.field_77994_a / item.func_77976_d();
                    }
                    ++i;
                }
            }
            ce = ce.field_70153_n;
        }
        return weight;
    }

    public void setTarget(int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        IC2.network.get().updateTileEntityField(this, "targetX");
        IC2.network.get().updateTileEntityField(this, "targetY");
        IC2.network.get().updateTileEntityField(this, "targetZ");
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(3);
        ret.add("targetX");
        ret.add("targetY");
        ret.add("targetZ");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.getDefaultVolume());
                IC2.audioManager.playOnce(new AudioPosition(this.field_145850_b, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.getDefaultVolume());
                this.spawnBlueParticles(20, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.spawnBlueParticles(20, this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ")", new Object[0]);
            }
        }
    }
}

