/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.BlockTileEntity;
import ic2.core.migration.BlockMigrate;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    public int tileEntityId;
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] lastRenderIcons;
    private int tesrMask;
    public int tesrTtl;
    private static final int defaultTesrTtl = 500;

    public void func_145829_t() {
        super.func_145829_t();
        IC2.tickHandler.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityBlock.this.func_145837_r() || !world.func_72899_e(TileEntityBlock.this.field_145851_c, TileEntityBlock.this.field_145848_d, TileEntityBlock.this.field_145849_e)) {
                    return;
                }
                TileEntityBlock.this.onLoaded();
                if (!TileEntityBlock.this.func_145837_r() && TileEntityBlock.this.enableUpdateEntity()) {
                    world.field_147482_g.add(TileEntityBlock.this);
                }
            }
        });
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.loaded = true;
        Block block = this.func_145838_q();
        if (block instanceof BlockMigrate) {
            ((BlockMigrate)block).migrate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tileEntityId = nbttagcompound.func_74762_e("tileEntityId");
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
        this.prevActive = this.active = nbttagcompound.func_74767_n("active");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("tileEntityId", this.tileEntityId);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74757_a("active", this.active);
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender() {
        Block block = this.func_145838_q();
        if (this.lastRenderIcons == null) {
            this.lastRenderIcons = new IIcon[6];
        }
        for (int side = 0; side < 6; ++side) {
            this.lastRenderIcons[side] = block.func_149673_e((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
        }
        this.tesrMask = 0;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !(oldBlock instanceof BlockMigrate) || !(newBlock instanceof BlockTileEntity);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active1) {
        this.active = active1;
        if (this.prevActive != active1) {
            IC2.network.get().updateTileEntityField(this, "active");
        }
        this.prevActive = active1;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("tileEntityId");
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int reRenderMask = 0;
            Block block = this.func_145838_q();
            if (this.lastRenderIcons == null) {
                reRenderMask = -1;
            } else {
                for (int side = 0; side < 6; ++side) {
                    IIcon newIcon;
                    IIcon oldIcon = this.lastRenderIcons[side];
                    if (oldIcon instanceof BlockTextureStitched) {
                        oldIcon = ((BlockTextureStitched)oldIcon).getRealTexture();
                    }
                    if ((newIcon = block.func_149673_e((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side)) instanceof BlockTextureStitched) {
                        newIcon = ((BlockTextureStitched)newIcon).getRealTexture();
                    }
                    if (oldIcon == newIcon) continue;
                    reRenderMask |= 1 << side;
                }
            }
            if (reRenderMask != 0) {
                if (reRenderMask < 0 || this.prevFacing != this.facing || block.func_149645_b() != IC2.platform.getRenderId("default")) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else {
                    this.tesrMask = reRenderMask;
                    this.tesrTtl = 500;
                }
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing1) {
        this.facing = facing1;
        if (this.prevFacing != facing1) {
            IC2.network.get().updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing1;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public boolean shouldRenderInPass(int pass) {
        return this.tesrMask != 0 && pass == 0;
    }

    public final int getTesrMask() {
        return this.tesrMask;
    }

    public void onBlockBreak(Block block, int meta) {
    }

    public String getTextureFolder() {
        return null;
    }

    public boolean onBlockActivated(EntityPlayer player, float xOffset, float yOffset, float zOffset, MutableBoolean result) {
        return false;
    }

    public void randomDisplayTick(Random random) {
    }

    public void adjustDrops(List<ItemStack> drops, int fortune) {
        drops.set(0, new ItemStack(Ic2Items.teBlock.func_77973_b(), 1, this.tileEntityId));
    }
}

