/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.resources;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ILatheItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

public class ItemLatheDefault
extends ItemIC2
implements ILatheItem {
    private final LatheMaterial material;
    private static final String location = IC2.textureDomain + ":textures/items/turnables/";
    private static final String tooltipPrefix = "ic2." + (Object)((Object)InternalName.itemTurningBlanks) + ".tooltip.";

    public ItemLatheDefault(LatheMaterial material) {
        super(material.name);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.material = material;
    }

    @Override
    public int getWidth(ItemStack stack) {
        return this.material.width;
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return "ic2." + (Object)((Object)InternalName.itemTurningBlanks) + (Object)((Object)this.material);
    }

    @Override
    public int[] getCurrentState(ItemStack stack) {
        if (stack == null) {
            return new int[0];
        }
        int[] ret = new int[5];
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("state")) {
            NBTTagCompound tag = (NBTTagCompound)stack.func_77978_p().func_74781_a("state");
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = tag.func_74764_b("l" + i) ? tag.func_74762_e("l" + i) : this.getWidth(stack);
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.getWidth(stack);
            }
        }
        return ret;
    }

    @Override
    public void setState(ItemStack stack, int position, int value) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.func_77978_p().func_74764_b("state")) {
            stack.field_77990_d.func_74782_a("state", (NBTBase)new NBTTagCompound());
        }
        ((NBTTagCompound)stack.func_77978_p().func_74781_a("state")).func_74768_a("l" + position, Math.max(Math.min(value, this.getWidth(stack)), 1));
    }

    @Override
    public ItemStack getOutputItem(ItemStack stack, int position) {
        switch (this.material) {
            case WOOD: {
                return new ItemStack(Items.field_151055_y);
            }
            case IRON: {
                return Ic2Items.smallIronDust;
            }
        }
        return null;
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack) {
        return new ResourceLocation(location + (Object)((Object)this.material) + ".png");
    }

    @Override
    public float getOutputChance(ItemStack stack, int position) {
        return this.material.chance;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        String localized;
        int[] state = this.getCurrentState(stack);
        int numState = ItemLatheDefault.getNumericState(state);
        String str = "ic2." + (Object)((Object)this.material.name) + ".tooltip." + Integer.toHexString(numState);
        if (str.equals(localized = StatCollector.func_74838_a((String)str))) {
            list.add(StatCollector.func_74838_a((String)"ic2.itemTurningBlanks.tooltip.blank"));
        } else {
            list.add(localized);
        }
        if (Keyboard.isKeyDown((int)42)) {
            int max = this.getWidth(stack);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < 5; ++j) {
                sb.append(StatCollector.func_74837_a((String)"ic2.Lathe.gui.info", (Object[])new Object[]{state[j], max}));
                sb.append("   ");
            }
            list.add(sb.toString());
        }
    }

    public static ItemStack getStackForState(ItemStack stack, int[] state) {
        if (stack == null) {
            return null;
        }
        if (state == null || state.length != 5 || !(stack.func_77973_b() instanceof ILatheItem)) {
            return stack.func_77946_l();
        }
        stack = stack.func_77946_l();
        ILatheItem l = (ILatheItem)stack.func_77973_b();
        for (int i = 0; i < 5; ++i) {
            l.setState(stack, i, state[i]);
        }
        return stack;
    }

    public static ItemStack getStackForState(ItemStack stack, int state) {
        return ItemLatheDefault.getStackForState(stack, ItemLatheDefault.getStateFromNumeric(state));
    }

    public static int getNumericState(int[] state) {
        if (state == null || state.length != 5) {
            return -1;
        }
        int i = 0;
        for (int j = 0; j < 5; ++j) {
            if (state[j] >= 16) continue;
            i += state[j];
            if (j == 4) continue;
            i <<= 4;
        }
        return i;
    }

    public static int[] getStateFromNumeric(int state) {
        int[] ret = new int[5];
        if (state == -1) {
            return ret;
        }
        for (int j = 4; j >= 0; --j) {
            ret[j] = state % 16;
            if (j == 0) continue;
            state >>= 4;
        }
        return ret;
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("state")) {
            if (super.getDamage(stack) == 0) {
                for (int i = 0; i < 5; ++i) {
                    this.setState(stack, i, this.getWidth(stack));
                }
            } else {
                int[] state = ItemLatheDefault.getStateFromNumeric(super.getDamage(stack));
                for (int i = 0; i < 5; ++i) {
                    this.setState(stack, i, state[i]);
                }
            }
        }
        this.setDamage(stack, ItemLatheDefault.getNumericState(this.getCurrentState(stack)));
        return super.getDamage(stack);
    }

    @Override
    public String getTextureName(int index) {
        return index == 0 ? super.getTextureName(0) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return super.func_77617_a(0);
    }

    public static enum LatheMaterial {
        WOOD(InternalName.itemTurningBlanksWood, 0.1f, 3),
        IRON(InternalName.itemTurningBlanks, 0.5f, 5);

        private InternalName name;
        private float chance;
        private int width;

        private LatheMaterial(InternalName name, float chance, int width) {
            this.name = name;
            this.chance = chance;
            this.width = width;
        }
    }
}

