/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.migration;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.init.InternalName;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMigrate
extends Block {
    private final boolean wildcardMeta;
    private final Integer[] newIds;

    public BlockMigrate(InternalName internalName, boolean wildcardMeta1, Integer ... newIds1) {
        super(Material.field_151573_f);
        this.wildcardMeta = wildcardMeta1;
        this.newIds = newIds1;
        this.func_149675_a(true);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.migrate(world, x, y, z);
    }

    public boolean migrate(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (!(this.wildcardMeta || meta < this.newIds.length && this.newIds[meta] != null)) {
            IC2.log.warn(LogCategory.Block, "Can't migrate block %s:%d at %s, no id mapping.", new Object[]{this, meta, Util.formatPosition((IBlockAccess)world, x, y, z)});
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBlock) {
            world.func_147465_d(x, y, z, StackUtil.getBlock(Ic2Items.teBlock), 0, 6);
            ((TileEntityBlock)te).tileEntityId = this.newIds[this.wildcardMeta ? 0 : meta];
            return true;
        }
        IC2.log.warn(LogCategory.Block, "Can't migrate block %s:%d at %s, no suitable te.", new Object[]{this, meta, Util.formatPosition((IBlockAccess)world, x, y, z)});
        return false;
    }
}

