/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemGradualInt;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemReactorMOX
extends ItemGradualInt
implements IReactorComponent {
    public final int numberOfCells;

    public ItemReactorMOX(InternalName internalName, int cells) {
        super(internalName, 10000);
        this.func_77625_d(64);
        this.numberOfCells = cells;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack stack, int x, int y, boolean heatRun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        for (int iteration = 0; iteration < this.numberOfCells; ++iteration) {
            float breedereffectiveness;
            int pulses = 1 + this.numberOfCells / 2;
            if (!heatRun) {
                for (int i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(reactor, stack, stack, x, y, x, y, heatRun);
                }
                pulses += ItemReactorMOX.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun);
                continue;
            }
            int heat = ItemReactorMOX.sumUp(pulses += ItemReactorMOX.checkPulseable(reactor, x - 1, y, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x + 1, y, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x, y - 1, stack, x, y, heatRun) + ItemReactorMOX.checkPulseable(reactor, x, y + 1, stack, x, y, heatRun)) * 4;
            if (reactor.isFluidCooled() && (double)(breedereffectiveness = (float)reactor.getHeat() / (float)reactor.getMaxHeat()) > 0.5) {
                heat *= 2;
            }
            ArrayList<ItemStackCoord> heatAcceptors = new ArrayList<ItemStackCoord>();
            this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
            while (heatAcceptors.size() > 0 && heat > 0) {
                int dheat = heat / heatAcceptors.size();
                heat -= dheat;
                dheat = ((IReactorComponent)heatAcceptors.get((int)0).stack.func_77973_b()).alterHeat(reactor, heatAcceptors.get((int)0).stack, heatAcceptors.get((int)0).x, heatAcceptors.get((int)0).y, dheat);
                heat += dheat;
                heatAcceptors.remove(0);
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (this.getCustomDamage(stack) >= this.getMaxCustomDamage(stack) - 1) {
            switch (this.numberOfCells) {
                case 1: {
                    reactor.setItemAt(x, y, new ItemStack(Ic2Items.reactorDepletedMOXSimple.func_77973_b(), 1));
                    break;
                }
                case 2: {
                    reactor.setItemAt(x, y, new ItemStack(Ic2Items.reactorDepletedMOXDual.func_77973_b(), 1));
                    break;
                }
                case 4: {
                    reactor.setItemAt(x, y, new ItemStack(Ic2Items.reactorDepletedMOXQuad.func_77973_b(), 1));
                }
            }
        } else if (heatRun) {
            this.applyCustomDamage(stack, 1, null);
        }
    }

    private static int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other != null && other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(reactor, other, me, x, y, mex, mey, heatrun)) {
            return 1;
        }
        return 0;
    }

    private static int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }

    private void checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing != null && thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (!heatrun) {
            float breedereffectiveness = (float)reactor.getHeat() / (float)reactor.getMaxHeat();
            float ReaktorOutput = 4.0f * breedereffectiveness + 1.0f;
            reactor.addOutput(ReaktorOutput);
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 2 * this.numberOfCells;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLivingBase && !ItemArmorHazmat.hasCompleteHazmat(entityLiving = (EntityLivingBase)entity)) {
            IC2Potion.radiation.applyTo(entityLiving, 200, 100);
        }
    }

    private class ItemStackCoord {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemStackCoord(ItemStack stack1, int x1, int y1) {
            this.stack = stack1;
            this.x = x1;
            this.y = y1;
        }
    }
}

