/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.IKineticWindRotor;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.WorldData;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableIKineticWindRotor;
import ic2.core.block.kineticgenerator.container.ContainerWindKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiWindKineticGenerator;
import ic2.core.util.Util;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui {
    public final InvSlotConsumableIKineticWindRotor rotorSlot;
    private double windStrength;
    private int obstructedCrossSection;
    private int crossSection;
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    private float rotationSpeed;
    private static final double efficiencyRollOffExponent = 2.0;
    private static final int nominalRotationPeriod = 500;

    public TileEntityWindKineticGenerator() {
        this.rotorSlot = new InvSlotConsumableIKineticWindRotor(this, "rotorslot", 0, 1);
    }

    public void func_145845_h() {
        super.func_145845_h();
        assert (IC2.platform.isSimulating());
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        boolean needsInvUpdate = false;
        if (!this.rotorSlot.isEmpty()) {
            if (this.checkSpace(1, true) == 0) {
                if (!this.getActive()) {
                    this.setActive(true);
                }
                needsInvUpdate = true;
            } else {
                if (this.getActive()) {
                    this.setActive(false);
                }
                needsInvUpdate = true;
            }
        } else {
            if (this.getActive()) {
                this.setActive(false);
            }
            needsInvUpdate = true;
        }
        if (this.getActive()) {
            this.crossSection = this.getRotorDiameter() / 2 * 2 * 2 + 1;
            this.crossSection *= this.crossSection;
            this.obstructedCrossSection = this.checkSpace(this.getRotorDiameter() * 3, false);
            if (this.obstructedCrossSection > 0 && this.obstructedCrossSection <= (this.getRotorDiameter() + 1) / 2) {
                this.obstructedCrossSection = 0;
            } else if (this.obstructedCrossSection < 0) {
                this.obstructedCrossSection = this.crossSection;
            }
            this.windStrength = this.calcWindStrength();
            float speed = (float)Util.limit((this.windStrength - (double)this.getMinWindStrength()) / (double)this.getMaxWindStrength(), 0.0, 2.0);
            this.setRotationSpeed(speed);
            if (this.windStrength >= (double)this.getMinWindStrength()) {
                if (this.windStrength <= (double)this.getMaxWindStrength()) {
                    this.rotorSlot.damage(1, false);
                } else {
                    this.rotorSlot.damage(4, false);
                }
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("rotationSpeed");
        ret.add("rotorSlot");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public ContainerBase<TileEntityWindKineticGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWindKineticGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWindKineticGenerator(new ContainerWindKineticGenerator(entityPlayer, this));
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public String getRotorhealth() {
        if (!this.rotorSlot.isEmpty()) {
            return StatCollector.func_74837_a((String)"ic2.WindKineticGenerator.gui.rotorhealth", (Object[])new Object[]{(int)(100.0f - (float)this.rotorSlot.get().func_77960_j() / (float)this.rotorSlot.get().func_77958_k() * 100.0f)});
        }
        return "";
    }

    @Override
    public int maxrequestkineticenergyTick(ForgeDirection directionFrom) {
        return this.getKuOutput();
    }

    @Override
    public int requestkineticenergy(ForgeDirection directionFrom, int requestkineticenergy) {
        if (this.facingMatchesDirection(directionFrom.getOpposite())) {
            return Math.min(requestkineticenergy, this.getKuOutput());
        }
        return 0;
    }

    @Override
    public String func_145825_b() {
        return "Wind Kinetic Generator";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int checkSpace(int length, boolean onlyrotor) {
        int box = this.getRotorDiameter() / 2;
        int lentemp = 0;
        if (onlyrotor) {
            length = 1;
            lentemp = length + 1;
        }
        if (!onlyrotor) {
            box *= 2;
        }
        ForgeDirection fwdDir = ForgeDirection.VALID_DIRECTIONS[this.getFacing()];
        ForgeDirection rightDir = fwdDir.getRotation(ForgeDirection.DOWN);
        int xMaxDist = Math.abs(length * fwdDir.offsetX + box * rightDir.offsetX);
        int zMaxDist = Math.abs(length * fwdDir.offsetZ + box * rightDir.offsetZ);
        ChunkCache chunkCache = new ChunkCache(this.field_145850_b, this.field_145851_c - xMaxDist, this.field_145848_d - box, this.field_145849_e - zMaxDist, this.field_145851_c + xMaxDist, this.field_145848_d + box, this.field_145849_e + zMaxDist, 0);
        int ret = 0;
        for (int up = -box; up <= box; ++up) {
            int y = this.field_145848_d + up;
            for (int right = -box; right <= box; ++right) {
                boolean occupied = false;
                for (int fwd = lentemp - length; fwd <= length; ++fwd) {
                    int x = this.field_145851_c + fwd * fwdDir.offsetX + right * rightDir.offsetX;
                    int z = this.field_145849_e + fwd * fwdDir.offsetZ + right * rightDir.offsetZ;
                    assert (Math.abs(x - this.field_145851_c) <= xMaxDist);
                    assert (Math.abs(z - this.field_145849_e) <= zMaxDist);
                    Block block = chunkCache.func_147439_a(x, y, z);
                    if (block.isAir((IBlockAccess)chunkCache, x, y, z)) continue;
                    occupied = true;
                    if (up == 0 && right == 0 && fwd == 0 || !(chunkCache.func_147438_o(x, y, z) instanceof TileEntityWindKineticGenerator) || onlyrotor) continue;
                    return -1;
                }
                if (!occupied) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean checkrotor() {
        return !this.rotorSlot.isEmpty();
    }

    public boolean rotorspace() {
        return this.checkSpace(1, true) == 0;
    }

    private void setRotationSpeed(float speed) {
        if (this.rotationSpeed != speed) {
            this.rotationSpeed = speed;
            IC2.network.get().updateTileEntityField(this, "rotationSpeed");
        }
    }

    public int getTickRate() {
        return 32;
    }

    public double calcWindStrength() {
        double windStr = WorldData.get((World)this.field_145850_b).windSim.getWindAt(this.field_145848_d);
        return Math.max(0.0, windStr *= 1.0 - Math.pow((double)this.obstructedCrossSection / (double)this.crossSection, 2.0));
    }

    public float getAngle() {
        if (this.rotationSpeed > 0.0f) {
            long period = (long)(5.0E8f / this.rotationSpeed);
            return (float)(System.nanoTime() % period) / (float)period * 360.0f;
        }
        return 0.0f;
    }

    public float getefficiency() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getEfficiency(stack);
        }
        return 0.0f;
    }

    public int getMinWindStrength() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getMinWindStrength(stack);
        }
        return 0;
    }

    public int getMaxWindStrength() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getMaxWindStrength(stack);
        }
        return 0;
    }

    public int getRotorDiameter() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getDiameter(stack);
        }
        return 0;
    }

    public ResourceLocation getRotorRenderTexture() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getRotorRenderTexture(stack);
        }
        return new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorWoodmodel.png");
    }

    public boolean guiisoverload() {
        return this.windStrength > (double)this.getMaxWindStrength();
    }

    public boolean guiisminWindStrength() {
        return this.windStrength >= (double)this.getMinWindStrength();
    }

    public int getKuOutput() {
        if (this.windStrength >= (double)this.getMinWindStrength() && this.getActive()) {
            return (int)(this.windStrength * 10.0 * (double)this.getefficiency());
        }
        return 0;
    }

    public int getWindStrength() {
        return (int)this.windStrength;
    }
}

