/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class LiquidUtil {
    public static LiquidData getLiquid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Fluid liquid = null;
        boolean isSource = false;
        if (block instanceof IFluidBlock) {
            IFluidBlock fblock = (IFluidBlock)block;
            liquid = fblock.getFluid();
            isSource = fblock.canDrain(world, x, y, z);
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            liquid = FluidRegistry.WATER;
            isSource = world.func_72805_g(x, y, z) == 0;
        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            liquid = FluidRegistry.LAVA;
            boolean bl = isSource = world.func_72805_g(x, y, z) == 0;
        }
        if (liquid != null) {
            return new LiquidData(liquid, isSource);
        }
        return null;
    }

    public static int fillContainerStack(ItemStack stack, EntityPlayer player, FluidStack fluid, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return 0;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.fill(stack, fluid, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        int amount = container.fill(testStack, fluid, true);
        if (amount <= 0) {
            return 0;
        }
        if (StackUtil.storeInventoryItem(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return amount;
        }
        return 0;
    }

    public static FluidStack drainContainerStack(ItemStack stack, EntityPlayer player, int maxAmount, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return null;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.drain(stack, maxAmount, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        FluidStack ret = container.drain(testStack, maxAmount, true);
        if (ret == null || ret.amount <= 0) {
            return null;
        }
        if (StackUtil.storeInventoryItem(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return ret;
        }
        return null;
    }

    public static FluidStack distributeFluid(FluidStack fluidstack, TileEntity tileEntity) {
        Fluid fluid = fluidstack.getFluid();
        int amount = fluidstack.amount;
        if (fluidstack != null && fluidstack.amount > 0) {
            for (Direction direction : Direction.values()) {
                int transamount;
                TileEntity target = direction.applyToTileEntity(tileEntity);
                if (!(target instanceof IFluidHandler) && !(target instanceof TileEntityLiquidTankElectricMachine) && !(target instanceof TileEntityLiquidHeatExchanger) || (transamount = ((IFluidHandler)target).fill(direction.toForgeDirection().getOpposite(), fluidstack, false)) <= 0) continue;
                if (amount > transamount) {
                    ((IFluidHandler)target).fill(direction.toForgeDirection().getOpposite(), fluidstack, true);
                    amount -= transamount;
                } else {
                    ((IFluidHandler)target).fill(direction.toForgeDirection().getOpposite(), fluidstack, true);
                    amount = 0;
                }
                if (amount == 0) break;
            }
        }
        return new FluidStack(fluid, amount);
    }

    public static boolean check(FluidStack fs) {
        return fs.getFluid() != null;
    }

    public static boolean placeFluid(FluidStack fs, World world, int x, int y, int z) {
        if (fs == null || fs.amount < 1000) {
            return false;
        }
        Fluid fluid = fs.getFluid();
        Object block = world.func_147439_a(x, y, z);
        if (!(!block.isAir((IBlockAccess)world, x, y, z) && block.func_149688_o().func_76220_a() || !fluid.canBePlacedInWorld() || block == fluid.getBlock() && LiquidUtil.isFullFluidBlock(world, x, y, z, block))) {
            if (world.field_73011_w.field_76575_d && fluid == FluidRegistry.WATER) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                int meta;
                if (!(world.field_72995_K || block.func_149688_o().func_76220_a() || block.func_149688_o().func_76224_d())) {
                    world.func_147480_a(x, y, z, true);
                }
                block = fluid == FluidRegistry.WATER ? Blocks.field_150358_i : (fluid == FluidRegistry.LAVA ? Blocks.field_150356_k : fluid.getBlock());
                int n = meta = block instanceof BlockFluidBase ? ((BlockFluidBase)block).getMaxRenderHeightMeta() : 0;
                if (!world.func_147465_d(x, y, z, block, meta, 3)) {
                    return false;
                }
            }
            fs.amount -= 1000;
            return true;
        }
        return false;
    }

    private static boolean isFullFluidBlock(World world, int x, int y, int z, Block block) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fBlock = (IFluidBlock)block;
            FluidStack drained = fBlock.drain(world, x, y, z, false);
            return drained != null && drained.amount >= 1000;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static class LiquidData {
        public final Fluid liquid;
        public final boolean isSource;

        LiquidData(Fluid liquid1, boolean isSource1) {
            this.liquid = liquid1;
            this.isSource = isSource1;
        }
    }
}

