/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.init.InternalName;
import ic2.core.item.ItemGradualInt;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ItemReactorHeatStorage
extends ItemGradualInt
implements IReactorComponent {
    public ItemReactorHeatStorage(InternalName internalName, int heatStorage1) {
        super(internalName, heatStorage1);
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getMaxDamageEx();
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getDamageOfStack(yourStack);
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        int myHeat = this.getDamageOfStack(yourStack);
        if (myHeat == 0 && this.getControlTagOfStack(yourStack) != 0) {
            this.setControlTagOfStack(yourStack, 0);
        }
        if ((myHeat += heat) > this.maxDmg) {
            reactor.setItemAt(x, y, null);
            heat = this.maxDmg - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            if (myHeat > 0 && this.getControlTagOfStack(yourStack) == 0 && !reactor.isFluidCooled()) {
                this.setControlTagOfStack(yourStack, 1);
            }
            this.setDamageForStack(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        super.func_77624_a(itemStack, player, info, b);
        switch (this.getControlTagOfStack(itemStack)) {
            case 1: {
                info.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line1"));
                info.add(StatCollector.func_74838_a((String)"ic2.reactoritem.heatwarning.line2"));
            }
        }
    }
}

