/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Locale;
import net.minecraft.util.StringTranslate;

public class Localization {
    private static final String defaultLang = "en_US";
    private static Map<String, Map<String, String>> langTable = new HashMap<String, Map<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File modSourceFile) {
        if (modSourceFile.isDirectory()) {
            File langFolder = new File(modSourceFile, "ic2/lang");
            if (langFolder.isDirectory()) {
                for (File langFile : langFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".properties");
                    }
                })) {
                    InputStream is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(langFile));
                        Localization.loadLocalization(is, langFile.getName().split("\\.")[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IC2.log.warn("can't read language file");
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            } else {
                IC2.log.warn("can't list language files (from folder)");
            }
        } else if (modSourceFile.exists() && modSourceFile.getName().endsWith(".jar")) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(modSourceFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("ic2/lang/") || (name = name.substring("ic2/lang/".length())).contains("/") || !name.endsWith(".properties")) continue;
                    InputStream is = null;
                    try {
                        is = zipFile.getInputStream(entry);
                        Localization.loadLocalization(is, name.split("\\.")[0]);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                IC2.log.warn("can't list language files (from jar)");
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            IC2.log.warn("can't find language files");
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            Localization.registerResourceReloadHook();
        } else {
            Map<String, String> map = Localization.getStringTranslateMap();
            map.putAll(Localization.getLangMap(defaultLang));
        }
    }

    public static void addLocalization(String name, String desc) {
        Localization.getLangMap(defaultLang).put(name, desc);
    }

    private static void loadLocalization(InputStream inputStream, String lang) throws IOException {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(inputStream, Charsets.UTF_8));
        Map<String, String> map = Localization.getLangMap(lang);
        for (Map.Entry<Object, Object> entries : properties.entrySet()) {
            Object key = entries.getKey();
            Object value = entries.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            String newKey = (String)key;
            if (!(newKey.startsWith("achievement.") || newKey.startsWith("itemGroup.") || newKey.startsWith("death."))) {
                newKey = "ic2." + newKey;
            }
            map.put(newKey, (String)value);
        }
    }

    protected static Map<String, String> getLangMap(String lang) {
        Map<String, String> ret = langTable.get(lang);
        if (ret == null) {
            ret = new HashMap<String, String>();
            langTable.put(lang, ret);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerResourceReloadHook() {
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        if (resManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resManager).func_110542_a(new IResourceManagerReloadListener(){

                public void func_110549_a(IResourceManager manager) {
                    Map<String, String> map = Localization.getStringTranslateMap();
                    Map<String, String> map2 = Localization.getLocaleMap();
                    map.putAll(Localization.getLangMap(Localization.defaultLang));
                    map.putAll(Localization.getLangMap(Minecraft.func_71410_x().field_71474_y.field_74363_ab));
                    map2.putAll(Localization.getLangMap(Localization.defaultLang));
                    map2.putAll(Localization.getLangMap(Minecraft.func_71410_x().field_71474_y.field_74363_ab));
                }
            });
        }
    }

    protected static Map<String, String> getStringTranslateMap() {
        for (Method method : StringTranslate.class.getDeclaredMethods()) {
            if (method.getReturnType() != StringTranslate.class) continue;
            method.setAccessible(true);
            for (Field field : StringTranslate.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(Map.class)) continue;
                field.setAccessible(true);
                try {
                    return (Map)field.get(method.invoke(null, new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    protected static Map<String, String> getLocaleMap() {
        for (Field fieldP : I18n.class.getDeclaredFields()) {
            if (!fieldP.getType().isAssignableFrom(Locale.class)) continue;
            fieldP.setAccessible(true);
            for (Field field : Locale.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(Map.class)) continue;
                field.setAccessible(true);
                try {
                    return (Map)field.get(fieldP.get(null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }
}

