-----------------------------------------------------------------------------------------------------------------------------
-- INCLUDES
-----------------------------------------------------------------------------------------------------------------------------

IncludeScript("base_shutdown");
IncludeScript("base_location");

-----------------------------------------------------------------------------------------------------------------------------
-- LOCATIONS
-----------------------------------------------------------------------------------------------------------------------------

location_blue_flagroom	= location_info:new({ text = "Flag Room", team = Team.kBlue })
location_blue_window	= location_info:new({ text = "Security Window", team = Team.kBlue })
location_blue_security	= location_info:new({ text = "Security Area", team = Team.kBlue })
location_blue_courtyard	= location_info:new({ text = "Main Courtyard", team = Team.kBlue })
location_blue_rampside	= location_info:new({ text = "Ramp Side", team = Team.kBlue })
location_blue_secside	= location_info:new({ text = "Security Side", team = Team.kBlue })
location_blue_frontdoor	= location_info:new({ text = "Front Door", team = Team.kBlue })
location_blue_water		= location_info:new({ text = "Water Area", team = Team.kBlue })
location_blue_spawn		= location_info:new({ text = "Team Respawn", team = Team.kBlue })

location_red_flagroom	= location_info:new({ text = "Flag Room", team = Team.kRed })
location_red_window		= location_info:new({ text = "Security Window", team = Team.kRed })
location_red_security	= location_info:new({ text = "Security Area", team = Team.kRed })
location_red_courtyard	= location_info:new({ text = "Main Courtyard", team = Team.kRed })
location_red_rampside	= location_info:new({ text = "Ramp Side", team = Team.kRed })
location_red_secside	= location_info:new({ text = "Security Side", team = Team.kRed })
location_red_frontdoor	= location_info:new({ text = "Front Door", team = Team.kRed })
location_red_water		= location_info:new({ text = "Water Area", team = Team.kRed })
location_red_spawn		= location_info:new({ text = "Team Respawn", team = Team.kRed })

location_yard			= location_info:new({ text = "Yard", team = Team.kUnassigned })


-----------------------------------------------------------------------------
-- TOUCH RESUP
-- Brush volume which gives players health, ammo, etc...
-- Pretty much taken from ff_.lua
-----------------------------------------------------------------------------

touch_resup = trigger_ff_script:new({ team = Team.kUnassigned })

function touch_resup:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == self.team then
			player:AddHealth( 400 )
			player:AddArmor( 400 )
			player:AddAmmo( Ammo.kNails, 400 )
			player:AddAmmo( Ammo.kShells, 400 )
			player:AddAmmo( Ammo.kRockets, 400 )
			player:AddAmmo( Ammo.kCells, 400 )
		end
	end
end

blue_touch_resup = touch_resup:new({ team = Team.kBlue })
red_touch_resup = touch_resup:new({ team = Team.kRed })

-----------------------------------------------------------------------------------------------------------------------------
-- WINDOWPACK
-- Team-specific packs which are located near the window where players can throw the flag out.
-----------------------------------------------------------------------------------------------------------------------------

windowpack = genericbackpack:new({
	health = 50,
	armor = 50,
	
	nails = 0,
	shells = 100,
	rockets = 40,
	cells = 100,
	
	gren1 = 0,
	gren2 = 0,
	
	respawntime = 30,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	botgoaltype = Bot.kBackPack_Ammo
})
function windowpack:dropatspawn() return false end

blue_windowpack = windowpack:new({ touchflags = { AllowFlags.kOnlyPlayers, AllowFlags.kBlue } })
red_windowpack = windowpack:new({ touchflags = { AllowFlags.kOnlyPlayers, AllowFlags.kRed } })

-----------------------------------------------------------------------------
-- SPAWN PROTECTION
-- kills those who wander into the enemy spawn
-----------------------------------------------------------------------------

spawn_protection = trigger_ff_script:new({ team = Team.kUnassigned })

function spawn_protection:allowed( activator )
	local player = CastToPlayer( activator )
	if player then
		if player:GetTeamId() == self.team then
			return EVENT_ALLOWED
		end
	end
	return EVENT_DISALLOWED
end

red_spawn_protection = spawn_protection:new({ team = Team.kBlue })
blue_spawn_protection = spawn_protection:new({ team = Team.kRed })

-----------------------------------------------------------------------------
-- OFFENSIVE AND DEFENSIVE SPAWNS
-- Medic, Spy, and Scout spawn in the offensive spawns, other classes spawn in the defensive spawn,
-- Copied from ff_session.lua
-----------------------------------------------------------------------------

red_o_only = function(self,player) return ((player:GetTeamId() == Team.kRed) and ((player:GetClass() == Player.kScout) or (player:GetClass() == Player.kMedic) or (player:GetClass() == Player.kSpy))) end
red_d_only = function(self,player) return ((player:GetTeamId() == Team.kRed) and (((player:GetClass() == Player.kScout) == false) and ((player:GetClass() == Player.kMedic) == false) and ((player:GetClass() == Player.kSpy) == false))) end

red_ospawn = { validspawn = red_o_only }
red_dspawn = { validspawn = red_d_only }

blue_o_only = function(self,player) return ((player:GetTeamId() == Team.kBlue) and ((player:GetClass() == Player.kScout) or (player:GetClass() == Player.kMedic) or (player:GetClass() == Player.kSpy))) end
blue_d_only = function(self,player) return ((player:GetTeamId() == Team.kBlue) and (((player:GetClass() == Player.kScout) == false) and ((player:GetClass() == Player.kMedic) == false) and ((player:GetClass() == Player.kSpy) == false))) end

blue_ospawn = { validspawn = blue_o_only }
blue_dspawn = { validspawn = blue_d_only }

-----------------------------------------------------------------------------
--  AND THEN, SOME MORE STUFF...
-----------------------------------------------------------------------------

red_sec = trigger_ff_script:new()
blue_sec = trigger_ff_script:new()
bluesecstatus = 1
redsecstatus = 1

function red_sec:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == Team.kBlue then
			if redsecstatus == 1 then
				redsecstatus = 0
				AddSchedule("secup10red",50,secup10red)
				AddSchedule("beginclosered",54,beginclosered)
				AddSchedule("secupred",60,secupred)
				OpenDoor("red_secdoor")
				BroadCastMessage("Red Security Deactivated for 60 Seconds")
				SpeakAll( "SD_REDDOWN" )
				RemoveHudItemFromAll( "red-sec-up" )
				AddHudIconToAll( "hud_secdown.vtf", "red-sec-down", 60, 25, 16, 16, 3 )
			end
		end
	end
end

function blue_sec:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == Team.kRed then
			if bluesecstatus == 1 then
				bluesecstatus = 0
				AddSchedule("secup10blue",50,secup10blue)
				AddSchedule("begincloseblue",54,begincloseblue)
				AddSchedule("secupblue",60,secupblue)
				OpenDoor("blue_secdoor")
				BroadCastMessage("Blue Security Deactivated for 60 Seconds")
				SpeakAll( "SD_BLUEDOWN" )
				RemoveHudItemFromAll( "blue-sec-up" )
				AddHudIconToAll( "hud_secdown.vtf", "blue-sec-down", 60, 25, 16, 16, 2 )
			end
		end
	end
end

function secupred()
	redsecstatus = 1
	BroadCastMessage("Red Security Online")
	SpeakAll( "SD_REDUP" )
	RemoveHudItemFromAll( "red-sec-down" )
	AddHudIconToAll( "hud_secup_red.vtf", "red-sec-up", 60, 25, 16, 16, 3 )
end

function begincloseblue()
	CloseDoor("blue_secdoor")
end

function beginclosered()
	CloseDoor("red_secdoor")
end

function secupblue()
	bluesecstatus = 1
	BroadCastMessage("Blue Security Online")
	SpeakAll( "SD_BLUEUP" )
	RemoveHudItemFromAll( "blue-sec-down" )
	AddHudIconToAll( "hud_secup_blue.vtf", "blue-sec-up", 60, 25, 16, 16, 2 )
end

function secup10red()
	BroadCastMessage("Red Security Online in 10 Seconds")
end

function secup10blue()
	BroadCastMessage("Blue Security Online in 10 Seconds")
end

grp = genericbackpack:new({
health = 50, armor = 50,
gren1 = 4, gren2 = 4,
respawntime = 3, model =
"models/items/backpack/backpack.mdl",
materializesound = "Item.Materialize",
touchsound = "Backpack.Touch",
})
function grp:dropatspawn() return false end

function flaginfo( player_entity )
-- at the moment this is crappy workaround - simply displays the home icon
	local player = CastToPlayer( player_entity )

	RemoveHudItem( player, blue_flag.name )
	RemoveHudItem( player, blue_flag.name .. "_c" )
	RemoveHudItem( player, blue_flag.name .. "_d" )

	RemoveHudItem( player, red_flag.name )
	RemoveHudItem( player, red_flag.name .. "_c" )
	RemoveHudItem( player, red_flag.name .. "_d" )

	-- copied from blue_flag variables
	AddHudIcon( player, blue_flag.hudstatusiconhome, ( blue_flag.name.. "_h" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )
	AddHudIcon( player, red_flag.hudstatusiconhome, ( red_flag.name.. "_h" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )
	
	local flag = GetInfoScriptByName("blue_flag")
	
	if flag:IsCarried() then
			AddHudIcon( player, blue_flag.hudstatusiconcarried, ( blue_flag.name.. "_h" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, blue_flag.hudstatusicondropped, ( blue_flag.name.. "_h" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )
	end

	flag = GetInfoScriptByName("red_flag")
	
	if flag:IsCarried() then
			AddHudIcon( player, red_flag.hudstatusiconcarried, ( red_flag.name.. "_h" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, red_flag.hudstatusicondropped, ( red_flag.name.. "_h" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )
	end

	RemoveHudItem( player, "red-sec-down" )
	RemoveHudItem( player, "blue-sec-down" )
	RemoveHudItem( player, "red-sec-up" )
	RemoveHudItem( player, "blue-sec-up" )

		if bluesecstatus == 1 then
			AddHudIcon( player, "hud_secup_blue.vtf", "blue-sec-up", 60, 25, 16, 16, 2 )
		else
			AddHudIcon( player, "hud_secdown.vtf", "blue-sec-down", 60, 25, 16, 16, 2 )
		end

		if redsecstatus == 1 then
			AddHudIcon( player, "hud_secup_red.vtf", "red-sec-up", 60, 25, 16, 16, 3 )
		else
			AddHudIcon( player, "hud_secdown.vtf", "red-sec-down", 60, 25, 16, 16, 3 )
		end
end
