
-- base_ctf4.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_ctf")

-----------------------------------------------------------------------------
-- map level handlers
-----------------------------------------------------------------------------
function startup()
	-- set up team limits
	SetPlayerLimit(Team.kBlue, 0)
	SetPlayerLimit(Team.kRed, 0)
	SetPlayerLimit(Team.kYellow, 0)
	SetPlayerLimit(Team.kGreen, 0)
	
	-- CTF maps generally don't have civilians,
	-- so override in map LUA file if you want 'em
	local team = GetTeam(Team.kBlue)
	team:SetClassLimit(Player.kCivilian, -1)

	team = GetTeam(Team.kRed)
	team:SetClassLimit(Player.kCivilian, -1)
end

function flaginfo( player_entity )
	local player = CastToPlayer( player_entity )

	local flag = GetInfoScriptByName("blue_flag")
	local flagname = flag:GetName()
	
	RemoveHudItem( player, flagname .. "_c" )
	RemoveHudItem( player, flagname.. "_d" )
	RemoveHudItem( player, flagname .. "_h" )

	if flag:IsCarried() then
			AddHudIcon( player, blue_flag.hudstatusiconcarried, ( flagname .. "_c" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, blue_flag.hudstatusicondropped, ( flagname .. "_d" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )
	else
		AddHudIcon( player, blue_flag.hudstatusiconhome, ( flagname .. "_h" ), blue_flag.hudstatusiconx, blue_flag.hudstatusicony, blue_flag.hudstatusiconw, blue_flag.hudstatusiconh, blue_flag.hudstatusiconalign )	
	end

	flag = GetInfoScriptByName("red_flag")
	flagname = flag:GetName()
	
	RemoveHudItem( player, flagname .. "_c" )
	RemoveHudItem( player, flagname.. "_d" )
	RemoveHudItem( player, flagname .. "_h" )

	if flag:IsCarried() then
			AddHudIcon( player, red_flag.hudstatusiconcarried, ( flagname .. "_c" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, red_flag.hudstatusicondropped, ( flagname .. "_d" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )
	else
			AddHudIcon( player, red_flag.hudstatusiconhome, ( flagname .. "_h" ), red_flag.hudstatusiconx, red_flag.hudstatusicony, red_flag.hudstatusiconw, red_flag.hudstatusiconh, red_flag.hudstatusiconalign )	
	end
	
	flag = GetInfoScriptByName("yellow_flag")
	flagname = flag:GetName()
	
	RemoveHudItem( player, flagname .. "_c" )
	RemoveHudItem( player, flagname.. "_d" )
	RemoveHudItem( player, flagname .. "_h" )

	if flag:IsCarried() then
			AddHudIcon( player, yellow_flag.hudstatusiconcarried, ( flagname .. "_c" ), yellow_flag.hudstatusiconx, yellow_flag.hudstatusicony, yellow_flag.hudstatusiconw, yellow_flag.hudstatusiconh, yellow_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, yellow_flag.hudstatusicondropped, ( flagname .. "_d" ), yellow_flag.hudstatusiconx, yellow_flag.hudstatusicony, yellow_flag.hudstatusiconw, yellow_flag.hudstatusiconh, yellow_flag.hudstatusiconalign )
	else
			AddHudIcon( player, yellow_flag.hudstatusiconhome, ( flagname .. "_h" ), yellow_flag.hudstatusiconx, yellow_flag.hudstatusicony, yellow_flag.hudstatusiconw, yellow_flag.hudstatusiconh, yellow_flag.hudstatusiconalign )	
	end
	
		flag = GetInfoScriptByName("green_flag")
	flagname = flag:GetName()
	
	RemoveHudItem( player, flagname .. "_c" )
	RemoveHudItem( player, flagname.. "_d" )
	RemoveHudItem( player, flagname .. "_h" )

	if flag:IsCarried() then
			AddHudIcon( player, green_flag.hudstatusiconcarried, ( flagname .. "_c" ), green_flag.hudstatusiconx, green_flag.hudstatusicony, green_flag.hudstatusiconw, green_flag.hudstatusiconh, green_flag.hudstatusiconalign )
	elseif flag:IsDropped() then
			AddHudIcon( player, green_flag.hudstatusicondropped, ( flagname .. "_d" ), green_flag.hudstatusiconx, green_flag.hudstatusicony, green_flag.hudstatusiconw, green_flag.hudstatusiconh, green_flag.hudstatusiconalign )
	else
			AddHudIcon( player, green_flag.hudstatusiconhome, ( flagname .. "_h" ), green_flag.hudstatusiconx, green_flag.hudstatusicony, green_flag.hudstatusiconw, green_flag.hudstatusiconh, green_flag.hudstatusiconalign )	
	end
end