
-- ff_palermo.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------

IncludeScript("base_id");
IncludeScript("base_respawnturret");
IncludeScript("base_location");

-----------------------------------------------------------------------------

-----------------------------------------------------------------------------

respawnturret_attackers = base_respawnturret:new({ team = attackers })
respawnturret_defenders = base_respawnturret:new({ team = defenders })

palhealthkit = genericbackpack:new({
	health = 50,
	model = "models/items/healthkit.mdl",
	materializesound = "Item.Materialize",
	touchsound = "HealthKit.Touch"
})
palarmorkit = genericbackpack:new({
	armor = 200,
	model = "models/items/armour/armour.mdl",
	materializesound = "Item.Materialize",
	touchsound = "ArmorKit.Touch"
})
palammopack = genericbackpack:new({
	grenades = 20,
	nails = 50,
	shells = 100,
	rockets = 15,
	cells = 70,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch"
})
palgrenadepackone = genericbackpack:new({
	grenades = 20,
	nails = 50,
	shells = 50,
	rockets = 20,
	mancannons = 1,
	gren1 = 2,
	gren2 = 1,
	armor = 50,
	health = 25,
	respawntime = 30,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch"
})
palgrenadepacktwo = genericbackpack:new({
	grenades = 20,
	nails = 50,
	shells = 50,
	rockets = 20,
	mancannons = 1,
	gren1 = 2,
	gren2 = 2,
	armor = 50,
	health = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch"
})
palammotypeone = genericbackpack:new({
	grenades = 20,
	nails = 50,
	shells = 50,
	rockets = 20,
	cells = 75,
	armor = 50,
	health = 25,
	respawntime = 5,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch"
})

--Fixme: can't get the bags to change teams at reset, so for now they are teamless
attackers_palammotypeone = palammotypeone:new({ })
attackers_palgrenadepackone = palgrenadepackone:new({ })

--This is called from base_id to do map-specific stuff
function onroundreset()
	-- close the holes
	OutputEvent("cp1_detpack_hole", "Enable")
	OutputEvent("cp4_detpack_hole", "Enable")
	--re-enable detpack relays
	OutputEvent("cp1_detpack_relay", "Enable")
	OutputEvent("cp4_detpack_relay", "Enable")
	-- Reset The Turrets(?) and Bags
	respawnturret_attackers = base_respawnturret:new({ team = attackers })
	respawnturret_defenders = base_respawnturret:new({ team = defenders })
	--Fixme: this doesn't work
	--if attackers == Team.kBlue then
	--	attackers_palammotypeone.touchflags =  {AllowFlags.kOnlyPlayers,AllowFlags.kBlue}
	--	attackers_palgrenadepackone.touchflags =  {AllowFlags.kOnlyPlayers,AllowFlags.kBlue}
	--else
	--	attackers_palammotypeone.touchflags =  {AllowFlags.kOnlyPlayers,AllowFlags.kRed}
	--	attackers_palgrenadepackone.touchflags =  {AllowFlags.kOnlyPlayers,AllowFlags.kRed}
	--end

end

detpack_trigger = trigger_ff_script:new({ prefix = "" })

function detpack_trigger:onexplode( trigger_entity )
	if IsDetpack( trigger_entity ) then
		local detpack = CastToDetpack( trigger_entity )
		if detpack:GetTeamId() == attackers then
			--This triggers a logic_relay in the map, which opens the hole and can trigger any other effect.
			OutputEvent( self.prefix .. "_detpack_relay", "Trigger" )
		end
	end
	return EVENT_ALLOWED
end

--The detpack trigger names. Only attakers can activate them.
--Prefix is used so each detpack area can have a different effect.
cp1_detpack_trigger = detpack_trigger:new({ prefix = "cp1" })
cp4_detpack_trigger = detpack_trigger:new({ prefix = "cp4" })
