-- ff_dropdown.lua
-- Author: Sh4x

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_shutdown");




-----------------------------------------------------------------------------
-- globals (lawl... unless it starts with "local" its already a global!)
-----------------------------------------------------------------------------

BLUEFIRE_TIMER_START = 60
BLUEFIRE_TIMER_STOP = 0
BLUEFIRE_TIMER_CURRENT = BLUEFIRE_TIMER_START
REDFIRE_TIMER_START = 60
REDFIRE_TIMER_STOP = 0
REDFIRE_TIMER_CURRENT = REDFIRE_TIMER_START



-----------------------------------------------------------------------------
-- backpacks  smallpack1=bottomfloor  smallpack2=middlefloor  smallpack3=upperfloor
-----------------------------------------------------------------------------
redsmallpack1 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redsmallpack1:dropatspawn() return false end

redsmallpack2 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redsmallpack2:dropatspawn() return false end

redsmallpack3 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kRed},
	botgoaltype = Bot.kBackPack_Ammo
})

function redsmallpack3:dropatspawn() return false end




bluesmallpack1 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluesmallpack1:dropatspawn() return false end

bluesmallpack2 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluesmallpack2:dropatspawn() return false end

bluesmallpack3 = genericbackpack:new({
	grenades = 100,
	bullets = 100,
	nails = 100,
	shells = 100,
	rockets = 100,
	gren1 = 1,
	gren2 = 1,
      cells = 200,
	armor = 100,
	health = 100,
      respawntime = 25,
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	touchflags = {AllowFlags.kBlue},
	botgoaltype = Bot.kBackPack_Ammo
})

function bluesmallpack3:dropatspawn() return false end

-----------------------------------------------------------------------------
-- unique dropdown locations
-----------------------------------------------------------------------------

location_blue_generator = location_info:new({ text = "Generator Room", team = Team.kBlue })
location_blue_tophole = location_info:new({ text = "Top Hole", team = Team.kBlue })

location_red_generator = location_info:new({ text = "Generator Room", team = Team.kRed })
location_red_tophole = location_info:new({ text = "Top Hole", team = Team.kRed })

-----------------------------------------------------------------------------
-- Grates
-----------------------------------------------------------------------------


red_grate_trigger = trigger_ff_script:new({ })

function red_grate_trigger:onexplode( trigger_entity  ) 
	if IsDetpack( trigger_entity ) then 
		OutputEvent( "red_grate", "Break" )
		OutputEvent( "red_grate_wall", "Kill" )
            BroadCastMessage("Red grate has been blown up!")
		ConsoleToAll( "Red grate has been blown up!" )
	end 
	return EVENT_ALLOWED
end
function red_grate_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end



blue_grate_trigger = trigger_ff_script:new({ })

function blue_grate_trigger:onexplode( trigger_entity  ) 
	if IsDetpack( trigger_entity ) then 
		OutputEvent( "blue_grate", "Break" )
		OutputEvent( "blue_grate_wall", "Kill" )
            BroadCastMessage("Blue grate has been blown up!")
		ConsoleToAll( "Blue grate has been blown up!" )
	end 
	return EVENT_ALLOWED
end
function blue_grate_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end


-----------------------------------------------------------------------------
-- Generators Destroy
-----------------------------------------------------------------------------

red_gen_trigger = trigger_ff_script:new({ })
redfire = 0

function red_gen_trigger:onexplode( trigger_entity  ) 
	if IsDetpack( trigger_entity ) then 
		if redgenup == 1 then
            OutputEvent( "red_doorhack", "Close" )
            BroadCastMessage("Red generator has been destroyed!")
		ConsoleToAll( "Red generator has been destroyed!")

      redfire_start_schedule()
      redfire = 1

            redgenup = 0
            end
	end 
	return EVENT_ALLOWED
end
function red_gen_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end



blue_gen_trigger = trigger_ff_script:new({ })
bluefire = 0

function blue_gen_trigger:onexplode( trigger_entity  ) 
	if IsDetpack( trigger_entity ) then 
            if bluegenup == 1 then
		OutputEvent( "blue_doorhack", "Close" )
            BroadCastMessage("Blue generator has been destroyed!")
		ConsoleToAll( "Blue generator has been destroyed!")

      bluefire_start_schedule()
      bluefire = 1

            bluegenup = 0
            end
	end 
	return EVENT_ALLOWED
end
function blue_gen_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end

-----------------------------------------------------------------------------
-- Generators Repair
-----------------------------------------------------------------------------

red_gen_repair_trigger = func_button:new({})
red_gen_repair_trigger_script = trigger_ff_script:new()
redspannerclang = 0
redgenup = 1
redclangcntr = 0

function red_gen_repair_trigger_script:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
			if player:GetActiveWeaponName() == "ff_weapon_spanner" then
				redspannerclang = 1
				if redfire == 1 then
					DisplayMessage( player, "You can't repair the generator while it's still burning.  Wait until the fire is out!" )
				end
			end
	end
end

function red_gen_repair_trigger_script:onendtouch()
	redspannerclang = 0
end

function red_gen_repair_trigger:ondamage()
	if redspannerclang == 1 then
		 if redgenup == 0 then
             	if redfire == 0 then
      	 	OutputEvent( "redspannerhit", "PlaySound" )
             	redclangcntr = redclangcntr + 1
                     if redclangcntr > 4 then
                     redclangcntr = 0             
                     BroadCastMessage("Red generator is up and running!")
		         ConsoleToAll( "Red generator has been repaired!")
                     OpenDoor("red_doorhack")
		         redspannerclang = 0
                     redgenup = 1
                     end
			end
		 end
      end
	return EVENT_DISALLOWED
end



blue_gen_repair_trigger = func_button:new({})
blue_gen_repair_trigger_script = trigger_ff_script:new()
bluespannerclang = 0
bluegenup = 1
blueclangcntr = 0


function blue_gen_repair_trigger_script:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
			if player:GetActiveWeaponName() == "ff_weapon_spanner" then
				bluespannerclang = 1
				if bluefire == 1 then
					DisplayMessage( player, "You can't repair the generator while it's still burning.  Wait until the fire is out!" )
				end
			end
	end
end

function blue_gen_repair_trigger_script:onendtouch()
	bluespannerclang = 0
end

function blue_gen_repair_trigger:ondamage()
	if bluespannerclang == 1 then
		 if bluegenup == 0 then
             	if bluefire == 0 then
             	OutputEvent( "bluespannerhit", "PlaySound" )
             	blueclangcntr = blueclangcntr + 1
                     if blueclangcntr > 4 then
                     blueclangcntr = 0             
                     BroadCastMessage("Blue generator is up and running!")
		         ConsoleToAll( "Blue generator has been repaired!")
                     OpenDoor("blue_doorhack")
		         bluespannerclang = 0
                     bluegenup = 1
                     end
			end
             end
      end
	return EVENT_DISALLOWED
end


-----------------------------------------------------------------------------
-- Walls
-----------------------------------------------------------------------------
-- used to check if walls already broken
red_wall = true
blue_wall = true


red_wall_trigger = trigger_ff_script:new({ })

function red_wall_trigger:onexplode( trigger_entity  ) 
	if red_wall then
		if IsDetpack( trigger_entity ) then 
			OutputEvent( "red_wall", "Break" )
			BroadCastMessage("Red generator room wall has been breached!")
			ConsoleToAll( "Red generator room wall has been breached!")
			red_wall = false
		end
	end
	return EVENT_ALLOWED
end
function red_wall_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end



blue_wall_trigger = trigger_ff_script:new({ })

function blue_wall_trigger:onexplode( trigger_entity  ) 
	if blue_wall then
		if IsDetpack( trigger_entity ) then 
			OutputEvent( "blue_wall", "Break" )
		        BroadCastMessage("Blue generator room wall has been breached!")
			ConsoleToAll( "Blue generator room wall has been breached!")
			blue_wall = false
		end
	end
	return EVENT_ALLOWED
end
function blue_wall_trigger:allowed( trigger_entity ) return EVENT_DISALLOWED 
end



-----------------------------------------------------------------------------
-- No builds: area where you can't build a jump pad
-----------------------------------------------------------------------------

nobuild = trigger_ff_script:new({})

function nobuild:onbuild( build_entity )
	local player = CastToPlayer( build_entity )
	if player:GetClass() == Player.kScout then
		DisplayMessage( player, "This is no place for a jump pad." )
		return EVENT_DISALLOWED
	end
	return EVENT_ALLOWED
end

no_build = nobuild



-----------------------------------------------------------------------------
-- Reset stuff
-----------------------------------------------------------------------------

function RedDoFireResetLogic()
--	ConsoleToAll( "RedDoFireResetLogic" )	

	-- stop fire timer schedule if its still going [no need for this now]
	--DeleteSchedule( "red_fire_timer_schedule" )

	-- Reset fire timer
	RedResetFireTimer()	

	-- Fire is off
	redfire = 0
end


function RedResetFireTimer()
	REDFIRE_TIMER_CURRENT = REDFIRE_TIMER_START
end




function BlueDoFireResetLogic()
--	ConsoleToAll( "BlueDoFireResetLogic" )	

	-- stop fire timer schedule if its still going [no need for this now]
	--DeleteSchedule( "blue_fire_timer_schedule" )

	-- Reset fire timer
	BlueResetFireTimer()	

	-- Fire is off
	bluefire = 0
end


function BlueResetFireTimer()
	BLUEFIRE_TIMER_CURRENT = BLUEFIRE_TIMER_START
end




-----------------------------------------------------------------------------
-- Generator delay before repair - schedules
-----------------------------------------------------------------------------

function redfire_start_schedule()	

--	ConsoleToAll( "starting fire timer schedule" )
	AddScheduleRepeating( "red_fire_timer_schedule", REDFIRE_TIMER_START, red_fire_timer_schedule )
end

function red_fire_timer_schedule()
--	ConsoleToAll( "red_fire_timer_schedule" )
		RedDoFireResetLogic()
end




function bluefire_start_schedule()	

--	ConsoleToAll( "starting fire timer schedule" )
	AddScheduleRepeating( "blue_fire_timer_schedule", BLUEFIRE_TIMER_START, blue_fire_timer_schedule )
end

function blue_fire_timer_schedule()
--	ConsoleToAll( "blue_fire_timer_schedule" )
		BlueDoFireResetLogic()	
end