-- FF_FiddleSticks.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------

IncludeScript("base_ctf")
-----------------------------------------------------------------------------
-- global overrides
-----------------------------------------------------------------------------

POINTS_PER_CAPTURE = 10
FLAG_RETURN_TIME = 90

-----------------------------------------------------------------------------
-- touch resupply
-----------------------------------------------------------------------------

supply = trigger_ff_script:new({ team = Team.kUnassigned })

function supply:ontouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == self.team then
			player:AddHealth( 400 )
			player:AddArmor( 400 )
			player:AddAmmo( Ammo.kNails, 400 )
			player:AddAmmo( Ammo.kShells, 400 )
			player:AddAmmo( Ammo.kRockets, 400 )
			player:AddAmmo( Ammo.kCells, 400 )
		end
	end
end

blue_supply = supply:new({ team = Team.kBlue })
red_supply = supply:new({ team = Team.kRed })

-----------------------------------------------------------------------------
--lzr killer 
-- must be trigger_hurt
-----------------------------------------------------------------------------

KILL_KILL_KILL = trigger_ff_script:new({ team = Team.kUnassigned })
function KILL_KILL_KILL:allowed( allowed_entity )
	if IsPlayer( allowed_entity ) then
		local player = CastToPlayer( allowed_entity )
		if player:GetTeamId() == self.team then
			return EVENT_ALLOWED
		end
	end

	return EVENT_DISALLOWED
end

-- blue_slayer KILLS red

red_slayer = KILL_KILL_KILL:new({ team = Team.kBlue })
blue_slayer = KILL_KILL_KILL:new({ team = Team.kRed })

-----------------------------------------------------------------------------
-- Pickups
-----------------------------------------------------------------------------

fiddlepack = genericbackpack:new({
	repawntime = 10,
	model = "models/items/backpack/backpack.mdl",
	materializesounds = "Item.Materialize",
	botgoaltype = Bot.kBackPack_Ammo
})

function fiddlepack:dropatspawn() return false end

function fiddlepack:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
	
		local dispensed = 0
		dispensed = dispensed + player:AddHealth( 0 )
		dispensed = dispensed + player:AddArmor( 50 )
		dispensed = dispensed + player:AddAmmo(Ammo.kNails, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kShells, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kRockets, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kCells, 75)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren1, 0)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren2, 0)
		if dispensed >= 1 then
			BroadCastMessageToPlayer( player, ">:U" )
			local backpack = CastToInfoScript(entity);
			if (backpack ~= nil) then
				backpack:EmitSound(self.touchsound);	
				backpack:Respawn(self.respawntime);

			end

		end

	end
end

bluefiddlepack = genericbackpack:new({
	repawntime = 10,
	model = "models/items/backpack/backpack.mdl",
	materializesounds = "Item.Materialize",
	botgoaltype = Bot.kBackPack_Ammo
})

function bluefiddlepack:dropatspawn() return false end

function bluefiddlepack:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
	
		local dispensed = 0
		dispensed = dispensed + player:AddHealth( 0 )
		dispensed = dispensed + player:AddArmor( 50 )
		dispensed = dispensed + player:AddAmmo(Ammo.kNails, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kShells, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kRockets, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kCells, 75)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren1, 0)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren2, 0)
		if dispensed >= 1 then
			BroadCastMessageToPlayer( player, ">:U" )
			local backpack = CastToInfoScript(entity);
			if (backpack ~= nil) then
				backpack:EmitSound(self.touchsound);	
				backpack:Respawn(self.respawntime);

			end

		end

	end
end

bluefiddlenades = genericbackpack:new({
	repawntime = 45,
	model = "models/items/backpack/backpack.mdl",
	materializesounds = "Item.Materialize",
	botgoaltype = Bot.kBackPack_Ammo
})

function bluefiddlenades:dropatspawn() return false end

function bluefiddlenades:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
	
		local dispensed = 0
		dispensed = dispensed + player:AddHealth( 0 )
		dispensed = dispensed + player:AddArmor( 50 )
		dispensed = dispensed + player:AddAmmo(Ammo.kNails, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kShells, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kRockets, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kCells, 75)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren1, 2)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren2, 2)
		if dispensed >= 1 then
			BroadCastMessageToPlayer( player, ">:U!!" )
			local backpack = CastToInfoScript(entity);
			if (backpack ~= nil) then
				backpack:EmitSound(self.touchsound);	
				backpack:Respawn(self.respawntime);

			end

		end

	end
end

redfiddlepack = genericbackpack:new({
	repawntime = 10,
	model = "models/items/backpack/backpack.mdl",
	materializesounds = "Item.Materialize",
	botgoaltype = Bot.kBackPack_Ammo
})

function redfiddlepack:dropatspawn() return false end

function redfiddlepack:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
	
		local dispensed = 0
		dispensed = dispensed + player:AddHealth( 0 )
		dispensed = dispensed + player:AddArmor( 50 )
		dispensed = dispensed + player:AddAmmo(Ammo.kNails, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kShells, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kRockets, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kCells, 75)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren1, 0)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren2, 0)
		if dispensed >= 1 then
			BroadCastMessageToPlayer( player, ">:U" )
			local backpack = CastToInfoScript(entity);
			if (backpack ~= nil) then
				backpack:EmitSound(self.touchsound);	
				backpack:Respawn(self.respawntime);

			end

		end

	end
end

redfiddlenades = genericbackpack:new({
	repawntime = 10,
	model = "models/items/backpack/backpack.mdl",
	materializesounds = "Item.Materialize",
	botgoaltype = Bot.kBackPack_Ammo
})

function redfiddlenades:dropatspawn() return false end

function redfiddlenades:touch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
	
		local dispensed = 0
		dispensed = dispensed + player:AddHealth( 0 )
		dispensed = dispensed + player:AddArmor( 50 )
		dispensed = dispensed + player:AddAmmo(Ammo.kNails, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kShells, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kRockets, 400)
		dispensed = dispensed + player:AddAmmo(Ammo.kCells, 75)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren1, 2)
		dispensed = dispensed + player:AddAmmo(Ammo.kGren2, 2)
		if dispensed >= 1 then
			BroadCastMessageToPlayer( player, ">:U!!" )
			local backpack = CastToInfoScript(entity);
			if (backpack ~= nil) then
				backpack:EmitSound(self.touchsound);	
				backpack:Respawn(self.respawntime);

			end

		end

	end
end